/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.providersupport.shared;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemProvider;
import org.openhab.core.items.ItemUtil;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ItemProvider.class, ScriptedItemProvider.class})
public class ScriptedItemProvider
extends AbstractProvider<Item>
implements ItemProvider,
ManagedProvider<Item, String> {
    private final Logger logger = LoggerFactory.getLogger(ScriptedItemProvider.class);
    private final Map<String, Item> items = new HashMap<String, Item>();

    public Collection<Item> getAll() {
        return this.items.values();
    }

    public @Nullable Item get(String itemName) {
        return this.items.get(itemName);
    }

    public void add(Item item) {
        if (!ItemUtil.isValidItemName((String)item.getName())) {
            throw new IllegalArgumentException("The item name '" + item.getName() + "' is invalid.");
        }
        if (this.items.get(item.getName()) != null) {
            throw new IllegalArgumentException("Cannot add item, because an item with same name (" + item.getName() + ") already exists.");
        }
        this.items.put(item.getName(), item);
        this.notifyListenersAboutAddedElement(item);
    }

    public @Nullable Item update(Item item) {
        Item oldItem = this.items.get(item.getName());
        if (oldItem != null) {
            this.items.put(item.getName(), item);
            this.notifyListenersAboutUpdatedElement(oldItem, item);
        } else {
            this.logger.warn("Could not update item with name '{}', because it does not exist.", (Object)item.getName());
        }
        return oldItem;
    }

    public @Nullable Item remove(String itemName) {
        Item item = this.items.remove(itemName);
        if (item != null) {
            this.notifyListenersAboutRemovedElement(item);
        }
        return item;
    }
}

