/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lsp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.log4j.Logger;

public class ForwardingClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(ForwardingClassLoader.class);
    private URLClassLoader delegate;

    public ForwardingClassLoader() {
        super(ClassLoader.getPlatformClassLoader());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.delegate != null) {
            return this.delegate.loadClass(name);
        }
        return super.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        if (this.delegate != null) {
            return this.delegate.getResource(name);
        }
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.delegate != null) {
            return this.delegate.getResourceAsStream(name);
        }
        return super.getResourceAsStream(name);
    }

    public void setDelegate(URLClassLoader delegate) {
        if (this.delegate != null) {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.delegate = null;
            }
        }
        this.delegate = delegate;
    }

    public ClassLoader getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.getParent();
    }
}

