/* { dg-final { check-function-bodies "**" "" "-DCHECK_ASM" } } */

#include "test_sve_acle.h"

/*
** sri_1_s32_tied1:
**	sri	z0\.s, z1\.s, #1
**	ret
*/
TEST_UNIFORM_Z (sri_1_s32_tied1, svint32_t,
		z0 = svsri_n_s32 (z0, z1, 1),
		z0 = svsri (z0, z1, 1))

/* Bad RA choice: no preferred output sequence.  */
TEST_UNIFORM_Z (sri_1_s32_tied2, svint32_t,
		z0 = svsri_n_s32 (z1, z0, 1),
		z0 = svsri (z1, z0, 1))

/*
** sri_1_s32_untied:
**	mov	z0\.d, z1\.d
**	sri	z0\.s, z2\.s, #1
**	ret
*/
TEST_UNIFORM_Z (sri_1_s32_untied, svint32_t,
		z0 = svsri_n_s32 (z1, z2, 1),
		z0 = svsri (z1, z2, 1))

/*
** sri_2_s32_tied1:
**	sri	z0\.s, z1\.s, #2
**	ret
*/
TEST_UNIFORM_Z (sri_2_s32_tied1, svint32_t,
		z0 = svsri_n_s32 (z0, z1, 2),
		z0 = svsri (z0, z1, 2))

/* Bad RA choice: no preferred output sequence.  */
TEST_UNIFORM_Z (sri_2_s32_tied2, svint32_t,
		z0 = svsri_n_s32 (z1, z0, 2),
		z0 = svsri (z1, z0, 2))

/*
** sri_2_s32_untied:
**	mov	z0\.d, z1\.d
**	sri	z0\.s, z2\.s, #2
**	ret
*/
TEST_UNIFORM_Z (sri_2_s32_untied, svint32_t,
		z0 = svsri_n_s32 (z1, z2, 2),
		z0 = svsri (z1, z2, 2))

/*
** sri_32_s32_tied1:
**	sri	z0\.s, z1\.s, #32
**	ret
*/
TEST_UNIFORM_Z (sri_32_s32_tied1, svint32_t,
		z0 = svsri_n_s32 (z0, z1, 32),
		z0 = svsri (z0, z1, 32))

/* Bad RA choice: no preferred output sequence.  */
TEST_UNIFORM_Z (sri_32_s32_tied2, svint32_t,
		z0 = svsri_n_s32 (z1, z0, 32),
		z0 = svsri (z1, z0, 32))

/*
** sri_32_s32_untied:
**	mov	z0\.d, z1\.d
**	sri	z0\.s, z2\.s, #32
**	ret
*/
TEST_UNIFORM_Z (sri_32_s32_untied, svint32_t,
		z0 = svsri_n_s32 (z1, z2, 32),
		z0 = svsri (z1, z2, 32))
