// Code generated by smithy-go-codegen DO NOT EDIT.

package lightsail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lightsail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns the current, previous, or pending versions of the master user password
// for a Lightsail database.
//
// The GetRelationalDatabaseMasterUserPassword operation supports tag-based access
// control via resource tags applied to the resource identified by
// relationalDatabaseName.
func (c *Client) GetRelationalDatabaseMasterUserPassword(ctx context.Context, params *GetRelationalDatabaseMasterUserPasswordInput, optFns ...func(*Options)) (*GetRelationalDatabaseMasterUserPasswordOutput, error) {
	if params == nil {
		params = &GetRelationalDatabaseMasterUserPasswordInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRelationalDatabaseMasterUserPassword", params, optFns, c.addOperationGetRelationalDatabaseMasterUserPasswordMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRelationalDatabaseMasterUserPasswordOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetRelationalDatabaseMasterUserPasswordInput struct {

	// The name of your database for which to get the master user password.
	//
	// This member is required.
	RelationalDatabaseName *string

	// The password version to return.
	//
	// Specifying CURRENT or PREVIOUS returns the current or previous passwords
	// respectively. Specifying PENDING returns the newest version of the password
	// that will rotate to CURRENT . After the PENDING password rotates to CURRENT ,
	// the PENDING password is no longer available.
	//
	// Default: CURRENT
	PasswordVersion types.RelationalDatabasePasswordVersion

	noSmithyDocumentSerde
}

type GetRelationalDatabaseMasterUserPasswordOutput struct {

	// The timestamp when the specified version of the master user password was
	// created.
	CreatedAt *time.Time

	// The master user password for the password version specified.
	MasterUserPassword *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRelationalDatabaseMasterUserPasswordMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetRelationalDatabaseMasterUserPassword{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetRelationalDatabaseMasterUserPassword{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRelationalDatabaseMasterUserPassword"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetRelationalDatabaseMasterUserPasswordValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRelationalDatabaseMasterUserPassword(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetRelationalDatabaseMasterUserPassword(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRelationalDatabaseMasterUserPassword",
	}
}
