package blueprint

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/blueprint/mgmt/2018-11-01-preview/blueprint"

// BasicArtifact represents a blueprint artifact.
type BasicArtifact interface {
	AsTemplateArtifact() (*TemplateArtifact, bool)
	AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool)
	AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool)
	AsArtifact() (*Artifact, bool)
}

// Artifact represents a blueprint artifact.
type Artifact struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindArtifact', 'KindTemplate', 'KindRoleAssignment', 'KindPolicyAssignment'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

func unmarshalBasicArtifact(body []byte) (BasicArtifact, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindTemplate):
		var ta TemplateArtifact
		err := json.Unmarshal(body, &ta)
		return ta, err
	case string(KindRoleAssignment):
		var raa RoleAssignmentArtifact
		err := json.Unmarshal(body, &raa)
		return raa, err
	case string(KindPolicyAssignment):
		var paa PolicyAssignmentArtifact
		err := json.Unmarshal(body, &paa)
		return paa, err
	default:
		var a Artifact
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicArtifactArray(body []byte) ([]BasicArtifact, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicArtifact, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicArtifact(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Artifact.
func (a Artifact) MarshalJSON() ([]byte, error) {
	a.Kind = KindArtifact
	objectMap := make(map[string]interface{})
	if a.Kind != "" {
		objectMap["kind"] = a.Kind
	}
	return json.Marshal(objectMap)
}

// AsTemplateArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsTemplateArtifact() (*TemplateArtifact, bool) {
	return nil, false
}

// AsRoleAssignmentArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool) {
	return nil, false
}

// AsPolicyAssignmentArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool) {
	return nil, false
}

// AsArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsArtifact() (*Artifact, bool) {
	return &a, true
}

// AsBasicArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsBasicArtifact() (BasicArtifact, bool) {
	return &a, true
}

// ArtifactList list of blueprint artifacts.
type ArtifactList struct {
	autorest.Response `json:"-"`
	// Value - List of blueprint artifacts.
	Value *[]BasicArtifact `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ArtifactList.
func (al ArtifactList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Value != nil {
		objectMap["value"] = al.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArtifactList struct.
func (al *ArtifactList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicArtifactArray(*v)
				if err != nil {
					return err
				}
				al.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				al.NextLink = &nextLink
			}
		}
	}

	return nil
}

// ArtifactListIterator provides access to a complete listing of Artifact values.
type ArtifactListIterator struct {
	i    int
	page ArtifactListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ArtifactListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArtifactListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ArtifactListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ArtifactListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ArtifactListIterator) Response() ArtifactList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ArtifactListIterator) Value() BasicArtifact {
	if !iter.page.NotDone() {
		return Artifact{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ArtifactListIterator type.
func NewArtifactListIterator(page ArtifactListPage) ArtifactListIterator {
	return ArtifactListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ArtifactList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al ArtifactList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// artifactListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ArtifactList) artifactListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ArtifactListPage contains a page of BasicArtifact values.
type ArtifactListPage struct {
	fn func(context.Context, ArtifactList) (ArtifactList, error)
	al ArtifactList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ArtifactListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArtifactListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ArtifactListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ArtifactListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ArtifactListPage) Response() ArtifactList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ArtifactListPage) Values() []BasicArtifact {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ArtifactListPage type.
func NewArtifactListPage(cur ArtifactList, getNextPage func(context.Context, ArtifactList) (ArtifactList, error)) ArtifactListPage {
	return ArtifactListPage{
		fn: getNextPage,
		al: cur,
	}
}

// ArtifactModel ...
type ArtifactModel struct {
	autorest.Response `json:"-"`
	Value             BasicArtifact `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ArtifactModel struct.
func (am *ArtifactModel) UnmarshalJSON(body []byte) error {
	a, err := unmarshalBasicArtifact(body)
	if err != nil {
		return err
	}
	am.Value = a

	return nil
}

// ArtifactPropertiesBase common properties shared by different artifacts.
type ArtifactPropertiesBase struct {
	// DependsOn - Artifacts which need to be deployed before the specified artifact.
	DependsOn *[]string `json:"dependsOn,omitempty"`
}

// Assignment represents a blueprint assignment.
type Assignment struct {
	autorest.Response `json:"-"`
	// Identity - Managed identity for this blueprint assignment.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
	// AssignmentProperties - Properties for blueprint assignment object.
	*AssignmentProperties `json:"properties,omitempty"`
	// Location - The location of this blueprint assignment.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Assignment.
func (a Assignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.AssignmentProperties != nil {
		objectMap["properties"] = a.AssignmentProperties
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Assignment struct.
func (a *Assignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "properties":
			if v != nil {
				var assignmentProperties AssignmentProperties
				err = json.Unmarshal(*v, &assignmentProperties)
				if err != nil {
					return err
				}
				a.AssignmentProperties = &assignmentProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		}
	}

	return nil
}

// AssignmentDeploymentJob represents individual job in given blueprint assignment operation.
type AssignmentDeploymentJob struct {
	// Kind - Kind of job.
	Kind *string `json:"kind,omitempty"`
	// Action - Name of the action performed in this job.
	Action *string `json:"action,omitempty"`
	// JobID - Id of this job.
	JobID *string `json:"jobId,omitempty"`
	// JobState - State of this job.
	JobState *string `json:"jobState,omitempty"`
	// Result - Deployment job result.
	Result *AssignmentDeploymentJobResult `json:"result,omitempty"`
	// History - Result of this deployment job for each retry.
	History *[]AssignmentDeploymentJobResult `json:"history,omitempty"`
	// RequestURI - Reference to deployment job resource id.
	RequestURI *string `json:"requestUri,omitempty"`
}

// AssignmentDeploymentJobResult result of each individual deployment in a blueprint assignment.
type AssignmentDeploymentJobResult struct {
	// Error - Contains error details if deployment job failed.
	Error *AzureResourceManagerError `json:"error,omitempty"`
	// Resources - Resources created as result of the deployment job.
	Resources *[]AssignmentJobCreatedResource `json:"resources,omitempty"`
}

// AssignmentJobCreatedResource azure resource created from deployment job.
type AssignmentJobCreatedResource struct {
	// Properties - Additional properties in a dictionary.
	Properties map[string]*string `json:"properties"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for AssignmentJobCreatedResource.
func (ajcr AssignmentJobCreatedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ajcr.Properties != nil {
		objectMap["properties"] = ajcr.Properties
	}
	return json.Marshal(objectMap)
}

// AssignmentList list of blueprint assignments
type AssignmentList struct {
	autorest.Response `json:"-"`
	// Value - List of blueprint assignments.
	Value *[]Assignment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AssignmentList.
func (al AssignmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Value != nil {
		objectMap["value"] = al.Value
	}
	return json.Marshal(objectMap)
}

// AssignmentListIterator provides access to a complete listing of Assignment values.
type AssignmentListIterator struct {
	i    int
	page AssignmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AssignmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssignmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AssignmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AssignmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AssignmentListIterator) Response() AssignmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AssignmentListIterator) Value() Assignment {
	if !iter.page.NotDone() {
		return Assignment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AssignmentListIterator type.
func NewAssignmentListIterator(page AssignmentListPage) AssignmentListIterator {
	return AssignmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AssignmentList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AssignmentList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// assignmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AssignmentList) assignmentListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AssignmentListPage contains a page of Assignment values.
type AssignmentListPage struct {
	fn func(context.Context, AssignmentList) (AssignmentList, error)
	al AssignmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AssignmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssignmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AssignmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AssignmentListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AssignmentListPage) Response() AssignmentList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AssignmentListPage) Values() []Assignment {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AssignmentListPage type.
func NewAssignmentListPage(cur AssignmentList, getNextPage func(context.Context, AssignmentList) (AssignmentList, error)) AssignmentListPage {
	return AssignmentListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AssignmentLockSettings defines how resources deployed by a blueprint assignment are locked.
type AssignmentLockSettings struct {
	// Mode - Lock mode. Possible values include: 'AssignmentLockModeNone', 'AssignmentLockModeAllResourcesReadOnly', 'AssignmentLockModeAllResourcesDoNotDelete'
	Mode AssignmentLockMode `json:"mode,omitempty"`
	// ExcludedPrincipals - List of AAD principals excluded from blueprint locks. Up to 5 principals are permitted.
	ExcludedPrincipals *[]string `json:"excludedPrincipals,omitempty"`
	// ExcludedActions - List of management operations that are excluded from blueprint locks. Up to 200 actions are permitted. If the lock mode is set to 'AllResourcesReadOnly', then the following actions are automatically appended to 'excludedActions': '*/read', 'Microsoft.Network/virtualNetworks/subnets/join/action' and 'Microsoft.Authorization/locks/delete'. If the lock mode is set to 'AllResourcesDoNotDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will get removed.
	ExcludedActions *[]string `json:"excludedActions,omitempty"`
}

// AssignmentOperation represents underlying deployment detail for each update to the blueprint assignment.
type AssignmentOperation struct {
	autorest.Response `json:"-"`
	// AssignmentOperationProperties - Properties for AssignmentOperation.
	*AssignmentOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for AssignmentOperation.
func (ao AssignmentOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ao.AssignmentOperationProperties != nil {
		objectMap["properties"] = ao.AssignmentOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssignmentOperation struct.
func (ao *AssignmentOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var assignmentOperationProperties AssignmentOperationProperties
				err = json.Unmarshal(*v, &assignmentOperationProperties)
				if err != nil {
					return err
				}
				ao.AssignmentOperationProperties = &assignmentOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ao.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ao.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ao.Name = &name
			}
		}
	}

	return nil
}

// AssignmentOperationList list of AssignmentOperation.
type AssignmentOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of AssignmentOperation.
	Value *[]AssignmentOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AssignmentOperationList.
func (aol AssignmentOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aol.Value != nil {
		objectMap["value"] = aol.Value
	}
	return json.Marshal(objectMap)
}

// AssignmentOperationListIterator provides access to a complete listing of AssignmentOperation values.
type AssignmentOperationListIterator struct {
	i    int
	page AssignmentOperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AssignmentOperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssignmentOperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AssignmentOperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AssignmentOperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AssignmentOperationListIterator) Response() AssignmentOperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AssignmentOperationListIterator) Value() AssignmentOperation {
	if !iter.page.NotDone() {
		return AssignmentOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AssignmentOperationListIterator type.
func NewAssignmentOperationListIterator(page AssignmentOperationListPage) AssignmentOperationListIterator {
	return AssignmentOperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aol AssignmentOperationList) IsEmpty() bool {
	return aol.Value == nil || len(*aol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aol AssignmentOperationList) hasNextLink() bool {
	return aol.NextLink != nil && len(*aol.NextLink) != 0
}

// assignmentOperationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aol AssignmentOperationList) assignmentOperationListPreparer(ctx context.Context) (*http.Request, error) {
	if !aol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aol.NextLink)))
}

// AssignmentOperationListPage contains a page of AssignmentOperation values.
type AssignmentOperationListPage struct {
	fn  func(context.Context, AssignmentOperationList) (AssignmentOperationList, error)
	aol AssignmentOperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AssignmentOperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssignmentOperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aol)
		if err != nil {
			return err
		}
		page.aol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AssignmentOperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AssignmentOperationListPage) NotDone() bool {
	return !page.aol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AssignmentOperationListPage) Response() AssignmentOperationList {
	return page.aol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AssignmentOperationListPage) Values() []AssignmentOperation {
	if page.aol.IsEmpty() {
		return nil
	}
	return *page.aol.Value
}

// Creates a new instance of the AssignmentOperationListPage type.
func NewAssignmentOperationListPage(cur AssignmentOperationList, getNextPage func(context.Context, AssignmentOperationList) (AssignmentOperationList, error)) AssignmentOperationListPage {
	return AssignmentOperationListPage{
		fn:  getNextPage,
		aol: cur,
	}
}

// AssignmentOperationProperties properties of AssignmentOperation.
type AssignmentOperationProperties struct {
	// BlueprintVersion - The published version of the blueprint definition used for the blueprint assignment operation.
	BlueprintVersion *string `json:"blueprintVersion,omitempty"`
	// AssignmentState - State of this blueprint assignment operation.
	AssignmentState *string `json:"assignmentState,omitempty"`
	// TimeCreated - Create time of this blueprint assignment operation.
	TimeCreated *string `json:"timeCreated,omitempty"`
	// TimeStarted - Start time of the underlying deployment.
	TimeStarted *string `json:"timeStarted,omitempty"`
	// TimeFinished - Finish time of the overall underlying deployments.
	TimeFinished *string `json:"timeFinished,omitempty"`
	// Deployments - List of jobs in this blueprint assignment operation.
	Deployments *[]AssignmentDeploymentJob `json:"deployments,omitempty"`
}

// AssignmentProperties detailed properties for a blueprint assignment.
type AssignmentProperties struct {
	// BlueprintID - ID of the published version of a blueprint definition.
	BlueprintID *string `json:"blueprintId,omitempty"`
	// Scope - The target subscription scope of the blueprint assignment (format: '/subscriptions/{subscriptionId}'). For management group level assignments, the property is required.
	Scope *string `json:"scope,omitempty"`
	// Parameters - Blueprint assignment parameter values.
	Parameters map[string]*ParameterValue `json:"parameters"`
	// ResourceGroups - Names and locations of resource group placeholders.
	ResourceGroups map[string]*ResourceGroupValue `json:"resourceGroups"`
	// Status - READ-ONLY; Status of blueprint assignment. This field is readonly.
	Status *AssignmentStatus `json:"status,omitempty"`
	// Locks - Defines how resources deployed by a blueprint assignment are locked.
	Locks *AssignmentLockSettings `json:"locks,omitempty"`
	// ProvisioningState - READ-ONLY; State of the blueprint assignment. Possible values include: 'Creating', 'Validating', 'Waiting', 'Deploying', 'Cancelling', 'Locking', 'Succeeded', 'Failed', 'Canceled', 'Deleting'
	ProvisioningState AssignmentProvisioningState `json:"provisioningState,omitempty"`
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for AssignmentProperties.
func (ap AssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.BlueprintID != nil {
		objectMap["blueprintId"] = ap.BlueprintID
	}
	if ap.Scope != nil {
		objectMap["scope"] = ap.Scope
	}
	if ap.Parameters != nil {
		objectMap["parameters"] = ap.Parameters
	}
	if ap.ResourceGroups != nil {
		objectMap["resourceGroups"] = ap.ResourceGroups
	}
	if ap.Locks != nil {
		objectMap["locks"] = ap.Locks
	}
	if ap.DisplayName != nil {
		objectMap["displayName"] = ap.DisplayName
	}
	if ap.Description != nil {
		objectMap["description"] = ap.Description
	}
	return json.Marshal(objectMap)
}

// AssignmentStatus the status of a blueprint assignment. This field is readonly.
type AssignmentStatus struct {
	// ManagedResources - READ-ONLY; List of resources that were created by the blueprint assignment.
	ManagedResources *[]string `json:"managedResources,omitempty"`
	// TimeCreated - READ-ONLY; Creation time of this blueprint definition.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// LastModified - READ-ONLY; Last modified time of this blueprint definition.
	LastModified *date.Time `json:"lastModified,omitempty"`
}

// MarshalJSON is the custom marshaler for AssignmentStatus.
func (as AssignmentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureResourceBase common properties for all Azure resources.
type AzureResourceBase struct {
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceBase.
func (arb AzureResourceBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureResourceManagerError error code and message
type AzureResourceManagerError struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
}

// KeyVaultReference specifies the link to a Key Vault.
type KeyVaultReference struct {
	// ID - Azure resource ID of the Key Vault.
	ID *string `json:"id,omitempty"`
}

// List list of blueprint definitions.
type List struct {
	autorest.Response `json:"-"`
	// Value - List of blueprint definitions.
	Value *[]Model `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for List.
func (l List) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.Value != nil {
		objectMap["value"] = l.Value
	}
	return json.Marshal(objectMap)
}

// ListIterator provides access to a complete listing of Model values.
type ListIterator struct {
	i    int
	page ListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListIterator) Response() List {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListIterator) Value() Model {
	if !iter.page.NotDone() {
		return Model{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListIterator type.
func NewListIterator(page ListPage) ListIterator {
	return ListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (l List) IsEmpty() bool {
	return l.Value == nil || len(*l.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (l List) hasNextLink() bool {
	return l.NextLink != nil && len(*l.NextLink) != 0
}

// listPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (l List) listPreparer(ctx context.Context) (*http.Request, error) {
	if !l.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(l.NextLink)))
}

// ListPage contains a page of Model values.
type ListPage struct {
	fn func(context.Context, List) (List, error)
	l  List
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.l)
		if err != nil {
			return err
		}
		page.l = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListPage) NotDone() bool {
	return !page.l.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListPage) Response() List {
	return page.l
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListPage) Values() []Model {
	if page.l.IsEmpty() {
		return nil
	}
	return *page.l.Value
}

// Creates a new instance of the ListPage type.
func NewListPage(cur List, getNextPage func(context.Context, List) (List, error)) ListPage {
	return ListPage{
		fn: getNextPage,
		l:  cur,
	}
}

// ManagedServiceIdentity managed identity generic object.
type ManagedServiceIdentity struct {
	// Type - Type of the managed identity. Possible values include: 'ManagedServiceIdentityTypeNone', 'ManagedServiceIdentityTypeSystemAssigned', 'ManagedServiceIdentityTypeUserAssigned'
	Type ManagedServiceIdentityType `json:"type,omitempty"`
	// PrincipalID - Azure Active Directory principal ID associated with this Identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - ID of the Azure Active Directory.
	TenantID *string `json:"tenantId,omitempty"`
	// UserAssignedIdentities - The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ManagedServiceIdentity.
func (msi ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msi.Type != "" {
		objectMap["type"] = msi.Type
	}
	if msi.PrincipalID != nil {
		objectMap["principalId"] = msi.PrincipalID
	}
	if msi.TenantID != nil {
		objectMap["tenantId"] = msi.TenantID
	}
	if msi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = msi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// Model represents a Blueprint definition.
type Model struct {
	autorest.Response `json:"-"`
	// Properties - Detailed properties for blueprint definition.
	*Properties `json:"properties,omitempty"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Model.
func (mVar Model) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Properties != nil {
		objectMap["properties"] = mVar.Properties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Model struct.
func (mVar *Model) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				mVar.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		}
	}

	return nil
}

// ParameterDefinition represent a parameter with constrains and metadata.
type ParameterDefinition struct {
	// Type - Allowed data types for Resource Manager template parameters. Possible values include: 'String', 'Array', 'Bool', 'Int', 'Object', 'SecureObject', 'SecureString'
	Type TemplateParameterType `json:"type,omitempty"`
	// ParameterDefinitionMetadata - User-friendly properties for this parameter.
	*ParameterDefinitionMetadata `json:"metadata,omitempty"`
	// DefaultValue - Default Value for this parameter.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// AllowedValues - Array of allowed values for this parameter.
	AllowedValues *[]interface{} `json:"allowedValues,omitempty"`
}

// MarshalJSON is the custom marshaler for ParameterDefinition.
func (pd ParameterDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pd.Type != "" {
		objectMap["type"] = pd.Type
	}
	if pd.ParameterDefinitionMetadata != nil {
		objectMap["metadata"] = pd.ParameterDefinitionMetadata
	}
	if pd.DefaultValue != nil {
		objectMap["defaultValue"] = pd.DefaultValue
	}
	if pd.AllowedValues != nil {
		objectMap["allowedValues"] = pd.AllowedValues
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ParameterDefinition struct.
func (pd *ParameterDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "type":
			if v != nil {
				var typeVar TemplateParameterType
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pd.Type = typeVar
			}
		case "metadata":
			if v != nil {
				var parameterDefinitionMetadata ParameterDefinitionMetadata
				err = json.Unmarshal(*v, &parameterDefinitionMetadata)
				if err != nil {
					return err
				}
				pd.ParameterDefinitionMetadata = &parameterDefinitionMetadata
			}
		case "defaultValue":
			if v != nil {
				var defaultValue interface{}
				err = json.Unmarshal(*v, &defaultValue)
				if err != nil {
					return err
				}
				pd.DefaultValue = defaultValue
			}
		case "allowedValues":
			if v != nil {
				var allowedValues []interface{}
				err = json.Unmarshal(*v, &allowedValues)
				if err != nil {
					return err
				}
				pd.AllowedValues = &allowedValues
			}
		}
	}

	return nil
}

// ParameterDefinitionMetadata user-friendly properties for this parameter.
type ParameterDefinitionMetadata struct {
	// DisplayName - DisplayName of this parameter/resourceGroup.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of this parameter/resourceGroup.
	Description *string `json:"description,omitempty"`
	// StrongType - StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId and location.
	StrongType *string `json:"strongType,omitempty"`
}

// ParameterValue value for the specified parameter. Can be either 'value' or 'reference' but not both.
type ParameterValue struct {
	// Value - Parameter value. Any valid JSON value is allowed including objects, arrays, strings, numbers and booleans.
	Value interface{} `json:"value,omitempty"`
	// Reference - Parameter value as reference type.
	Reference *SecretValueReference `json:"reference,omitempty"`
}

// PolicyAssignmentArtifact blueprint artifact that applies a Policy assignment.
type PolicyAssignmentArtifact struct {
	// PolicyAssignmentArtifactProperties - properties for policyAssignment Artifact
	*PolicyAssignmentArtifactProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindArtifact', 'KindTemplate', 'KindRoleAssignment', 'KindPolicyAssignment'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) MarshalJSON() ([]byte, error) {
	paa.Kind = KindPolicyAssignment
	objectMap := make(map[string]interface{})
	if paa.PolicyAssignmentArtifactProperties != nil {
		objectMap["properties"] = paa.PolicyAssignmentArtifactProperties
	}
	if paa.Kind != "" {
		objectMap["kind"] = paa.Kind
	}
	return json.Marshal(objectMap)
}

// AsTemplateArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsTemplateArtifact() (*TemplateArtifact, bool) {
	return nil, false
}

// AsRoleAssignmentArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool) {
	return nil, false
}

// AsPolicyAssignmentArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool) {
	return &paa, true
}

// AsArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsArtifact() (*Artifact, bool) {
	return nil, false
}

// AsBasicArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsBasicArtifact() (BasicArtifact, bool) {
	return &paa, true
}

// UnmarshalJSON is the custom unmarshaler for PolicyAssignmentArtifact struct.
func (paa *PolicyAssignmentArtifact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyAssignmentArtifactProperties PolicyAssignmentArtifactProperties
				err = json.Unmarshal(*v, &policyAssignmentArtifactProperties)
				if err != nil {
					return err
				}
				paa.PolicyAssignmentArtifactProperties = &policyAssignmentArtifactProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				paa.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				paa.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				paa.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				paa.Name = &name
			}
		}
	}

	return nil
}

// PolicyAssignmentArtifactProperties properties of a Policy assignment blueprint artifact.
type PolicyAssignmentArtifactProperties struct {
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
	// DependsOn - Artifacts which need to be deployed before the specified artifact.
	DependsOn *[]string `json:"dependsOn,omitempty"`
	// PolicyDefinitionID - Azure resource ID of the policy definition.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`
	// Parameters - Parameter values for the policy definition.
	Parameters map[string]*ParameterValue `json:"parameters"`
	// ResourceGroup - Name of the resource group placeholder to which the policy will be assigned.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyAssignmentArtifactProperties.
func (paap PolicyAssignmentArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if paap.DisplayName != nil {
		objectMap["displayName"] = paap.DisplayName
	}
	if paap.Description != nil {
		objectMap["description"] = paap.Description
	}
	if paap.DependsOn != nil {
		objectMap["dependsOn"] = paap.DependsOn
	}
	if paap.PolicyDefinitionID != nil {
		objectMap["policyDefinitionId"] = paap.PolicyDefinitionID
	}
	if paap.Parameters != nil {
		objectMap["parameters"] = paap.Parameters
	}
	if paap.ResourceGroup != nil {
		objectMap["resourceGroup"] = paap.ResourceGroup
	}
	return json.Marshal(objectMap)
}

// Properties schema for blueprint definition properties.
type Properties struct {
	// Versions - Published versions of this blueprint definition.
	Versions interface{} `json:"versions,omitempty"`
	// Layout - Layout view of the blueprint definition for UI reference.
	Layout interface{} `json:"layout,omitempty"`
	// Status - READ-ONLY; Status of the blueprint. This field is readonly.
	Status *Status `json:"status,omitempty"`
	// TargetScope - The scope where this blueprint definition can be assigned. Possible values include: 'Subscription', 'ManagementGroup'
	TargetScope TargetScope `json:"targetScope,omitempty"`
	// Parameters - Parameters required by this blueprint definition.
	Parameters map[string]*ParameterDefinition `json:"parameters"`
	// ResourceGroups - Resource group placeholders defined by this blueprint definition.
	ResourceGroups map[string]*ResourceGroupDefinition `json:"resourceGroups"`
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Versions != nil {
		objectMap["versions"] = p.Versions
	}
	if p.Layout != nil {
		objectMap["layout"] = p.Layout
	}
	if p.TargetScope != "" {
		objectMap["targetScope"] = p.TargetScope
	}
	if p.Parameters != nil {
		objectMap["parameters"] = p.Parameters
	}
	if p.ResourceGroups != nil {
		objectMap["resourceGroups"] = p.ResourceGroups
	}
	if p.DisplayName != nil {
		objectMap["displayName"] = p.DisplayName
	}
	if p.Description != nil {
		objectMap["description"] = p.Description
	}
	return json.Marshal(objectMap)
}

// PublishedBlueprint represents a published blueprint.
type PublishedBlueprint struct {
	autorest.Response `json:"-"`
	// PublishedBlueprintProperties - Detailed properties for published blueprint.
	*PublishedBlueprintProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for PublishedBlueprint.
func (pb PublishedBlueprint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pb.PublishedBlueprintProperties != nil {
		objectMap["properties"] = pb.PublishedBlueprintProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublishedBlueprint struct.
func (pb *PublishedBlueprint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var publishedBlueprintProperties PublishedBlueprintProperties
				err = json.Unmarshal(*v, &publishedBlueprintProperties)
				if err != nil {
					return err
				}
				pb.PublishedBlueprintProperties = &publishedBlueprintProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pb.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pb.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pb.Name = &name
			}
		}
	}

	return nil
}

// PublishedBlueprintList list of published blueprint definitions.
type PublishedBlueprintList struct {
	autorest.Response `json:"-"`
	// Value - List of published blueprint definitions.
	Value *[]PublishedBlueprint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PublishedBlueprintList.
func (pbl PublishedBlueprintList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pbl.Value != nil {
		objectMap["value"] = pbl.Value
	}
	return json.Marshal(objectMap)
}

// PublishedBlueprintListIterator provides access to a complete listing of PublishedBlueprint values.
type PublishedBlueprintListIterator struct {
	i    int
	page PublishedBlueprintListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublishedBlueprintListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublishedBlueprintListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PublishedBlueprintListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublishedBlueprintListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublishedBlueprintListIterator) Response() PublishedBlueprintList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublishedBlueprintListIterator) Value() PublishedBlueprint {
	if !iter.page.NotDone() {
		return PublishedBlueprint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PublishedBlueprintListIterator type.
func NewPublishedBlueprintListIterator(page PublishedBlueprintListPage) PublishedBlueprintListIterator {
	return PublishedBlueprintListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pbl PublishedBlueprintList) IsEmpty() bool {
	return pbl.Value == nil || len(*pbl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pbl PublishedBlueprintList) hasNextLink() bool {
	return pbl.NextLink != nil && len(*pbl.NextLink) != 0
}

// publishedBlueprintListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pbl PublishedBlueprintList) publishedBlueprintListPreparer(ctx context.Context) (*http.Request, error) {
	if !pbl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pbl.NextLink)))
}

// PublishedBlueprintListPage contains a page of PublishedBlueprint values.
type PublishedBlueprintListPage struct {
	fn  func(context.Context, PublishedBlueprintList) (PublishedBlueprintList, error)
	pbl PublishedBlueprintList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublishedBlueprintListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublishedBlueprintListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pbl)
		if err != nil {
			return err
		}
		page.pbl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PublishedBlueprintListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublishedBlueprintListPage) NotDone() bool {
	return !page.pbl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublishedBlueprintListPage) Response() PublishedBlueprintList {
	return page.pbl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublishedBlueprintListPage) Values() []PublishedBlueprint {
	if page.pbl.IsEmpty() {
		return nil
	}
	return *page.pbl.Value
}

// Creates a new instance of the PublishedBlueprintListPage type.
func NewPublishedBlueprintListPage(cur PublishedBlueprintList, getNextPage func(context.Context, PublishedBlueprintList) (PublishedBlueprintList, error)) PublishedBlueprintListPage {
	return PublishedBlueprintListPage{
		fn:  getNextPage,
		pbl: cur,
	}
}

// PublishedBlueprintProperties schema for published blueprint definition properties.
type PublishedBlueprintProperties struct {
	// BlueprintName - Name of the published blueprint definition.
	BlueprintName *string `json:"blueprintName,omitempty"`
	// ChangeNotes - Version-specific change notes.
	ChangeNotes *string `json:"changeNotes,omitempty"`
	// Status - READ-ONLY; Status of the blueprint. This field is readonly.
	Status *Status `json:"status,omitempty"`
	// TargetScope - The scope where this blueprint definition can be assigned. Possible values include: 'Subscription', 'ManagementGroup'
	TargetScope TargetScope `json:"targetScope,omitempty"`
	// Parameters - Parameters required by this blueprint definition.
	Parameters map[string]*ParameterDefinition `json:"parameters"`
	// ResourceGroups - Resource group placeholders defined by this blueprint definition.
	ResourceGroups map[string]*ResourceGroupDefinition `json:"resourceGroups"`
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for PublishedBlueprintProperties.
func (pbp PublishedBlueprintProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pbp.BlueprintName != nil {
		objectMap["blueprintName"] = pbp.BlueprintName
	}
	if pbp.ChangeNotes != nil {
		objectMap["changeNotes"] = pbp.ChangeNotes
	}
	if pbp.TargetScope != "" {
		objectMap["targetScope"] = pbp.TargetScope
	}
	if pbp.Parameters != nil {
		objectMap["parameters"] = pbp.Parameters
	}
	if pbp.ResourceGroups != nil {
		objectMap["resourceGroups"] = pbp.ResourceGroups
	}
	if pbp.DisplayName != nil {
		objectMap["displayName"] = pbp.DisplayName
	}
	if pbp.Description != nil {
		objectMap["description"] = pbp.Description
	}
	return json.Marshal(objectMap)
}

// ResourceGroupDefinition represents an Azure resource group in a blueprint definition.
type ResourceGroupDefinition struct {
	// Name - Name of this resourceGroup. Leave empty if the resource group name will be specified during the blueprint assignment.
	Name *string `json:"name,omitempty"`
	// Location - Location of this resourceGroup. Leave empty if the resource group location will be specified during the blueprint assignment.
	Location *string `json:"location,omitempty"`
	// ParameterDefinitionMetadata - User-friendly properties for this resource group.
	*ParameterDefinitionMetadata `json:"metadata,omitempty"`
	// DependsOn - Artifacts which need to be deployed before this resource group.
	DependsOn *[]string `json:"dependsOn,omitempty"`
	// Tags - Tags to be assigned to this resource group.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ResourceGroupDefinition.
func (rgd ResourceGroupDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rgd.Name != nil {
		objectMap["name"] = rgd.Name
	}
	if rgd.Location != nil {
		objectMap["location"] = rgd.Location
	}
	if rgd.ParameterDefinitionMetadata != nil {
		objectMap["metadata"] = rgd.ParameterDefinitionMetadata
	}
	if rgd.DependsOn != nil {
		objectMap["dependsOn"] = rgd.DependsOn
	}
	if rgd.Tags != nil {
		objectMap["tags"] = rgd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceGroupDefinition struct.
func (rgd *ResourceGroupDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rgd.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rgd.Location = &location
			}
		case "metadata":
			if v != nil {
				var parameterDefinitionMetadata ParameterDefinitionMetadata
				err = json.Unmarshal(*v, &parameterDefinitionMetadata)
				if err != nil {
					return err
				}
				rgd.ParameterDefinitionMetadata = &parameterDefinitionMetadata
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []string
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				rgd.DependsOn = &dependsOn
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rgd.Tags = tags
			}
		}
	}

	return nil
}

// ResourceGroupValue represents an Azure resource group.
type ResourceGroupValue struct {
	// Name - Name of the resource group.
	Name *string `json:"name,omitempty"`
	// Location - Location of the resource group.
	Location *string `json:"location,omitempty"`
}

// ResourcePropertiesBase shared properties between all blueprint resources.
type ResourcePropertiesBase struct {
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// ResourceProviderOperation supported operations of this resource provider.
type ResourceProviderOperation struct {
	// Name - Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`
}

// ResourceProviderOperationDisplay display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Provider - Resource provider: Microsoft Blueprint.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of this operation.
	Description *string `json:"description,omitempty"`
}

// ResourceProviderOperationList results of the request to list operations.
type ResourceProviderOperationList struct {
	// Value - List of operations supported by this resource provider.
	Value *[]ResourceProviderOperation `json:"value,omitempty"`
}

// ResourceStatusBase shared status properties between all blueprint resources.
type ResourceStatusBase struct {
	// TimeCreated - READ-ONLY; Creation time of this blueprint definition.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// LastModified - READ-ONLY; Last modified time of this blueprint definition.
	LastModified *date.Time `json:"lastModified,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceStatusBase.
func (rsb ResourceStatusBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RoleAssignmentArtifact blueprint artifact that applies a Role assignment.
type RoleAssignmentArtifact struct {
	// RoleAssignmentArtifactProperties - Properties for a Role assignment blueprint artifact.
	*RoleAssignmentArtifactProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindArtifact', 'KindTemplate', 'KindRoleAssignment', 'KindPolicyAssignment'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) MarshalJSON() ([]byte, error) {
	raa.Kind = KindRoleAssignment
	objectMap := make(map[string]interface{})
	if raa.RoleAssignmentArtifactProperties != nil {
		objectMap["properties"] = raa.RoleAssignmentArtifactProperties
	}
	if raa.Kind != "" {
		objectMap["kind"] = raa.Kind
	}
	return json.Marshal(objectMap)
}

// AsTemplateArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsTemplateArtifact() (*TemplateArtifact, bool) {
	return nil, false
}

// AsRoleAssignmentArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool) {
	return &raa, true
}

// AsPolicyAssignmentArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool) {
	return nil, false
}

// AsArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsArtifact() (*Artifact, bool) {
	return nil, false
}

// AsBasicArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsBasicArtifact() (BasicArtifact, bool) {
	return &raa, true
}

// UnmarshalJSON is the custom unmarshaler for RoleAssignmentArtifact struct.
func (raa *RoleAssignmentArtifact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var roleAssignmentArtifactProperties RoleAssignmentArtifactProperties
				err = json.Unmarshal(*v, &roleAssignmentArtifactProperties)
				if err != nil {
					return err
				}
				raa.RoleAssignmentArtifactProperties = &roleAssignmentArtifactProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				raa.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				raa.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				raa.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				raa.Name = &name
			}
		}
	}

	return nil
}

// RoleAssignmentArtifactProperties properties of a Role assignment blueprint artifact.
type RoleAssignmentArtifactProperties struct {
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
	// DependsOn - Artifacts which need to be deployed before the specified artifact.
	DependsOn *[]string `json:"dependsOn,omitempty"`
	// RoleDefinitionID - Azure resource ID of the RoleDefinition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalIds - Array of user or group identities in Azure Active Directory. The roleDefinition will apply to each identity.
	PrincipalIds interface{} `json:"principalIds,omitempty"`
	// ResourceGroup - RoleAssignment will be scope to this resourceGroup. If empty, it scopes to the subscription.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// SecretValueReference reference to a Key Vault secret.
type SecretValueReference struct {
	// KeyVault - Specifies the reference to a given Azure Key Vault.
	KeyVault *KeyVaultReference `json:"keyVault,omitempty"`
	// SecretName - Name of the secret.
	SecretName *string `json:"secretName,omitempty"`
	// SecretVersion - The version of the secret to use. If left blank, the latest version of the secret is used.
	SecretVersion *string `json:"secretVersion,omitempty"`
}

// SharedBlueprintProperties shared Schema for both blueprintProperties and publishedBlueprintProperties.
type SharedBlueprintProperties struct {
	// Status - READ-ONLY; Status of the blueprint. This field is readonly.
	Status *Status `json:"status,omitempty"`
	// TargetScope - The scope where this blueprint definition can be assigned. Possible values include: 'Subscription', 'ManagementGroup'
	TargetScope TargetScope `json:"targetScope,omitempty"`
	// Parameters - Parameters required by this blueprint definition.
	Parameters map[string]*ParameterDefinition `json:"parameters"`
	// ResourceGroups - Resource group placeholders defined by this blueprint definition.
	ResourceGroups map[string]*ResourceGroupDefinition `json:"resourceGroups"`
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedBlueprintProperties.
func (sbp SharedBlueprintProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbp.TargetScope != "" {
		objectMap["targetScope"] = sbp.TargetScope
	}
	if sbp.Parameters != nil {
		objectMap["parameters"] = sbp.Parameters
	}
	if sbp.ResourceGroups != nil {
		objectMap["resourceGroups"] = sbp.ResourceGroups
	}
	if sbp.DisplayName != nil {
		objectMap["displayName"] = sbp.DisplayName
	}
	if sbp.Description != nil {
		objectMap["description"] = sbp.Description
	}
	return json.Marshal(objectMap)
}

// Status the status of the blueprint. This field is readonly.
type Status struct {
	// TimeCreated - READ-ONLY; Creation time of this blueprint definition.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// LastModified - READ-ONLY; Last modified time of this blueprint definition.
	LastModified *date.Time `json:"lastModified,omitempty"`
}

// MarshalJSON is the custom marshaler for Status.
func (s Status) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TemplateArtifact blueprint artifact that deploys a Resource Manager template.
type TemplateArtifact struct {
	// TemplateArtifactProperties - Properties for a Resource Manager template blueprint artifact.
	*TemplateArtifactProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindArtifact', 'KindTemplate', 'KindRoleAssignment', 'KindPolicyAssignment'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for TemplateArtifact.
func (ta TemplateArtifact) MarshalJSON() ([]byte, error) {
	ta.Kind = KindTemplate
	objectMap := make(map[string]interface{})
	if ta.TemplateArtifactProperties != nil {
		objectMap["properties"] = ta.TemplateArtifactProperties
	}
	if ta.Kind != "" {
		objectMap["kind"] = ta.Kind
	}
	return json.Marshal(objectMap)
}

// AsTemplateArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsTemplateArtifact() (*TemplateArtifact, bool) {
	return &ta, true
}

// AsRoleAssignmentArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool) {
	return nil, false
}

// AsPolicyAssignmentArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool) {
	return nil, false
}

// AsArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsArtifact() (*Artifact, bool) {
	return nil, false
}

// AsBasicArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsBasicArtifact() (BasicArtifact, bool) {
	return &ta, true
}

// UnmarshalJSON is the custom unmarshaler for TemplateArtifact struct.
func (ta *TemplateArtifact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var templateArtifactProperties TemplateArtifactProperties
				err = json.Unmarshal(*v, &templateArtifactProperties)
				if err != nil {
					return err
				}
				ta.TemplateArtifactProperties = &templateArtifactProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ta.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ta.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ta.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ta.Name = &name
			}
		}
	}

	return nil
}

// TemplateArtifactProperties properties of a Resource Manager template blueprint artifact.
type TemplateArtifactProperties struct {
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
	// DependsOn - Artifacts which need to be deployed before the specified artifact.
	DependsOn *[]string `json:"dependsOn,omitempty"`
	// Template - The Resource Manager template blueprint artifact body.
	Template interface{} `json:"template,omitempty"`
	// ResourceGroup - If applicable, the name of the resource group placeholder to which the Resource Manager template blueprint artifact will be deployed.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// Parameters - Resource Manager template blueprint artifact parameter values.
	Parameters map[string]*ParameterValue `json:"parameters"`
}

// MarshalJSON is the custom marshaler for TemplateArtifactProperties.
func (tap TemplateArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tap.DisplayName != nil {
		objectMap["displayName"] = tap.DisplayName
	}
	if tap.Description != nil {
		objectMap["description"] = tap.Description
	}
	if tap.DependsOn != nil {
		objectMap["dependsOn"] = tap.DependsOn
	}
	if tap.Template != nil {
		objectMap["template"] = tap.Template
	}
	if tap.ResourceGroup != nil {
		objectMap["resourceGroup"] = tap.ResourceGroup
	}
	if tap.Parameters != nil {
		objectMap["parameters"] = tap.Parameters
	}
	return json.Marshal(objectMap)
}

// TrackedResource common properties for all Azure tracked resources.
type TrackedResource struct {
	// Location - The location of this blueprint assignment.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UserAssignedIdentity user-assigned managed identity.
type UserAssignedIdentity struct {
	// PrincipalID - Azure Active Directory principal ID associated with this Identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - Client App Id associated with this identity.
	ClientID *string `json:"clientId,omitempty"`
}

// WhoIsBlueprintContract response schema for querying the Azure Blueprints service principal in the
// tenant.
type WhoIsBlueprintContract struct {
	autorest.Response `json:"-"`
	// ObjectID - AAD object Id of the Azure Blueprints service principal in the tenant.
	ObjectID *string `json:"objectId,omitempty"`
}
