﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ce/CostExplorerRequest.h>
#include <aws/ce/CostExplorer_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace CostExplorer {
namespace Model {

/**
 */
class GetAnomalyMonitorsRequest : public CostExplorerRequest {
 public:
  AWS_COSTEXPLORER_API GetAnomalyMonitorsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetAnomalyMonitors"; }

  AWS_COSTEXPLORER_API Aws::String SerializePayload() const override;

  AWS_COSTEXPLORER_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>A list of cost anomaly monitor ARNs. </p>
   */
  inline const Aws::Vector<Aws::String>& GetMonitorArnList() const { return m_monitorArnList; }
  inline bool MonitorArnListHasBeenSet() const { return m_monitorArnListHasBeenSet; }
  template <typename MonitorArnListT = Aws::Vector<Aws::String>>
  void SetMonitorArnList(MonitorArnListT&& value) {
    m_monitorArnListHasBeenSet = true;
    m_monitorArnList = std::forward<MonitorArnListT>(value);
  }
  template <typename MonitorArnListT = Aws::Vector<Aws::String>>
  GetAnomalyMonitorsRequest& WithMonitorArnList(MonitorArnListT&& value) {
    SetMonitorArnList(std::forward<MonitorArnListT>(value));
    return *this;
  }
  template <typename MonitorArnListT = Aws::String>
  GetAnomalyMonitorsRequest& AddMonitorArnList(MonitorArnListT&& value) {
    m_monitorArnListHasBeenSet = true;
    m_monitorArnList.emplace_back(std::forward<MonitorArnListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to retrieve the next set of results. Amazon Web Services provides
   * the token when the response from a previous call has more results than the
   * maximum page size. </p>
   */
  inline const Aws::String& GetNextPageToken() const { return m_nextPageToken; }
  inline bool NextPageTokenHasBeenSet() const { return m_nextPageTokenHasBeenSet; }
  template <typename NextPageTokenT = Aws::String>
  void SetNextPageToken(NextPageTokenT&& value) {
    m_nextPageTokenHasBeenSet = true;
    m_nextPageToken = std::forward<NextPageTokenT>(value);
  }
  template <typename NextPageTokenT = Aws::String>
  GetAnomalyMonitorsRequest& WithNextPageToken(NextPageTokenT&& value) {
    SetNextPageToken(std::forward<NextPageTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of entries that a paginated response contains. </p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline GetAnomalyMonitorsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_monitorArnList;
  bool m_monitorArnListHasBeenSet = false;

  Aws::String m_nextPageToken;
  bool m_nextPageTokenHasBeenSet = false;

  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostExplorer
}  // namespace Aws
