﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/bedrock-agent-runtime/model/GenerationConfiguration.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBaseRetrievalConfiguration.h>
#include <aws/bedrock-agent-runtime/model/OrchestrationConfiguration.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgentRuntime {
namespace Model {

/**
 * <p>Contains details about the resource being queried.</p> <p>This data type is
 * used in the following API operations:</p> <ul> <li> <p> <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax">Retrieve
 * request</a> – in the <code>knowledgeBaseConfiguration</code> field</p> </li>
 * <li> <p> <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate
 * request</a> – in the <code>knowledgeBaseConfiguration</code> field</p> </li>
 * </ul><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/KnowledgeBaseRetrieveAndGenerateConfiguration">AWS
 * API Reference</a></p>
 */
class KnowledgeBaseRetrieveAndGenerateConfiguration {
 public:
  AWS_BEDROCKAGENTRUNTIME_API KnowledgeBaseRetrieveAndGenerateConfiguration() = default;
  AWS_BEDROCKAGENTRUNTIME_API KnowledgeBaseRetrieveAndGenerateConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API KnowledgeBaseRetrieveAndGenerateConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier of the knowledge base that is queried.</p>
   */
  inline const Aws::String& GetKnowledgeBaseId() const { return m_knowledgeBaseId; }
  inline bool KnowledgeBaseIdHasBeenSet() const { return m_knowledgeBaseIdHasBeenSet; }
  template <typename KnowledgeBaseIdT = Aws::String>
  void SetKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    m_knowledgeBaseIdHasBeenSet = true;
    m_knowledgeBaseId = std::forward<KnowledgeBaseIdT>(value);
  }
  template <typename KnowledgeBaseIdT = Aws::String>
  KnowledgeBaseRetrieveAndGenerateConfiguration& WithKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    SetKnowledgeBaseId(std::forward<KnowledgeBaseIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the foundation model or <a
   * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference
   * profile</a> used to generate a response.</p>
   */
  inline const Aws::String& GetModelArn() const { return m_modelArn; }
  inline bool ModelArnHasBeenSet() const { return m_modelArnHasBeenSet; }
  template <typename ModelArnT = Aws::String>
  void SetModelArn(ModelArnT&& value) {
    m_modelArnHasBeenSet = true;
    m_modelArn = std::forward<ModelArnT>(value);
  }
  template <typename ModelArnT = Aws::String>
  KnowledgeBaseRetrieveAndGenerateConfiguration& WithModelArn(ModelArnT&& value) {
    SetModelArn(std::forward<ModelArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains configurations for how to retrieve and return the knowledge base
   * query.</p>
   */
  inline const KnowledgeBaseRetrievalConfiguration& GetRetrievalConfiguration() const { return m_retrievalConfiguration; }
  inline bool RetrievalConfigurationHasBeenSet() const { return m_retrievalConfigurationHasBeenSet; }
  template <typename RetrievalConfigurationT = KnowledgeBaseRetrievalConfiguration>
  void SetRetrievalConfiguration(RetrievalConfigurationT&& value) {
    m_retrievalConfigurationHasBeenSet = true;
    m_retrievalConfiguration = std::forward<RetrievalConfigurationT>(value);
  }
  template <typename RetrievalConfigurationT = KnowledgeBaseRetrievalConfiguration>
  KnowledgeBaseRetrieveAndGenerateConfiguration& WithRetrievalConfiguration(RetrievalConfigurationT&& value) {
    SetRetrievalConfiguration(std::forward<RetrievalConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains configurations for response generation based on the knowledge base
   * query results.</p>
   */
  inline const GenerationConfiguration& GetGenerationConfiguration() const { return m_generationConfiguration; }
  inline bool GenerationConfigurationHasBeenSet() const { return m_generationConfigurationHasBeenSet; }
  template <typename GenerationConfigurationT = GenerationConfiguration>
  void SetGenerationConfiguration(GenerationConfigurationT&& value) {
    m_generationConfigurationHasBeenSet = true;
    m_generationConfiguration = std::forward<GenerationConfigurationT>(value);
  }
  template <typename GenerationConfigurationT = GenerationConfiguration>
  KnowledgeBaseRetrieveAndGenerateConfiguration& WithGenerationConfiguration(GenerationConfigurationT&& value) {
    SetGenerationConfiguration(std::forward<GenerationConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Settings for how the model processes the prompt prior to retrieval and
   * generation.</p>
   */
  inline const OrchestrationConfiguration& GetOrchestrationConfiguration() const { return m_orchestrationConfiguration; }
  inline bool OrchestrationConfigurationHasBeenSet() const { return m_orchestrationConfigurationHasBeenSet; }
  template <typename OrchestrationConfigurationT = OrchestrationConfiguration>
  void SetOrchestrationConfiguration(OrchestrationConfigurationT&& value) {
    m_orchestrationConfigurationHasBeenSet = true;
    m_orchestrationConfiguration = std::forward<OrchestrationConfigurationT>(value);
  }
  template <typename OrchestrationConfigurationT = OrchestrationConfiguration>
  KnowledgeBaseRetrieveAndGenerateConfiguration& WithOrchestrationConfiguration(OrchestrationConfigurationT&& value) {
    SetOrchestrationConfiguration(std::forward<OrchestrationConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_knowledgeBaseId;
  bool m_knowledgeBaseIdHasBeenSet = false;

  Aws::String m_modelArn;
  bool m_modelArnHasBeenSet = false;

  KnowledgeBaseRetrievalConfiguration m_retrievalConfiguration;
  bool m_retrievalConfigurationHasBeenSet = false;

  GenerationConfiguration m_generationConfiguration;
  bool m_generationConfigurationHasBeenSet = false;

  OrchestrationConfiguration m_orchestrationConfiguration;
  bool m_orchestrationConfigurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
