/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.internal.Utils;
import org.testng.reporters.ICustomizeXmlReport;
import org.testng.reporters.RuntimeBehavior;
import org.testng.reporters.XMLReporterConfig;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.XMLSuiteResultWriter;
import org.testng.util.TimeUtils;
import org.testng.xml.XmlSuite;

public class XMLReporter
implements IReporter,
ICustomizeXmlReport {
    private final XMLReporterConfig config = new XMLReporterConfig();
    private XMLStringBuffer rootBuffer;

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        if (Utils.isStringEmpty(this.config.getOutputDirectory())) {
            this.config.setOutputDirectory(outputDirectory);
        }
        int passed = 0;
        int failed = 0;
        int skipped = 0;
        int ignored = 0;
        int retried = 0;
        for (ISuite s : suites) {
            Map<String, ISuiteResult> suiteResults = s.getResults();
            for (ISuiteResult sr : suiteResults.values()) {
                ITestContext testContext = sr.getTestContext();
                passed += testContext.getPassedTests().size();
                failed += testContext.getFailedTests().size();
                int retriedPerTest = 0;
                int skippedPerTest = 0;
                for (ITestResult result : testContext.getSkippedTests().getAllResults()) {
                    if (result.wasRetried()) {
                        ++retriedPerTest;
                        continue;
                    }
                    ++skippedPerTest;
                }
                skipped += skippedPerTest;
                retried += retriedPerTest;
                ignored += testContext.getExcludedMethods().size();
            }
        }
        this.rootBuffer = new XMLStringBuffer();
        Properties p = new Properties();
        p.put("passed", (Object)passed);
        p.put("failed", (Object)failed);
        p.put("skipped", (Object)skipped);
        if (retried > 0) {
            p.put("retried", (Object)retried);
        }
        p.put("ignored", (Object)ignored);
        p.put("total", (Object)(passed + failed + skipped + ignored + retried));
        this.rootBuffer.push("testng-results", p);
        this.writeReporterOutput(this.rootBuffer);
        for (ISuite suite : suites) {
            this.writeSuite(suite);
        }
        this.rootBuffer.pop();
        Utils.writeUtf8File(this.config.getOutputDirectory(), this.fileName(), this.rootBuffer, null);
    }

    @Override
    public void addCustomTagsFor(XMLStringBuffer xmlBuffer, ITestResult testResult) {
    }

    public String fileName() {
        return RuntimeBehavior.getDefaultFileNameForXmlReports();
    }

    private void writeReporterOutput(XMLStringBuffer xmlBuffer) {
        xmlBuffer.push("reporter-output");
        List<String> output = Reporter.getOutput();
        for (String line : output) {
            if (line == null) continue;
            xmlBuffer.push("line");
            xmlBuffer.addCDATA(line);
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private void writeSuite(ISuite suite) {
        switch (this.config.getFileFragmentationLevel()) {
            case 1: {
                this.writeSuiteToBuffer(this.rootBuffer, suite);
                break;
            }
            case 2: 
            case 3: {
                File suiteFile = this.referenceSuite(this.rootBuffer, suite);
                this.writeSuiteToFile(suiteFile, suite);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected value: " + this.config.getFileFragmentationLevel()));
            }
        }
    }

    private void writeSuiteToFile(File suiteFile, ISuite suite) {
        XMLStringBuffer xmlBuffer = new XMLStringBuffer();
        this.writeSuiteToBuffer(xmlBuffer, suite);
        File parentDir = suiteFile.getParentFile();
        suiteFile.getParentFile().mkdirs();
        if (parentDir.exists() || suiteFile.getParentFile().exists()) {
            Utils.writeUtf8File(parentDir.getAbsolutePath(), this.fileName(), xmlBuffer.toXML());
        }
    }

    private File referenceSuite(XMLStringBuffer xmlBuffer, ISuite suite) {
        String relativePath = suite.getName() + File.separatorChar + this.fileName();
        File suiteFile = new File(this.config.getOutputDirectory(), relativePath);
        Properties attrs = new Properties();
        attrs.setProperty("url", relativePath);
        xmlBuffer.addEmptyElement("suite", attrs);
        return suiteFile;
    }

    private void writeSuiteToBuffer(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("suite", this.getSuiteAttributes(suite));
        this.writeSuiteGroups(xmlBuffer, suite);
        Map<String, ISuiteResult> results = suite.getResults();
        XMLSuiteResultWriter suiteResultWriter = new XMLSuiteResultWriter(this.config, this);
        for (Map.Entry<String, ISuiteResult> result : results.entrySet()) {
            suiteResultWriter.writeSuiteResult(xmlBuffer, result.getValue());
        }
        xmlBuffer.pop();
    }

    private void writeSuiteGroups(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("groups");
        Map<String, Collection<ITestNGMethod>> methodsByGroups = suite.getMethodsByGroups();
        for (Map.Entry<String, Collection<ITestNGMethod>> entry : methodsByGroups.entrySet()) {
            Properties groupAttrs = new Properties();
            groupAttrs.setProperty("name", entry.getKey());
            xmlBuffer.push("group", groupAttrs);
            Set<ITestNGMethod> groupMethods = this.getUniqueMethodSet(entry.getValue());
            for (ITestNGMethod groupMethod : groupMethods) {
                Properties methodAttrs = new Properties();
                methodAttrs.setProperty("name", groupMethod.getMethodName());
                methodAttrs.setProperty("signature", groupMethod.toString());
                methodAttrs.setProperty("class", groupMethod.getRealClass().getName());
                xmlBuffer.addEmptyElement("method", methodAttrs);
            }
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private Properties getSuiteAttributes(ISuite suite) {
        Properties props = new Properties();
        props.setProperty("name", suite.getName());
        Map<String, ISuiteResult> results = suite.getResults();
        Date minStartDate = new Date();
        Date maxEndDate = null;
        for (Map.Entry<String, ISuiteResult> result : results.entrySet()) {
            ITestContext testContext = result.getValue().getTestContext();
            Date startDate = testContext.getStartDate();
            Date endDate = testContext.getEndDate();
            if (minStartDate.after(startDate)) {
                minStartDate = startDate;
            }
            if (maxEndDate != null && !maxEndDate.before(endDate)) continue;
            maxEndDate = endDate != null ? endDate : startDate;
        }
        if (maxEndDate == null) {
            maxEndDate = minStartDate;
        }
        XMLReporter.addDurationAttributes(this.config, props, minStartDate, maxEndDate);
        return props;
    }

    public static void addDurationAttributes(XMLReporterConfig config, Properties attributes, Date minStartDate, Date maxEndDate) {
        String startTime = TimeUtils.formatTimeInLocalOrSpecifiedTimeZone(minStartDate.getTime(), config.getTimestampFormat());
        String endTime = TimeUtils.formatTimeInLocalOrSpecifiedTimeZone(maxEndDate.getTime(), config.getTimestampFormat());
        long duration = maxEndDate.getTime() - minStartDate.getTime();
        attributes.setProperty("started-at", startTime);
        attributes.setProperty("finished-at", endTime);
        attributes.setProperty("duration-ms", Long.toString(duration));
    }

    private Set<ITestNGMethod> getUniqueMethodSet(Collection<ITestNGMethod> methods) {
        return new LinkedHashSet<ITestNGMethod>(methods);
    }

    @Override
    public XMLReporterConfig getConfig() {
        return this.config;
    }
}

