/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ksh extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "de Ääd" },
            { "002", "Affrika" },
            { "003", "Nood-Amärrika" },
            { "005", "Söhd-Amärrika" },
            { "009", "Ozejahneje" },
            { "011", "Wäß-Affrika" },
            { "013", "Meddelammärrika" },
            { "014", "Oß-Affrika" },
            { "015", "Nood-Affrika" },
            { "017", "Meddel-Affrika" },
            { "018", "Söhd-Affrika" },
            { "019", "Ammärrika" },
            { "021", "der Norde vun Amärrika" },
            { "029", "de Karribik" },
            { "030", "Oß-Aasije" },
            { "034", "Söhd-Aasije" },
            { "035", "Söhd-Oß-Aasije" },
            { "039", "Söhd-Europpa" },
            { "053", "de Rejjohn öm Austrahlije" },
            { "054", "Mellanehsije" },
            { "057", "de Rejohn vun Mikronehseje" },
            { "061", "Polinehsije" },
            { "142", "Aasije" },
            { "143", "Meddelaasije" },
            { "145", "Wäß-Aasije" },
            { "150", "Europpa" },
            { "151", "Oß-Europpa" },
            { "154", "Nood-Europpa" },
            { "155", "Wäß-Europpa" },
            { "419", "Lateinamärrika" },
            { "AC", "Aßension" },
            { "AD", "Andorra" },
            { "AE", "Vereinschte Arrabesche Emmirate" },
            { "AF", "Afjaanistahn" },
            { "AG", "Antigwa un Barbuda" },
            { "AI", "Anggwilla" },
            { "AL", "Albaanije" },
            { "AM", "Arrmeenije" },
            { "AO", "Angjoola" },
            { "AQ", "der Södpol" },
            { "AR", "Ajjentiinije" },
            { "AS", "Ammerikaanesch Sammoha" },
            { "AT", "Öösterisch" },
            { "AU", "Austraalije" },
            { "AW", "Aruba" },
            { "AX", "de Ohland-Enselle" },
            { "AZ", "Asserbaidschahn" },
            { "BA", "Boßnije un Herzegovina" },
            { "BB", "de Ensel Barbados" },
            { "BD", "Bangladesch" },
            { "BE", "Bellje" },
            { "BF", "Bukkinna-Faase" },
            { "BG", "Bulljaarije" },
            { "BH", "Bachrain" },
            { "BI", "Burundi" },
            { "BJ", "dä Benin" },
            { "BL", "de Zint Battälmi-Enselle" },
            { "BM", "de Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bolliivije" },
            { "BQ", "de karribbesche Nederläng" },
            { "BR", "Brasilije" },
            { "BS", "de Bahamas" },
            { "BT", "Buttaan" },
            { "BV", "de Buvee-Ensel" },
            { "BW", "Bozwaana" },
            { "BY", "Wießrußland" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "de Kokkos-Enselle" },
            { "CD", "dä Konggo (Kinschasa)" },
            { "CF", "de Zäntraalaffrikaanesche Republik" },
            { "CG", "dä Konggo (Brassavill)" },
            { "CH", "de Schweiz" },
            { "CI", "Älfebeijn-Köß" },
            { "CK", "de Kuuk-Enselle" },
            { "CL", "Schiile" },
            { "CM", "Kammeruhn" },
            { "CN", "Schiina" },
            { "CO", "Kolumbije" },
            { "CP", "de Klipperton-Ensel" },
            { "CR", "Kostarika" },
            { "CU", "Kuhba" },
            { "CV", "de kapvärdesche Enselle" },
            { "CW", "Curaçao" },
            { "CX", "de Weihnaachs-Ensel" },
            { "CY", "Züppere" },
            { "CZ", "de Tschäschei" },
            { "DE", "Doütschland" },
            { "DG", "de Diego-Garcia-Ensel" },
            { "DJ", "Dschibutti" },
            { "DK", "Dänemark" },
            { "DM", "Dominnika" },
            { "DO", "de Dommenekaanesche Reppublik" },
            { "DZ", "Alljeerije" },
            { "EA", "Ze’uta un Meliija" },
            { "EC", "Äkwador" },
            { "EE", "Äßland" },
            { "EG", "Äjüpte" },
            { "EH", "Wäß-Sahara" },
            { "ER", "Äritreja" },
            { "ES", "Schpaanije" },
            { "ET", "Ättijoopije" },
            { "EU", "de Europähjesche Unijon" },
            { "FI", "Finnland" },
            { "FJ", "de Fidschi-Endelle" },
            { "FK", "de Falkland-Enselle" },
            { "FM", "Mikroneesije" },
            { "FO", "de Färrör-Enselle" },
            { "FR", "Frankrisch" },
            { "GA", "Jabuhn" },
            { "GB", "Jruußbrettannije" },
            { "GD", "Jrenahda" },
            { "GE", "Jeorrjije" },
            { "GF", "Franzüüsesch Jujaana" },
            { "GG", "Jöönsei" },
            { "GH", "Jaana" },
            { "GI", "Jibralltaa" },
            { "GL", "Jröhnland" },
            { "GM", "Jambija" },
            { "GN", "Jinneha" },
            { "GP", "Juadelupp" },
            { "GQ", "Äquatorial Jineeja" },
            { "GR", "Jriescheland" },
            { "GS", "Söd-Jeorjie un de södlijje Botteramms-Enselle" },
            { "GT", "Juwatemahla" },
            { "GU", "Juham" },
            { "GW", "Jinneha_Bißau" },
            { "GY", "Jujaana" },
            { "HK", "Hongkong" },
            { "HM", "de Heart Ensel un de McDonald-Enselle" },
            { "HN", "Honduras" },
            { "HR", "Krowazije" },
            { "HT", "Ha’itti" },
            { "HU", "Unjann" },
            { "IC", "de Kannaresche Enselle" },
            { "ID", "Indoneesije" },
            { "IE", "Irrland" },
            { "IL", "Ißraäl" },
            { "IM", "de Ensel Män" },
            { "IN", "Indije" },
            { "IQ", "Irak" },
            { "IR", "Persije" },
            { "IS", "Ißland" },
            { "IT", "Itaalije" },
            { "JE", "Jööseh" },
            { "JM", "Jammaika" },
            { "JO", "Jordaanije" },
            { "JP", "Japan" },
            { "KE", "Keenija" },
            { "KG", "Kirrjiisije" },
            { "KH", "Kambodscha" },
            { "KI", "Kiribati" },
            { "KM", "de Kommoore" },
            { "KN", "Zint Kitts un Nevis" },
            { "KP", "Nood-Koreja" },
            { "KR", "Söd-Koreja" },
            { "KW", "Kuweit" },
            { "KY", "de Kaiman-Enselle" },
            { "KZ", "Kassakstahn" },
            { "LA", "La’os" },
            { "LB", "Lebbannon" },
            { "LC", "de Ensel Zint-Lutscha" },
            { "LI", "Lischteschtein" },
            { "LK", "Sri Lanka" },
            { "LR", "Libeerija" },
            { "LS", "Lesooto" },
            { "LT", "Littaue" },
            { "LU", "Luxembursch" },
            { "LV", "Lätland" },
            { "LY", "Libbije" },
            { "MA", "Marokko" },
            { "MC", "Monakko" },
            { "MD", "Moldaavije" },
            { "ME", "et Monteneejro" },
            { "MF", "de Zint-Määtes-Ensel" },
            { "MG", "Maddajaska" },
            { "MH", "de Machschall-Enselle" },
            { "ML", "Maali" },
            { "MM", "Birma" },
            { "MN", "Mongjolei" },
            { "MO", "Makau" },
            { "MP", "de nöödlijje Marijanne-Enselle" },
            { "MQ", "Machtinik" },
            { "MR", "Mautitaanije" },
            { "MS", "Mongßerrat" },
            { "MT", "Malta" },
            { "MU", "Maurizijus" },
            { "MV", "Mallediive" },
            { "MW", "Malawi" },
            { "MX", "Mäxiko" },
            { "MY", "Malaisije" },
            { "MZ", "Mosambik" },
            { "NA", "Namiibije" },
            { "NC", "Neuschottland" },
            { "NE", "Nijer" },
            { "NF", "de Noofok-Ensel" },
            { "NG", "Nikaraagua" },
            { "NI", "Nikarahguwa" },
            { "NL", "de Nederläng" },
            { "NO", "Norrweeje" },
            { "NP", "Nepall" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Neuseeland" },
            { "OM", "Oman" },
            { "PA", "Pannama" },
            { "PE", "Perruh" },
            { "PF", "Franzüüsesch Pollineesije" },
            { "PG", "Papuwa Neujineeja" },
            { "PH", "Fillipiine" },
            { "PK", "Pakistahn" },
            { "PL", "Pole" },
            { "PM", "Zint Pjäär un Mikelong" },
            { "PN", "de Pitkärn-Ensel" },
            { "PR", "Pochtoriko" },
            { "PS", "Palästina" },
            { "PT", "Pochtojall" },
            { "PW", "Pallau" },
            { "PY", "Parraguwai" },
            { "QA", "Kataa" },
            { "QO", "Ozejahnije ußerhallef" },
            { "RE", "Rehunjohn" },
            { "RO", "Romäänije" },
            { "RS", "Särbije" },
            { "RU", "Rußland" },
            { "RW", "Ruanda" },
            { "SA", "Saudi Arraabije" },
            { "SB", "de Solomone-Enselle" },
            { "SC", "de Seischälle" },
            { "SD", "Noodsudahn" },
            { "SE", "Schweede" },
            { "SG", "Singjapuur" },
            { "SH", "de Ensel Zint Hellena" },
            { "SI", "ẞloveenije" },
            { "SJ", "de Enselle Svalbard un Jan Mayen" },
            { "SK", "ẞlovakei" },
            { "SL", "Sjärra Lejone" },
            { "SM", "San-Marino" },
            { "SN", "der Sennejall" },
            { "SO", "Somaalije" },
            { "SR", "Sürinamm" },
            { "SS", "Södsudahn" },
            { "ST", "Zint Tommeh un Printschipe" },
            { "SV", "Äl Slavadohr" },
            { "SX", "Zint Maarten" },
            { "SY", "Sürije" },
            { "SZ", "ẞwaasiland" },
            { "TA", "Tristan da Cunja" },
            { "TC", "de Enselle Turks un Kaikos" },
            { "TD", "der Tschadd" },
            { "TF", "Franzüüsesche Södsee-Enselle" },
            { "TG", "Toojo" },
            { "TH", "Tailand" },
            { "TJ", "Tadschikistahn" },
            { "TK", "Tokelau" },
            { "TL", "Oß-Timor" },
            { "TM", "Turkmenistahn" },
            { "TN", "Tuneesije" },
            { "TO", "Tongga" },
            { "TR", "de Törkei" },
            { "TT", "Trinidad un Tobähjo" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansanija" },
            { "UA", "de Ukra’iine" },
            { "UG", "Ujanda" },
            { "UM", "de Vereineschte Schtaate vun Amärrika ier ußerhallef jelääje Enselsche" },
            { "US", "de vereineschte Schtaate vun Ammärrika" },
            { "UY", "Urrujwai" },
            { "UZ", "Ußbeekistahn" },
            { "VA", "der Vattikahn" },
            { "VC", "Zint Vinzänz un de Jrenadines-Enselle" },
            { "VE", "Venezuela" },
            { "VG", "de brettesche Juffer-Enselle" },
            { "VI", "de ammärrikahnesche Juffer-Enselle" },
            { "VN", "Vijätnamm" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis un Futuna" },
            { "WS", "Sammoha" },
            { "XK", "Kosovo" },
            { "YE", "Jämme" },
            { "YT", "Majott" },
            { "ZA", "de Republik Södaffrika" },
            { "ZM", "Sambija" },
            { "ZW", "Simbabwe" },
            { "ZZ", "- Jähjend onbikannt -" },
            { "aa", "Afahresch" },
            { "ab", "Abchahsesch" },
            { "ae", "Avästahnesch" },
            { "af", "Afrikaans" },
            { "ak", "Akahnesch" },
            { "am", "Amhahresch" },
            { "an", "Arrajonehsesch" },
            { "ar", "Arahbesch" },
            { "as", "Aßamehsesch" },
            { "av", "Avahresch" },
            { "ay", "Aimahresch" },
            { "az", "Asserbaidschahnesch" },
            { "ba", "Baschkihresch" },
            { "be", "Wiißrußesch" },
            { "bg", "Bulljahresch" },
            { "bi", "Bislahmesch" },
            { "bm", "Bambara" },
            { "bn", "Bängjahlesch" },
            { "bo", "Tibehtesch" },
            { "br", "Bettohnesch" },
            { "bs", "Boßnesch" },
            { "ca", "Kattalahnesch" },
            { "ce", "Tschätschehnesch" },
            { "ch", "Chamorru" },
            { "co", "Korsesch" },
            { "cs", "Tschäschesch" },
            { "cu", "Kerscheßlahwesch" },
            { "cv", "Tschowaschesch" },
            { "cy", "Wallihsesch" },
            { "da", "Dähnesch" },
            { "de", "Deutsch" },
            { "dv", "Divehjesch" },
            { "dz", "Butahnesch" },
            { "ee", "Ewe" },
            { "el", "Jrihschesch" },
            { "en", "Änglesch" },
            { "eo", "Esperanto" },
            { "es", "Schpahnesch" },
            { "et", "Äßnesch" },
            { "eu", "Baskesch" },
            { "fa", "Pärsesch" },
            { "ff", "Fulfulde" },
            { "fi", "Finnesch" },
            { "fj", "Fihdschesch" },
            { "fo", "Färröhresch" },
            { "fr", "Franzühsesch" },
            { "fy", "Wäßfrihsesch" },
            { "ga", "Ihresch" },
            { "gl", "Jallihzesch" },
            { "gn", "Juwarahnesch" },
            { "gu", "Gutscharatesch" },
            { "gv", "Mangx" },
            { "ha", "Haußa" },
            { "he", "Hebrähjesch" },
            { "hi", "Hinndi" },
            { "hr", "Krowatesch" },
            { "ht", "Ha’iihtesch" },
            { "hu", "Unnjarresch" },
            { "hy", "Armehnesch" },
            { "hz", "Herrehro" },
            { "ia", "de Interlingua" },
            { "id", "Indonehsesch" },
            { "ig", "Igbo" },
            { "io", "Ihdo" },
            { "is", "Ißlänndesch" },
            { "it", "Etalljähnesch" },
            { "iu", "Inuktitut" },
            { "ja", "Japahnesch" },
            { "jv", "Javahnesch" },
            { "ka", "Je’orjesch" },
            { "ki", "Rekohjo" },
            { "kj", "Oschivambo" },
            { "kk", "Kassakkesch" },
            { "kl", "Jröhnländesch" },
            { "km", "Khmer" },
            { "kn", "Kannada" },
            { "ko", "Korrejaanesch" },
            { "kr", "Kanuhresch" },
            { "ks", "Kaschmihresch" },
            { "ku", "Kurrdesch" },
            { "kv", "Kohmesch" },
            { "kw", "Kornesch" },
            { "ky", "Kirjihsesch" },
            { "la", "Lateijnesch" },
            { "lb", "Luxemborjesch" },
            { "lg", "Lugannda" },
            { "li", "Lemburjesch" },
            { "ln", "Lingjalla" },
            { "lo", "Lahootesch" },
            { "lt", "Littouesch" },
            { "lu", "Kiluba" },
            { "lv", "Lättesch" },
            { "mg", "Madajaßkesch" },
            { "mh", "Maschallehsesch" },
            { "mi", "Ma’ohresch" },
            { "mk", "Mazedohnesch" },
            { "ml", "Mallajalam" },
            { "mn", "Mongjohlesch" },
            { "mr", "Marrahtesch" },
            { "ms", "Mallaijesch" },
            { "mt", "Maltehsesch" },
            { "my", "Burmehsesch" },
            { "na", "Nauruhesch" },
            { "nb", "Norrwehjesch Bokmål" },
            { "nd", "Nood-Ndebele" },
            { "ne", "Nepallehsesch" },
            { "ng", "Ndongjahnesch" },
            { "nl", "Holländesch" },
            { "nn", "Neu Norrwehjesch" },
            { "no", "Norrwehjesch" },
            { "nv", "Navvacho" },
            { "ny", "Schi-Schewa" },
            { "or", "Oriija" },
            { "os", "Oßeetesch" },
            { "pa", "Panschaabesch" },
            { "pl", "Pollnesch" },
            { "ps", "Paschtuunesch" },
            { "pt", "Pochtojesesch" },
            { "qu", "Kättschowa" },
            { "rm", "Rätoromaanesch" },
            { "rn", "K-Rundesch" },
            { "ro", "Rumänesch" },
            { "ru", "Rußßesch" },
            { "rw", "Kinja-Ruandesch" },
            { "sa", "Sanskrit" },
            { "sd", "Sinndi" },
            { "se", "Nood-Lappländesch" },
            { "sg", "Sangjo" },
            { "sh", "Särbokowatesch" },
            { "si", "Singjaleesesch" },
            { "sk", "ẞlovakesch" },
            { "sl", "ẞloveenesch" },
            { "sm", "Sammohanesch" },
            { "sn", "Schi-Schona" },
            { "so", "Somahlesch" },
            { "sq", "Albahnesch" },
            { "sr", "Särbesch" },
            { "ss", "Si-Swatesch" },
            { "st", "Söd-Sooto" },
            { "su", "Sindanehsesch" },
            { "sv", "Schwehdesch" },
            { "sw", "Suahehlesch" },
            { "ta", "Tamihlesch" },
            { "te", "Telluhju" },
            { "tg", "Tadschihkesch" },
            { "th", "Tailändesch" },
            { "ti", "Tijrenejahnesch" },
            { "tk", "Törkmehnesch" },
            { "tl", "Tajalloch" },
            { "tn", "Se-Zwahnesch" },
            { "to", "Tongjahnesch" },
            { "tr", "Törkesch" },
            { "ts", "Xi-Zongjahnesch" },
            { "tt", "Tattahresch" },
            { "ty", "Tahihtesch" },
            { "ug", "Uj’juhresch" },
            { "uk", "Ukrainesch" },
            { "ur", "Urdu/Hindi" },
            { "uz", "Ußbehkesch" },
            { "ve", "Wenda" },
            { "vi", "Vijätnammehsesch" },
            { "vo", "Volapük" },
            { "wa", "Walohnesch" },
            { "wo", "Woloff" },
            { "xh", "Isi-Khohsa" },
            { "yi", "Jiddesch" },
            { "yo", "Joruhba" },
            { "zh", "Schinehsesch (Mandarin)" },
            { "zu", "Suhlu" },
            { "ace", "Aschenehsesch" },
            { "ada", "Adangmesch" },
            { "ady", "Adygehjsch" },
            { "aeb", "Tonehsesch Arahbesch" },
            { "afh", "Afrehihlesch" },
            { "agq", "Aghehmesch" },
            { "ain", "Aijnu" },
            { "akk", "Akahdesch" },
            { "ale", "Ale’uhtesch" },
            { "ang", "Ahl Änglesch" },
            { "anp", "Anjikahnesch" },
            { "arp", "Arrappaho" },
            { "arq", "Aljehresch Arahbesch" },
            { "ary", "Marokahnesch Arahbesch" },
            { "arz", "Äjiptesch Arahbesch" },
            { "asa", "Pare" },
            { "ase", "Amärrekahnesche Blendeschprohch" },
            { "ast", "Astuhrejahnesch" },
            { "awa", "Awahdesch" },
            { "bal", "Beluhtschesch" },
            { "ban", "Balinehsesch" },
            { "bar", "Bairesch" },
            { "bas", "Basaa-Schprohche" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bho", "Bhohdschpuresch" },
            { "bin", "Edo" },
            { "bpy", "Bischnuprejahnesch" },
            { "bra", "Brahjesch" },
            { "brh", "Brahuijesch" },
            { "brx", "Boddo" },
            { "bua", "Burejahtesch" },
            { "bug", "Bujinehsesch" },
            { "byn", "Bilihnesch" },
            { "ceb", "Zebuwahnesch" },
            { "cgg", "Kihja-Schprohch" },
            { "chk", "Trukehsesch" },
            { "chm", "Mahresch" },
            { "cho", "Tschoktoh" },
            { "chr", "Tschärrokeh" },
            { "chy", "Tschäjänn" },
            { "ckb", "Zäntrahl-Kurrdesch" },
            { "cop", "Koptesch" },
            { "csb", "Kaschuhbesch" },
            { "dak", "Dakohtesch" },
            { "dar", "Darjihnesch" },
            { "dav", "Dawedahnesch" },
            { "dgr", "Dohjribesch" },
            { "dje", "Djerma" },
            { "dsb", "Niddersorbesch" },
            { "dua", "Du’ala" },
            { "dum", "Meddelnehderlängsch" },
            { "dyo", "Jola-Fonyisch" },
            { "dzg", "Dassajahnesch" },
            { "ebu", "Kîembu" },
            { "efi", "Äffiksch" },
            { "egl", "Emilijahnesch" },
            { "egy", "Ahl Äjiptesch" },
            { "eka", "Ekajukesch" },
            { "enm", "Meddelänglesch" },
            { "esu", "Zäntrahl-Juppik" },
            { "ewo", "Ewonndo" },
            { "fil", "Fillipihnesch" },
            { "fon", "Fohnesch" },
            { "fur", "Frijauhlesch" },
            { "gaa", "Jah" },
            { "gez", "Ji’is-Ahl-Ättejohpesch" },
            { "gil", "Jillbättehsesch" },
            { "gor", "Jorontalohsch" },
            { "gsw", "Schwitzerdütsch" },
            { "haw", "Hauajahnesch" },
            { "hil", "Hiligaynon" },
            { "hmn", "Hmong" },
            { "hsb", "Bovversorrbesch" },
            { "hup", "Hupa" },
            { "iba", "Ibahnesch" },
            { "ibb", "Ibibio" },
            { "ilo", "Ilokahnesch" },
            { "inh", "Engjuschesch" },
            { "izh", "Ingjrijahnesch" },
            { "jam", "Jamaikahnesch-Änglesch" },
            { "jbo", "Lodschbahn" },
            { "jgo", "Njomba" },
            { "jpr", "Jühdesch-Pärsesch" },
            { "jut", "Jüttesch" },
            { "kab", "Kabyhlesch" },
            { "kam", "Kamba vun Kehnija" },
            { "kbd", "Kabadihnesch" },
            { "kde", "Chimakonde" },
            { "kea", "Kapvärdesch" },
            { "kfo", "Koro vun de Älfebeijnköß" },
            { "kha", "Khasi" },
            { "khq", "Kojra Tschihni" },
            { "kkj", "Kako" },
            { "kln", "Kaländjihnesch" },
            { "kmb", "Kimbundu" },
            { "kok", "Kon’kahnesch" },
            { "kpe", "Kpäle" },
            { "krc", "Karatschaj-Balkahresch-Törkesch" },
            { "krl", "Karehlesch" },
            { "kru", "Korochesch" },
            { "ksf", "Bafijahnesch" },
            { "ksh", "Kölsch" },
            { "kum", "Kumykesch" },
            { "lad", "Ladihnesch" },
            { "lag", "Lango" },
            { "lah", "de Landa-Schprooche" },
            { "lez", "Lesjesch" },
            { "lkt", "Lakota" },
            { "loz", "Silohzi" },
            { "lrc", "Nood-Luhresch" },
            { "lua", "Tschiluba" },
            { "lun", "Schilunnda" },
            { "luo", "Luo" },
            { "luy", "Luhjesch" },
            { "mdf", "Mokschah" },
            { "mni", "Meitei-Manipuhresch" },
            { "mua", "Mundang" },
            { "mul", "-ongerscheidlijje Schprohche-" },
            { "mus", "Krihk" },
            { "mwl", "Mirandehsesch" },
            { "myv", "Ärsjahnesch" },
            { "nap", "Napolletahnesch" },
            { "new", "Newahresch" },
            { "nmg", "Gyele" },
            { "nnh", "Njijembohn" },
            { "nog", "Nojal" },
            { "nso", "Nood-Sohto" },
            { "quc", "K’ische’" },
            { "rof", "Kirombo" },
            { "rup", "Arromahnesch" },
            { "sah", "Jackutesch" },
            { "sba", "Njambaij" },
            { "ses", "Kojraboro Senni" },
            { "shi", "Taschelhittesch" },
            { "smj", "Lule-Läppländesch" },
            { "smn", "Inahri Lappländesch" },
            { "swb", "Kommohresch" },
            { "syr", "Sührejakkesch" },
            { "tet", "Tetumsch" },
            { "tig", "Tigre" },
            { "tlh", "Klingjohnesch" },
            { "tpi", "Tok Pisin" },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinijahnesch" },
            { "tzm", "Tamasicht ussem meddlere Atlas" },
            { "udm", "Udmuchtesch" },
            { "umb", "Umbundesch" },
            { "und", "-onbikannte-Schprooch-" },
            { "wae", "Walserdütsch" },
            { "wal", "Welahmo" },
            { "war", "Waray-Waray" },
            { "xal", "Kalmükkesch" },
            { "ybb", "Jämmbah" },
            { "yue", "Kanton-Schinehsesch" },
            { "zun", "Suhñi" },
            { "zxx", "kein Schprooch" },
            { "zza", "Sahsajesch" },
            { "Arab", "arraabesche Schreff" },
            { "Armn", "armeenesche Schreff" },
            { "Beng", "bängjaalesche Schreff" },
            { "Bopo", "schineeseche Ömschreff Bopomofo" },
            { "Brai", "Blindeschreff" },
            { "Cyrl", "kürrellesche Schreff" },
            { "Deva", "indesche Devanajari-Schreff" },
            { "Ethi", "ätejoopesche Schreff" },
            { "Geor", "je’orrjesche Schreff" },
            { "Grek", "jriischesche Schreff" },
            { "Gujr", "jujaraatesche Schreff" },
            { "Guru", "indesche Gurmukhi-Schreff" },
            { "Hang", "korrejaanesche Schreff" },
            { "Hani", "en schineesesche Schreff" },
            { "Hans", "eijfacher" },
            { "Hant", "tradizjonäll" },
            { "Hebr", "hebrääjesche Schreff" },
            { "Hira", "japaanesche Hiddajaana-Schreff" },
            { "Jpan", "en japaanesche Schreff" },
            { "Kana", "japaanesche Kattakaana-Schreff" },
            { "Khmr", "Khmer-Schreff" },
            { "Knda", "indesche Kannada-Schreff" },
            { "Kore", "korrejaanesche Schreff udder en schineesesche Schreff" },
            { "Laoo", "lahootesche Schreff" },
            { "Latn", "lateinesche Schreff" },
            { "Mlym", "indesche Malajalam-Schreff" },
            { "Mong", "mongjoolesche Schreff" },
            { "Mymr", "birmahnesche Schreff" },
            { "Orya", "indesche Orija-Schreff" },
            { "Sinh", "singjaleesesche Schreff" },
            { "Taml", "tamiilesche Schreff" },
            { "Telu", "indesche Telugu-Schreff" },
            { "Thaa", "malledivesche Taana-Schreff" },
            { "Thai", "tailändesche Schreff" },
            { "Tibt", "tibeetesche Schreff" },
            { "Zsym", "-Zeiche ävver kein Schreff-" },
            { "Zxxx", "-jaa keij Schreff-" },
            { "Zyyy", "-öhnß en Schreff-" },
            { "Zzzz", "-onbikannte Schreff-" },
            { "de_AT", "Deutsch uß Öhßterich" },
            { "de_CH", "Deutsch uß de Schweijz" },
            { "en_AU", "Änglesch uß Außtrahlije" },
            { "en_CA", "Änglesch uß Kanada" },
            { "en_GB", "Änglesch uß Jruhßbrettannije" },
            { "en_US", "Amärrekahnesch Änglesch" },
            { "es_ES", "Schpahnesch en Schpahneje" },
            { "es_MX", "Schpahnesch en Mäxikoh" },
            { "fr_CA", "Franzühsesch uß Kanada" },
            { "fr_CH", "Franzühsesch uß de Schweijz" },
            { "nl_BE", "Flähmesch" },
            { "pt_BR", "Brasilljaanesch Pochtojesesch" },
            { "pt_PT", "Pochtojesesch uß Pochtojall" },
            { "%%1901", "Schriefwiiß vun 1901 aff" },
            { "%%1994", "resijanesch schtandatt Schriefwiiß vun 1994" },
            { "%%1996", "Schriefwiiß vun 1996 aff" },
            { "ar_001", "Schtandatt Arahbesch" },
            { "es_419", "Schpahnesch uß Latting-Ammärrika" },
            { "key.ca", "dä Kalländer" },
            { "key.co", "de Reijefollsch zom Zotiere" },
            { "key.cu", "de Zoot Jeld" },
            { "key.nu", "de Nummere" },
            { "nds_NL", "Nehdersaksesch en de Nederläng" },
            { "%%BISKE", "zint jorjo’sche uder bila’sche reijanesche Dijaläk" },
            { "%%BOONT", "boontlingsche Dijaläk" },
            { "%%KKCOR", "jemeinsam widderbeläf kornesche Schriefwiiß" },
            { "%%LIPAW", "lipovazesch resijanesche Dijaläk" },
            { "%%NEDIS", "natisonesche Dijaläk" },
            { "%%NJIVA", "gniva’sche uder njiva’sche reijanesche Dijaläk" },
            { "%%OSOJS", "oseacco’sche uder osojanesche reijanesche Dijaläk" },
            { "%%ROZAJ", "resijanesche Dijaläk" },
            { "%%SOLBA", "stolvizanesche uder solbizanesch reijanesche Dijaläk" },
            { "%%UCCOR", "eijheijtlesch Schriefwiiß" },
            { "az_Arab", "Södasserbaidschahnesch" },
            { "zh_Hans", "Schinehsesch (eijfache Schreff)" },
            { "zh_Hant", "Schinehsesch (tradizjonälle Schreff)" },
            { "%%FONIPA", "IPA-Loutschreff" },
            { "%%FONUPA", "UPA-Loutschreff" },
            { "%%NDYUKA", "ndyukanesche Dijaläk" },
            { "%%PAMAKA", "pamakanesche Dijaläk" },
            { "%%PINYIN", "Pinjin-Ömschreff" },
            { "%%SCOUSE", "scouse Dijaläk" },
            { "%%TARASK", "Taraskijeviza-Schriefwiiß" },
            { "%%UCRCOR", "eijheijtlesch, neu opjelate Schriefwiiß" },
            { "%%ALALC97", "de lateinesche Ömschreff ALA-LC vun 1997" },
            { "%%AREVELA", "oß-armeensch" },
            { "%%AREVMDA", "wäß-armeenesch" },
            { "%%HEPBURN", "De Lateinesche Ömschreff noh Hepburn" },
            { "%%MONOTON", "monnotoonesch" },
            { "%%POLYTON", "pollütoonesch" },
            { "%%REVISED", "neu opjelate Schriefwiiß" },
            { "%%1606NICT", "späätmeddelfranzüüsesch vör 1606" },
            { "%%1694ACAD", "fröhneufranzüüsesch aff 1694" },
            { "%%1959ACAD", "akademesche Schriefwiiß vun 1959" },
            { "%%BAKU1926", "eijheijtlesch törkesch lateijnesch Allfabeet" },
            { "%%HOGNORSK", "Huhnorrweejesch" },
            { "%%SCOTLAND", "schottesche Dijaläk" },
            { "%%VALENCIA", "valenzijaanesche Dijaläk" },
            { "%%WADEGILE", "lateijnesche Ömschreff noh Wade-Giles" },
            { "type.ca.roc", "rotschineesesche Kaländer" },
            { "type.nu.arab", "araabesche un indesche Zeffere" },
            { "type.nu.armn", "armeenesche Zahle" },
            { "type.nu.beng", "bängjaalesche Zeffere" },
            { "type.nu.deva", "Devanagari-Zeffere" },
            { "type.nu.ethi", "ätejoopesche Zahle" },
            { "type.nu.geor", "jeorjeesche Zahle" },
            { "type.nu.grek", "jriischesche Zahle" },
            { "type.nu.gujr", "Jujarati-Zeffere" },
            { "type.nu.guru", "Jurmukhi-Zeffere" },
            { "type.nu.hans", "eijfache schineesesche Zahle" },
            { "type.nu.hant", "tradizjonälle schineesesche Zahle" },
            { "type.nu.hebr", "hebräjesche Zahle" },
            { "type.nu.jpan", "japanesche Zahle" },
            { "type.nu.khmr", "Khmer-Zeffere" },
            { "type.nu.knda", "Kannada-Zeffere" },
            { "type.nu.laoo", "laootesche Zeffere" },
            { "type.nu.latn", "wäßlejje Zeffere" },
            { "type.nu.mlym", "Malayalam-Zeffere" },
            { "type.nu.mong", "mongjoolesche Zeffere" },
            { "type.nu.mymr", "Myanmar-Zeffere" },
            { "type.nu.orya", "Oriya-Zeffere" },
            { "type.nu.taml", "tradizjonälle tamilesche Zahle" },
            { "type.nu.telu", "Teluju-Zeffere" },
            { "type.nu.thai", "thailändesche Zeffere" },
            { "type.nu.tibt", "tibetaanesche Zeffere" },
            { "type.ca.dangi", "Dangikalännder" },
            { "type.co.ducet", "standattmähßesch zotehrt nohm Unicode" },
            { "type.nu.roman", "römesche Zahle" },
            { "type.ca.coptic", "kopttesche Kaländer" },
            { "type.ca.hebrew", "jühdesche Kalännder" },
            { "type.ca.indian", "indesche Nazjonahl-Kaländer" },
            { "type.co.pinyin", "zoteert noh de Pinjin Ömschreff vum Schineesesch" },
            { "type.co.search", "Söhke" },
            { "type.co.stroke", "zoteert noh de Stresche vum tradizjonäll schineesesch" },
            { "type.co.unihan", "zoteert noh de Radikaale un Stresche vum Schineesesch" },
            { "type.ca.chinese", "schinehsesche Kalännder" },
            { "type.ca.persian", "pärsesche Kaländer" },
            { "type.nu.arabext", "ußjedehnt araabesche un indesche Zeffere" },
            { "type.nu.armnlow", "klein jeschrevve armeenesche Zahle" },
            { "type.nu.greklow", "klein jeschrevve jriischesche Zahle" },
            { "type.nu.hanidec", "schineesesche Zehnerzahle" },
            { "type.nu.hansfin", "eijfache schineesesche Finanzzahle" },
            { "type.nu.hantfin", "tradizjonälle schineesesche Finanzzahle" },
            { "type.nu.jpanfin", "japaanesche Finazzahle" },
            { "type.nu.tamldec", "tamiilesche Zeffere" },
            { "type.ca.buddhist", "buddistesche Kaländer" },
            { "type.ca.ethiopic", "ätejohpesche Kalännder" },
            { "type.ca.japanese", "japaanesche Kaländer" },
            { "type.co.standard", "Schtandatt" },
            { "type.nu.fullwide", "janz breede Zeffere" },
            { "type.nu.romanlow", "klein jeschrevve römesche Zahle" },
            { "type.ca.gregorian", "jrejorejahnesche Kalännder" },
            { "type.co.phonebook", "zoteert wi em Tollefoonbooch" },
            { "type.co.dictionary", "zotehrt wi em Wööterbohch" },
            { "type.co.traditional", "tradizjonäll zoteert" },
            { "ListCompositionPattern", "{0} uß {1}" },
            { "type.ca.ethiopic-amete-alem", "ätejoopesche Amete Alem Kaländer" },
        };
        return data;
    }
}
