// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

use icu_collections::codepointtrie::{CodePointTrieHeader, TrieType};
use zerovec::ule::AsULE;
use zerovec::{zerovec, ZeroVec};

#[rustfmt::skip]
pub const INDEX: ZeroVec<u16> = zerovec!(u16; <u16 as AsULE>::ULE::from_unsigned;
    [
        0,0x40,0x7f,0xbf,0xff,0x12e,0x16d,0x1ad,0x1e5,0x224,0x250,0x28e,0x2ce,0x2de,0x31e,0x34f,
        0x38c,0x3bc,0x3fa,0x43a,0x44a,0x47b,0x4b2,0x4f2,0x532,0x572,0x5a3,0x5cf,0x60f,0x644,0x65e,0x69e,
        0x6de,0x71e,0x756,0x78d,0x7ca,0x809,0x848,0x887,0x8c6,0x905,0x944,0x983,0x9c3,0xa01,0xa3f,0xa7f,
        0xabf,0xafe,0xb3e,0xb7e,0xbbe,0xbfd,0xc3d,0xc7d,0xcbc,0xcfc,0xd3b,0xd7b,0xdbb,0xdfb,0xe3b,0xe79,
        0xeb9,0xef9,0xf37,0xf71,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0xfb1,0xfe8,0x1026,0x1055,0x107a,0x10ba,0x10da,
        0x111a,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x112d,0x116d,0x118d,0x11cd,0x120d,0x124d,0x128b,
        0x12cb,0x1308,0x1348,0x1378,0x13b8,0x13f8,0x1438,0x146e,0x14ae,0x14d9,0x1519,0x1558,0x1598,0x15d6,0x1616,0x1650,
        0x1690,0x16d0,0x1710,0x1750,0x1790,0x17bc,0x17a1,0x2ce,0x17fc,0x17fc,0x1826,0x17fc,0x1865,0x18a5,0x18e5,0x1924,
        0x1964,0x19a3,0x19e3,0x1a22,0x1a62,0x1aa2,0x1adf,0x1b11,0x1b45,0x1b45,0x1b45,0x1b45,0x1b85,0x1bb0,0x1bed,0x1c21,
        0x1c43,0x1c83,0x1ca7,0x1cc3,0x1d03,0x1d03,0x1bb5,0x1d42,0x1d03,0x1bbd,0x1d03,0x1d03,0x1d03,0x1d82,0x1cef,0x1dc2,
        0x1d03,0x1d03,0x1d03,0x1d03,0x1b45,0x1b45,0x1dff,0x1e27,0x1b45,0x1b45,0x1b45,0x1b45,0x1e67,0x1ea2,0x1ed8,0x1d03,
        0x38c,0x1f18,0x17fc,0x1f57,0x1f97,0x1fc7,0x2007,0x2027,0x2067,0x20a7,0x20e7,0x2102,0x1d03,0x1d03,0x1d03,0x2120,
        0x2160,0x21a0,0x21c9,0x21ea,0x222a,0x5a3,0x225b,0x229b,0x22db,0x2313,0x2329,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x1d03,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x12f6,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x2369,0x23a2,0x5a3,0x5a3,0x5a3,0x5a3,0x23e2,0x2422,0x2462,0x2482,0x24c2,0x24f4,0x2532,0x256e,
        0x25ac,0x25ec,0x262c,0x2668,0x26a8,0x26e1,0x2721,0x2760,0x27a0,0x27e0,0x281e,0x285e,0x289d,0x28cd,0x28fd,0x293d,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x297d,0x29b6,
        0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,
        0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,0x29f6,
        0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,
        0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,
        0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,
        0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,
        0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,
        0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,
        0x2a36,0x2a36,0x2a36,0x2a36,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x2a76,0x5a3,0x2aa6,0x2ae6,0x2b26,0x2b34,0x2b71,
        0x5a3,0x5a3,0x5a3,0x5a3,0x2b84,0x2bc4,0x2bf4,0x2c2c,0x2c6c,0x2ca8,0x5a3,0x2cde,0x2d1e,0x2d5e,0x2d8f,0x2dce,
        0xac0,0xade,0xafb,0xb1a,0xb3a,0xb3a,0xb47,0xb64,0xb84,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,
        0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,
        0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,0xb8e,
        0xb8e,0xb8e,0xb8e,0xb8e,0xbae,0xb8e,0xb8e,0xb8e,0xbce,0xbce,0xbce,0xbcf,0xbce,0xbce,0xbce,0xbcf,
        0x865,0x5a3,0xae1,0x2e0e,0x50f,0x50f,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x73e,
        0x2e1e,0x10a3,0x10a3,0x2e2a,0x1ac2,0x1ac2,0x1ac2,0x2e3a,0x2e43,0x1c5d,0x1c69,0xd18,0xd18,0x1d03,0x1d03,0x2e53,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x510,0x5a3,0x5a3,0x5a3,0x993,0x2e63,0x2e67,
        0x5a3,0x5a3,0x2e6f,0x5a3,0x2e7e,0x5a3,0x5a3,0x2e8e,0x5a3,0x2e9e,0x5a3,0x5a3,0x1460,0x2ead,0xd18,0xd18,
        0x41,0x41,0x342,0x28fd,0x28fd,0x5a3,0x5a3,0x5a3,0x5a3,0x50f,0xb24,0x41,0x41,0x2ebd,0x28fd,0x2ec5,
        0x5a3,0x5a3,0x13a6,0x5a3,0x5a3,0x5a3,0x2ed5,0x335,0x335,0x2ee5,0x2ef3,0x2f01,0xd18,0xd18,0xd18,0xd18,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x13a7,0x5a3,0x13a8,0x13a6,0xd18,0x2f11,0x280,0x280,0x2f16,0xd18,0xd18,0xd18,0xd18,
        0x2f26,0x5a3,0x5a3,0x2f30,0x5a3,0x2f3f,0x5a3,0x2f4f,0x5a3,0x50e,0x1c9c,0xd18,0xd18,0xd18,0x5a3,0x2f5f,
        0x5a3,0x2f6f,0x5a3,0x2f7f,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x2f8f,0x10a3,0x1ca1,0x10a3,0x10a3,
        0x2f9e,0x94e,0x5a3,0x2fae,0x2e6a,0x2fbe,0x5a3,0x2fce,0x5a3,0x2fde,0xd18,0xd18,0x2fee,0x5a3,0x2ff9,0x3009,
        0x5a3,0x5a3,0x5a3,0x3019,0x5a3,0x3029,0x5a3,0x3039,0x5a3,0x3049,0x1c9a,0xd18,0xd18,0xd18,0xd18,0xd18,
        0x5a3,0x5a3,0x5a3,0x5a3,0x1338,0xd18,0xd18,0xd18,0x41,0x41,0x41,0x3059,0x28fd,0x28fd,0x28fd,0x3069,
        0x5a3,0x5a3,0x3079,0xb24,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0x10a3,0x10a8,0x5a3,0x5a3,0x3089,0xd99,0xd18,0xd18,0xd18,0xd18,0x5a3,0x2fde,0x3099,0x5a3,0x577,0x30a9,
        0xd18,0x5a3,0x30b9,0xd18,0xd18,0x5a3,0x30c9,0xd18,0x5a3,0x13a7,0x281b,0x5a3,0x5a3,0x575,0x30d9,0x1ca1,
        0x30e9,0x30f9,0x7cb,0x5a3,0x5a3,0x3109,0x3117,0x5a3,0x1338,0xb24,0x773,0x5a3,0x3127,0x3134,0x3144,0x5a3,
        0x5a3,0x3154,0x7cb,0x5a3,0x5a3,0x3164,0x3173,0x3183,0x1ca2,0x3193,0x5a3,0x954,0x31a3,0x31b2,0xd18,0xd18,
        0xd18,0xd18,0x31c2,0x863,0x31d1,0x5a3,0x5a3,0x630,0x31e1,0xb24,0x31f1,0x858,0x868,0x3200,0x3210,0x3220,
        0x322e,0x1562,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x323e,0x324e,0x325e,
        0xd99,0xd18,0x5a3,0x5a3,0x5a3,0x326e,0x327d,0xb24,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0x5a3,0x5a3,0xed5,0x328d,0x329c,0x32a4,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x32b4,0x32c3,0xb24,
        0x32d3,0xd18,0x5a3,0x5a3,0x32e3,0x32f3,0xb24,0xd18,0xd18,0xd18,0x5a3,0x108a,0x3303,0x3313,0x13a7,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x31a3,0x3323,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0x41,0x41,0x28fd,0x28fd,0xc23,0x3333,0x3342,0x334e,0x5a3,0x335e,0x336e,0xb24,
        0xd18,0xd18,0xd18,0xd18,0x2a9c,0x5a3,0x5a3,0x337e,0x338e,0xd18,0x339e,0x5a3,0x5a3,0x33ab,0x33ba,0x33ca,
        0x5a3,0x5a3,0x573,0x33da,0x33e8,0x5a3,0x5a3,0x5a3,0x5a3,0x1338,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x868,0x5a3,0xed5,0x33f8,0x3408,0xc23,
        0x10aa,0x550,0x5a3,0xe2a,0x3418,0x3427,0xd18,0xd18,0xd18,0xd18,0x96e,0x5a3,0x5a3,0x3437,0x3446,0xb24,
        0x3456,0x5a3,0x3460,0x3470,0xb24,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0x5a3,0x3480,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0x993,0x10a3,0x3490,0x349f,0x34ad,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x1337,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0x1ac2,0x1ac2,0x1ac2,0x1ac2,0x1ac2,0x1ac2,0x34bd,0x34cd,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0xd97,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x34dd,0x5a3,0x5a3,0x50e,0x34ed,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0x5a3,0x5a3,0x5a3,0x5a3,0x13a7,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0x5a3,0x5a3,0x5a3,0x1338,0x5a3,0x50e,0x2770,0x5a3,0x5a3,0x5a3,0x5a3,0x50e,0xb24,0x5a3,0x50f,
        0x34fd,0x5a3,0x5a3,0x5a3,0x350d,0x351d,0x352d,0x353b,0x741,0x5a3,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0x41,0x41,0x28fd,0x28fd,0x10a3,0x354b,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,
        0x5a3,0xe1d,0x355b,0x355c,0x355c,0x3564,0x3573,0xd18,0xd18,0xd18,0xd18,0x3581,0x3591,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x13a6,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x13a8,0xd18,0xd18,0x1338,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x35a1,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0xd98,0xd18,0xd18,0xd98,0x2ed1,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x511,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x73e,0x510,0x1338,0x35b1,0x35c1,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0x2ce,0x2ce,0x641,0x2ce,0x1560,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,
        0x1d03,0x1c66,0xd18,0xd18,0xd18,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,
        0x1d03,0x1d03,0x1d03,0x1d03,0x1c64,0x1d03,0x1d03,0x1ecf,0x1d03,0x1d03,0x1d03,0x35d1,0x35de,0x35eb,0x1d03,0x35f7,
        0x1d03,0x1d03,0x1d03,0x1c5f,0xd18,0x1d03,0x1d03,0x1d03,0x1d03,0x3605,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0x10a3,0x3615,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1c63,0x10a3,0x2e6a,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0x41,0x3b2,0x28fd,0x3625,0x3ae,0x2ef0,0x1865,0x41,0xdc,0x3635,0x3645,
        0x3653,0x2ef1,0x41,0x3b2,0x28fd,0x3660,0x366d,0x28fd,0x367b,0x368b,0x369a,0x369e,0x41,0xd8,0x28fd,0x41,
        0x3b2,0x28fd,0x3625,0x3ae,0x28fd,0x1865,0x41,0xdc,0x369e,0x41,0xd8,0x28fd,0x41,0x3b2,0x28fd,0x36ae,
        0x41,0x36bd,0xeb,0x38a,0x36cd,0x28fd,0x36d9,0x41,0x36b9,0xe7,0x36c7,0xc7,0x28fd,0xed,0x41,0x36e5,
        0x28fd,0x36f2,0x3700,0x3700,0x3700,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,
        0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,
        0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x2ce,0x2ce,0x2ce,0x3710,0x2ce,0x2ce,0x371b,0x3728,0x3734,0x1a27,0x4c2,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0x25a,0x1fae,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xe4c,0x3744,0x3752,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x510,0x3762,0x3772,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x3782,0xd18,0x5a3,0x5a3,0x633,0x3792,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x37a2,0x50e,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x37b2,0x1560,0xd18,0xd18,0x41,0x41,0xdc,0x28fd,
        0x37c2,0x2770,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x1ca2,0x10a3,0x10a3,0x37d2,
        0x37e2,0xd18,0xd18,0xd18,0xd18,0x1ca2,0x10a3,0x37f2,0x10a9,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xae4,0x5a3,0x3802,0x380f,0x381d,0x382d,0x383b,0x3843,0x867,0x511,0x3852,
        0x511,0xd18,0xd18,0xd18,0x3862,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0x1d03,0x1d03,0x1c5e,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1c66,0x1c5b,
        0x148b,0x148b,0x148b,0x1d03,0x1c64,0x1cb6,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1c5c,
        0xd18,0xd18,0xd18,0x1c7d,0x1d03,0x1c67,0x1d03,0x1d03,0x1c5e,0x1c61,0x1c68,0x1c64,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,
        0x1d03,0x1d03,0x1d03,0x1d03,0x3872,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,
        0x1d03,0x1d03,0x3882,0x1c5d,0x1c5d,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1c66,0x1d03,0x1d03,0x1d03,
        0x1d03,0x1d03,0x1c61,0x1c5e,0x1c69,0x1c5e,0x1d03,0x1d03,0x1d03,0x1c62,0x10ca,0x1d03,0x1d03,0x1c62,0x1d03,0x1c5c,
        0x1c68,0xd18,0xd18,0xd18,0xd18,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,
        0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1c66,0x1c5c,0x388f,0x1c63,0x1d03,0x1c5d,0x1c5f,0x1c64,0x10ca,0x1c62,0x1c63,
        0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1d03,0x1eeb,0x1d03,0x1d03,0x1c5f,0xd18,0xd18,0xb24,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0xd18,0xd18,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x1338,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x50f,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0xd99,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x993,0xd18,
        0x5a3,0x50f,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
        0x5a3,0x5a3,0x5a3,0x5a3,0x73e,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0x389e,0xd18,0x38ae,0x38ae,0x38ae,0x38ae,0x38ae,0x38ae,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
        0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0xd18,
        0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,
        0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x2a36,0x38be,
        0x440,0x460,0x480,0x4a0,0x4c0,0x4e0,0x500,0x51a,0x53a,0x55a,0x57a,0x59a,0x5ba,0x5da,0x5fa,0x615,
        0xd0,0x635,0x655,0x66a,0x66a,0x66a,0x66a,0x671,0xd0,0xd0,0x691,0x66a,0x66a,0x66a,0x66a,0x66a,
        0xd0,0x6b1,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,
        0x66a,0x66a,0xd0,0x6d1,0x66a,0x6ed,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0x70d,0xd0,
        0xd0,0x72d,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,
        0x66a,0x66a,0x73e,0x75e,0x775,0x66a,0x66a,0x66a,0x66a,0x795,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,
        0x66a,0x7a5,0x7c5,0x7e5,0x805,0x825,0x845,0x865,0x66a,0x875,0x895,0x8ac,0x66a,0x8bc,0x8dc,0x66a,
        0x8f5,0x915,0x935,0x955,0x845,0x975,0x995,0x9b0,0x66a,0x66a,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,
        0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,
        0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0x9d0,0xd0,0xd0,0xd0,0xd0,0xd0,
        0xd0,0xd0,0x9e0,0x9ff,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xa15,0xd0,0xd0,0xd0,0xd0,
        0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xa20,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,
        0xd0,0xa40,0x66a,0x66a,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xa60,0x66a,0x66a,
        0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,
        0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0xa80,0x66a,
        0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,
        0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x66a,0x380,0x380,
        0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,
        0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0xaa0
    ]
);

#[rustfmt::skip]
pub const DATA: ZeroVec<u8> = zerovec!(u8; core::convert::identity;
    [
        0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,
        0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,
        0xc,0x17,0x17,0x17,0x19,0x17,0x17,0x17,0x14,0x15,0x17,0x18,0x17,0x13,0x17,0x17,
        9,9,9,9,9,9,9,9,9,9,0x17,0x17,0x18,0x18,0x18,0x17,
        0x17,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,0x14,0x17,0x15,0x1a,0x16,
        0x1a,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,0x14,0x18,0x15,0x18,0xf,
        0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,
        0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xc,
        0x17,0x19,0x19,0x19,0x19,0x1b,0x17,0x1a,0x1b,5,0x1c,0x18,0x10,0x1b,0x1a,0x1b,
        0x18,0xb,0xb,0x1a,2,0x17,0x17,0x1a,0xb,5,0x1d,0xb,0xb,0xb,0x17,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,0x18,1,1,1,1,1,1,1,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,0x18,2,2,2,2,2,2,2,2,1,
        2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
        2,1,2,1,2,1,2,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,1,2,1,2,1,2,2,1,1,
        2,1,2,1,1,2,1,1,1,2,2,1,1,1,1,2,
        1,1,2,1,1,1,2,2,2,1,1,2,1,1,2,1,
        2,1,2,1,1,2,1,2,2,1,2,1,1,2,1,1,
        1,2,1,2,1,1,2,2,5,1,2,2,2,5,5,5,
        5,1,3,2,1,3,2,1,3,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,2,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,1,2,1,2,2,1,3,
        2,1,2,1,1,1,2,1,2,1,2,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,2,2,2,2,2,2,1,
        1,2,1,1,2,1,2,1,1,1,1,2,1,2,1,2,
        1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,5,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
        0x1a,0x1a,0x1a,0x1a,4,4,4,4,4,4,4,4,4,4,4,4,
        0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,4,4,
        4,4,4,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,4,0x1a,4,0x1a,0x1a,0x1a,
        0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,2,
        1,2,4,0x1a,1,2,0,0,4,2,2,2,0x17,1,0,0,
        0,0,0x1a,0x1a,1,0x17,1,1,1,0,1,0,1,1,2,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,
        2,1,1,1,2,2,2,1,2,1,2,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,
        2,2,2,1,2,0x18,1,2,1,1,2,2,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,0x1b,6,6,6,
        6,6,7,7,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,0,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,0,0,4,0x17,0x17,0x17,0x17,0x17,0x17,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,0x17,0x13,0,0,0x1b,
        0x1b,0x19,0,6,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
        0x13,6,0x17,6,6,0x17,6,6,0x17,6,0,0,0,0,0,0,
        0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,
        0,5,5,5,5,0x17,0x17,0,0,0,0,0,0,0,0,0,
        0,0,0x10,0x10,0x10,0x10,0x10,0x10,0x18,0x18,0x18,0x17,0x17,0x19,0x17,0x17,
        0x1b,0x1b,6,6,6,6,6,6,6,6,6,6,6,0x17,0x10,0x17,
        0x17,0x17,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,4,5,5,5,5,5,5,5,5,5,5,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,9,9,9,9,9,9,9,9,9,9,0x17,0x17,0x17,0x17,
        5,5,6,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,0x17,5,6,6,6,6,6,6,6,0x10,0x1b,6,6,
        6,6,6,6,4,4,6,6,0x1b,6,6,6,6,5,5,9,
        9,9,9,9,9,9,9,9,9,5,5,5,0x1b,0x1b,5,0x17,
        0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,0x10,5,
        6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,
        0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,5,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,
        9,9,9,9,9,9,9,9,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,
        6,6,4,4,0x1b,0x17,0x17,0x17,4,0,0,6,0x19,0x19,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,6,6,6,6,4,6,6,6,6,6,6,6,
        6,6,4,6,6,6,4,6,6,6,6,6,0,0,0x17,0x17,
        0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,6,6,6,0,0,0x17,0,5,5,
        5,5,5,5,5,5,5,5,5,0,0,0,0,0,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,0x1a,5,
        5,5,5,5,5,0,0x10,0x10,0,0,0,0,0,0,6,6,
        6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,4,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0x10,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,8,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,6,8,6,5,8,8,6,6,6,6,6,6,
        6,6,8,8,8,8,6,8,8,5,6,6,6,6,6,6,
        6,5,5,5,5,5,5,5,5,5,5,6,6,0x17,0x17,9,
        9,9,9,9,9,9,9,9,9,0x17,4,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,6,8,8,0,5,5,5,
        5,5,5,5,5,0,0,5,5,0,0,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,0,5,5,5,5,5,5,5,0,5,0,0,0,5,5,
        5,5,0,0,6,5,8,8,6,6,6,6,0,0,8,8,
        0,0,8,8,6,5,0,0,0,0,0,0,0,0,8,0,
        0,0,0,5,5,0,5,5,5,6,6,0,0,9,9,9,
        9,9,9,9,9,9,9,5,5,0x19,0x19,0xb,0xb,0xb,0xb,0xb,
        0xb,0x1b,0x19,5,0x17,6,0,6,6,8,0,5,5,5,5,5,
        5,0,0,0,0,5,5,0,0,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,
        5,5,5,5,5,5,5,0,5,5,0,5,5,0,5,5,
        0,0,6,0,8,8,6,6,0,0,0,0,6,6,0,0,
        6,6,6,0,0,0,6,0,0,0,0,0,0,0,5,5,
        5,5,0,5,0,0,0,0,0,0,0,9,9,9,9,9,
        9,9,9,9,9,6,6,5,5,5,6,0x17,0,0,0,0,
        0,0,0,0,0,6,6,8,0,5,5,5,5,5,5,5,
        5,5,0,5,5,5,0,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,
        5,5,5,5,5,0,5,5,0,5,5,5,5,5,0,0,
        6,5,8,8,6,6,6,6,6,0,6,6,8,0,8,8,
        6,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,5,5,6,6,0,0,9,9,9,9,9,9,9,
        9,9,9,0x17,0x19,0,0,0,0,0,0,0,5,6,6,6,
        6,6,6,0,6,8,8,0,5,5,5,5,5,5,5,5,
        0,0,5,5,0,0,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,
        5,5,5,5,0,5,5,0,5,5,5,5,5,0,0,6,
        5,8,6,6,6,6,0,0,8,8,0,0,8,8,6,0,
        0,0,0,0,0,0,6,6,8,0,0,0,0,5,5,0,
        5,5,5,6,6,0,0,9,9,9,9,9,9,9,9,9,
        9,0x1b,5,0xb,0xb,0xb,0xb,0xb,0xb,0,0,0,0,0,0,0,
        0,6,5,0,5,5,5,5,5,5,0,0,0,5,5,5,
        0,5,5,5,5,0,0,0,5,5,0,5,0,5,5,0,
        0,0,5,5,0,0,0,5,5,5,0,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,0,0,0,0,8,8,6,
        8,8,0,0,0,8,8,8,0,8,8,8,6,0,0,5,
        0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,0xb,
        0xb,0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x1b,0,0,0,0,0,6,
        8,8,8,6,5,5,5,5,5,5,5,5,0,5,5,5,
        0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,0,0,6,5,6,6,8,
        8,8,8,0,6,6,6,0,6,6,6,6,0,0,0,0,
        0,0,0,6,6,0,5,5,5,0,0,5,0,0,5,5,
        6,6,0,0,9,9,9,9,9,9,9,9,9,9,0,0,
        0,0,0,0,0,0x17,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x1b,5,6,
        8,8,0x17,5,5,5,5,5,5,5,5,0,5,5,5,0,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,
        5,5,0,5,5,5,5,5,0,0,6,5,8,6,8,8,
        8,8,8,0,6,8,8,0,8,8,6,6,0,0,0,0,
        0,0,0,8,8,0,0,0,0,0,0,5,5,0,5,5,
        6,6,0,0,9,9,9,9,9,9,9,9,9,9,0,5,
        5,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,
        8,8,5,5,5,5,5,5,5,5,5,0,5,5,5,0,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,6,6,5,8,8,6,6,
        6,6,0,8,8,8,0,8,8,8,6,5,0x1b,0,0,0,
        0,5,5,5,8,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,5,5,6,
        6,0,0,9,9,9,9,9,9,9,9,9,9,0xb,0xb,0xb,
        0xb,0xb,0xb,0xb,0xb,0xb,0x1b,5,5,5,5,5,5,0,6,8,
        8,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,0,0,0,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,
        5,5,5,5,5,5,5,5,5,0,5,0,0,5,5,5,
        5,5,5,5,0,0,0,6,0,0,0,0,8,8,8,6,
        6,6,0,6,0,8,8,8,8,8,8,8,8,0,0,0,
        0,0,0,9,9,9,9,9,9,9,9,9,9,0,0,8,
        8,0x17,0,0,0,0,0,0,0,0,0,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,6,5,5,
        6,6,6,6,6,6,6,0,0,0,0,0x19,5,5,5,5,
        5,5,4,6,6,6,6,6,6,6,6,0x17,9,9,9,9,
        9,9,9,9,9,9,0x17,0x17,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,5,5,0,5,
        0,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,
        5,0,5,5,5,5,5,5,5,5,5,5,6,5,5,6,
        6,6,6,6,6,6,6,6,5,0,0,5,5,5,5,5,
        0,4,0,6,6,6,6,6,6,0,0,9,9,9,9,9,
        9,9,9,9,9,0,0,5,5,5,5,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,5,0x1b,0x1b,0x1b,0x17,
        0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x1b,0x17,
        0x1b,0x1b,0x1b,6,6,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,9,9,9,9,9,
        9,9,9,9,9,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x1b,
        6,0x1b,6,0x1b,6,0x14,0x15,0x14,0x15,8,8,5,5,5,5,5,
        5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,0,0,0,0,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,8,6,6,6,6,6,
        0x17,6,6,5,5,5,5,5,6,6,6,6,6,6,6,6,
        6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,6,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0x1b,0x1b,0x17,0x17,0x17,0x17,0x17,0x1b,0x1b,
        0x1b,0x1b,0x17,0x17,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,8,8,6,6,6,6,8,6,6,6,6,6,
        6,8,6,6,8,8,6,6,5,9,9,9,9,9,9,9,
        9,9,9,0x17,0x17,0x17,0x17,0x17,0x17,5,5,5,5,5,5,8,
        8,6,6,5,5,5,5,6,6,6,5,8,8,8,5,5,
        8,8,8,8,8,8,8,5,5,5,6,6,6,6,5,5,
        5,5,5,5,5,5,5,5,5,6,8,8,6,6,8,8,
        8,8,8,8,6,5,8,9,9,9,9,9,9,9,9,9,
        9,8,8,8,6,0x1b,0x1b,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,0,1,0,0,0,0,0,1,0,
        0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,0x17,4,2,2,
        2,5,5,5,5,5,5,5,5,5,0,5,5,5,5,0,
        0,5,5,5,5,5,5,5,0,5,0,5,5,5,5,0,
        0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,0,5,5,5,5,0,0,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,0,5,5,5,5,0,0,
        5,5,5,5,5,5,5,0,5,5,5,5,0,0,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,0,5,5,5,5,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,0,0,6,6,6,0x17,0x17,0x17,0x17,0x17,0x17,
        0x17,0x17,0x17,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0xb,0xb,0xb,0xb,0,0,0,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        0,0,2,2,2,2,2,2,0,0,0x13,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,0x1b,0x17,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,0xc,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,0x14,0x15,0,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,0x17,0x17,0x17,0xa,0xa,0xa,5,5,
        5,5,5,5,5,5,0,0,0,0,0,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,
        6,6,8,0,0,0,0,0,0,0,0,0,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,
        6,8,0x17,0x17,0,0,0,0,0,0,0,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,
        6,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,5,0,5,5,5,0,6,
        6,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,6,6,8,6,6,6,6,6,6,6,8,8,8,8,8,
        8,6,8,8,6,6,6,6,6,6,6,6,6,6,6,0x17,
        0x17,0x17,4,0x17,0x17,0x17,0x19,5,6,0,0,9,9,9,9,9,
        9,9,9,9,9,0,0,0,0,0,0,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0xb,0xb,0,0,0,0,0,0,0x17,0x17,0x17,0x17,0x17,
        0x17,0x13,0x17,0x17,0x17,0x17,6,6,6,0x10,6,9,9,9,9,9,
        9,9,9,9,9,0,0,0,0,0,0,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,4,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,0,0,0,0,0,0,0,5,5,5,5,5,6,6,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,6,5,0,0,0,0,0,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,
        0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,0,6,6,6,8,8,8,8,6,
        6,8,8,8,0,0,0,0,8,8,6,8,8,8,8,8,
        8,6,6,6,0,0,0,0,0x1b,0,0,0,0x17,0x17,9,9,
        9,9,9,9,9,9,9,9,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,0,0,5,5,5,5,5,0,0,0,
        0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,0,0,0,0,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,0,0,0,0,0,0,9,9,
        9,9,9,9,9,9,9,9,0xb,0,0,0,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,6,6,8,8,6,0,0,0x17,0x17,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,6,
        8,6,6,6,6,6,6,6,0,6,8,6,8,8,6,6,
        6,6,6,6,6,6,8,8,8,8,8,8,6,6,6,6,
        6,6,6,6,6,6,0,0,6,9,9,9,9,9,9,9,
        9,9,9,0,0,0,0,0,0,9,9,9,9,9,9,9,
        9,9,9,0,0,0,0,0,0,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
        4,0x17,0x17,0x17,0x17,0x17,0x17,0,0,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,7,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,6,6,6,6,8,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,6,8,6,6,
        6,6,6,8,6,8,8,8,6,8,8,5,5,5,5,5,
        5,5,5,0,0,0,9,9,9,9,9,9,9,9,9,9,
        0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,6,6,6,6,6,6,6,6,6,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x17,0x17,0,6,6,8,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,8,6,6,6,6,8,8,6,6,
        8,6,6,6,5,5,9,9,9,9,9,9,9,9,9,9,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,6,8,6,6,8,8,8,6,8,6,
        6,6,8,8,0,0,0,0,0,0,0,0,0x17,0x17,0x17,0x17,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,8,8,8,8,8,8,8,8,6,6,6,6,
        6,6,6,6,8,8,6,6,0,0,0,0x17,0x17,0x17,0x17,0x17,
        9,9,9,9,9,9,9,9,9,9,0,0,0,5,5,5,
        9,9,9,9,9,9,9,9,9,9,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,4,4,4,4,4,4,0x17,0x17,
        2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,
        0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,0,0,0,0,0,0,0,
        6,6,6,0x17,6,6,6,6,6,6,6,6,6,6,6,6,
        6,8,6,6,6,6,6,6,6,5,5,5,5,6,5,5,
        5,5,5,5,6,5,5,8,6,6,5,0,0,0,0,0,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,
        4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
        4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
        4,4,4,4,4,4,4,2,2,2,2,2,2,2,2,2,
        2,2,2,2,4,2,2,2,2,2,2,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,2,2,2,2,
        2,2,2,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,2,2,2,2,2,2,2,1,1,1,
        1,1,1,1,1,2,2,2,2,2,2,0,0,1,1,1,
        1,1,1,0,0,2,2,2,2,2,2,2,2,1,1,1,
        1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,
        1,1,1,1,1,2,2,2,2,2,2,0,0,1,1,1,
        1,1,1,0,0,2,2,2,2,2,2,2,2,0,1,0,
        1,0,1,0,1,2,2,2,2,2,2,2,2,1,1,1,
        1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,0,0,2,2,2,2,2,2,2,2,3,3,3,
        3,3,3,3,3,2,2,2,2,2,2,2,2,3,3,3,
        3,3,3,3,3,2,2,2,2,2,2,2,2,3,3,3,
        3,3,3,3,3,2,2,2,2,2,0,2,2,1,1,1,
        1,3,0x1a,2,0x1a,0x1a,2,2,2,0,2,2,1,1,1,1,
        3,0x1a,0x1a,0x1a,2,2,2,2,0,0,2,2,1,1,1,1,
        0,0x1a,0x1a,0x1a,2,2,2,2,2,2,2,2,1,1,1,1,
        1,0x1a,0x1a,0x1a,0,0,2,2,2,0,2,2,1,1,1,1,
        3,0x1a,0x1a,0,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0x10,
        0x10,0x10,0x10,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x17,0x17,0x1c,0x1d,0x14,0x1c,
        0x1c,0x1d,0x14,0x1c,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0xd,0xe,0x10,0x10,
        0x10,0x10,0x10,0xc,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x1c,0x1d,0x17,
        0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x18,0x14,0x15,0x17,0x17,0x17,0x17,0x17,0x17,
        0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
        0x17,0x17,0xc,0x10,0x10,0x10,0x10,0x10,0,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
        0x10,0x10,0x10,0xb,4,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0x18,0x18,0x18,
        0x14,0x15,4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x18,0x18,0x18,
        0x14,0x15,0,4,4,4,4,4,4,4,4,4,4,4,4,4,
        0,0,0,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
        0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
        0x19,0x19,0x19,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,7,
        7,7,7,6,7,7,7,6,6,6,6,6,6,6,6,6,
        6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0x1b,0x1b,1,0x1b,0x1b,0x1b,0x1b,1,0x1b,0x1b,2,1,1,1,
        2,2,1,1,1,2,0x1b,1,0x1b,0x1b,0x18,1,1,1,1,1,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,1,0x1b,1,0x1b,1,0x1b,1,1,1,1,
        0x1b,2,1,1,1,1,2,5,5,5,5,2,0x1b,0x1b,2,2,
        1,1,0x18,0x18,0x18,0x18,0x18,1,2,2,2,2,0x1b,0x18,0x1b,0x1b,
        2,0x1b,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,
        0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,
        0xa,0xa,1,2,0xa,0xa,0xa,0xa,0xb,0x1b,0x1b,0,0,0,0,0x18,
        0x18,0x18,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x18,
        0x1b,0x1b,0x18,0x1b,0x1b,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,
        0x18,0x1b,0x1b,0x18,0x1b,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x14,0x15,0x14,
        0x15,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x14,0x15,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x18,
        0x18,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xb,0xb,0xb,
        0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x14,0x15,0x14,0x15,0x14,0x15,
        0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0x18,0x18,0x18,0x18,0x18,0x14,0x15,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,
        0x14,0x15,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,
        0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x14,
        0x15,0x14,0x15,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x14,0x15,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,0x18,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,1,2,1,1,1,2,2,1,
        2,1,2,1,2,1,1,1,1,2,1,2,2,1,2,2,
        2,2,2,2,4,4,1,1,2,1,2,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
        2,1,2,1,2,1,2,1,2,1,2,2,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,1,2,1,2,6,6,6,1,2,0,0,0,0,0,
        0x17,0x17,0x17,0x17,0xb,0x17,0x17,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,0,
        0,0,0,0,2,0,0,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,
        0,0,0,0,0,0,4,0x17,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,6,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,
        0,0,0,0,0,0,0,5,5,5,5,5,5,5,0,5,
        5,5,5,5,5,5,0,5,5,5,5,5,5,5,0,5,
        5,5,5,5,5,5,0,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,0x17,0x17,0x1c,0x1d,0x1c,0x1d,0x17,0x17,0x17,
        0x1c,0x1d,0x17,0x1c,0x1d,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x13,0x17,
        0x17,0x13,0x17,0x1c,0x1d,0x17,0x17,0x1c,0x1d,0x14,0x15,0x14,0x15,0x14,0x15,0x14,
        0x15,0x17,0x17,0x17,0x17,0x17,4,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
        0x17,0x13,0x13,0x17,0x17,0x17,0x17,0x13,0x17,0x14,0x17,0x17,0x17,0x17,0x17,0x17,
        0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x1b,0x1b,0x17,0x17,0x17,0x14,0x15,0x14,0x15,
        0x14,0x15,0x14,0x15,0x13,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,
        0xc,0x17,0x17,0x17,0x1b,4,5,0xa,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,
        0x14,0x15,0x1b,0x1b,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x13,0x14,0x15,0x15,
        0x1b,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,6,6,6,6,8,8,
        0x13,4,4,4,4,4,0x1b,0x1b,0xa,0xa,0xa,4,5,0x17,0x1b,0x1b,
        0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        0,0,6,6,0x1a,0x1a,4,4,5,0x13,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,0x17,4,4,4,5,0,0,0,0,0,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,0,0x1b,0x1b,0xb,0xb,0xb,
        0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,
        0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0xb,0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0x1b,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,5,5,5,5,5,5,
        5,5,5,5,5,5,0,0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0,0,
        0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,
        0x17,0x17,5,5,5,5,5,5,5,5,5,5,5,5,4,0x17,
        0x17,0x17,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,9,9,9,9,9,9,9,9,9,9,5,5,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        5,6,7,7,7,0x17,6,6,6,6,6,6,6,6,6,6,
        0x17,4,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,4,4,
        6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,
        0xa,0xa,6,6,0x17,0x17,0x17,0x17,0x17,0x17,0,0,0,0,0,0,
        0,0,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
        0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,4,4,4,4,4,4,4,
        4,4,0x1a,0x1a,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,2,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
        1,2,1,2,4,2,2,2,2,2,2,2,2,1,2,1,
        2,1,1,2,1,2,1,2,1,2,4,0x1a,0x1a,1,2,1,
        2,5,1,2,1,2,2,2,1,2,1,2,1,2,1,2,
        1,2,1,2,1,2,1,2,1,2,1,2,1,1,1,1,
        1,2,1,1,1,1,1,2,1,2,1,2,1,2,1,2,
        1,2,1,1,1,1,2,1,2,0,0,0,0,0,1,2,
        0,2,0,2,1,2,1,2,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        4,4,4,1,2,5,4,4,2,5,5,5,5,5,6,5,
        5,5,6,5,5,5,5,6,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,
        8,6,6,8,0x1b,0x1b,0x1b,0x1b,6,0,0,0,0xb,0xb,0xb,0xb,
        0xb,0xb,0x1b,0x1b,0x19,0x1b,0,0,0,0,0,0,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        0x17,0x17,0x17,0x17,0,0,0,0,0,0,0,0,8,8,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        8,8,8,8,8,8,8,8,8,8,8,8,6,6,0,0,
        0,0,0,0,0,0,0x17,0x17,9,9,9,9,9,9,9,9,
        9,9,0,0,0,0,0,0,6,6,6,6,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,
        0x17,0x17,0x17,5,0x17,5,5,6,9,9,9,9,9,9,9,9,
        9,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,
        6,6,6,6,6,6,0x17,0x17,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,
        6,6,6,8,8,0,0,0,0,0,0,0,0,0,0,0,
        0x17,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,
        0,6,6,6,8,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,6,8,8,6,6,6,6,8,8,6,6,8,
        8,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,4,
        9,9,9,9,9,9,9,9,9,9,0,0,0,0,0x17,0x17,
        5,5,5,5,5,6,4,5,5,5,5,5,5,5,5,5,
        9,9,9,9,9,9,9,9,9,9,5,5,5,5,5,0,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,8,
        8,6,6,8,8,6,6,0,0,0,0,0,0,0,0,0,
        5,5,5,6,5,5,5,5,5,5,5,5,6,8,0,0,
        9,9,9,9,9,9,9,9,9,9,0,0,0x17,0x17,0x17,0x17,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        4,5,5,5,5,5,5,0x1b,0x1b,0x1b,5,8,6,8,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,5,
        6,6,6,5,5,6,6,5,5,5,5,5,6,6,5,6,
        5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,5,5,4,0x17,0x17,5,5,
        5,5,5,5,5,5,5,5,5,8,6,6,8,8,0x17,0x17,
        5,4,4,8,6,0,0,0,0,0,0,0,0,0,5,5,
        5,5,5,5,0,0,5,5,5,5,5,5,0,0,5,5,
        5,5,5,5,0,0,0,0,0,0,0,0,0,5,5,5,
        5,5,5,5,0,5,5,5,5,5,5,5,0,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,0x1a,4,4,4,4,2,2,2,
        2,2,2,2,2,2,4,0x1a,0x1a,0,0,0,0,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        8,8,6,8,8,6,8,8,0x17,8,6,0,0,9,9,9,
        9,9,9,9,9,9,9,0,0,0,0,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,
        0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,0,0,0,0,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
        0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
        0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
        0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
        0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
        0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
        0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
        0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
        0x11,0x11,0x11,0x11,0x11,0x11,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,0,0,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,
        0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,
        0,0,0,5,6,5,5,5,5,5,5,5,5,5,5,0x18,
        5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,
        5,5,5,0,5,0,5,5,0,5,5,0,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
        0x1a,0x1a,0x1a,0x1a,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,0x15,0x14,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,0,0,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,0,0,0,0,0,0,0,0x1b,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,
        5,5,5,5,5,5,5,5,0x19,0x1b,0x1b,0x1b,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,0x17,0x17,0x17,0x17,
        0x17,0x17,0x17,0x14,0x15,0x17,0,0,0,0,0,0,6,6,6,6,
        6,6,6,6,6,6,6,6,6,6,6,6,0x17,0x13,0x13,0x16,
        0x16,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x17,0x17,0x14,
        0x15,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0,0x17,0x17,0x17,0x17,
        0x13,0x14,0x15,0x14,0x15,0x14,0x15,0x17,0x17,0x17,0x18,0x13,0x18,0x18,0x18,0,
        0x17,0x19,0x17,0x17,0,0,0,0,5,5,5,5,5,0,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,0,0,0x10,0,0x17,
        0x17,0x17,0x19,0x17,0x17,0x17,0x14,0x15,0x17,0x18,0x17,0x13,0x17,0x17,9,9,
        9,9,9,9,9,9,9,9,0x17,0x17,0x18,0x18,0x18,0x17,0x17,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,0x14,0x17,0x15,0x1a,0x16,0x1a,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
        2,2,2,2,2,2,2,2,2,0x14,0x18,0x15,0x18,0x14,0x15,0x17,
        0x14,0x15,0x17,0x17,5,5,5,5,5,5,5,5,5,5,4,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,
        5,5,5,5,5,5,0,0,5,5,5,5,5,5,0,0,
        5,5,5,5,5,5,0,0,5,5,5,0,0,0,0x19,0x19,
        0x18,0x1a,0x1b,0x19,0x19,0,0x1b,0x18,0x18,0x18,0x18,0x1b,0x1b,0,0,0,
        0,0,0,0,0,0,0,0x10,0x10,0x10,0x1b,0x1b,0,0,5,5,
        5,5,5,5,5,5,5,5,5,0,5,5,0,5,0x17,0x17,
        0x17,0,0,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0,0,
        0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xa,0xa,0xa,0xa,0xa,0xb,
        0xb,0xb,0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xb,0xb,0x1b,
        0x1b,0x1b,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        6,0,0,6,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0xb,0,0,0,0,0,0,0,0,0,5,5,5,0xa,
        5,5,5,5,5,5,5,5,0xa,0,0,0,0,0,5,5,
        5,5,5,5,6,6,6,6,6,0,0,0,0,0,5,5,
        5,5,5,5,5,5,5,5,5,5,5,5,0,0x17,0xa,0xa,
        0xa,0xa,0xa,0,0,0,0,0,0,0,0,0,0,1,1,1,
        1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,
        2,0,0,0,0,5,5,5,5,0,0,0,0,0,0,0,
        0,0,0,0,0x17,1,1,1,0,1,1,0,2,2,2,2,
        2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,
        2,2,2,0,2,2,2,2,2,2,2,0,2,2,0,0,
        0,4,4,4,4,4,4,0,4,4,4,4,4,4,4,4,
        4,0,0,0,0,0,5,5,5,5,5,5,0,0,5,0,
        5,5,5,5,5,5,0,5,5,0,0,0,5,0,0,5,
        5,5,5,5,5,0,0x17,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,
        5,5,5,5,5,5,0x1b,0x1b,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,
        5,5,0,5,5,0,0,0,0,0,0xb,0xb,0xb,0xb,0xb,5,
        5,5,5,5,5,0xb,0xb,0xb,0xb,0xb,0xb,0,0,0,0x17,5,
        5,5,5,5,5,5,5,5,5,0,0,0,0,0,0x17,5,
        5,5,5,5,5,5,5,0,0,0,0,0xb,0xb,5,5,6,
        6,6,0,6,6,0,0,0,0,0,6,6,6,6,5,5,
        5,5,5,5,0,0,6,6,6,0,0,0,0,6,0x17,0x17,
        0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,0,0,0,0,0,0,5,5,
        5,5,5,5,5,5,5,5,5,5,5,0xb,0xb,0x17,5,5,
        5,5,5,5,5,5,5,5,5,5,5,0xb,0xb,0xb,5,5,
        5,5,5,5,5,5,0x1b,5,5,5,5,5,5,5,6,6,
        0,0,0,0,0xb,0xb,0xb,0xb,0xb,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
        0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,0,
        0,0,0x17,0x17,0x17,0x17,0x17,0x17,0x17,5,5,5,5,5,5,0,
        0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,5,5,0,0,0,0,
        0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,5,0,0,0,0,0,
        0,0,0x17,0x17,0x17,0x17,0,0,0,1,1,1,0,0,0,0,
        0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,
        0,0,0,0xb,0xb,0xb,0xb,0xb,0xb,5,5,5,5,6,6,6,
        6,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,
        5,5,5,0,6,6,0x13,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        5,0,0,0,0,0,0,0,0,6,0xb,0xb,0xb,0xb,0x17,0x17,
        0x17,0x17,0x17,0,0,0,0,0,0,5,5,6,6,6,6,0x17,
        0x17,0x17,0x17,0,0,0,0,0,0,5,5,5,5,5,0xb,0xb,
        0xb,0xb,0xb,0xb,0xb,0,0,0,0,6,6,6,6,6,6,6,
        0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,0,0xb,0xb,0xb,0xb,0xb,0xb,9,
        9,9,9,9,9,9,9,9,9,6,5,5,6,6,5,0,
        0,0,0,0,0,0,0,0,6,8,8,8,6,6,6,6,
        8,8,6,6,0x17,0x17,0x10,0x17,0x17,6,0,0,0,0,0,0,
        0,0,0,0,0x10,0,0,5,5,5,5,5,5,5,6,6,
        6,6,6,8,6,6,6,6,6,0,9,9,9,9,9,9,
        9,9,9,9,0x17,0x17,0x17,0x17,5,8,8,5,0,0,0,0,
        0,0,0,0,5,5,5,6,0x17,0x17,5,0,0,0,0,0,
        0,0,0,0,5,5,5,8,8,8,6,6,6,6,6,6,
        6,6,6,8,5,5,5,5,0x17,0x17,0x17,0x17,6,6,6,6,
        0x17,8,6,9,9,9,9,9,9,9,9,9,9,5,0x17,5,
        0x17,0x17,0x17,0xb,0xb,0xb,0xb,0xb,0,0,0,0,0,0,0,0,
        0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,8,
        8,8,6,6,8,8,6,8,6,6,0x17,0x17,0x17,0x17,0x17,0x17,
        6,0,5,5,5,5,5,5,5,0,5,0,5,5,5,5,
        0,5,5,5,5,5,5,5,5,5,0x17,0,0,0,0,0,
        0,8,8,8,6,6,6,6,6,6,6,6,0,0,0,0,
        0,6,6,8,8,0,5,5,5,5,5,5,5,5,0,0,
        5,0,5,5,0,5,5,5,5,5,0,6,6,5,8,8,
        6,8,8,8,8,0,0,8,8,0,0,8,8,8,0,0,
        5,0,0,0,0,0,0,8,0,0,0,0,0,5,5,5,
        8,8,0,0,6,6,6,6,6,6,6,0,0,0,5,5,
        5,5,5,8,8,8,6,6,6,6,6,6,6,6,8,8,
        6,6,6,8,6,5,5,5,5,0x17,0x17,0x17,0x17,0x17,9,9,
        9,9,9,9,9,9,9,9,0x17,0x17,0,0x17,6,5,8,8,
        8,6,6,6,6,6,6,8,6,8,8,8,8,6,8,6,
        6,5,5,0x17,5,0,0,0,0,0,0,0,0,8,8,6,
        6,6,6,0,0,8,8,8,8,6,6,8,6,0x17,0x17,0x17,
        0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,5,5,5,5,
        6,6,0,0,8,8,8,6,6,6,6,6,6,6,6,8,
        8,6,8,6,0x17,0x17,0x17,5,0,0,0,0,0,0,0,0,
        0,0,0,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
        0,0,0,5,5,5,5,5,5,5,5,5,5,5,6,8,
        6,8,8,6,6,6,6,6,6,8,6,5,0x17,0,0,0,
        0,0,0,8,8,6,6,6,6,8,6,6,6,6,6,0,
        0,0,0,9,9,9,9,9,9,9,9,9,9,0xb,0xb,0x17,
        0x17,0x17,0x1b,6,6,6,6,6,6,6,6,8,6,6,0x17,0,
        0,0,0,0xb,0xb,0xb,0,0,0,0,0,0,0,0,0,0,
        0,0,5,5,5,5,5,5,5,0,0,5,0,0,5,5,
        5,5,0,5,5,0,5,5,5,5,5,5,5,5,8,8,
        8,8,8,8,0,8,8,0,0,6,6,8,6,5,8,5,
        8,6,0x17,0x17,0x17,0,0,0,0,0,0,0,0,0,5,8,
        8,8,6,6,6,6,0,0,6,6,8,8,8,8,6,5,
        0x17,5,8,0,0,0,0,0,0,0,0,0,0,0,5,6,
        6,6,6,6,6,6,6,6,6,5,5,5,5,5,6,6,
        6,6,6,6,8,5,6,6,6,6,0x17,0x17,0x17,0x17,0x17,0x17,
        0x17,6,0,0,0,0,0,0,0,0,5,6,6,6,6,6,
        6,8,8,6,6,6,5,5,5,5,6,6,6,6,6,6,
        6,8,6,6,0x17,0x17,0x17,5,0x17,0x17,0x17,0,0,0,0,0,
        0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,0,
        6,6,6,6,6,6,8,6,5,0x17,0x17,0x17,0x17,0x17,0,0,
        0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,
        0,8,6,6,6,6,6,6,8,6,6,8,6,6,0,0,
        0,0,0,0,0,0,0,5,6,6,6,6,6,6,0,0,
        0,6,0,6,6,0,6,6,6,6,6,6,5,6,0,0,
        0,0,0,0,0,0,5,5,5,5,5,5,0,5,5,0,
        5,5,5,5,5,5,5,5,5,5,8,8,8,8,8,0,
        6,6,0,8,8,6,8,6,5,0,0,0,0,0,0,0,
        5,5,5,6,6,8,8,0x17,0x17,0,0,0,0,0,0,0,
        0xb,0xb,0xb,0xb,0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x19,0x19,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0x17,0xa,0xa,0xa,
        0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0,0x17,0x17,0x17,
        0x17,0x17,0,0,0,0,0,0,0,0,0,0,0,5,0x17,0x17,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0x10,0x10,0x10,
        0x10,0x10,0x10,0x10,0x10,0x10,0,0,0,0,0,0,0,6,6,6,
        6,6,0x17,0,0,0,0,0,0,0,0,0,0,6,6,6,
        6,6,6,6,0x17,0x17,0x17,0x17,0x17,0x1b,0x1b,0x1b,0x1b,4,4,4,
        4,0x17,0x1b,0,0,0,0,0,0,0,0,0,0,9,9,9,
        9,9,9,9,9,9,9,0,0xb,0xb,0xb,0xb,0xb,0,5,5,
        5,5,5,5,5,5,5,5,5,5,5,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,0x17,0x17,0x17,0x17,0,0,0,0,0,5,8,8,8,8,
        8,8,8,8,8,8,8,8,8,8,8,8,0,0,0,0,
        0,0,0,6,6,6,4,4,4,4,4,4,4,4,4,4,
        4,4,4,0x17,4,6,0,0,0,0,0,0,0,0,0,0,
        0,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,4,4,4,4,0,4,4,4,4,4,4,4,0,4,4,
        0,5,5,5,5,5,5,5,5,5,5,0,0,0x1b,6,6,
        0x17,0x10,0x10,0x10,0x10,0,0,0,0,0,0,0,0,0,0,0,
        0,0x1b,0x1b,0x1b,0x1b,0x1b,8,8,6,6,6,0x1b,0x1b,0x1b,8,8,
        8,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,6,6,6,6,6,0x1b,0x1b,
        6,6,6,6,6,6,6,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
        0x1b,6,6,6,6,0x1b,0x1b,6,6,6,0x1b,0,0,0,0,0,
        0,0,0,0,0,0xb,0xb,0xb,0xb,0,0,0,0,0,0,0,
        0,0,0,0,0,2,2,2,2,1,1,1,1,1,1,1,
        1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,
        2,1,0,1,1,0,0,1,0,0,1,1,0,0,1,1,
        1,1,0,1,1,1,1,1,1,2,2,2,2,0,2,0,
        2,2,2,2,1,1,0,1,1,1,1,0,0,1,1,1,
        1,1,0,1,1,1,1,1,1,1,0,2,2,2,2,2,
        2,2,2,1,1,0,1,1,1,1,0,1,1,1,1,1,
        0,1,0,0,0,1,1,1,1,1,1,0,2,2,2,2,
        2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,
        2,2,2,2,0,0,1,1,1,1,1,1,1,1,0x18,2,
        2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,
        1,1,1,1,1,1,1,1,0x18,2,2,2,2,2,0x18,2,
        2,2,2,2,2,1,1,1,1,1,1,1,1,1,0x18,2,
        2,2,2,2,2,0x18,2,2,2,2,2,2,1,2,0,0,
        9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
        6,6,6,6,6,6,6,0x1b,0x1b,0x1b,0x1b,6,6,6,6,6,
        6,6,6,6,6,6,6,6,0x1b,0x1b,0x1b,0x1b,0x1b,6,0x1b,0x1b,
        0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,6,0x1b,0x1b,0x17,0x17,0x17,0x17,0x17,
        0,0,0,0,6,6,6,6,6,6,6,6,6,0,0,6,
        6,6,6,6,0,6,6,0,6,6,6,6,6,0,0,0,
        0,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,
        0,0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,
        5,0x1b,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
        6,0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,
        0,0x19,5,5,5,5,5,5,5,0,5,5,5,5,0,5,
        5,0,5,5,5,5,5,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0xb,0xb,2,2,2,2,6,6,6,6,6,6,6,4,0,0,
        0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x1b,0xb,
        0xb,0xb,0x19,0xb,0xb,0xb,0xb,0,0,0,0,0,0,0,0,0,
        0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
        0x1b,0xb,0,5,5,0,5,0,0,5,0,5,5,5,5,5,
        5,5,0,5,5,5,5,0,5,0,5,0,0,0,0,5,
        0,0,0,0,5,0,5,0,5,0,5,5,5,0,5,5,
        0,5,0,0,5,0,5,0,5,0,5,0,5,5,0,5,
        0,0,5,5,5,5,0,5,5,5,5,0,5,5,5,5,
        0,5,0,5,5,5,0,5,5,5,5,5,0,5,5,5,
        5,5,0x18,0x18,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x1a,0x1a,
        0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0x1b,
        0x1b,0x1b,0x1b,0x1b,0,0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0x10,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x10,0x10,
        0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x11,
        0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0,0
    ]
);

pub static HEADER: CodePointTrieHeader = CodePointTrieHeader {
    high_start: 0x110000,
    shifted12_high_start: 0x110,
    trie_type: TrieType::Fast,
    index3_null_offset: 0x66a,
    data_null_offset: 0xd18,
    null_value: 0x0,
};
