// @(#)root/core/meta:$Id$e
// Author: Vassil Vassilev   13/03/2013

/*******************************************************************************
 * Copyright (C) 1995-2013, Rene Brun and Fons Rademakers.                     *
 * All rights reserved.                                                        *
 *                                                                             *
 * For the licensing terms see $ROOTSYS/LICENSE.                               *
 * For the list of contributors see $ROOTSYS/README/CREDITS.                   *
 ******************************************************************************/

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  Class representing a value coming from cling. Its main use case           //
//  is to TCallFunc. When TCallFunc returns by-value, i.e. a temporary        //
//  variable, its lifetime has to be extended. TClingValue provides a         //
//  way to extend the temporaries lifetime and gives the user to control it.  //
//                                                                            //
//  The class is used to hide the implementation details of                   //
//  cling::Value.                                                             //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#ifndef ROOT_TClingValue
#define ROOT_TClingValue

#include "RtypesCore.h"
#include "TInterpreterValue.h"
#include <string>
#include <utility>

namespace cling {
   class Value;
}

class TClingValue : public TInterpreterValue {
private:
   struct HasTheSameSizeAsClingValue {
      long double fBiggestElementOfUnion;
      bool  fNeedsManagedAlloc;
      short fTypeKind;
      void* fType;
      void* fInterpreter;
   } fValue;

   cling::Value& ToCV() {
      return reinterpret_cast<cling::Value&>(fValue); }
   const cling::Value& ToCV() const {
      return reinterpret_cast<const cling::Value&>(fValue); }

public:
   TClingValue();
   TClingValue(const TClingValue& Other);
   TClingValue& operator=(TClingValue &Other);
   ~TClingValue();

   const void* GetValAddr() const override { return &fValue; }
   void* GetValAddr() override { return &fValue; }

   std::pair<std::string, std::string> ToTypeAndValueString() const override;
   Bool_t      IsValid() const override;
   Double_t    GetAsDouble() const override;
   Long_t      GetAsLong() const override;
   ULong_t     GetAsUnsignedLong() const override;
   void*       GetAsPointer() const override;
   std::string ToString() const override;
};

#endif // ROOT_TClingValue
