// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

//! Data obtained from [`calendrical_calculations`].

use super::PackedHijriYearData;

pub const STARTING_YEAR: i32 = 1317;

#[rustfmt::skip]
#[allow(clippy::unwrap_used)] // const
pub const DATA: &[PackedHijriYearData] = {
    use calendrical_calculations::gregorian::fixed_from_gregorian as gregorian;
    let l = true; // long
    let s = false; // short
    &[
        PackedHijriYearData::try_new(1317, [l, l, l, l, s, s, l, s, l, s, s, l], gregorian(1899, 5, 11)).unwrap(),
        PackedHijriYearData::try_new(1318, [s, l, l, l, s, l, s, l, s, l, s, s], gregorian(1900, 5, 1)).unwrap(),
        PackedHijriYearData::try_new(1319, [l, s, l, l, s, l, s, l, l, s, l, s], gregorian(1901, 4, 20)).unwrap(),
        PackedHijriYearData::try_new(1320, [l, s, s, l, s, l, s, l, l, s, l, l], gregorian(1902, 4, 10)).unwrap(),
        PackedHijriYearData::try_new(1321, [s, l, s, s, l, s, s, l, l, s, l, l], gregorian(1903, 3, 31)).unwrap(),
        PackedHijriYearData::try_new(1322, [l, s, l, s, s, s, l, s, l, s, l, l], gregorian(1904, 3, 19)).unwrap(),
        PackedHijriYearData::try_new(1323, [l, s, l, l, s, s, s, l, s, l, s, l], gregorian(1905, 3, 8)).unwrap(),
        PackedHijriYearData::try_new(1324, [l, s, l, l, s, l, s, s, l, s, l, s], gregorian(1906, 2, 25)).unwrap(),
        PackedHijriYearData::try_new(1325, [l, s, l, l, s, l, l, s, l, s, l, s], gregorian(1907, 2, 14)).unwrap(),
        PackedHijriYearData::try_new(1326, [s, l, s, l, s, l, l, s, l, l, s, l], gregorian(1908, 2, 4)).unwrap(),
        PackedHijriYearData::try_new(1327, [s, s, l, s, l, s, l, s, l, l, l, s], gregorian(1909, 1, 24)).unwrap(),
        PackedHijriYearData::try_new(1328, [l, s, s, l, s, s, l, s, l, l, l, s], gregorian(1910, 1, 13)).unwrap(),
        PackedHijriYearData::try_new(1329, [l, l, s, l, s, s, s, l, s, l, l, l], gregorian(1911, 1, 2)).unwrap(),
        PackedHijriYearData::try_new(1330, [s, l, l, s, s, l, s, s, l, s, l, l], gregorian(1911, 12, 23)).unwrap(),
        PackedHijriYearData::try_new(1331, [s, l, l, s, l, s, l, s, l, s, l, s], gregorian(1912, 12, 11)).unwrap(),
        PackedHijriYearData::try_new(1332, [s, l, l, l, s, l, s, l, s, l, s, l], gregorian(1913, 11, 30)).unwrap(),
        PackedHijriYearData::try_new(1333, [s, s, l, l, s, l, l, s, l, l, s, s], gregorian(1914, 11, 20)).unwrap(),
        PackedHijriYearData::try_new(1334, [s, l, s, l, s, l, l, s, l, l, l, s], gregorian(1915, 11, 9)).unwrap(),
        PackedHijriYearData::try_new(1335, [s, s, l, s, l, s, l, s, l, l, l, s], gregorian(1916, 10, 29)).unwrap(),
        PackedHijriYearData::try_new(1336, [l, s, l, s, s, l, s, l, s, l, l, s], gregorian(1917, 10, 18)).unwrap(),
        PackedHijriYearData::try_new(1337, [l, s, l, l, s, s, l, s, l, s, l, s], gregorian(1918, 10, 7)).unwrap(),
        PackedHijriYearData::try_new(1338, [l, s, l, l, l, s, l, s, s, l, s, l], gregorian(1919, 9, 26)).unwrap(),
        PackedHijriYearData::try_new(1339, [s, s, l, l, l, s, l, s, l, s, l, s], gregorian(1920, 9, 15)).unwrap(),
        PackedHijriYearData::try_new(1340, [s, l, s, l, l, l, s, l, s, l, s, l], gregorian(1921, 9, 4)).unwrap(),
        PackedHijriYearData::try_new(1341, [s, s, l, s, l, l, s, l, l, s, l, s], gregorian(1922, 8, 25)).unwrap(),
        PackedHijriYearData::try_new(1342, [s, l, s, l, s, l, s, l, l, s, l, l], gregorian(1923, 8, 14)).unwrap(),
        PackedHijriYearData::try_new(1343, [s, s, l, s, l, s, l, s, l, s, l, l], gregorian(1924, 8, 3)).unwrap(),
        PackedHijriYearData::try_new(1344, [s, l, s, l, s, l, s, l, s, l, s, l], gregorian(1925, 7, 23)).unwrap(),
        PackedHijriYearData::try_new(1345, [s, l, l, s, l, l, s, s, l, s, s, l], gregorian(1926, 7, 12)).unwrap(),
        PackedHijriYearData::try_new(1346, [s, l, l, s, l, l, s, l, s, l, s, s], gregorian(1927, 7, 1)).unwrap(),
        PackedHijriYearData::try_new(1347, [l, s, l, s, l, l, l, s, l, s, l, s], gregorian(1928, 6, 19)).unwrap(),
        PackedHijriYearData::try_new(1348, [s, l, s, l, s, l, l, l, s, l, s, l], gregorian(1929, 6, 9)).unwrap(),
        PackedHijriYearData::try_new(1349, [s, s, l, s, l, s, l, s, l, l, l, s], gregorian(1930, 5, 30)).unwrap(),
        PackedHijriYearData::try_new(1350, [l, s, s, l, s, l, s, l, s, l, l, s], gregorian(1931, 5, 19)).unwrap(),
        PackedHijriYearData::try_new(1351, [l, l, s, l, s, l, s, s, l, s, l, s], gregorian(1932, 5, 7)).unwrap(),
        PackedHijriYearData::try_new(1352, [l, l, s, l, l, s, l, s, s, l, s, l], gregorian(1933, 4, 26)).unwrap(),
        PackedHijriYearData::try_new(1353, [s, l, l, s, l, l, s, s, l, s, l, s], gregorian(1934, 4, 16)).unwrap(),
        PackedHijriYearData::try_new(1354, [s, l, l, s, l, l, l, s, s, l, s, l], gregorian(1935, 4, 5)).unwrap(),
        PackedHijriYearData::try_new(1355, [s, s, l, l, s, l, l, s, l, s, l, s], gregorian(1936, 3, 25)).unwrap(),
        PackedHijriYearData::try_new(1356, [l, s, s, l, l, s, l, s, l, l, s, l], gregorian(1937, 3, 14)).unwrap(),
        PackedHijriYearData::try_new(1357, [s, l, s, l, s, s, l, s, l, l, s, l], gregorian(1938, 3, 4)).unwrap(),
        PackedHijriYearData::try_new(1358, [l, s, l, s, l, s, s, l, s, l, s, l], gregorian(1939, 2, 21)).unwrap(),
        PackedHijriYearData::try_new(1359, [l, l, s, l, s, l, s, s, l, s, s, l], gregorian(1940, 2, 10)).unwrap(),
        PackedHijriYearData::try_new(1360, [l, l, s, l, l, s, l, s, s, l, s, l], gregorian(1941, 1, 29)).unwrap(),
        PackedHijriYearData::try_new(1361, [s, l, s, l, l, s, l, s, l, s, l, s], gregorian(1942, 1, 19)).unwrap(),
        PackedHijriYearData::try_new(1362, [l, s, l, s, l, s, l, l, s, l, s, l], gregorian(1943, 1, 8)).unwrap(),
        PackedHijriYearData::try_new(1363, [s, l, s, s, l, s, l, l, s, l, l, s], gregorian(1943, 12, 29)).unwrap(),
        PackedHijriYearData::try_new(1364, [l, s, l, s, s, l, s, l, s, l, l, l], gregorian(1944, 12, 17)).unwrap(),
        PackedHijriYearData::try_new(1365, [s, l, s, l, s, s, l, s, s, l, l, l], gregorian(1945, 12, 7)).unwrap(),
        PackedHijriYearData::try_new(1366, [s, l, l, s, l, s, s, l, s, s, l, l], gregorian(1946, 11, 26)).unwrap(),
        PackedHijriYearData::try_new(1367, [s, l, l, l, s, l, s, s, l, s, s, l], gregorian(1947, 11, 15)).unwrap(),
        PackedHijriYearData::try_new(1368, [l, s, l, l, s, l, l, s, s, l, s, l], gregorian(1948, 11, 3)).unwrap(),
        PackedHijriYearData::try_new(1369, [s, l, s, l, s, l, l, s, l, s, l, s], gregorian(1949, 10, 24)).unwrap(),
        PackedHijriYearData::try_new(1370, [l, s, s, l, l, s, l, s, l, l, s, l], gregorian(1950, 10, 13)).unwrap(),
        PackedHijriYearData::try_new(1371, [l, s, s, l, s, s, l, s, l, l, l, l], gregorian(1951, 10, 3)).unwrap(),
        PackedHijriYearData::try_new(1372, [s, s, l, s, l, s, s, l, s, l, l, l], gregorian(1952, 9, 22)).unwrap(),
        PackedHijriYearData::try_new(1373, [s, l, s, l, s, l, s, s, l, s, l, l], gregorian(1953, 9, 11)).unwrap(),
        PackedHijriYearData::try_new(1374, [s, l, s, l, l, s, l, s, s, l, s, l], gregorian(1954, 8, 31)).unwrap(),
        PackedHijriYearData::try_new(1375, [s, l, s, l, l, l, s, l, s, s, l, s], gregorian(1955, 8, 20)).unwrap(),
        PackedHijriYearData::try_new(1376, [l, s, l, s, l, l, s, l, l, s, l, s], gregorian(1956, 8, 8)).unwrap(),
        PackedHijriYearData::try_new(1377, [s, l, s, s, l, l, s, l, l, l, s, l], gregorian(1957, 7, 29)).unwrap(),
        PackedHijriYearData::try_new(1378, [s, s, l, s, s, l, s, l, l, l, s, l], gregorian(1958, 7, 19)).unwrap(),
        PackedHijriYearData::try_new(1379, [l, s, s, l, s, s, l, s, l, l, s, l], gregorian(1959, 7, 8)).unwrap(),
        PackedHijriYearData::try_new(1380, [l, s, l, s, l, s, s, l, s, l, s, l], gregorian(1960, 6, 26)).unwrap(),
        PackedHijriYearData::try_new(1381, [l, s, l, s, l, l, s, l, s, s, l, s], gregorian(1961, 6, 15)).unwrap(),
        PackedHijriYearData::try_new(1382, [l, s, l, l, s, l, l, s, l, s, s, l], gregorian(1962, 6, 4)).unwrap(),
        PackedHijriYearData::try_new(1383, [s, l, s, l, s, l, l, l, s, l, s, s], gregorian(1963, 5, 25)).unwrap(),
        PackedHijriYearData::try_new(1384, [l, s, s, l, s, l, l, l, s, l, l, s], gregorian(1964, 5, 13)).unwrap(),
        PackedHijriYearData::try_new(1385, [s, l, s, s, l, s, l, l, s, l, l, l], gregorian(1965, 5, 3)).unwrap(),
        PackedHijriYearData::try_new(1386, [s, s, l, s, s, l, s, l, s, l, l, l], gregorian(1966, 4, 23)).unwrap(),
        PackedHijriYearData::try_new(1387, [s, l, s, l, s, l, s, s, l, s, l, l], gregorian(1967, 4, 12)).unwrap(),
        PackedHijriYearData::try_new(1388, [s, l, l, s, l, s, l, s, s, l, s, l], gregorian(1968, 3, 31)).unwrap(),
        PackedHijriYearData::try_new(1389, [s, l, l, s, l, l, s, l, s, s, l, s], gregorian(1969, 3, 20)).unwrap(),
        PackedHijriYearData::try_new(1390, [l, s, l, s, l, l, l, s, l, s, l, s], gregorian(1970, 3, 9)).unwrap(),
        PackedHijriYearData::try_new(1391, [s, l, s, l, s, l, l, l, s, l, s, l], gregorian(1971, 2, 27)).unwrap(),
        PackedHijriYearData::try_new(1392, [s, s, l, s, s, l, l, l, s, l, s, l], gregorian(1972, 2, 17)).unwrap(),
        PackedHijriYearData::try_new(1393, [l, s, s, l, s, l, s, l, s, l, s, l], gregorian(1973, 2, 5)).unwrap(),
        PackedHijriYearData::try_new(1394, [l, l, s, s, l, s, l, s, s, l, s, l], gregorian(1974, 1, 25)).unwrap(),
        PackedHijriYearData::try_new(1395, [l, l, s, l, s, l, s, l, s, s, l, s], gregorian(1975, 1, 14)).unwrap(),
        PackedHijriYearData::try_new(1396, [l, l, l, s, l, s, l, s, l, s, s, l], gregorian(1976, 1, 3)).unwrap(),
        PackedHijriYearData::try_new(1397, [s, l, l, s, l, l, s, l, s, l, s, s], gregorian(1976, 12, 23)).unwrap(),
        PackedHijriYearData::try_new(1398, [l, s, l, s, l, l, s, l, l, s, s, l], gregorian(1977, 12, 12)).unwrap(),
        PackedHijriYearData::try_new(1399, [s, l, s, l, s, l, s, l, l, s, l, s], gregorian(1978, 12, 2)).unwrap(),
        PackedHijriYearData::try_new(1400, [l, l, s, s, l, s, l, s, l, s, l, l], gregorian(1979, 11, 21)).unwrap(),
        PackedHijriYearData::try_new(1401, [s, l, l, s, s, l, s, s, l, s, l, l], gregorian(1980, 11, 10)).unwrap(),
        PackedHijriYearData::try_new(1402, [s, l, l, l, s, s, l, s, s, l, s, l], gregorian(1981, 10, 30)).unwrap(),
        PackedHijriYearData::try_new(1403, [s, l, l, l, s, l, s, l, s, s, l, s], gregorian(1982, 10, 19)).unwrap(),
        PackedHijriYearData::try_new(1404, [l, s, l, l, s, l, l, s, l, s, s, l], gregorian(1983, 10, 8)).unwrap(),
        PackedHijriYearData::try_new(1405, [s, l, s, l, s, l, l, l, s, l, s, s], gregorian(1984, 9, 27)).unwrap(),
        PackedHijriYearData::try_new(1406, [l, s, l, s, l, s, l, l, s, l, s, l], gregorian(1985, 9, 16)).unwrap(),
        PackedHijriYearData::try_new(1407, [l, s, s, l, s, l, s, l, s, l, l, s], gregorian(1986, 9, 6)).unwrap(),
        PackedHijriYearData::try_new(1408, [l, l, s, s, l, s, l, s, l, s, l, s], gregorian(1987, 8, 26)).unwrap(),
        PackedHijriYearData::try_new(1409, [l, l, l, s, s, l, s, l, s, s, l, s], gregorian(1988, 8, 14)).unwrap(),
        PackedHijriYearData::try_new(1410, [l, l, l, s, l, l, s, s, l, s, s, l], gregorian(1989, 8, 3)).unwrap(),
        PackedHijriYearData::try_new(1411, [l, s, l, s, l, l, s, l, s, l, s, s], gregorian(1990, 7, 24)).unwrap(),
        PackedHijriYearData::try_new(1412, [l, l, s, l, s, l, l, s, l, s, l, s], gregorian(1991, 7, 13)).unwrap(),
        PackedHijriYearData::try_new(1413, [l, s, s, l, s, l, l, s, l, l, s, l], gregorian(1992, 7, 2)).unwrap(),
        PackedHijriYearData::try_new(1414, [s, l, s, s, l, s, l, s, l, l, l, s], gregorian(1993, 6, 22)).unwrap(),
        PackedHijriYearData::try_new(1415, [l, s, l, s, s, l, s, l, s, l, l, s], gregorian(1994, 6, 11)).unwrap(),
        PackedHijriYearData::try_new(1416, [l, l, s, l, s, s, l, s, l, s, l, s], gregorian(1995, 5, 31)).unwrap(),
        PackedHijriYearData::try_new(1417, [l, l, s, l, s, l, s, l, s, l, s, s], gregorian(1996, 5, 19)).unwrap(),
        PackedHijriYearData::try_new(1418, [l, l, s, l, l, s, l, s, l, s, l, s], gregorian(1997, 5, 8)).unwrap(),
        PackedHijriYearData::try_new(1419, [s, l, s, l, s, l, l, l, s, l, s, l], gregorian(1998, 4, 28)).unwrap(),
        PackedHijriYearData::try_new(1420, [s, s, l, s, l, s, l, l, l, s, l, s], gregorian(1999, 4, 18)).unwrap(),
        PackedHijriYearData::try_new(1421, [l, s, s, l, s, s, l, l, l, s, l, l], gregorian(2000, 4, 6)).unwrap(),
        PackedHijriYearData::try_new(1422, [s, l, s, s, l, s, s, l, l, s, l, l], gregorian(2001, 3, 27)).unwrap(),
        PackedHijriYearData::try_new(1423, [l, s, l, s, s, l, s, s, l, l, s, l], gregorian(2002, 3, 16)).unwrap(),
        PackedHijriYearData::try_new(1424, [l, s, l, s, l, s, l, s, l, s, s, l], gregorian(2003, 3, 5)).unwrap(),
        PackedHijriYearData::try_new(1425, [l, s, l, l, s, l, s, l, s, l, s, s], gregorian(2004, 2, 22)).unwrap(),
        PackedHijriYearData::try_new(1426, [l, l, s, l, s, l, l, s, l, s, l, s], gregorian(2005, 2, 10)).unwrap(),
        PackedHijriYearData::try_new(1427, [l, s, s, l, s, l, l, l, s, l, s, l], gregorian(2006, 1, 31)).unwrap(),
        PackedHijriYearData::try_new(1428, [s, l, s, s, l, s, l, l, l, s, l, s], gregorian(2007, 1, 21)).unwrap(),
        PackedHijriYearData::try_new(1429, [l, s, l, s, s, l, s, l, l, s, l, s], gregorian(2008, 1, 10)).unwrap(),
        PackedHijriYearData::try_new(1430, [l, l, s, l, s, s, l, s, l, s, l, s], gregorian(2008, 12, 29)).unwrap(),
        PackedHijriYearData::try_new(1431, [l, l, l, s, l, s, s, l, s, l, s, s], gregorian(2009, 12, 18)).unwrap(),
        PackedHijriYearData::try_new(1432, [l, l, l, s, l, l, s, l, s, s, l, s], gregorian(2010, 12, 7)).unwrap(),
        PackedHijriYearData::try_new(1433, [s, l, l, s, l, l, s, l, l, s, s, l], gregorian(2011, 11, 27)).unwrap(),
        PackedHijriYearData::try_new(1434, [s, s, l, s, l, l, s, l, l, l, s, s], gregorian(2012, 11, 16)).unwrap(),
        PackedHijriYearData::try_new(1435, [l, s, s, l, s, l, s, l, l, l, s, l], gregorian(2013, 11, 5)).unwrap(),
        PackedHijriYearData::try_new(1436, [s, l, s, l, s, s, l, s, l, l, s, l], gregorian(2014, 10, 26)).unwrap(),
        PackedHijriYearData::try_new(1437, [s, l, l, s, l, s, s, l, s, l, s, l], gregorian(2015, 10, 15)).unwrap(),
        PackedHijriYearData::try_new(1438, [s, l, l, l, s, l, s, s, l, s, s, l], gregorian(2016, 10, 3)).unwrap(),
        PackedHijriYearData::try_new(1439, [s, l, l, l, l, s, l, s, s, l, s, s], gregorian(2017, 9, 22)).unwrap(),
        PackedHijriYearData::try_new(1440, [l, s, l, l, l, s, l, l, s, s, l, s], gregorian(2018, 9, 11)).unwrap(),
        PackedHijriYearData::try_new(1441, [s, l, s, l, l, s, l, l, s, l, s, l], gregorian(2019, 9, 1)).unwrap(),
        PackedHijriYearData::try_new(1442, [s, s, l, s, l, s, l, l, l, s, l, s], gregorian(2020, 8, 21)).unwrap(),
        PackedHijriYearData::try_new(1443, [l, s, l, s, s, l, s, l, l, s, l, s], gregorian(2021, 8, 10)).unwrap(),
        PackedHijriYearData::try_new(1444, [l, l, s, l, s, s, l, s, l, s, l, s], gregorian(2022, 7, 30)).unwrap(),
        PackedHijriYearData::try_new(1445, [l, l, l, s, l, s, l, s, s, l, s, l], gregorian(2023, 7, 19)).unwrap(),
        PackedHijriYearData::try_new(1446, [s, l, l, l, s, l, s, l, s, s, l, s], gregorian(2024, 7, 8)).unwrap(),
        PackedHijriYearData::try_new(1447, [s, l, l, l, s, l, l, s, l, s, s, l], gregorian(2025, 6, 27)).unwrap(),
        PackedHijriYearData::try_new(1448, [s, s, l, l, s, l, l, s, l, l, s, s], gregorian(2026, 6, 17)).unwrap(),
        PackedHijriYearData::try_new(1449, [l, s, l, s, l, s, l, s, l, l, s, l], gregorian(2027, 6, 6)).unwrap(),
        PackedHijriYearData::try_new(1450, [s, l, s, l, s, s, l, s, l, l, l, s], gregorian(2028, 5, 26)).unwrap(),
        PackedHijriYearData::try_new(1451, [l, s, l, l, s, s, s, l, s, l, l, s], gregorian(2029, 5, 15)).unwrap(),
        PackedHijriYearData::try_new(1452, [l, l, l, s, s, l, s, s, l, s, l, s], gregorian(2030, 5, 4)).unwrap(),
        PackedHijriYearData::try_new(1453, [l, l, l, s, l, s, l, s, s, l, s, l], gregorian(2031, 4, 23)).unwrap(),
        PackedHijriYearData::try_new(1454, [s, l, l, s, l, l, s, l, s, s, l, s], gregorian(2032, 4, 12)).unwrap(),
        PackedHijriYearData::try_new(1455, [l, s, l, s, l, l, s, l, s, l, l, s], gregorian(2033, 4, 1)).unwrap(),
        PackedHijriYearData::try_new(1456, [s, l, s, l, s, l, s, l, l, s, l, l], gregorian(2034, 3, 22)).unwrap(),
        PackedHijriYearData::try_new(1457, [s, s, l, s, s, l, s, l, l, s, l, l], gregorian(2035, 3, 12)).unwrap(),
        PackedHijriYearData::try_new(1458, [l, s, s, l, s, s, l, s, l, s, l, l], gregorian(2036, 2, 29)).unwrap(),
        PackedHijriYearData::try_new(1459, [l, s, l, s, l, s, s, l, s, l, s, l], gregorian(2037, 2, 17)).unwrap(),
        PackedHijriYearData::try_new(1460, [l, s, l, l, s, l, s, s, l, s, l, s], gregorian(2038, 2, 6)).unwrap(),
        PackedHijriYearData::try_new(1461, [l, s, l, l, s, l, s, l, s, l, s, l], gregorian(2039, 1, 26)).unwrap(),
        PackedHijriYearData::try_new(1462, [s, l, s, l, l, s, l, s, l, l, s, s], gregorian(2040, 1, 16)).unwrap(),
        PackedHijriYearData::try_new(1463, [l, s, l, s, l, s, l, s, l, l, l, s], gregorian(2041, 1, 4)).unwrap(),
        PackedHijriYearData::try_new(1464, [s, l, s, l, s, s, l, s, l, l, l, l], gregorian(2041, 12, 25)).unwrap(),
        PackedHijriYearData::try_new(1465, [s, l, s, s, l, s, s, l, s, l, l, l], gregorian(2042, 12, 15)).unwrap(),
        PackedHijriYearData::try_new(1466, [s, l, l, s, s, l, s, s, l, l, s, l], gregorian(2043, 12, 4)).unwrap(),
        PackedHijriYearData::try_new(1467, [s, l, l, s, l, s, l, s, s, l, l, s], gregorian(2044, 11, 22)).unwrap(),
        PackedHijriYearData::try_new(1468, [s, l, l, l, s, l, s, l, s, l, s, s], gregorian(2045, 11, 11)).unwrap(),
        PackedHijriYearData::try_new(1469, [l, s, l, s, l, l, l, s, l, s, l, s], gregorian(2046, 10, 31)).unwrap(),
        PackedHijriYearData::try_new(1470, [s, l, s, l, s, l, l, s, l, l, s, l], gregorian(2047, 10, 21)).unwrap(),
        PackedHijriYearData::try_new(1471, [s, s, l, s, l, s, l, s, l, l, l, s], gregorian(2048, 10, 10)).unwrap(),
        PackedHijriYearData::try_new(1472, [l, s, s, l, s, l, s, l, s, l, l, s], gregorian(2049, 9, 29)).unwrap(),
        PackedHijriYearData::try_new(1473, [l, s, l, s, l, s, l, s, s, l, l, s], gregorian(2050, 9, 18)).unwrap(),
        PackedHijriYearData::try_new(1474, [l, s, l, l, s, l, s, l, s, s, l, s], gregorian(2051, 9, 7)).unwrap(),
        PackedHijriYearData::try_new(1475, [l, s, l, l, l, s, l, s, l, s, s, l], gregorian(2052, 8, 26)).unwrap(),
        PackedHijriYearData::try_new(1476, [s, l, s, l, l, l, s, l, s, l, s, s], gregorian(2053, 8, 16)).unwrap(),
        PackedHijriYearData::try_new(1477, [l, s, s, l, l, l, s, l, l, s, l, s], gregorian(2054, 8, 5)).unwrap(),
        PackedHijriYearData::try_new(1478, [s, l, s, s, l, l, s, l, l, s, l, l], gregorian(2055, 7, 26)).unwrap(),
        PackedHijriYearData::try_new(1479, [s, s, l, s, l, s, l, s, l, s, l, l], gregorian(2056, 7, 15)).unwrap(),
        PackedHijriYearData::try_new(1480, [s, l, s, l, s, l, s, s, l, l, s, l], gregorian(2057, 7, 4)).unwrap(),
        PackedHijriYearData::try_new(1481, [s, l, l, s, l, s, l, s, l, s, s, l], gregorian(2058, 6, 23)).unwrap(),
        PackedHijriYearData::try_new(1482, [s, l, l, s, l, l, s, l, s, l, s, s], gregorian(2059, 6, 12)).unwrap(),
        PackedHijriYearData::try_new(1483, [l, s, l, s, l, l, l, s, l, s, l, s], gregorian(2060, 5, 31)).unwrap(),
        PackedHijriYearData::try_new(1484, [s, l, s, l, l, s, l, s, l, l, s, l], gregorian(2061, 5, 21)).unwrap(),
        PackedHijriYearData::try_new(1485, [s, s, l, s, l, s, l, l, s, l, l, s], gregorian(2062, 5, 11)).unwrap(),
        PackedHijriYearData::try_new(1486, [l, s, s, l, s, l, s, l, s, l, l, s], gregorian(2063, 4, 30)).unwrap(),
        PackedHijriYearData::try_new(1487, [l, l, s, l, s, s, l, s, l, s, l, s], gregorian(2064, 4, 18)).unwrap(),
        PackedHijriYearData::try_new(1488, [l, l, s, l, l, s, s, l, s, s, l, l], gregorian(2065, 4, 7)).unwrap(),
        PackedHijriYearData::try_new(1489, [s, l, l, s, l, l, s, s, l, s, s, l], gregorian(2066, 3, 28)).unwrap(),
        PackedHijriYearData::try_new(1490, [s, l, l, s, l, l, l, s, s, l, s, s], gregorian(2067, 3, 17)).unwrap(),
        PackedHijriYearData::try_new(1491, [l, s, l, s, l, l, l, s, l, s, l, s], gregorian(2068, 3, 5)).unwrap(),
        PackedHijriYearData::try_new(1492, [l, s, s, l, s, l, l, s, l, s, l, l], gregorian(2069, 2, 23)).unwrap(),
        PackedHijriYearData::try_new(1493, [s, l, s, s, l, s, l, s, l, s, l, l], gregorian(2070, 2, 13)).unwrap(),
        PackedHijriYearData::try_new(1494, [l, s, l, s, s, l, s, s, l, s, l, l], gregorian(2071, 2, 2)).unwrap(),
        PackedHijriYearData::try_new(1495, [l, l, s, l, s, s, l, s, s, l, s, l], gregorian(2072, 1, 22)).unwrap(),
        PackedHijriYearData::try_new(1496, [l, l, s, l, l, s, s, l, s, s, l, s], gregorian(2073, 1, 10)).unwrap(),
        PackedHijriYearData::try_new(1497, [l, l, s, l, l, s, l, s, l, s, s, l], gregorian(2073, 12, 30)).unwrap(),
        PackedHijriYearData::try_new(1498, [s, l, s, l, l, s, l, l, s, l, s, l], gregorian(2074, 12, 20)).unwrap(),
        PackedHijriYearData::try_new(1499, [s, s, l, s, l, s, l, l, s, l, l, s], gregorian(2075, 12, 10)).unwrap(),
        PackedHijriYearData::try_new(1500, [l, s, s, l, s, l, s, l, s, l, l, l], gregorian(2076, 11, 28)).unwrap(),
        PackedHijriYearData::try_new(1501, [s, l, s, l, s, s, l, s, s, l, l, l], gregorian(2077, 11, 18)).unwrap(),
        PackedHijriYearData::try_new(1502, [s, l, l, s, l, s, s, l, s, s, l, l], gregorian(2078, 11, 7)).unwrap(),
        PackedHijriYearData::try_new(1503, [l, s, l, l, s, l, s, s, l, s, s, l], gregorian(2079, 10, 27)).unwrap(),
        PackedHijriYearData::try_new(1504, [l, s, l, l, s, l, l, s, s, l, s, l], gregorian(2080, 10, 15)).unwrap(),
        PackedHijriYearData::try_new(1505, [s, s, l, l, s, l, l, s, l, s, l, s], gregorian(2081, 10, 5)).unwrap(),
        PackedHijriYearData::try_new(1506, [l, s, s, l, s, l, l, s, l, l, s, l], gregorian(2082, 9, 24)).unwrap(),
        PackedHijriYearData::try_new(1507, [l, s, s, s, l, s, l, s, l, l, l, l], gregorian(2083, 9, 14)).unwrap(),
        PackedHijriYearData::try_new(1508, [s, s, l, s, s, l, s, l, s, l, l, l], gregorian(2084, 9, 3)).unwrap(),
        PackedHijriYearData::try_new(1509, [s, l, s, l, s, s, l, s, l, s, l, l], gregorian(2085, 8, 23)).unwrap(),
        PackedHijriYearData::try_new(1510, [s, l, s, l, l, s, l, s, s, l, s, l], gregorian(2086, 8, 12)).unwrap(),
        PackedHijriYearData::try_new(1511, [s, l, s, l, l, s, l, l, s, s, l, s], gregorian(2087, 8, 1)).unwrap(),
        PackedHijriYearData::try_new(1512, [l, s, s, l, l, l, s, l, l, s, s, l], gregorian(2088, 7, 20)).unwrap(),
        PackedHijriYearData::try_new(1513, [s, s, l, s, l, l, s, l, l, s, l, s], gregorian(2089, 7, 10)).unwrap(),
        PackedHijriYearData::try_new(1514, [l, s, s, l, s, l, s, l, l, l, s, l], gregorian(2090, 6, 29)).unwrap(),
        PackedHijriYearData::try_new(1515, [s, l, s, s, l, s, l, s, l, l, s, l], gregorian(2091, 6, 19)).unwrap(),
        PackedHijriYearData::try_new(1516, [l, s, l, s, s, l, s, l, s, l, s, l], gregorian(2092, 6, 7)).unwrap(),
        PackedHijriYearData::try_new(1517, [l, s, l, s, l, s, l, s, l, s, l, s], gregorian(2093, 5, 27)).unwrap(),
        PackedHijriYearData::try_new(1518, [l, s, l, l, s, l, l, s, s, l, s, l], gregorian(2094, 5, 16)).unwrap(),
        PackedHijriYearData::try_new(1519, [s, s, l, l, s, l, l, s, l, s, l, s], gregorian(2095, 5, 6)).unwrap(),
        PackedHijriYearData::try_new(1520, [l, s, s, l, s, l, l, l, s, l, l, s], gregorian(2096, 4, 24)).unwrap(),
        PackedHijriYearData::try_new(1521, [s, l, s, s, l, s, l, l, s, l, l, l], gregorian(2097, 4, 14)).unwrap(),
        PackedHijriYearData::try_new(1522, [s, s, l, s, s, l, s, l, s, l, l, l], gregorian(2098, 4, 4)).unwrap(),
        PackedHijriYearData::try_new(1523, [s, l, s, l, s, s, l, s, l, s, l, l], gregorian(2099, 3, 24)).unwrap(),
        PackedHijriYearData::try_new(1524, [s, l, l, s, l, s, l, s, s, l, s, l], gregorian(2100, 3, 13)).unwrap(),
        PackedHijriYearData::try_new(1525, [s, l, l, s, l, l, s, l, s, s, l, s], gregorian(2101, 3, 2)).unwrap(),
        PackedHijriYearData::try_new(1526, [l, s, l, s, l, l, l, s, l, s, s, l], gregorian(2102, 2, 19)).unwrap(),
        PackedHijriYearData::try_new(1527, [s, l, s, l, s, l, l, l, s, s, l, s], gregorian(2103, 2, 9)).unwrap(),
        PackedHijriYearData::try_new(1528, [l, s, l, s, s, l, l, l, s, l, s, l], gregorian(2104, 1, 29)).unwrap(),
        PackedHijriYearData::try_new(1529, [s, l, s, l, s, l, s, l, s, l, s, l], gregorian(2105, 1, 18)).unwrap(),
        PackedHijriYearData::try_new(1530, [l, s, l, s, l, s, l, s, s, l, s, l], gregorian(2106, 1, 7)).unwrap(),
        PackedHijriYearData::try_new(1531, [l, l, s, l, s, l, s, l, s, s, l, s], gregorian(2106, 12, 27)).unwrap(),
        PackedHijriYearData::try_new(1532, [l, l, l, s, l, s, l, s, s, l, s, s], gregorian(2107, 12, 16)).unwrap(),
        PackedHijriYearData::try_new(1533, [l, l, l, s, l, l, s, l, s, s, l, s], gregorian(2108, 12, 4)).unwrap(),
        PackedHijriYearData::try_new(1534, [l, s, l, s, l, l, s, l, s, l, s, l], gregorian(2109, 11, 24)).unwrap(),
        PackedHijriYearData::try_new(1535, [s, l, s, l, s, l, s, l, l, s, l, s], gregorian(2110, 11, 14)).unwrap(),
        PackedHijriYearData::try_new(1536, [l, s, l, s, l, s, s, l, l, s, l, l], gregorian(2111, 11, 3)).unwrap(),
        PackedHijriYearData::try_new(1537, [s, l, s, l, s, l, s, s, l, s, l, l], gregorian(2112, 10, 23)).unwrap(),
        PackedHijriYearData::try_new(1538, [s, l, l, s, l, s, l, s, s, l, s, l], gregorian(2113, 10, 12)).unwrap(),
        PackedHijriYearData::try_new(1539, [s, l, l, l, s, l, s, l, s, s, s, l], gregorian(2114, 10, 1)).unwrap(),
        PackedHijriYearData::try_new(1540, [l, s, l, l, s, l, l, s, l, s, s, l], gregorian(2115, 9, 20)).unwrap(),
        PackedHijriYearData::try_new(1541, [s, l, s, l, s, l, l, l, s, l, s, s], gregorian(2116, 9, 9)).unwrap(),
        PackedHijriYearData::try_new(1542, [l, s, l, s, l, s, l, l, s, l, s, l], gregorian(2117, 8, 29)).unwrap(),
        PackedHijriYearData::try_new(1543, [l, s, s, l, s, l, s, l, s, l, l, s], gregorian(2118, 8, 19)).unwrap(),
        PackedHijriYearData::try_new(1544, [l, l, s, s, l, s, l, s, s, l, l, s], gregorian(2119, 8, 8)).unwrap(),
        PackedHijriYearData::try_new(1545, [l, l, l, s, s, l, s, s, l, s, l, s], gregorian(2120, 7, 27)).unwrap(),
        PackedHijriYearData::try_new(1546, [l, l, l, s, l, s, l, s, l, s, s, l], gregorian(2121, 7, 16)).unwrap(),
        PackedHijriYearData::try_new(1547, [l, s, l, s, l, l, s, l, s, l, s, s], gregorian(2122, 7, 6)).unwrap(),
        PackedHijriYearData::try_new(1548, [l, s, l, s, l, l, s, l, l, s, l, s], gregorian(2123, 6, 25)).unwrap(),
        PackedHijriYearData::try_new(1549, [s, l, s, l, s, l, s, l, l, l, s, l], gregorian(2124, 6, 14)).unwrap(),
        PackedHijriYearData::try_new(1550, [s, l, s, s, s, l, s, l, l, l, l, s], gregorian(2125, 6, 4)).unwrap(),
        PackedHijriYearData::try_new(1551, [l, s, l, s, s, s, l, s, l, l, l, s], gregorian(2126, 5, 24)).unwrap(),
        PackedHijriYearData::try_new(1552, [l, l, s, s, l, s, s, l, s, l, l, s], gregorian(2127, 5, 13)).unwrap(),
        PackedHijriYearData::try_new(1553, [l, l, s, l, s, l, s, l, s, s, l, s], gregorian(2128, 5, 1)).unwrap(),
        PackedHijriYearData::try_new(1554, [l, l, s, l, s, l, l, s, l, s, s, l], gregorian(2129, 4, 20)).unwrap(),
        PackedHijriYearData::try_new(1555, [s, l, s, l, s, l, l, l, s, l, s, l], gregorian(2130, 4, 10)).unwrap(),
        PackedHijriYearData::try_new(1556, [s, s, l, s, l, s, l, l, l, s, l, s], gregorian(2131, 3, 31)).unwrap(),
        PackedHijriYearData::try_new(1557, [l, s, s, l, s, s, l, l, l, s, l, l], gregorian(2132, 3, 19)).unwrap(),
        PackedHijriYearData::try_new(1558, [s, l, s, s, s, l, s, l, l, s, l, l], gregorian(2133, 3, 9)).unwrap(),
        PackedHijriYearData::try_new(1559, [l, s, l, s, s, l, s, s, l, s, l, l], gregorian(2134, 2, 26)).unwrap(),
        PackedHijriYearData::try_new(1560, [l, s, l, s, l, s, l, s, l, s, s, l], gregorian(2135, 2, 15)).unwrap(),
        PackedHijriYearData::try_new(1561, [l, s, l, l, s, l, s, l, s, l, s, s], gregorian(2136, 2, 4)).unwrap(),
        PackedHijriYearData::try_new(1562, [l, s, l, l, s, l, l, s, l, s, l, s], gregorian(2137, 1, 23)).unwrap(),
        PackedHijriYearData::try_new(1563, [s, l, s, l, s, l, l, l, l, s, s, l], gregorian(2138, 1, 13)).unwrap(),
        PackedHijriYearData::try_new(1564, [s, s, l, s, l, s, l, l, l, s, l, s], gregorian(2139, 1, 3)).unwrap(),
        PackedHijriYearData::try_new(1565, [l, s, l, s, s, l, s, l, l, s, l, s], gregorian(2139, 12, 23)).unwrap(),
        PackedHijriYearData::try_new(1566, [l, l, s, l, s, s, l, s, l, s, l, s], gregorian(2140, 12, 11)).unwrap(),
    ]
};
