/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle;

import com.google.gradle.osdetector.OsDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.openjfx.gradle.JavaFXModule;
import org.openjfx.gradle.JavaFXPlatform;

public abstract class JavaFXOptions {
    static final String MAVEN_JAVAFX_ARTIFACT_GROUP_ID = "org.openjfx";
    private static final String JAVAFX_SDK_LIB_FOLDER = "lib";
    private JavaFXPlatform platform;
    private String version = "17";
    private String sdk;
    private String[] configurations = new String[]{"implementation"};
    private List<String> modules = new ArrayList<String>();
    private FlatDirectoryArtifactRepository customSDKArtifactRepository;
    private final SourceSetContainer sourceSets;
    private final Set<String> seenConfigurations = new HashSet<String>();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract RepositoryHandler getRepositories();

    @Inject
    protected abstract ConfigurationContainer getConfigurationContainer();

    @Inject
    protected abstract DependencyHandler getDependencies();

    public JavaFXOptions(SourceSetContainer sourceSets, OsDetector osDetector) {
        this.sourceSets = sourceSets;
        this.platform = JavaFXPlatform.detect(osDetector);
        this.setClasspathAttributesForAllSourceSets();
    }

    public JavaFXPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = JavaFXPlatform.fromString(platform);
        this.setClasspathAttributesForAllSourceSets();
    }

    private void setClasspathAttributesForAllSourceSets() {
        this.sourceSets.all(sourceSet -> {
            this.setClasspathAttributes(this.getConfigurationContainer().getByName(sourceSet.getCompileClasspathConfigurationName()));
            this.setClasspathAttributes(this.getConfigurationContainer().getByName(sourceSet.getRuntimeClasspathConfigurationName()));
        });
    }

    private void setClasspathAttributes(Configuration classpath) {
        classpath.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)((OperatingSystemFamily)this.getObjects().named(OperatingSystemFamily.class, this.platform.getOsFamily())));
        classpath.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)((MachineArchitecture)this.getObjects().named(MachineArchitecture.class, this.platform.getArch())));
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSdk(String sdk) {
        this.sdk = sdk;
        this.updateCustomSDKArtifactRepository();
    }

    public String getSdk() {
        return this.sdk;
    }

    public void setConfiguration(String configuration) {
        this.setConfigurations(new String[]{configuration});
    }

    public void setConfigurations(String[] configurations) {
        this.configurations = configurations;
        for (String conf : configurations) {
            if (this.seenConfigurations.contains(conf)) continue;
            this.declareFXDependencies(conf);
            this.seenConfigurations.add(conf);
        }
    }

    public String getConfiguration() {
        return this.configurations[0];
    }

    public String[] getConfigurations() {
        return this.configurations;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    public void modules(String ... moduleNames) {
        this.setModules(List.of(moduleNames));
    }

    private void declareFXDependencies(String conf) {
        this.getConfigurationContainer().getByName(conf).withDependencies(dependencySet -> {
            if (!List.of(this.configurations).contains(conf)) {
                return;
            }
            Set<JavaFXModule> javaFXModules = JavaFXModule.getJavaFXModules(this.modules);
            if (this.customSDKArtifactRepository == null) {
                javaFXModules.stream().sorted().forEach(javaFXModule -> dependencySet.add((Object)this.getDependencies().create((Object)("org.openjfx:" + javaFXModule.getArtifactName() + ":" + this.getVersion()))));
            } else {
                Stream javaFXModulesWithTransitives = Stream.concat(javaFXModules.stream(), javaFXModules.stream().flatMap(m -> m.getDependentModules().stream())).distinct().sorted();
                javaFXModulesWithTransitives.forEach(javaFXModule -> dependencySet.add((Object)this.getDependencies().create(Map.of("name", javaFXModule.getModuleName()))));
            }
        });
    }

    private void updateCustomSDKArtifactRepository() {
        if (this.customSDKArtifactRepository != null) {
            this.getRepositories().remove((Object)this.customSDKArtifactRepository);
            this.customSDKArtifactRepository = null;
        }
        if (this.sdk != null && !this.sdk.isEmpty()) {
            HashMap<String, Object> dirs = new HashMap<String, Object>();
            dirs.put("name", "customSDKArtifactRepository");
            if (this.sdk.endsWith(File.separator)) {
                dirs.put("dirs", this.sdk + JAVAFX_SDK_LIB_FOLDER);
            } else {
                dirs.put("dirs", this.sdk + File.separator + JAVAFX_SDK_LIB_FOLDER);
            }
            this.customSDKArtifactRepository = this.getRepositories().flatDir(dirs);
        }
    }
}

