/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.shadow.javaparser.JavaParser;
import org.javamodularity.moduleplugin.shadow.javaparser.ParserConfiguration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.CompilationUnit;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.modules.ModuleDeclaration;

class ModuleName {
    private static final Logger LOGGER = Logging.getLogger(ModuleName.class);

    ModuleName() {
    }

    Optional<String> findModuleName(Project project) {
        SourceSet main;
        try {
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.1")) >= 0) {
                JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
                main = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
            } else {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                main = (SourceSet)javaConvention.getSourceSets().getByName("main");
            }
        }
        catch (IllegalStateException | UnknownDomainObjectException e) {
            LOGGER.warn("Cannot obtain JavaPluginConvention", e);
            return Optional.empty();
        }
        Optional<Path> moduleInfoJava = main.getAllJava().getSourceDirectories().getFiles().stream().map(sourceDir -> sourceDir.toPath().resolve("module-info.java")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findAny();
        String projectPath = project.getPath();
        if (moduleInfoJava.isEmpty()) {
            LOGGER.lifecycle("Project {} => no module-info.java found", new Object[]{projectPath});
            return Optional.empty();
        }
        return this.findModuleName(moduleInfoJava.get(), projectPath);
    }

    private Optional<String> findModuleName(Path moduleInfoJava, String projectPath) {
        try {
            JavaParser parser = new JavaParser();
            parser.getParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_11);
            Optional<CompilationUnit> compilationUnit = parser.parse(moduleInfoJava).getResult();
            if (compilationUnit.isEmpty()) {
                LOGGER.debug("Project {} => compilation unit is empty", (Object)projectPath);
                return Optional.empty();
            }
            Optional<ModuleDeclaration> module = compilationUnit.get().getModule();
            if (module.isEmpty()) {
                LOGGER.warn("Project {} => module-info.java found, but module name could not be parsed", (Object)projectPath);
                return Optional.empty();
            }
            String name = module.get().getName().toString();
            LOGGER.lifecycle("Project {} => '{}' Java module", new Object[]{projectPath, name});
            return Optional.of(name);
        }
        catch (IOException e) {
            LOGGER.error("Project {} => error opening module-info.java at {}", (Object)projectPath, (Object)moduleInfoJava);
            return Optional.empty();
        }
    }
}

