/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.secret.Pair;
import org.freedesktop.secret.Secret;
import org.freedesktop.secret.Service;
import org.freedesktop.secret.Static;
import org.freedesktop.secret.handlers.Messaging;
import org.freedesktop.secret.interfaces.Collection;

public class Collection
extends Messaging
implements org.freedesktop.secret.interfaces.Collection {
    private String id;
    public static final List<Class<? extends DBusSignal>> signals = Arrays.asList(Collection.ItemCreated.class, Collection.ItemChanged.class, Collection.ItemDeleted.class);

    public Collection(DBusPath path, Service service) {
        super(service.getConnection(), signals, "org.freedesktop.secrets", path.getPath(), "org.freedesktop.Secret.Collection");
        String[] split = path.getPath().split("/");
        this.id = split[split.length - 1];
    }

    public Collection(DBusPath path, Service service, List<Class<? extends DBusSignal>> signals) {
        super(service.getConnection(), signals, "org.freedesktop.secrets", path.getPath(), "org.freedesktop.Secret.Collection");
        String[] split = path.getPath().split("/");
        this.id = split[split.length - 1];
    }

    public Collection(String id, Service service) {
        super(service.getConnection(), signals, "org.freedesktop.secrets", Static.ObjectPaths.collection(id), "org.freedesktop.Secret.Collection");
        this.id = id;
    }

    public static Map<String, Variant> createProperties(String label) {
        HashMap<String, Variant> properties = new HashMap<String, Variant>();
        properties.put("org.freedesktop.Secret.Collection.Label", new Variant((Object)label));
        return properties;
    }

    @Override
    public ObjectPath delete() {
        Object[] response = this.send("Delete", "", new Object[0]);
        if (response == null) {
            return null;
        }
        ObjectPath prompt = (ObjectPath)response[0];
        return prompt;
    }

    @Override
    public List<ObjectPath> searchItems(Map<String, String> attributes) {
        Object[] response = this.send("SearchItems", "a{ss}", attributes);
        if (response == null) {
            return null;
        }
        return (List)response[0];
    }

    @Override
    public Pair<ObjectPath, ObjectPath> createItem(Map<String, Variant> properties, Secret secret, boolean replace) {
        Object[] response = this.send("CreateItem", "a{sv}(oayays)b", properties, secret, replace);
        if (response == null) {
            return null;
        }
        return new Pair<Object, Object>(response[0], response[1]);
    }

    @Override
    public List<ObjectPath> getItems() {
        Variant response = this.getProperty("Items");
        if (response == null) {
            return null;
        }
        return (ArrayList)response.getValue();
    }

    @Override
    public String getLabel() {
        Variant response = this.getProperty("Label");
        if (response == null) {
            return null;
        }
        return (String)response.getValue();
    }

    @Override
    public void setLabel(String label) {
        this.setProperty("Label", new Variant((Object)label));
    }

    @Override
    public boolean isLocked() {
        Variant response = this.getProperty("Locked");
        if (response == null) {
            return true;
        }
        return (Boolean)response.getValue();
    }

    @Override
    public UInt64 created() {
        Variant response = this.getProperty("Created");
        if (response == null) {
            return null;
        }
        return (UInt64)response.getValue();
    }

    @Override
    public UInt64 modified() {
        Variant response = this.getProperty("Modified");
        if (response == null) {
            return null;
        }
        return (UInt64)response.getValue();
    }

    public boolean isRemote() {
        return false;
    }

    @Override
    public String getObjectPath() {
        return super.getObjectPath();
    }

    public String getId() {
        return this.id;
    }
}

