/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.printer.concretesyntaxmodel;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.SourcePrinter;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.concretesyntaxmodel.CsmElement;

public class CsmSequence
implements CsmElement {
    private List<CsmElement> elements;

    public CsmSequence(List<CsmElement> elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Null element in the sequence");
        }
        this.elements = elements;
    }

    public List<CsmElement> getElements() {
        return this.elements;
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        this.elements.forEach((Consumer<CsmElement> & Serializable)e -> e.prettyPrint(node, printer));
    }

    public String toString() {
        return this.elements.stream().map((Function<CsmElement, String> & Serializable)e -> e.toString()).collect(Collectors.joining(",", "CsmSequence[", "]"));
    }
}

