/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.endnote;

import de.undercouch.citeproc.bibtex.DateParser;
import de.undercouch.citeproc.bibtex.NameParser;
import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLItemDataBuilder;
import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.csl.CSLType;
import de.undercouch.citeproc.endnote.EndNoteLibrary;
import de.undercouch.citeproc.endnote.EndNoteParser;
import de.undercouch.citeproc.endnote.EndNoteReference;
import de.undercouch.citeproc.endnote.EndNoteType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jbibtex.ParseException;

public class EndNoteConverter {
    public EndNoteLibrary loadLibrary(InputStream is) throws IOException, ParseException {
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        EndNoteParser parser = new EndNoteParser();
        return parser.parse(reader);
    }

    public Map<String, CSLItemData> toItemData(EndNoteLibrary lib) {
        HashMap<String, CSLItemData> result = new HashMap<String, CSLItemData>();
        for (EndNoteReference ref : lib.getReferences()) {
            CSLItemData item = this.toItemData(ref);
            result.put(item.getId(), this.toItemData(ref));
        }
        return result;
    }

    public CSLItemData toItemData(EndNoteReference ref) {
        CSLType type = this.toType(ref.getType());
        CSLItemDataBuilder builder = new CSLItemDataBuilder().type(type);
        if (ref.getLabel() != null) {
            builder.id(ref.getLabel());
        }
        if (ref.getAccessDate() != null) {
            builder.accessed(DateParser.toDate(ref.getAccessDate()));
        }
        if (ref.getAuthors() != null) {
            builder.author(EndNoteConverter.toAuthors(ref.getAuthors()));
        }
        if (ref.getEditors() != null) {
            builder.editor(EndNoteConverter.toAuthors(ref.getEditors()));
        }
        if (ref.getJournal() != null) {
            builder.containerTitle(ref.getJournal());
            builder.collectionTitle(ref.getJournal());
        } else if (ref.getNameOfDatabase() != null) {
            builder.containerTitle(ref.getNameOfDatabase());
        } else {
            builder.containerTitle(ref.getBookOrConference());
            builder.collectionTitle(ref.getBookOrConference());
        }
        if (ref.getDate() != null) {
            CSLDate date = DateParser.toDate(ref.getDate());
            builder.issued(date);
            builder.eventDate(date);
        } else {
            CSLDate date = DateParser.toDate(ref.getYear());
            builder.issued(date);
            builder.eventDate(date);
        }
        if (ref.getLinkToPDF() != null) {
            builder.URL(ref.getLinkToPDF());
        } else {
            builder.URL(ref.getURL());
        }
        if (ref.getResearchNotes() != null) {
            builder.note(ref.getResearchNotes());
        } else {
            builder.note(StringUtils.join((Object[])ref.getNotes(), (char)'\n'));
        }
        builder.issue(ref.getNumberOrIssue());
        builder.number(ref.getNumberOrIssue());
        builder.eventPlace(ref.getPlace());
        builder.publisherPlace(ref.getPlace());
        builder.abstrct(ref.getAbstrct());
        builder.callNumber(ref.getCallNumber());
        builder.edition(ref.getEdition());
        builder.ISBN(ref.getIsbnOrIssn());
        builder.ISSN(ref.getIsbnOrIssn());
        builder.keyword(StringUtils.join((Object[])ref.getKeywords(), (char)','));
        builder.language(ref.getLanguage());
        builder.numberOfVolumes(ref.getNumberOfVolumes());
        builder.originalTitle(ref.getOriginalPublication());
        builder.page(ref.getPages());
        builder.publisher(ref.getPublisher());
        builder.reviewedTitle(ref.getReviewedItem());
        builder.section(ref.getSection());
        builder.titleShort(ref.getShortTitle());
        builder.title(ref.getTitle());
        builder.volume(ref.getVolume());
        return builder.build();
    }

    public CSLType toType(EndNoteType type) {
        switch (type) {
            case ARTWORK: {
                return CSLType.ARTICLE;
            }
            case AUDIOVISUAL_MATERIAL: {
                return CSLType.ARTICLE;
            }
            case BILL: {
                return CSLType.BILL;
            }
            case BOOK: {
                return CSLType.BOOK;
            }
            case BOOK_SECTION: {
                return CSLType.CHAPTER;
            }
            case CASE: {
                return CSLType.LEGAL_CASE;
            }
            case CHART_OR_TABLE: {
                return CSLType.ARTICLE;
            }
            case CLASSICAL_WORK: {
                return CSLType.MANUSCRIPT;
            }
            case COMPUTER_PROGRAM: {
                return CSLType.ARTICLE;
            }
            case CONFERENCE_PAPER: {
                return CSLType.PAPER_CONFERENCE;
            }
            case CONFERENCE_PROCEEDINGS: {
                return CSLType.BOOK;
            }
            case EQUATION: {
                return CSLType.ARTICLE;
            }
            case EDITED_BOOK: {
                return CSLType.BOOK;
            }
            case ELECTRONIC_ARTICLE: {
                return CSLType.ARTICLE;
            }
            case ELECTRONIC_BOOK: {
                return CSLType.BOOK;
            }
            case ELECTRONIC_SOURCE: {
                return CSLType.WEBPAGE;
            }
            case FIGURE: {
                return CSLType.FIGURE;
            }
            case FILM_OR_BROADCAST: {
                return CSLType.BROADCAST;
            }
            case GOVERNMENT_DOCUMENT: {
                return CSLType.LEGISLATION;
            }
            case HEARING: {
                return CSLType.ARTICLE;
            }
            case JOURNAL_ARTICLE: {
                return CSLType.ARTICLE_JOURNAL;
            }
            case LEGAL_RULE_REGULATION: {
                return CSLType.LEGISLATION;
            }
            case MAGAZINE_ARTICLE: {
                return CSLType.ARTICLE_MAGAZINE;
            }
            case MANUSCRIPT: {
                return CSLType.MANUSCRIPT;
            }
            case MAP: {
                return CSLType.MAP;
            }
            case NEWSPAPER_ARTICLE: {
                return CSLType.ARTICLE_NEWSPAPER;
            }
            case ONLINE_DATABASE: {
                return CSLType.WEBPAGE;
            }
            case ONLINE_MULTIMEDIA: {
                return CSLType.WEBPAGE;
            }
            case PATENT: {
                return CSLType.PATENT;
            }
            case PERSONAL_COMMUNICATION: {
                return CSLType.PERSONAL_COMMUNICATION;
            }
            case REPORT: {
                return CSLType.REPORT;
            }
            case STATUTE: {
                return CSLType.LEGISLATION;
            }
            case THESIS: {
                return CSLType.THESIS;
            }
        }
        return CSLType.ARTICLE;
    }

    private static CSLName[] toAuthors(String[] authors) {
        ArrayList<CSLName> result = new ArrayList<CSLName>();
        for (String a : authors) {
            CSLName[] names = NameParser.parse(a);
            result.addAll(Arrays.asList(names));
        }
        return result.toArray(new CSLName[0]);
    }
}

