/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.jmh;

import java.io.File;
import javax.inject.Inject;
import me.champeau.jmh.WithJavaToolchain;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;

@CacheableTask
public abstract class JmhBytecodeGeneratorTask
extends DefaultTask
implements WithJavaToolchain {
    @Inject
    public abstract ExecOperations getExecOperations();

    @Input
    public abstract ListProperty<String> getJvmArgs();

    @Input
    public abstract Property<String> getGeneratorType();

    @Classpath
    public abstract ConfigurableFileCollection getJmhClasspath();

    @Classpath
    public abstract ConfigurableFileCollection getRuntimeClasspath();

    @Classpath
    public abstract ConfigurableFileCollection getClassesDirsToProcess();

    @OutputDirectory
    public abstract DirectoryProperty getGeneratedSourcesDir();

    @OutputDirectory
    public abstract DirectoryProperty getGeneratedResourcesDir();

    @TaskAction
    public void generate() {
        JmhBytecodeGeneratorTask.cleanup(((Directory)this.getGeneratedSourcesDir().get()).getAsFile());
        JmhBytecodeGeneratorTask.cleanup(((Directory)this.getGeneratedResourcesDir().get()).getAsFile());
        for (File classesDir : this.getClassesDirsToProcess()) {
            this.getExecOperations().javaexec(spec -> {
                spec.getMainClass().set((Object)"org.openjdk.jmh.generators.bytecode.JmhBytecodeGenerator");
                spec.classpath(new Object[]{this.getJmhClasspath(), this.getRuntimeClasspath(), this.getClassesDirsToProcess()});
                spec.args(new Object[]{classesDir, ((Directory)this.getGeneratedSourcesDir().get()).getAsFile(), ((Directory)this.getGeneratedResourcesDir().get()).getAsFile(), this.getGeneratorType().get()});
                spec.jvmArgs((Iterable)this.getJvmArgs().get());
                Property javaLauncher = this.getJavaLauncher();
                if (javaLauncher.isPresent()) {
                    spec.executable((Object)((JavaLauncher)javaLauncher.get()).getExecutablePath().getAsFile());
                }
            });
        }
    }

    private static void cleanup(File file) {
        if (file.exists()) {
            File[] listing = file.listFiles();
            if (listing != null) {
                for (File sub : listing) {
                    JmhBytecodeGeneratorTask.cleanup(sub);
                }
            }
            file.delete();
        }
    }
}

