/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview.link;

import com.dlsc.gemsfx.treeview.TreeNodeView;
import com.dlsc.gemsfx.treeview.link.AbstractLinkStrategy;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class SineWaveDecayLink<T>
extends AbstractLinkStrategy<T> {
    @Override
    protected ArrayList<Node> drawLink(TreeNodeView.LayoutDirection direction, double maxDimensionInLine, double startX, double startY, double endX, double endY, double vgap, double hgap) {
        Path path = new Path();
        path.getStyleClass().add((Object)"link-path");
        path.getElements().add((Object)new MoveTo(startX, startY));
        switch (direction) {
            case TOP_TO_BOTTOM: 
            case BOTTOM_TO_TOP: {
                double fraction;
                int i;
                for (i = 1; i <= 10; ++i) {
                    fraction = (double)i * 1.0 / 10.0;
                    double x = startX + fraction * (endX - startX);
                    double y = startY + Math.sin(1.5707963267948966 * fraction) * (endY - startY);
                    path.getElements().add((Object)new LineTo(x, y));
                }
                break;
            }
            case LEFT_TO_RIGHT: 
            case RIGHT_TO_LEFT: {
                double fraction;
                int i;
                for (i = 1; i <= 10; ++i) {
                    fraction = (double)i * 1.0 / 10.0;
                    double x = startX + Math.sin(1.5707963267948966 * fraction) * (endX - startX);
                    double y = startY + fraction * (endY - startY);
                    path.getElements().add((Object)new LineTo(x, y));
                }
                break;
            }
        }
        LineTo p2 = (LineTo)path.getElements().get(path.getElements().size() - 1);
        LineTo p1 = (LineTo)path.getElements().get(path.getElements().size() - 2);
        double angle = this.calculateAngle(p1, p2);
        Node arrow = this.createSimpleArrow();
        arrow.setRotate(angle);
        return new ArrayList<Node>(List.of(path, arrow));
    }
}

