/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview.link;

import com.dlsc.gemsfx.treeview.TreeNodeView;
import com.dlsc.gemsfx.treeview.link.AbstractLinkStrategy;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;

public class PolyLineLink<T>
extends AbstractLinkStrategy<T> {
    @Override
    protected ArrayList<Node> drawLink(TreeNodeView.LayoutDirection direction, double maxDimensionInLine, double startX, double startY, double endX, double endY, double vgap, double hgap) {
        Path path = new Path();
        path.getStyleClass().add((Object)"link-path");
        path.getElements().add((Object)new MoveTo(startX, startY));
        Node arrow = this.createSimpleArrow();
        switch (direction) {
            case TOP_TO_BOTTOM: {
                path.getElements().addAll((Object[])new PathElement[]{new LineTo(startX, startY + vgap / 2.0), new LineTo(endX, startY + vgap / 2.0), new LineTo(endX, endY)});
                arrow.setRotate(90.0);
                break;
            }
            case BOTTOM_TO_TOP: {
                path.getElements().addAll((Object[])new PathElement[]{new LineTo(startX, startY - vgap / 2.0), new LineTo(endX, startY - vgap / 2.0), new LineTo(endX, endY)});
                arrow.setRotate(-90.0);
                break;
            }
            case LEFT_TO_RIGHT: {
                path.getElements().addAll((Object[])new PathElement[]{new LineTo(startX + hgap / 2.0, startY), new LineTo(startX + hgap / 2.0, endY), new LineTo(endX, endY)});
                arrow.setRotate(0.0);
                break;
            }
            case RIGHT_TO_LEFT: {
                path.getElements().addAll((Object[])new PathElement[]{new LineTo(startX - hgap / 2.0, startY), new LineTo(startX - hgap / 2.0, endY), new LineTo(endX, endY)});
                arrow.setRotate(180.0);
            }
        }
        path.getStyleClass().addAll((Object[])new String[]{"link-line"});
        return new ArrayList<Node>(List.of(path, arrow));
    }
}

