/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.ChipView;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class ChipViewSkin<T>
extends SkinBase<ChipView<T>> {
    public ChipViewSkin(ChipView<T> chip) {
        super(chip);
        Label label = new Label();
        label.textProperty().bind((ObservableValue)chip.textProperty());
        label.graphicProperty().bind(chip.graphicProperty());
        label.contentDisplayProperty().bind(chip.contentDisplayProperty());
        FontIcon closeIcon = new FontIcon((Ikon)MaterialDesign.MDI_CLOSE);
        StackPane.setAlignment((Node)closeIcon, (Pos)Pos.CENTER);
        StackPane iconWrapper = new StackPane(new Node[]{closeIcon});
        iconWrapper.getStyleClass().add((Object)"close-icon");
        iconWrapper.visibleProperty().bind((ObservableValue)chip.onCloseProperty().isNotNull());
        iconWrapper.managedProperty().bind((ObservableValue)chip.onCloseProperty().isNotNull());
        iconWrapper.setOnMouseClicked(evt -> chip.getOnClose().accept(chip.getValue()));
        HBox box = new HBox(new Node[]{label, iconWrapper});
        box.getStyleClass().add((Object)"chip-container");
        box.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().setAll((Object[])new Node[]{box});
    }
}

