/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.infocenter;

import com.dlsc.gemsfx.infocenter.NotificationAction;
import com.dlsc.gemsfx.infocenter.NotificationGroup;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Callback;

public class Notification<T>
implements Comparable<Notification<T>> {
    private NotificationGroup group;
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private final StringProperty summary = new SimpleStringProperty((Object)this, "description");
    private final ObjectProperty<ZonedDateTime> dateTime = new SimpleObjectProperty((Object)this, "dateTime", (Object)ZonedDateTime.now());
    private final ObservableList<NotificationAction> actions = FXCollections.observableArrayList();
    private final ObjectProperty<T> userObject = new SimpleObjectProperty((Object)this, "userObject");
    private final BooleanProperty expanded = new SimpleBooleanProperty((Object)this, "expanded", false);
    public final ObjectProperty<Callback<Notification<T>, OnClickBehaviour>> onClick = new SimpleObjectProperty((Object)this, "onClick", notification -> OnClickBehaviour.HIDE_AND_REMOVE);

    public Notification(String title, String summary, ZonedDateTime dateTime) {
        this.setTitle(Objects.requireNonNull(title));
        this.setSummary(Objects.requireNonNull(summary));
        this.setDateTime(Objects.requireNonNull(dateTime));
    }

    public Notification(String title, String summary) {
        this(title, summary, ZonedDateTime.now());
    }

    void setGroup(NotificationGroup group) {
        this.group = group;
    }

    public final NotificationGroup getGroup() {
        return this.group;
    }

    public final void remove() {
        this.getGroup().getNotifications().remove((Object)this);
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final String getSummary() {
        return (String)this.summary.get();
    }

    public final StringProperty summaryProperty() {
        return this.summary;
    }

    public final void setSummary(String summary) {
        this.summary.set((Object)summary);
    }

    public final ZonedDateTime getDateTime() {
        return (ZonedDateTime)this.dateTime.get();
    }

    public final ObjectProperty<ZonedDateTime> dateTimeProperty() {
        return this.dateTime;
    }

    public final void setDateTime(ZonedDateTime dateTime) {
        this.dateTime.set((Object)dateTime);
    }

    public final ObservableList<NotificationAction> getActions() {
        return this.actions;
    }

    public final T getUserObject() {
        return (T)this.userObject.get();
    }

    public final ObjectProperty<T> userObjectProperty() {
        return this.userObject;
    }

    public final void setUserObject(T userObject) {
        this.userObject.set(userObject);
    }

    public final boolean isExpanded() {
        return this.expanded.get();
    }

    public final BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public final void setExpanded(boolean expanded) {
        this.expanded.set(expanded);
    }

    public final Callback<Notification<T>, OnClickBehaviour> getOnClick() {
        return (Callback)this.onClick.get();
    }

    public final ObjectProperty<Callback<Notification<T>, OnClickBehaviour>> onClickProperty() {
        return this.onClick;
    }

    public final void setOnClick(Callback<Notification<T>, OnClickBehaviour> onClick) {
        this.onClick.set(onClick);
    }

    public String toString() {
        return new StringJoiner(", ", Notification.class.getSimpleName() + "[", "]").add("title=" + this.getTitle()).add("description=" + this.getSummary()).add("expanded=" + this.isExpanded()).toString();
    }

    @Override
    public int compareTo(Notification<T> o) {
        return this.getDateTime().compareTo(o.getDateTime());
    }

    public static enum OnClickBehaviour {
        NONE,
        REMOVE,
        HIDE,
        HIDE_AND_REMOVE;

    }
}

