/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.EnhancedPasswordFieldSkin;
import com.dlsc.gemsfx.util.EchoCharConverter;
import com.dlsc.gemsfx.util.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class EnhancedPasswordField
extends PasswordField {
    public static final char DEFAULT_ECHO_CHAR = '\u25cf';
    private static final String DEFAULT_STYLE_CLASS = "enhanced-password-field";
    private static final boolean DEFAULT_SHOW_PASSWORD = false;
    private static final PseudoClass SHOWING_PASSWORD_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"showing-password");
    private final Logger LOG = Logger.getLogger(EnhancedPasswordField.class.getName());
    private final ObjectProperty<Node> left = new SimpleObjectProperty((Object)this, "left");
    private final ObjectProperty<Node> right = new SimpleObjectProperty((Object)this, "right");
    private BooleanProperty showPassword;
    private ObjectProperty<Character> echoCharProperty;

    public EnhancedPasswordField() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.showPasswordProperty().subscribe(showing -> this.pseudoClassStateChanged(SHOWING_PASSWORD_PSEUDO_CLASS, (boolean)showing));
        Region rightIcon = new Region();
        rightIcon.getStyleClass().add((Object)"right-icon");
        StackPane rightWrapper = new StackPane(new Node[]{rightIcon});
        rightWrapper.getStyleClass().add((Object)"right-icon-wrapper");
        rightWrapper.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (UIUtil.isClickOnNode(event)) {
                this.setShowPassword(!this.isShowPassword());
                event.consume();
            }
        });
        this.setRight((Node)rightWrapper);
    }

    public EnhancedPasswordField(String text) {
        this();
        this.setText(text);
    }

    protected Skin<?> createDefaultSkin() {
        return new EnhancedPasswordFieldSkin(this){

            public ObjectProperty<Node> leftProperty() {
                return EnhancedPasswordField.this.leftProperty();
            }

            public ObjectProperty<Node> rightProperty() {
                return EnhancedPasswordField.this.rightProperty();
            }
        };
    }

    public final ObjectProperty<Node> leftProperty() {
        return this.left;
    }

    public final Node getLeft() {
        return (Node)this.left.get();
    }

    public final void setLeft(Node left) {
        this.leftProperty().set((Object)left);
    }

    public final ObjectProperty<Node> rightProperty() {
        return this.right;
    }

    public final Node getRight() {
        return (Node)this.right.get();
    }

    public final void setRight(Node right) {
        this.rightProperty().set((Object)right);
    }

    public final BooleanProperty showPasswordProperty() {
        if (this.showPassword == null) {
            this.showPassword = new SimpleBooleanProperty((Object)this, "showPassword", false);
        }
        return this.showPassword;
    }

    public final boolean isShowPassword() {
        return this.showPassword == null ? false : this.showPassword.get();
    }

    public final void setShowPassword(boolean showPassword) {
        this.showPasswordProperty().set(showPassword);
    }

    public final ObjectProperty<Character> echoCharProperty() {
        if (this.echoCharProperty == null) {
            this.echoCharProperty = new StyleableObjectProperty<Character>(Character.valueOf('\u25cf')){

                public Object getBean() {
                    return EnhancedPasswordField.this;
                }

                public String getName() {
                    return "echoChar";
                }

                public CssMetaData<? extends Styleable, Character> getCssMetaData() {
                    return StyleableProperties.ECHO_CHAR;
                }
            };
        }
        return this.echoCharProperty;
    }

    public final Character getEchoChar() {
        return Character.valueOf(this.echoCharProperty == null ? (char)'\u25cf' : ((Character)this.echoCharProperty.get()).charValue());
    }

    public final Character getEchoCharSafe() {
        if (this.echoCharProperty == null) {
            return Character.valueOf('\u25cf');
        }
        try {
            Character c = (Character)this.echoCharProperty.get();
            return Character.valueOf(c == null ? (char)'\u25cf' : (char)c.charValue());
        }
        catch (Exception e) {
            String logMessage = String.format("Caught '%s' while converting value for '-fx-echo-char' style on %s[styleClass=%s]", e, ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).getClass().getName());
            this.LOG.log(Level.WARNING, logMessage);
            return Character.valueOf('\u25cf');
        }
    }

    public final void setEchoChar(Character echoChar) {
        this.echoCharProperty().set((Object)echoChar);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return EnhancedPasswordField.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(EnhancedPasswordField.class.getResource("enhanced-password-field.css")).toExternalForm();
    }

    private static class StyleableProperties {
        private static final CssMetaData<EnhancedPasswordField, Character> ECHO_CHAR = new CssMetaData<EnhancedPasswordField, Character>("-fx-echo-char", (StyleConverter)EchoCharConverter.getInstance(), Character.valueOf('\u25cf')){

            public boolean isSettable(EnhancedPasswordField control) {
                return control.echoCharProperty == null || !control.echoCharProperty.isBound();
            }

            public StyleableProperty<Character> getStyleableProperty(EnhancedPasswordField control) {
                return (StyleableProperty)control.echoCharProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<EnhancedPasswordField, Character>> styleables = new ArrayList<CssMetaData<EnhancedPasswordField, Character>>(PasswordField.getClassCssMetaData());
            styleables.add(ECHO_CHAR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

