/*
 * Decompiled with CFR 0.152.
 */
package pt.davidafsilva.apple;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pt.davidafsilva.apple.OSXKeychainException;
import pt.davidafsilva.apple.OSXKeychainProtocolType;

public class OSXKeychain {
    private static OSXKeychain instance;
    private static final Map<Integer, OSXKeychainProtocolType> PROTOCOLS;

    private OSXKeychain() {
    }

    public static OSXKeychain getInstance() throws OSXKeychainException {
        if (instance == null) {
            try {
                OSXKeychain.loadSharedObject();
            }
            catch (IOException e) {
                throw new OSXKeychainException("Failed to load osxkeychain.so", e);
            }
            instance = new OSXKeychain();
        }
        return instance;
    }

    public void addGenericPassword(String serviceName, String accountName, String password) throws OSXKeychainException {
        this._addGenericPassword(serviceName, accountName, password);
    }

    public void modifyGenericPassword(String serviceName, String accountName, String password) throws OSXKeychainException {
        this._modifyGenericPassword(serviceName, accountName, password);
    }

    public Optional<String> findGenericPassword(String serviceName, String accountName) throws OSXKeychainException {
        return Optional.ofNullable(this._findGenericPassword(serviceName, accountName));
    }

    public void deleteGenericPassword(String serviceName, String accountName) throws OSXKeychainException {
        this._deleteGenericPassword(serviceName, accountName);
    }

    private native void _addGenericPassword(String var1, String var2, String var3) throws OSXKeychainException;

    private native void _modifyGenericPassword(String var1, String var2, String var3) throws OSXKeychainException;

    private native String _findGenericPassword(String var1, String var2) throws OSXKeychainException;

    private native void _deleteGenericPassword(String var1, String var2) throws OSXKeychainException;

    private static void loadSharedObject() throws IOException {
        File tmpFile = File.createTempFile("osxkeychain", ".so");
        try (InputStream soInJarStream = OSXKeychain.class.getResourceAsStream("/osxkeychain.so");
             FileOutputStream soInTmpStream = new FileOutputStream(tmpFile);){
            int bytesRead;
            File soInTmp = File.createTempFile("osxkeychain", ".so");
            soInTmp.deleteOnExit();
            byte[] buffer = new byte[4096];
            while ((bytesRead = soInJarStream.read(buffer)) > 0) {
                ((OutputStream)soInTmpStream).write(buffer, 0, bytesRead);
            }
        }
        System.load(tmpFile.getAbsolutePath());
    }

    static {
        PROTOCOLS = new HashMap<Integer, OSXKeychainProtocolType>(32);
        PROTOCOLS.put(548, OSXKeychainProtocolType.AFP);
        PROTOCOLS.put(3020, OSXKeychainProtocolType.CIFS);
        PROTOCOLS.put(2401, OSXKeychainProtocolType.CVSpserver);
        PROTOCOLS.put(3689, OSXKeychainProtocolType.DAAP);
        PROTOCOLS.put(3031, OSXKeychainProtocolType.EPPC);
        PROTOCOLS.put(21, OSXKeychainProtocolType.FTP);
        PROTOCOLS.put(990, OSXKeychainProtocolType.FTPS);
        PROTOCOLS.put(80, OSXKeychainProtocolType.HTTP);
        PROTOCOLS.put(443, OSXKeychainProtocolType.HTTPS);
        PROTOCOLS.put(143, OSXKeychainProtocolType.IMAP);
        PROTOCOLS.put(993, OSXKeychainProtocolType.IMAPS);
        PROTOCOLS.put(631, OSXKeychainProtocolType.IPP);
        PROTOCOLS.put(6667, OSXKeychainProtocolType.IRC);
        PROTOCOLS.put(994, OSXKeychainProtocolType.IRCS);
        PROTOCOLS.put(389, OSXKeychainProtocolType.LDAP);
        PROTOCOLS.put(636, OSXKeychainProtocolType.LDAPS);
        PROTOCOLS.put(119, OSXKeychainProtocolType.NNTP);
        PROTOCOLS.put(563, OSXKeychainProtocolType.NNTPS);
        PROTOCOLS.put(110, OSXKeychainProtocolType.POP3);
        PROTOCOLS.put(995, OSXKeychainProtocolType.POP3S);
        PROTOCOLS.put(554, OSXKeychainProtocolType.RTSP);
        PROTOCOLS.put(25, OSXKeychainProtocolType.SMTP);
        PROTOCOLS.put(1080, OSXKeychainProtocolType.SOCKS);
        PROTOCOLS.put(22, OSXKeychainProtocolType.SSH);
        PROTOCOLS.put(3690, OSXKeychainProtocolType.SVN);
        PROTOCOLS.put(23, OSXKeychainProtocolType.Telnet);
        PROTOCOLS.put(992, OSXKeychainProtocolType.TelnetS);
    }
}

