/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.afterburner.views;

import com.airhacks.afterburner.injection.PresenterFactory;
import com.airhacks.afterburner.views.ResourceLocator;
import com.airhacks.afterburner.views.ViewLoaderResult;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewLoader.class);
    private static final String DEFAULT_ENDING = "View";
    private static final String CSS_FILE_ENDING = ".css";
    private static final String BSS_FILE_ENDING = ".bss";
    protected FXMLLoader fxmlLoader;
    protected String bundleName;
    protected URL resource;
    protected static Executor FX_PLATFORM_EXECUTOR = Platform::runLater;
    protected static final ExecutorService PARENT_CREATION_POOL = ViewLoader.getExecutorService();
    protected final Class<?> clazz;

    private ViewLoader(Class<?> clazz) {
        this.clazz = clazz;
        this.resource = this.clazz.getResource(this.getFXMLName());
        this.bundleName = this.getBundleName();
        this.fxmlLoader = new FXMLLoader(this.resource);
        this.updateControllerFactory(f -> null);
    }

    public static ViewLoader view(Class<? extends Object> clazz) {
        return new ViewLoader(clazz);
    }

    public static ViewLoader view(Object root) {
        return ViewLoader.view(root.getClass()).controller(root);
    }

    private static String stripEnding(String clazz) {
        if (!clazz.endsWith(DEFAULT_ENDING)) {
            return clazz;
        }
        int viewIndex = clazz.lastIndexOf(DEFAULT_ENDING);
        return clazz.substring(0, viewIndex);
    }

    private static ExecutorService getExecutorService() {
        return Executors.newCachedThreadPool(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            String name = thread.getName();
            thread.setName("afterburner.fx-" + name);
            thread.setDaemon(true);
            return thread;
        });
    }

    public ViewLoader controller(Object root) {
        PresenterFactory factory = PresenterFactory.discover();
        this.fxmlLoader.setControllerFactory(type -> {
            if (type == root.getClass()) {
                factory.injectMembers(root, f -> null);
                return root;
            }
            try {
                return factory.instantiatePresenter(type, f -> null);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return this;
    }

    public ViewLoader inject(Function<String, Object> injectionContext) {
        this.updateControllerFactory(injectionContext);
        return this;
    }

    public ViewLoader root(Object root) {
        this.fxmlLoader.setRoot(root);
        return this;
    }

    private void updateControllerFactory(Function<String, Object> injectionContext) {
        PresenterFactory factory = PresenterFactory.discover();
        Callback controllerFactory = p -> factory.instantiatePresenter(p, injectionContext);
        this.fxmlLoader.setControllerFactory(controllerFactory);
    }

    public ViewLoaderResult load() throws IllegalStateException {
        ResourceLocator resourceLocator = ResourceLocator.discover();
        ResourceBundle bundle = resourceLocator.getResourceBundle(this.bundleName);
        this.fxmlLoader.setResources(bundle);
        try {
            this.fxmlLoader.load();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot load " + this.bundleName, ex);
        }
        Parent parent = (Parent)this.fxmlLoader.getRoot();
        this.addCSSIfAvailable(parent);
        return new ViewLoaderResult(parent, this.fxmlLoader.getController(), bundle);
    }

    public void load(Consumer<Parent> consumer) {
        ((CompletableFuture)CompletableFuture.completedFuture(this.load().getView()).thenAcceptAsync((Consumer)consumer, FX_PLATFORM_EXECUTOR)).exceptionally(this::exceptionReporter);
    }

    public void loadAsync(Consumer<Parent> consumer) {
        Supplier<Parent> supplier = () -> this.load().getView();
        ((CompletableFuture)CompletableFuture.supplyAsync(supplier, PARENT_CREATION_POOL).thenAcceptAsync((Consumer)consumer, FX_PLATFORM_EXECUTOR)).exceptionally(this::exceptionReporter);
    }

    private void addCSSIfAvailable(Parent parent) {
        URL uri = this.clazz.getResource(this.getBinaryStyleSheetName());
        if (uri == null) {
            uri = this.clazz.getResource(this.getStyleSheetName());
        }
        if (uri == null) {
            return;
        }
        String uriToCss = uri.toExternalForm();
        if (!parent.getStylesheets().contains((Object)uriToCss)) {
            parent.getStylesheets().add((Object)uriToCss);
        }
    }

    private String getStyleSheetName() {
        return this.getResourceCamelOrLowerCase(false, CSS_FILE_ENDING);
    }

    protected String getConventionalName(boolean lowercase, String ending) {
        return this.getConventionalName(lowercase) + ending;
    }

    private String getBinaryStyleSheetName() {
        return this.getResourceCamelOrLowerCase(false, BSS_FILE_ENDING);
    }

    private String getFXMLName() {
        return this.getResourceCamelOrLowerCase(true, ".fxml");
    }

    private String getResourceCamelOrLowerCase(boolean mandatory, String ending) {
        String name = this.getConventionalName(true, ending);
        URL found = this.clazz.getResource(name);
        if (found != null) {
            return name;
        }
        LOGGER.debug("File: " + name + " not found, attempting with camel case");
        name = this.getConventionalName(false, ending);
        found = this.clazz.getResource(name);
        if (mandatory && found == null) {
            String message = "Cannot load file " + name;
            LOGGER.error(message);
            LOGGER.error("Stopping initialization phase...");
            throw new IllegalStateException(message);
        }
        return name;
    }

    protected String getConventionalName(boolean lowercase) {
        String clazzWithEnding = this.clazz.getSimpleName();
        String clazz = ViewLoader.stripEnding(clazzWithEnding);
        if (lowercase) {
            clazz = clazz.toLowerCase();
        }
        return clazz;
    }

    private String getBundleName() {
        String conventionalName = this.getConventionalName(true);
        return this.clazz.getPackage().getName() + "." + conventionalName;
    }

    public Void exceptionReporter(Throwable t) {
        LOGGER.error("Exception thrown in afterburner.fx", t);
        return null;
    }
}

