/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/event.h>
        #include <wx/event.h>
        #include <wx/eventfilter.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        
        class wxPyCallback : public wxEvtHandler {
            DECLARE_ABSTRACT_CLASS(wxPyCallback)
        public:
            wxPyCallback(PyObject* func);
            wxPyCallback(const wxPyCallback& other);
            ~wxPyCallback();
        
            void EventThunker(wxEvent& event);
        
            PyObject*   m_func;
        };
        
        IMPLEMENT_ABSTRACT_CLASS(wxPyCallback, wxEvtHandler);
        
        wxPyCallback::wxPyCallback(PyObject* func) {
            m_func = func;
            wxPyBLOCK_THREADS( Py_INCREF(m_func) );
        }
        
        wxPyCallback::wxPyCallback(const wxPyCallback& other) {
            m_func = other.m_func;
            wxPyBLOCK_THREADS( Py_INCREF(m_func) );
        }
        
        wxPyCallback::~wxPyCallback() {
            wxPyBLOCK_THREADS( Py_DECREF(m_func) );
        }
        
        
        // #define wxPy_PRECALLINIT     "_preCallInit"
        // #define wxPy_POSTCALLCLEANUP "_postCallCleanup"
        
        // This function is used for all events destined for Python event handlers.
        void wxPyCallback::EventThunker(wxEvent& event) {
            wxPyCallback*   cb = (wxPyCallback*)event.m_callbackUserData;
            PyObject*       func = cb->m_func;
            PyObject*       result;
            PyObject*       arg;
            PyObject*       tuple;
            bool            checkSkip = false;
        
            wxPyThreadBlocker blocker;
            wxString className = event.GetClassInfo()->GetClassName();
            arg = wxPyConstructObject((void*)&event, className);
        
            if (!arg) {
                PyErr_Print();
            } else {
                // Call the event handler, passing the event object
                tuple = PyTuple_New(1);
                PyTuple_SET_ITEM(tuple, 0, arg);  // steals ref to arg
                result = PyObject_CallObject(func, tuple);
                if ( result ) {
                    Py_DECREF(result);   // result is ignored, but we still need to decref it
                    PyErr_Clear();       // Just in case...
                } else {
                    PyErr_Print();
                }
                Py_DECREF(tuple);
            }
        }
    void _wxEvtHandler_Connect(wxEvtHandler* self, int id, int lastId, wxEventType eventType, PyObject* func)
    {
        if (PyCallable_Check(func)) {
            self->Connect(id, lastId, eventType,
                          (wxObjectEventFunction)&wxPyCallback::EventThunker,
                          new wxPyCallback(func));
        }
        else if (func == Py_None) {
            self->Disconnect(id, lastId, eventType,
                             (wxObjectEventFunction)(wxEventFunction)
                             &wxPyCallback::EventThunker);
        }
        else {
            PyErr_SetString(PyExc_TypeError, "Expected callable object or None.");
        }
    }
    bool _wxEvtHandler_Disconnect(wxEvtHandler* self, int id, int lastId, wxEventType eventType, PyObject* func)
    {
        if (func && func != Py_None) {
            // Find the current matching binder that has this function
            // pointer and disconnect that one.  Unfortunately since we
            // wrapped the PyObject function pointer in another object we
            // have to do the searching ourselves...
            size_t cookie;
            wxDynamicEventTableEntry *entry = self->GetFirstDynamicEntry(cookie);
            while (entry)
            {
                if ((entry->m_id == id) &&
                    ((entry->m_lastId == lastId) || (lastId == wxID_ANY)) &&
                    ((entry->m_eventType == eventType) || (eventType == wxEVT_NULL)) &&
                    entry->m_fn->IsMatching(wxObjectEventFunctor((wxObjectEventFunction)&wxPyCallback::EventThunker, NULL)) &&
                    (entry->m_callbackUserData != NULL))
                {
                    wxPyThreadBlocker block;
                    wxPyCallback *cb = (wxPyCallback*)entry->m_callbackUserData;
                    // NOTE: Just comparing PyObject pointers is not enough, as bound
                    // methods can result in different PyObjects each time obj.Method
                    // is evaluated. (!!!)
                    if (PyObject_RichCompareBool(cb->m_func, func, Py_EQ) == 1) {
                        delete cb;
                        // Set callback data to a known value instead of NULL to
                        // ensure Disconnect() removes the correct handler.
                        entry->m_callbackUserData = new wxObject();
                        // Now Disconnect should work
                        return self->Disconnect(id, lastId, eventType,
                                                (wxObjectEventFunction)&wxPyCallback::EventThunker,
                                                entry->m_callbackUserData);
                    }
                }
                entry = self->GetNextDynamicEntry(cookie);
            }
            return false;
        }
        else {
            return self->Disconnect(id, lastId, eventType,
                                    (wxObjectEventFunction)&wxPyCallback::EventThunker);
        }
    }


class sipwxEvtHandler : public ::wxEvtHandler
{
public:
    sipwxEvtHandler();
    virtual ~sipwxEvtHandler();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    bool sipProtectVirt_TryBefore(bool, ::wxEvent&);
    bool sipProtectVirt_TryAfter(bool, ::wxEvent&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool TryAfter(::wxEvent&) SIP_OVERRIDE;
    bool TryBefore(::wxEvent&) SIP_OVERRIDE;
    bool ProcessEvent(::wxEvent&) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxEvtHandler(const sipwxEvtHandler &);
    sipwxEvtHandler &operator = (const sipwxEvtHandler &);

    char sipPyMethods[3];
};

sipwxEvtHandler::sipwxEvtHandler(): ::wxEvtHandler(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxEvtHandler::~sipwxEvtHandler()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxEvtHandler::TryAfter(::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_TryAfter);

    if (!sipMeth)
        return ::wxEvtHandler::TryAfter(event);

    extern bool sipVH__core_102(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxEvent&);

    return sipVH__core_102(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxEvtHandler::TryBefore(::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_TryBefore);

    if (!sipMeth)
        return ::wxEvtHandler::TryBefore(event);

    extern bool sipVH__core_102(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxEvent&);

    return sipVH__core_102(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxEvtHandler::ProcessEvent(::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_ProcessEvent);

    if (!sipMeth)
        return ::wxEvtHandler::ProcessEvent(event);

    extern bool sipVH__core_102(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxEvent&);

    return sipVH__core_102(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxEvtHandler::sipProtectVirt_TryBefore(bool sipSelfWasArg, ::wxEvent& event)
{
    return (sipSelfWasArg ? ::wxEvtHandler::TryBefore(event) : TryBefore(event));
}

bool sipwxEvtHandler::sipProtectVirt_TryAfter(bool sipSelfWasArg, ::wxEvent& event)
{
    return (sipSelfWasArg ? ::wxEvtHandler::TryAfter(event) : TryAfter(event));
}


PyDoc_STRVAR(doc_wxEvtHandler_QueueEvent, "QueueEvent(event) -> None\n"
"\n"
"Queue event for a later processing.");

extern "C" {static PyObject *meth_wxEvtHandler_QueueEvent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_QueueEvent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEvent* event;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxEvtHandler, &sipCpp, sipType_wxEvent, &event))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->QueueEvent(event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_QueueEvent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_AddPendingEvent, "AddPendingEvent(event) -> None\n"
"\n"
"Post an event to be processed later.");

extern "C" {static PyObject *meth_wxEvtHandler_AddPendingEvent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_AddPendingEvent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxEvent* event;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxEvtHandler, &sipCpp, sipType_wxEvent, &event))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddPendingEvent(*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_AddPendingEvent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_ProcessEvent, "ProcessEvent(event) -> bool\n"
"\n"
"Processes an event, searching event tables and calling zero or more\n"
"suitable event handler function(s).");

extern "C" {static PyObject *meth_wxEvtHandler_ProcessEvent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_ProcessEvent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxEvent* event;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxEvtHandler, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxEvtHandler::ProcessEvent(*event) : sipCpp->ProcessEvent(*event));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_ProcessEvent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_ProcessEventLocally, "ProcessEventLocally(event) -> bool\n"
"\n"
"Try to process the event in this handler and all those chained to it.");

extern "C" {static PyObject *meth_wxEvtHandler_ProcessEventLocally(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_ProcessEventLocally(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEvent* event;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxEvtHandler, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ProcessEventLocally(*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_ProcessEventLocally, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_SafelyProcessEvent, "SafelyProcessEvent(event) -> bool\n"
"\n"
"Processes an event by calling ProcessEvent() and handles any\n"
"exceptions that occur in the process.");

extern "C" {static PyObject *meth_wxEvtHandler_SafelyProcessEvent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_SafelyProcessEvent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEvent* event;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxEvtHandler, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SafelyProcessEvent(*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_SafelyProcessEvent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_ProcessPendingEvents, "ProcessPendingEvents() -> None\n"
"\n"
"Processes the pending events previously queued using QueueEvent() or\n"
"AddPendingEvent(); you must call this function only if you are sure\n"
"there are pending events for this handler, otherwise a wxCHECK will\n"
"fail.");

extern "C" {static PyObject *meth_wxEvtHandler_ProcessPendingEvents(PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_ProcessPendingEvents(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEvtHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvtHandler, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ProcessPendingEvents();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_ProcessPendingEvents, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_DeletePendingEvents, "DeletePendingEvents() -> None\n"
"\n"
"Deletes all events queued on this event handler using QueueEvent() or\n"
"AddPendingEvent().");

extern "C" {static PyObject *meth_wxEvtHandler_DeletePendingEvents(PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_DeletePendingEvents(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEvtHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvtHandler, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DeletePendingEvents();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_DeletePendingEvents, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_Connect, "Connect(id, lastId, eventType, func) -> None\n"
"\n"
"Make an entry in the dynamic event table for an event binding.");

extern "C" {static PyObject *meth_wxEvtHandler_Connect(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_Connect(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        int lastId;
        ::wxEventType eventType;
        PyObject * func;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_lastId,
            sipName_eventType,
            sipName_func,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiiiP0", &sipSelf, sipType_wxEvtHandler, &sipCpp, &id, &lastId, &eventType, &func))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxEvtHandler_Connect(sipCpp, id, lastId, eventType, func);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_Connect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_Disconnect, "Disconnect(id, lastId=-1, eventType=wxEVT_NULL, func=None) -> bool\n"
"\n"
"Remove an event binding by removing its entry in the dynamic event\n"
"table.");

extern "C" {static PyObject *meth_wxEvtHandler_Disconnect(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_Disconnect(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        int lastId = -1;
        ::wxEventType eventType = wxEVT_NULL;
        PyObject * func = 0;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_lastId,
            sipName_eventType,
            sipName_func,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|iiP0", &sipSelf, sipType_wxEvtHandler, &sipCpp, &id, &lastId, &eventType, &func))
        {
            bool sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxEvtHandler_Disconnect(sipCpp, id, lastId, eventType, func);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_Disconnect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_GetEvtHandlerEnabled, "GetEvtHandlerEnabled() -> bool\n"
"\n"
"Returns true if the event handler is enabled, false otherwise.");

extern "C" {static PyObject *meth_wxEvtHandler_GetEvtHandlerEnabled(PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_GetEvtHandlerEnabled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxEvtHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvtHandler, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEvtHandlerEnabled();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_GetEvtHandlerEnabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_GetNextHandler, "GetNextHandler() -> EvtHandler\n"
"\n"
"Returns the pointer to the next handler in the chain.");

extern "C" {static PyObject *meth_wxEvtHandler_GetNextHandler(PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_GetNextHandler(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxEvtHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvtHandler, &sipCpp))
        {
            ::wxEvtHandler*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNextHandler();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxEvtHandler, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_GetNextHandler, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_GetPreviousHandler, "GetPreviousHandler() -> EvtHandler\n"
"\n"
"Returns the pointer to the previous handler in the chain.");

extern "C" {static PyObject *meth_wxEvtHandler_GetPreviousHandler(PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_GetPreviousHandler(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxEvtHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvtHandler, &sipCpp))
        {
            ::wxEvtHandler*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPreviousHandler();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxEvtHandler, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_GetPreviousHandler, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_SetEvtHandlerEnabled, "SetEvtHandlerEnabled(enabled) -> None\n"
"\n"
"Enables or disables the event handler.");

extern "C" {static PyObject *meth_wxEvtHandler_SetEvtHandlerEnabled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_SetEvtHandlerEnabled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool enabled;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enabled,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxEvtHandler, &sipCpp, &enabled))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEvtHandlerEnabled(enabled);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_SetEvtHandlerEnabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_SetNextHandler, "SetNextHandler(handler) -> None\n"
"\n"
"Sets the pointer to the next handler.");

extern "C" {static PyObject *meth_wxEvtHandler_SetNextHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_SetNextHandler(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEvtHandler* handler;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxEvtHandler, &sipCpp, sipType_wxEvtHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNextHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_SetNextHandler, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_SetPreviousHandler, "SetPreviousHandler(handler) -> None\n"
"\n"
"Sets the pointer to the previous handler.");

extern "C" {static PyObject *meth_wxEvtHandler_SetPreviousHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_SetPreviousHandler(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEvtHandler* handler;
        ::wxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxEvtHandler, &sipCpp, sipType_wxEvtHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPreviousHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_SetPreviousHandler, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_Unlink, "Unlink() -> None\n"
"\n"
"Unlinks this event handler from the chain it's part of (if any); then links the \"previous\" event handler to the \"next\" one (so that the chain won't be interrupted).");

extern "C" {static PyObject *meth_wxEvtHandler_Unlink(PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_Unlink(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEvtHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvtHandler, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Unlink();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_Unlink, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_IsUnlinked, "IsUnlinked() -> bool\n"
"\n"
"Returns true if the next and the previous handler pointers of this\n"
"event handler instance are NULL.");

extern "C" {static PyObject *meth_wxEvtHandler_IsUnlinked(PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_IsUnlinked(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxEvtHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvtHandler, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsUnlinked();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_IsUnlinked, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_AddFilter, "AddFilter(filter) -> None\n"
"\n"
"Add an event filter whose FilterEvent() method will be called for each\n"
"and every event processed by wxWidgets.");

extern "C" {static PyObject *meth_wxEvtHandler_AddFilter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_AddFilter(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEventFilter* filter;

        static const char *sipKwdList[] = {
            sipName_filter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8", sipType_wxEventFilter, &filter))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxEvtHandler::AddFilter(filter);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_AddFilter, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_RemoveFilter, "RemoveFilter(filter) -> None\n"
"\n"
"Remove a filter previously installed with AddFilter().");

extern "C" {static PyObject *meth_wxEvtHandler_RemoveFilter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_RemoveFilter(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEventFilter* filter;

        static const char *sipKwdList[] = {
            sipName_filter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8", sipType_wxEventFilter, &filter))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxEvtHandler::RemoveFilter(filter);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_RemoveFilter, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_TryBefore, "TryBefore(event) -> bool\n"
"\n"
"Method called by ProcessEvent() before examining this object event\n"
"tables.");

extern "C" {static PyObject *meth_wxEvtHandler_TryBefore(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_TryBefore(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxEvent* event;
        sipwxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxEvtHandler, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_TryBefore(sipSelfWasArg, *event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_TryBefore, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvtHandler_TryAfter, "TryAfter(event) -> bool\n"
"\n"
"Method called by ProcessEvent() as last resort.");

extern "C" {static PyObject *meth_wxEvtHandler_TryAfter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvtHandler_TryAfter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxEvent* event;
        sipwxEvtHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxEvtHandler, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_TryAfter(sipSelfWasArg, *event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_EvtHandler, sipName_TryAfter, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxEvtHandler(void *, const sipTypeDef *);}
static void *cast_wxEvtHandler(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxEvtHandler *sipCpp = reinterpret_cast< ::wxEvtHandler *>(sipCppV);

    if (targetType == sipType_wxEvtHandler)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    if (targetType == sipType_wxTrackable)
        return static_cast< ::wxTrackable *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxEvtHandler(void *, int);}
static void release_wxEvtHandler(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxEvtHandler *>(sipCppV);
    else
        delete reinterpret_cast< ::wxEvtHandler *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxEvtHandler(Py_ssize_t);}
static void *array_wxEvtHandler(Py_ssize_t sipNrElem)
{
    return new ::wxEvtHandler[sipNrElem];
}


extern "C" {static void array_delete_wxEvtHandler(void *);}
static void array_delete_wxEvtHandler(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxEvtHandler *>(sipCpp);
}


extern "C" {static void dealloc_wxEvtHandler(sipSimpleWrapper *);}
static void dealloc_wxEvtHandler(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxEvtHandler *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxEvtHandler(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxEvtHandler(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxEvtHandler(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxEvtHandler *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxEvtHandler();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxEvtHandler[] = {{392, 255, 0}, {599, 255, 1}};


static PyMethodDef methods_wxEvtHandler[] = {
    {sipName_AddFilter, SIP_MLMETH_CAST(meth_wxEvtHandler_AddFilter), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_AddFilter},
    {sipName_AddPendingEvent, SIP_MLMETH_CAST(meth_wxEvtHandler_AddPendingEvent), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_AddPendingEvent},
    {sipName_Connect, SIP_MLMETH_CAST(meth_wxEvtHandler_Connect), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_Connect},
    {sipName_DeletePendingEvents, meth_wxEvtHandler_DeletePendingEvents, METH_VARARGS, doc_wxEvtHandler_DeletePendingEvents},
    {sipName_Disconnect, SIP_MLMETH_CAST(meth_wxEvtHandler_Disconnect), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_Disconnect},
    {sipName_GetEvtHandlerEnabled, meth_wxEvtHandler_GetEvtHandlerEnabled, METH_VARARGS, doc_wxEvtHandler_GetEvtHandlerEnabled},
    {sipName_GetNextHandler, meth_wxEvtHandler_GetNextHandler, METH_VARARGS, doc_wxEvtHandler_GetNextHandler},
    {sipName_GetPreviousHandler, meth_wxEvtHandler_GetPreviousHandler, METH_VARARGS, doc_wxEvtHandler_GetPreviousHandler},
    {sipName_IsUnlinked, meth_wxEvtHandler_IsUnlinked, METH_VARARGS, doc_wxEvtHandler_IsUnlinked},
    {sipName_ProcessEvent, SIP_MLMETH_CAST(meth_wxEvtHandler_ProcessEvent), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_ProcessEvent},
    {sipName_ProcessEventLocally, SIP_MLMETH_CAST(meth_wxEvtHandler_ProcessEventLocally), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_ProcessEventLocally},
    {sipName_ProcessPendingEvents, meth_wxEvtHandler_ProcessPendingEvents, METH_VARARGS, doc_wxEvtHandler_ProcessPendingEvents},
    {sipName_QueueEvent, SIP_MLMETH_CAST(meth_wxEvtHandler_QueueEvent), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_QueueEvent},
    {sipName_RemoveFilter, SIP_MLMETH_CAST(meth_wxEvtHandler_RemoveFilter), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_RemoveFilter},
    {sipName_SafelyProcessEvent, SIP_MLMETH_CAST(meth_wxEvtHandler_SafelyProcessEvent), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_SafelyProcessEvent},
    {sipName_SetEvtHandlerEnabled, SIP_MLMETH_CAST(meth_wxEvtHandler_SetEvtHandlerEnabled), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_SetEvtHandlerEnabled},
    {sipName_SetNextHandler, SIP_MLMETH_CAST(meth_wxEvtHandler_SetNextHandler), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_SetNextHandler},
    {sipName_SetPreviousHandler, SIP_MLMETH_CAST(meth_wxEvtHandler_SetPreviousHandler), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_SetPreviousHandler},
    {sipName_TryAfter, SIP_MLMETH_CAST(meth_wxEvtHandler_TryAfter), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_TryAfter},
    {sipName_TryBefore, SIP_MLMETH_CAST(meth_wxEvtHandler_TryBefore), METH_VARARGS|METH_KEYWORDS, doc_wxEvtHandler_TryBefore},
    {sipName_Unlink, meth_wxEvtHandler_Unlink, METH_VARARGS, doc_wxEvtHandler_Unlink}
};

sipVariableDef variables_wxEvtHandler[] = {
    {PropertyVariable, sipName_PreviousHandler, &methods_wxEvtHandler[7], &methods_wxEvtHandler[17], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NextHandler, &methods_wxEvtHandler[6], &methods_wxEvtHandler[16], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_EvtHandlerEnabled, &methods_wxEvtHandler[5], &methods_wxEvtHandler[15], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxEvtHandler, "EvtHandler() -> None\n"
"\n"
"A class that can handle events from the windowing system.");


sipClassTypeDef sipTypeDef__core_wxEvtHandler = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxEvtHandler,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_EvtHandler,
        {0, 0, 1},
        21, methods_wxEvtHandler,
        0, SIP_NULLPTR,
        3, variables_wxEvtHandler,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxEvtHandler,
    -1,
    -1,
    supers_wxEvtHandler,
    SIP_NULLPTR,
    init_type_wxEvtHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxEvtHandler,
    SIP_NULLPTR,
    array_wxEvtHandler,
    SIP_NULLPTR,
    release_wxEvtHandler,
    cast_wxEvtHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxEvtHandler,
    sizeof (::wxEvtHandler),
};
