// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The summary of a stream.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct StreamSummary {
    /// <p>The name of a stream.</p>
    pub stream_name: ::std::string::String,
    /// <p>The ARN of the stream.</p>
    pub stream_arn: ::std::string::String,
    /// <p>The status of the stream.</p>
    pub stream_status: crate::types::StreamStatus,
    /// <p>Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.</p>
    pub stream_mode_details: ::std::option::Option<crate::types::StreamModeDetails>,
    /// <p>The timestamp at which the stream was created.</p>
    pub stream_creation_timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl StreamSummary {
    /// <p>The name of a stream.</p>
    pub fn stream_name(&self) -> &str {
        use std::ops::Deref;
        self.stream_name.deref()
    }
    /// <p>The ARN of the stream.</p>
    pub fn stream_arn(&self) -> &str {
        use std::ops::Deref;
        self.stream_arn.deref()
    }
    /// <p>The status of the stream.</p>
    pub fn stream_status(&self) -> &crate::types::StreamStatus {
        &self.stream_status
    }
    /// <p>Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.</p>
    pub fn stream_mode_details(&self) -> ::std::option::Option<&crate::types::StreamModeDetails> {
        self.stream_mode_details.as_ref()
    }
    /// <p>The timestamp at which the stream was created.</p>
    pub fn stream_creation_timestamp(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.stream_creation_timestamp.as_ref()
    }
}
impl StreamSummary {
    /// Creates a new builder-style object to manufacture [`StreamSummary`](crate::types::StreamSummary).
    pub fn builder() -> crate::types::builders::StreamSummaryBuilder {
        crate::types::builders::StreamSummaryBuilder::default()
    }
}

/// A builder for [`StreamSummary`](crate::types::StreamSummary).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StreamSummaryBuilder {
    pub(crate) stream_name: ::std::option::Option<::std::string::String>,
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
    pub(crate) stream_status: ::std::option::Option<crate::types::StreamStatus>,
    pub(crate) stream_mode_details: ::std::option::Option<crate::types::StreamModeDetails>,
    pub(crate) stream_creation_timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl StreamSummaryBuilder {
    /// <p>The name of a stream.</p>
    /// This field is required.
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of a stream.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_name = input;
        self
    }
    /// <p>The name of a stream.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_name
    }
    /// <p>The ARN of the stream.</p>
    /// This field is required.
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// <p>The status of the stream.</p>
    /// This field is required.
    pub fn stream_status(mut self, input: crate::types::StreamStatus) -> Self {
        self.stream_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status of the stream.</p>
    pub fn set_stream_status(mut self, input: ::std::option::Option<crate::types::StreamStatus>) -> Self {
        self.stream_status = input;
        self
    }
    /// <p>The status of the stream.</p>
    pub fn get_stream_status(&self) -> &::std::option::Option<crate::types::StreamStatus> {
        &self.stream_status
    }
    /// <p>Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.</p>
    pub fn stream_mode_details(mut self, input: crate::types::StreamModeDetails) -> Self {
        self.stream_mode_details = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.</p>
    pub fn set_stream_mode_details(mut self, input: ::std::option::Option<crate::types::StreamModeDetails>) -> Self {
        self.stream_mode_details = input;
        self
    }
    /// <p>Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.</p>
    pub fn get_stream_mode_details(&self) -> &::std::option::Option<crate::types::StreamModeDetails> {
        &self.stream_mode_details
    }
    /// <p>The timestamp at which the stream was created.</p>
    pub fn stream_creation_timestamp(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.stream_creation_timestamp = ::std::option::Option::Some(input);
        self
    }
    /// <p>The timestamp at which the stream was created.</p>
    pub fn set_stream_creation_timestamp(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.stream_creation_timestamp = input;
        self
    }
    /// <p>The timestamp at which the stream was created.</p>
    pub fn get_stream_creation_timestamp(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.stream_creation_timestamp
    }
    /// Consumes the builder and constructs a [`StreamSummary`](crate::types::StreamSummary).
    /// This method will fail if any of the following fields are not set:
    /// - [`stream_name`](crate::types::builders::StreamSummaryBuilder::stream_name)
    /// - [`stream_arn`](crate::types::builders::StreamSummaryBuilder::stream_arn)
    /// - [`stream_status`](crate::types::builders::StreamSummaryBuilder::stream_status)
    pub fn build(self) -> ::std::result::Result<crate::types::StreamSummary, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::StreamSummary {
            stream_name: self.stream_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "stream_name",
                    "stream_name was not specified but it is required when building StreamSummary",
                )
            })?,
            stream_arn: self.stream_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "stream_arn",
                    "stream_arn was not specified but it is required when building StreamSummary",
                )
            })?,
            stream_status: self.stream_status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "stream_status",
                    "stream_status was not specified but it is required when building StreamSummary",
                )
            })?,
            stream_mode_details: self.stream_mode_details,
            stream_creation_timestamp: self.stream_creation_timestamp,
        })
    }
}
