/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Iterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollectionFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.IteratorWrapper;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.MappingJavaIterator;
import net.sf.saxon.value.AnyURIValue;

public class UriCollection
extends SystemFunction {
    private SequenceIterator getUris(String absoluteURI, XPathContext context) throws XPathException {
        CollectionFinder collectionFinder;
        ResourceCollection collection = context.getConfiguration().getRegisteredCollection(absoluteURI);
        if (collection == null && (collectionFinder = context.getController().getCollectionFinder()) != null) {
            collection = collectionFinder.findCollection(context, absoluteURI);
        }
        if (collection == null) {
            throw new XPathException("No collection has been defined for href: " + (absoluteURI == null ? "" : absoluteURI)).withErrorCode("FODC0002").withXPathContext(context);
        }
        Iterator<String> sources = collection.getResourceURIs(context);
        MappingJavaIterator<String, AnyURIValue> uris = new MappingJavaIterator<String, AnyURIValue>(sources, s -> new AnyURIValue((String)s));
        return new IteratorWrapper(uris);
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Item arg;
        Object href = arguments.length == 0 ? null : ((arg = arguments[0].head()) == null ? null : arg.getStringValue());
        if (href == null && (href = context.getConfiguration().getDefaultCollection()) == null) {
            throw new XPathException("No default collection has been defined", "FODC0002");
        }
        String abs = CollectionFn.getAbsoluteCollectionURI(this.getRetainedStaticContext().getStaticBaseUriString(), (String)href, context);
        return new LazySequence(this.getUris(abs, context));
    }
}

