%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0xEEEEEEEECCCCCCCC", "0x7FFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", "0x4041424344454647"],
    "XMM1": ["0xAAAAAAAAAAAAAAAA", "0xCCEEDDAABBFF0990", "0x2021222324252627", "0x5555555555555555"],
    "XMM2": ["0x9999999977777776", "0x4CEEDDAABBFF098F", "0x2021222324252626", "0x95969798999A9B9C"],
    "XMM3": ["0x9999999977777776", "0x4CEEDDAABBFF098F", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0x9999999977777776", "0x4CEEDDAABBFF098F", "0x2021222324252626", "0x95969798999A9B9C"],
    "XMM5": ["0x9999999977777776", "0x4CEEDDAABBFF098F", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

; Registers
vmovapd ymm0, [rdx]
vmovapd ymm1, [rdx + 32]
vpaddq ymm2, ymm0, ymm1
vpaddq xmm3, xmm0, xmm1

; Memory operand
vpaddq ymm4, ymm0, [rdx + 32]
vpaddq xmm5, xmm0, [rdx + 32]

hlt

align 32
.data:
dq 0xEEEEEEEECCCCCCCC
dq 0x7FFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0x4041424344454647

dq 0xAAAAAAAAAAAAAAAA
dq 0xCCEEDDAABBFF0990
dq 0x2021222324252627
dq 0x5555555555555555
