/*
    beacondb.h - Beacon database 
    Copyright (C) 2024 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#ifndef __BEACONDB_H
#define __BEACONDB_H

#include "header.h"

#include "qsodb.h"

struct beacon{
    char *call; // Beacon
	char* wwl; // Locator
	double freq; // Frequency in MHz

    char *location; // Location
    char *antenna; // Antenna
    char *heading; // Heading
    float power; // Power
    float erp; // ERP
    char *status; // Status
    char *last; // DateLastSpot

	// internal
	double kx, ky; // actual position
	double qrb, qtf, qtfrad;
};

extern struct beacondb* gbeacondb;

struct beaconband{
	char bandchar;
    GPtrArray *beacons; // of struct beacon
};

struct beacondb{
    GPtrArray *bands; // of struct beaconband

};

struct beacondb *init_beacondb(void);
void free_beacondb(struct beacondb *beacondb);

struct beaconband* get_beacondb_band(struct beacondb* beacondb, char bandchar);
void read_beacondb_files(struct beacondb* beacondb);
void save_beacondb_file(const char* data);
#ifdef Z_HAVE_SDL
void plot_beacon(struct subwin* sw, SDL_Surface* surface, struct beacon* beacon);
void plot_beacons(struct subwin* sw, SDL_Surface* surface, struct band* band, SDL_Rect* area);
void plot_info_beacon(struct subwin* sw, SDL_Surface* surface, struct beacon* qso);
#endif
void beacon_compute_qrbqtf(struct beacon* beacon);
void beacondb_recalc_qrbqtf(struct beacondb* beacondb);
void menu_import_beaconspot(void* arg);
#endif
