/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.util.Collection;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.attachment.AttachmentMarshaller;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.message.Attachment;

public class JAXBAttachmentMarshaller
extends AttachmentMarshaller {
    private int threshold = 5120;
    private Collection<Attachment> atts;
    private boolean isXop;

    public JAXBAttachmentMarshaller(Collection<Attachment> attachments, Integer mtomThreshold) {
        if (mtomThreshold != null) {
            this.threshold = mtomThreshold;
        }
        this.atts = attachments;
        this.isXop = attachments != null;
    }

    public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNS, String elementLocalName) {
        Attachment att = AttachmentUtil.createMtomAttachment((boolean)this.isXop, (String)mimeType, (String)elementNS, (byte[])data, (int)offset, (int)length, (int)this.threshold);
        if (att != null) {
            this.atts.add(att);
            return "cid:" + att.getId();
        }
        return null;
    }

    public String addMtomAttachment(DataHandler handler, String elementNS, String elementLocalName) {
        Attachment att = AttachmentUtil.createMtomAttachmentFromDH((boolean)this.isXop, (DataHandler)handler, (String)elementNS, (int)this.threshold);
        if (att != null) {
            this.atts.add(att);
            return "cid:" + att.getId();
        }
        return null;
    }

    public String addSwaRefAttachment(DataHandler handler) {
        String id = UUID.randomUUID() + "@apache.org";
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(false);
        this.atts.add((Attachment)att);
        return id;
    }

    public boolean isXOPPackage() {
        return this.isXop;
    }
}

