#nullable enable
using System.CommandLine.Help;
using System.CommandLine.Invocation;
using System.CommandLine.IO;

namespace Microsoft.Dafny;

/// <summary>
/// The class HelpResult is internal to System.CommandLine so we have to include it as source.
/// It seems System.CommandLine didn't consider having more than one help option as a use-case.
/// </summary>
internal class HelpResult : IInvocationResult {
  public void Apply(InvocationContext context) {
    var output = context.Console.Out.CreateTextWriter();
    var helpBuilder = (HelpBuilder)context.BindingContext.GetService(typeof(HelpBuilder))!;
    var helpContext = new HelpContext(helpBuilder,
      context.ParseResult.CommandResult.Command,
      output,
      context.ParseResult);

    helpBuilder.Write(helpContext);
  }
}