/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FilenameUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.ChunkModule;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLSerializer;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractDomFilter;
import org.dita.dost.writer.ChunkTopicParser;
import org.dita.dost.writer.SeparateChunkTopicParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public final class ChunkMapReader
extends AbstractDomFilter {
    public static final String FILE_NAME_STUB_DITAMAP = "stub.ditamap";
    public static final String FILE_EXTENSION_CHUNK = ".chunk";
    public static final String ATTR_XTRF_VALUE_GENERATED = "generated_by_chunk";
    public static final String CHUNK_SELECT_BRANCH = "select-branch";
    public static final String CHUNK_SELECT_TOPIC = "select-topic";
    public static final String CHUNK_SELECT_DOCUMENT = "select-document";
    private static final String CHUNK_BY_DOCUMENT = "by-document";
    private static final String CHUNK_BY_TOPIC = "by-topic";
    public static final String CHUNK_TO_CONTENT = "to-content";
    public static final String CHUNK_TO_NAVIGATION = "to-navigation";
    public static final String CHUNK_PREFIX = "Chunk";
    private XMLUtils xmlUtils;
    private TempFileNameScheme tempFileNameScheme;
    private Collection<String> rootChunkOverride;
    private String defaultChunkByToken;
    private final LinkedHashMap<URI, URI> changeTable = new LinkedHashMap(128);
    private final Map<URI, URI> conflictTable = new HashMap<URI, URI>(128);
    private boolean supportToNavigation;
    private ProcessingInstruction workdir = null;
    private ProcessingInstruction workdirUrl = null;
    private ProcessingInstruction path2proj = null;
    private ProcessingInstruction path2projUrl = null;
    private ProcessingInstruction path2rootmapUrl = null;
    private final ChunkModule.ChunkFilenameGenerator chunkFilenameGenerator = ChunkModule.ChunkFilenameGeneratorFactory.newInstance();
    private URI currentFile;
    private final Set<URI> chunkTopicSet = new HashSet<URI>();

    @Override
    public void setJob(Job job) {
        super.setJob(job);
        try {
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(job.getProperty("temp-file-name-scheme")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(job.getInputDir());
    }

    public void setXmlUtils(XMLUtils xmlUtils) {
        this.xmlUtils = xmlUtils;
    }

    public void setRootChunkOverride(String chunkValue) {
        this.rootChunkOverride = StringUtils.split(chunkValue);
    }

    @Override
    public void read(File inputFile) throws DITAOTException {
        this.currentFile = inputFile.toURI();
        super.read(inputFile);
    }

    @Override
    public Document process(Document doc) {
        Float ditaVersion = DitaUtils.getDitaVersion(doc.getDocumentElement());
        if (ditaVersion == null || ditaVersion.floatValue() >= 2.0f) {
            return doc;
        }
        Element root = doc.getDocumentElement();
        if (this.rootChunkOverride != null) {
            String c = StringUtils.join(this.rootChunkOverride, " ");
            this.logger.debug("Use override root chunk \"" + c + "\"");
            root.setAttribute("chunk", c);
        }
        this.readLinks(doc);
        this.readProcessingInstructions(doc);
        Collection<String> rootChunk = StringUtils.split(root.getAttribute("chunk"));
        this.defaultChunkByToken = ChunkMapReader.getChunkByToken(rootChunk, "by-", CHUNK_BY_DOCUMENT);
        if (rootChunk.contains(CHUNK_TO_CONTENT)) {
            this.chunkMap(root);
        } else {
            for (Element currentElem : XMLUtils.getChildElements(root)) {
                if (Constants.MAP_RELTABLE.matches(currentElem)) {
                    this.updateReltable(currentElem);
                    continue;
                }
                if (!Constants.MAP_TOPICREF.matches(currentElem)) continue;
                this.processTopicref(currentElem);
            }
        }
        return this.buildOutputDocument(root);
    }

    public Set<URI> getChunkTopicSet() {
        return Collections.unmodifiableSet(this.chunkTopicSet);
    }

    private void readLinks(Document doc) {
        Element root = doc.getDocumentElement();
        this.readLinks(root, false, false);
    }

    private void readLinks(Element elem, boolean chunk, boolean disabled) {
        boolean c = chunk || elem.getAttributeNode("chunk") != null;
        boolean d = disabled || elem.getAttribute("chunk").contains(CHUNK_TO_NAVIGATION) || Constants.MAPGROUP_D_TOPICGROUP.matches(elem) && !Constants.SUBMAP.matches(elem) || Constants.MAP_RELTABLE.matches(elem);
        Attr href = elem.getAttributeNode("href");
        if (href != null) {
            URI filename = URLUtils.stripFragment(this.currentFile.resolve(href.getValue()));
            if (c && !d) {
                this.chunkTopicSet.add(filename);
                Attr copyTo = elem.getAttributeNode("copy-to");
                if (copyTo != null) {
                    URI copyToFile = URLUtils.stripFragment(this.currentFile.resolve(copyTo.getValue()));
                    this.chunkTopicSet.add(copyToFile);
                }
            }
        }
        for (Element topicref : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
            this.readLinks(topicref, c, d);
        }
    }

    public static String getChunkByToken(Collection<String> chunkValue, String category, String defaultToken) {
        if (chunkValue.isEmpty()) {
            return defaultToken;
        }
        for (String token : chunkValue) {
            if (!token.startsWith(category)) continue;
            return token;
        }
        return defaultToken;
    }

    private void chunkMap(Element root) {
        URI newFilename = URLUtils.toURI(FileUtils.replaceExtension(new File(this.currentFile).getName(), ".dita"));
        URI newFile = this.currentFile.resolve(newFilename);
        if (this.job.getStore().exists(newFile)) {
            URI oldFile = newFile;
            newFilename = URLUtils.toURI(this.chunkFilenameGenerator.generateFilename(CHUNK_PREFIX, ".dita"));
            newFile = this.currentFile.resolve(newFilename);
            this.conflictTable.put(newFile, oldFile.normalize());
        }
        this.changeTable.put(newFile, newFile);
        String origCls = root.getAttribute("class");
        root.setAttribute("class", origCls + Constants.MAP_TOPICREF.matcher);
        root.setAttribute("href", newFilename.toString());
        this.createTopicStump(newFile);
        this.processTopicref(root);
        if (origCls != null) {
            root.setAttribute("class", origCls);
        }
        root.removeAttribute("href");
    }

    private void createTopicStump(URI newFile) {
        try (OutputStream newFileWriter = this.job.getStore().getOutputStream(newFile);){
            XMLStreamWriter o = XMLOutputFactory.newInstance().createXMLStreamWriter(newFileWriter, "UTF-8");
            o.writeStartDocument();
            o.writeProcessingInstruction("workdir", "/" + new File(newFile.resolve(".")).getAbsolutePath());
            o.writeProcessingInstruction("workdir-uri", newFile.resolve(".").toString());
            o.writeStartElement("dita");
            o.writeEndElement();
            o.writeEndDocument();
            o.close();
            newFileWriter.flush();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private void readProcessingInstructions(Document doc) {
        NodeList docNodes = doc.getChildNodes();
        block14: for (int i = 0; i < docNodes.getLength(); ++i) {
            Node node = docNodes.item(i);
            if (node.getNodeType() != 7) continue;
            ProcessingInstruction pi = (ProcessingInstruction)node;
            switch (pi.getNodeName()) {
                case "workdir": {
                    this.workdir = pi;
                    continue block14;
                }
                case "workdir-uri": {
                    this.workdirUrl = pi;
                    continue block14;
                }
                case "path2project": {
                    this.path2proj = pi;
                    continue block14;
                }
                case "path2project-uri": {
                    this.path2projUrl = pi;
                    continue block14;
                }
                case "path2rootmap-uri": {
                    this.path2rootmapUrl = pi;
                }
            }
        }
    }

    private void outputMapFile(URI file, Document doc) {
        try {
            this.job.getStore().writeDocument(doc, file);
        }
        catch (IOException e) {
            this.logger.error("Failed to serialize map: " + e.getMessage(), e);
        }
    }

    private Document buildOutputDocument(Element root) {
        Document doc = this.xmlUtils.newDocument();
        if (this.workdir != null) {
            doc.appendChild(doc.importNode(this.workdir, true));
        }
        if (this.workdirUrl != null) {
            doc.appendChild(doc.importNode(this.workdirUrl, true));
        }
        if (this.path2proj != null) {
            doc.appendChild(doc.importNode(this.path2proj, true));
        }
        if (this.path2projUrl != null) {
            doc.appendChild(doc.importNode(this.path2projUrl, true));
        }
        if (this.path2rootmapUrl != null) {
            doc.appendChild(doc.importNode(this.path2rootmapUrl, true));
        }
        doc.appendChild(doc.importNode(root, true));
        return doc;
    }

    private void processTopicref(Element topicref) {
        String xtrf = XMLUtils.getValue(topicref, "xtrf");
        if (xtrf != null && xtrf.contains(ATTR_XTRF_VALUE_GENERATED)) {
            return;
        }
        Collection<String> chunk = StringUtils.split(XMLUtils.getValue(topicref, "chunk"));
        URI href = URLUtils.toURI(XMLUtils.getValue(topicref, "href"));
        URI copyTo = URLUtils.toURI(XMLUtils.getValue(topicref, "copy-to"));
        String scope = XMLUtils.getCascadeValue(topicref, "scope");
        String chunkByToken = ChunkMapReader.getChunkByToken(chunk, "by-", this.defaultChunkByToken);
        if ("external".equals(scope) || href != null && !this.job.getStore().exists(this.currentFile.resolve(href.toString())) || chunk.isEmpty() && href == null) {
            this.processChildTopicref(topicref);
        } else if (chunk.contains(CHUNK_TO_CONTENT)) {
            if (href != null || copyTo != null || topicref.hasChildNodes()) {
                if (chunk.contains(CHUNK_BY_TOPIC)) {
                    this.logger.warn(MessageUtils.getMessage("DOTJ064W", new String[0]).setLocation(topicref).toString());
                }
                if (href == null) {
                    this.generateStumpTopic(topicref);
                }
                this.processCombineChunk(topicref);
            }
        } else if (chunk.contains(CHUNK_TO_NAVIGATION) && this.supportToNavigation) {
            this.processChildTopicref(topicref);
            this.processNavitation(topicref);
        } else if (chunkByToken.equals(CHUNK_BY_TOPIC)) {
            if (href != null) {
                this.processSeparateChunk(topicref);
            }
            this.processChildTopicref(topicref);
        } else {
            URI currentPath = null;
            if (copyTo != null) {
                currentPath = this.currentFile.resolve(copyTo);
            } else if (href != null) {
                currentPath = this.currentFile.resolve(href);
            }
            if (currentPath != null) {
                this.changeTable.remove(currentPath);
                String processingRole = XMLUtils.getCascadeValue(topicref, "processing-role");
                if (!"resource-only".equals(processingRole)) {
                    this.changeTable.put(currentPath, currentPath);
                }
            }
            this.processChildTopicref(topicref);
        }
    }

    private void processNavitation(Element topicref) {
        Element root = (Element)topicref.getOwnerDocument().getDocumentElement().cloneNode(false);
        Element navref = topicref.getOwnerDocument().createElement(Constants.MAP_NAVREF.localName);
        String newMapFile = this.chunkFilenameGenerator.generateFilename("MAPCHUNK", ".ditamap");
        navref.setAttribute("mapref", newMapFile);
        navref.setAttribute("class", Constants.MAP_NAVREF.toString());
        topicref.getParentNode().replaceChild(navref, topicref);
        root.appendChild(topicref);
        URI navmap = this.currentFile.resolve(newMapFile);
        this.changeTable.put(URLUtils.stripFragment(navmap), URLUtils.stripFragment(navmap));
        this.outputMapFile(navmap, this.buildOutputDocument(root));
    }

    private String generateFilename() {
        return this.chunkFilenameGenerator.generateFilename(CHUNK_PREFIX, ".dita");
    }

    private void generateStumpTopic(Element topicref) {
        String shortDesc;
        URI result = this.getResultFile(topicref);
        URI temp = this.tempFileNameScheme.generateTempFileName(result);
        URI absTemp = this.job.tempDir.toURI().resolve(temp);
        String name = FilenameUtils.getBaseName((String)new File(result).getName());
        String navtitle = this.getChildElementValueOfTopicmeta(topicref, Constants.TOPIC_NAVTITLE);
        if (navtitle == null) {
            navtitle = XMLUtils.getValue(topicref, "navtitle");
        }
        if ((shortDesc = this.getChildElementValueOfTopicmeta(topicref, Constants.TOPIC_SHORTDESC)) == null) {
            shortDesc = this.getChildElementValueOfTopicmeta(topicref, Constants.MAP_SHORTDESC);
        }
        this.writeChunk(absTemp, name, navtitle, shortDesc);
        URI relativePath = URLUtils.getRelativePath(this.currentFile.resolve(FILE_NAME_STUB_DITAMAP), absTemp);
        topicref.setAttribute("href", relativePath.toString());
        if (Constants.MAPGROUP_D_TOPICGROUP.matches(topicref)) {
            topicref.setAttribute("class", Constants.MAP_TOPICREF.toString());
        }
        URI relativeToBase = URLUtils.getRelativePath(this.job.tempDirURI.resolve("dummy"), absTemp);
        Job.FileInfo fi = new Job.FileInfo.Builder().uri(temp).result(result).format("dita").build();
        this.job.add(fi);
    }

    private void writeChunk(URI outputFileName, String id, String title, String shortDesc) {
        try (OutputStream output = this.job.getStore().getOutputStream(outputFileName);){
            XMLSerializer serializer = XMLSerializer.newInstance(output);
            serializer.writeStartDocument();
            if (title == null && shortDesc == null) {
                serializer.writeStartElement("dita");
                serializer.writeAttribute("http://dita.oasis-open.org/architecture/2005/", "ditaarch:DITAArchVersion", "1.3");
                serializer.writeEndElement();
            } else {
                serializer.writeStartElement(Constants.TOPIC_TOPIC.localName);
                serializer.writeAttribute("http://dita.oasis-open.org/architecture/2005/", "ditaarch:DITAArchVersion", "1.3");
                serializer.writeAttribute("id", id);
                serializer.writeAttribute("class", Constants.TOPIC_TOPIC.toString());
                serializer.writeAttribute("domains", "");
                serializer.writeAttribute("specializations", "");
                serializer.writeStartElement(Constants.TOPIC_TITLE.localName);
                serializer.writeAttribute("class", Constants.TOPIC_TITLE.toString());
                if (title != null) {
                    serializer.writeCharacters(title);
                }
                serializer.writeEndElement();
                if (shortDesc != null) {
                    serializer.writeStartElement(Constants.TOPIC_SHORTDESC.localName);
                    serializer.writeAttribute("class", Constants.TOPIC_SHORTDESC.toString());
                    serializer.writeCharacters(shortDesc);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndDocument();
            serializer.close();
        }
        catch (IOException | SAXException e) {
            this.logger.error("Failed to write generated chunk: " + e.getMessage(), e);
        }
    }

    private URI getResultFile(Element topicref) {
        URI outputFileName;
        Job.FileInfo curr = this.job.getFileInfo(this.currentFile);
        URI copyTo = URLUtils.toURI(XMLUtils.getValue(topicref, "copy-to"));
        String id = XMLUtils.getValue(topicref, "id");
        if (copyTo != null) {
            outputFileName = curr.result.resolve(copyTo);
        } else if (id != null) {
            outputFileName = curr.result.resolve(id + ".dita");
        } else {
            Set results = this.job.getFileInfo().stream().map(fi -> fi.result).collect(Collectors.toSet());
            while (results.contains(outputFileName = curr.result.resolve(this.generateFilename()))) {
            }
        }
        return outputFileName;
    }

    private String getChildElementValueOfTopicmeta(Element element, DitaClass classValue) {
        Element elem;
        Element topicMeta;
        if (element.hasChildNodes() && (topicMeta = XMLUtils.getElementNode(element, Constants.MAP_TOPICMETA)) != null && (elem = XMLUtils.getElementNode(topicMeta, classValue)) != null) {
            return XMLUtils.getText(elem);
        }
        return null;
    }

    private void processChildTopicref(Element node) {
        List<Element> children = XMLUtils.getChildElements(node, Constants.MAP_TOPICREF);
        for (Element currentElem : children) {
            URI href = URLUtils.toURI(XMLUtils.getValue(currentElem, "href"));
            String xtrf = currentElem.getAttribute("xtrf");
            if (href == null) {
                this.processTopicref(currentElem);
                continue;
            }
            if (ATTR_XTRF_VALUE_GENERATED.equals(xtrf) || this.currentFile.resolve(href).equals(this.changeTable.get(this.currentFile.resolve(href)))) continue;
            this.processTopicref(currentElem);
        }
    }

    private void processSeparateChunk(Element topicref) {
        SeparateChunkTopicParser chunkParser = new SeparateChunkTopicParser();
        chunkParser.setLogger(this.logger);
        chunkParser.setJob(this.job);
        chunkParser.setup(this.changeTable, this.conflictTable, topicref, this.chunkFilenameGenerator);
        chunkParser.write(this.currentFile);
    }

    private void processCombineChunk(Element topicref) {
        ChunkTopicParser chunkParser = new ChunkTopicParser();
        chunkParser.setLogger(this.logger);
        chunkParser.setJob(this.job);
        this.createChildTopicrefStubs(XMLUtils.getChildElements(topicref, Constants.MAP_TOPICREF));
        chunkParser.setup(this.changeTable, this.conflictTable, topicref, this.chunkFilenameGenerator);
        chunkParser.write(this.currentFile);
    }

    private void createChildTopicrefStubs(List<Element> topicrefs) {
        if (!topicrefs.isEmpty()) {
            for (Element currentElem : topicrefs) {
                String href = XMLUtils.getValue(currentElem, "href");
                String chunk = XMLUtils.getValue(currentElem, "chunk");
                if (href == null && chunk != null) {
                    this.generateStumpTopic(currentElem);
                }
                this.createChildTopicrefStubs(XMLUtils.getChildElements(currentElem, Constants.MAP_TOPICREF));
            }
        }
    }

    private void updateReltable(Element elem) {
        String href = elem.getAttribute("href");
        if (href.length() != 0 && this.changeTable.containsKey(this.currentFile.resolve(href))) {
            URI res = URLUtils.getRelativePath(this.currentFile.resolve(FILE_NAME_STUB_DITAMAP), this.currentFile.resolve(href));
            String fragment = FileUtils.getFragment(href);
            if (fragment != null) {
                res = URLUtils.setFragment(res, fragment);
            }
            elem.setAttribute("href", res.toString());
        }
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element currentElem;
            String cls;
            Node current = children.item(i);
            if (current.getNodeType() == 1 && !Constants.MAP_TOPICREF.matches(cls = (currentElem = (Element)current).getAttribute("class"))) continue;
        }
    }

    public Map<URI, URI> getChangeTable() {
        for (Map.Entry<URI, URI> e : this.changeTable.entrySet()) {
            assert (e.getKey().isAbsolute());
            assert (e.getValue().isAbsolute());
        }
        return Collections.unmodifiableMap(this.changeTable);
    }

    public Map<URI, URI> getConflicTable() {
        for (Map.Entry<URI, URI> e : this.conflictTable.entrySet()) {
            assert (e.getKey().isAbsolute());
            assert (e.getValue().isAbsolute());
        }
        return this.conflictTable;
    }

    public void supportToNavigation(boolean supportToNavigation) {
        this.supportToNavigation = supportToNavigation;
    }
}

