/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.Plugin;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PluginParser {
    private static final String EXTENSION_POINT_ELEM = "extension-point";
    private static final String EXTENSION_POINT_NAME_ATTR = "name";
    private static final String EXTENSION_POINT_ID_ATTR = "id";
    private static final String TEMPLATE_ELEM = "template";
    private static final String TEMPLATE_FILE_ATTR = "file";
    private static final String META_ELEM = "meta";
    private static final String META_VALUE_ATTR = "value";
    private static final String META_TYPE_ATTR = "type";
    private static final String REQUIRE_ELEM = "require";
    private static final String REQUIRE_IMPORTANCE_ATTR = "importance";
    static final String REQUIRE_IMPORTANCE_VALUE_REQUIRED = "required";
    private static final String REQUIRE_PLUGIN_ATTR = "plugin";
    public static final String FEATURE_ELEM = "feature";
    private static final String TRANSTYPE_ELEM = "transtype";
    private static final String TRANSTYPE_ABSTRACT_ATTR = "abstract";
    private static final String TRANSTYPE_NAME_ATTR = "name";
    public static final String FEATURE_ID_ATTR = "extension";
    public static final String FEATURE_VALUE_ATTR = "value";
    public static final String FEATURE_FILE_ATTR = "file";
    public static final String FEATURE_TYPE_ATTR = "type";
    public static final String FEATURE_TYPE_VALUE_FILE = "file";
    public static final String PLUGIN_ELEM = "plugin";
    private static final String PLUGIN_ID_ATTR = "id";
    private static final String PLUGIN_VERSION_ATTR = "version";
    public static final Pattern ID_PATTERN = Pattern.compile("[0-9a-zA-Z_\\-]+(?:\\.[0-9a-zA-Z_\\-]+)*");
    public static final Pattern VERSION_PATTERN = Pattern.compile("\\d+(?:\\.\\d+(?:\\.\\d+(?:\\.[0-9a-zA-Z_\\-]+)?)?)?");
    private final File ditaDir;
    private final DocumentBuilder builder;
    private File pluginDir;
    private Features.Builder features;
    private DITAOTLogger logger;

    public PluginParser(File ditaDir) {
        assert (ditaDir.isAbsolute());
        this.ditaDir = ditaDir;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newDefaultInstance();
        factory.setNamespaceAware(true);
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void setPluginDir(File pluginDir) {
        assert (pluginDir.isAbsolute());
        this.pluginDir = pluginDir;
    }

    public Plugin getPlugin() {
        return this.features.build();
    }

    public Element parse(File file) throws Exception {
        Document doc;
        try {
            doc = this.builder.parse(file);
        }
        catch (IOException | SAXException e) {
            throw new Exception("Failed to parse " + String.valueOf(file) + ": " + e.getMessage(), e);
        }
        Element root = this.migrate(doc.getDocumentElement());
        String pluginId = root.getAttribute("id");
        this.features = Features.builder().setPluginDir(this.pluginDir).setDitaDir(this.ditaDir).setPluginId(pluginId);
        Attr pluginVersion = root.getAttributeNode(PLUGIN_VERSION_ATTR);
        if (pluginVersion != null) {
            if (!VERSION_PATTERN.matcher(pluginVersion.getValue()).matches()) {
                this.logger.error("Plug-in version '%s' doesn't follow syntax rules.".formatted(pluginVersion.getValue()));
            } else {
                this.features.setPluginVersion(pluginVersion.getValue());
            }
        }
        for (Element elem : XMLUtils.getChildElements(root)) {
            String qName = elem.getTagName();
            if (EXTENSION_POINT_ELEM.equals(qName)) {
                this.addExtensionPoint(elem);
                continue;
            }
            if (TRANSTYPE_ELEM.equals(qName)) {
                this.addTranstype(elem);
                continue;
            }
            if (FEATURE_ELEM.equals(qName)) {
                this.features.addFeature(elem.getAttribute(FEATURE_ID_ATTR), elem);
                continue;
            }
            if (REQUIRE_ELEM.equals(qName)) {
                String importance = elem.getAttribute(REQUIRE_IMPORTANCE_ATTR);
                this.features.addRequire(elem.getAttribute("plugin"), importance.isEmpty() ? null : importance);
                continue;
            }
            if (META_ELEM.equals(qName)) {
                this.features.addMeta(elem.getAttribute("type"), elem.getAttribute("value"));
                continue;
            }
            if (!TEMPLATE_ELEM.equals(qName)) continue;
            this.features.addTemplate(elem.getAttribute("file"));
        }
        return root;
    }

    private Element migrate(Element root) {
        if (root.getAttributeNode(PLUGIN_VERSION_ATTR) == null) {
            List featureElems = XMLUtils.toList(root.getElementsByTagName(FEATURE_ELEM));
            String version = featureElems.stream().filter(elem -> elem.getAttribute(FEATURE_ID_ATTR).equals("package.version")).findFirst().map(elem -> elem.getAttribute("value")).orElse("0.0.0");
            root.setAttribute(PLUGIN_VERSION_ATTR, version);
        }
        return root;
    }

    private void addTranstype(Element elem) {
        if (!Boolean.parseBoolean(elem.getAttribute(TRANSTYPE_ABSTRACT_ATTR))) {
            Document doc = elem.getOwnerDocument();
            for (String transtype : elem.getAttribute("name").split("\\s+")) {
                Element buf = doc.createElement(FEATURE_ELEM);
                buf.setAttribute("value", transtype);
                this.features.addFeature("dita.conductor.transtype.check", buf);
            }
        }
    }

    private void addExtensionPoint(Element elem) {
        String id = elem.getAttribute("id");
        if (id.isEmpty()) {
            throw new IllegalArgumentException("id attribute not set on extension-point");
        }
        String name = elem.getAttribute("name");
        this.features.addExtensionPoint(id, name);
    }
}

