#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1205
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 139
#define ALIAS_COUNT 0
#define TOKEN_COUNT 72
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 39

enum ts_symbol_identifiers {
  anon_sym_COLON = 1,
  anon_sym_SLASHdts_DASHv1_SLASH = 2,
  anon_sym_SEMI = 3,
  anon_sym_SLASHplugin_SLASH = 4,
  anon_sym_SLASHmemreserve_SLASH = 5,
  sym_comment = 6,
  sym__node_path = 7,
  aux_sym__label_name_token1 = 8,
  aux_sym__node_name_token1 = 9,
  aux_sym__property_name_token1 = 10,
  anon_sym_AMP = 11,
  anon_sym_SLASH = 12,
  anon_sym_AT = 13,
  anon_sym_AMP_LBRACE = 14,
  anon_sym_RBRACE = 15,
  anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH = 16,
  anon_sym_LBRACE = 17,
  anon_sym_SLASHbits_SLASH = 18,
  anon_sym_EQ = 19,
  anon_sym_COMMA = 20,
  anon_sym_SLASHdelete_DASHnode_SLASH = 21,
  anon_sym_SLASHdelete_DASHproperty_SLASH = 22,
  anon_sym_SLASHincbin_SLASH = 23,
  anon_sym_LPAREN = 24,
  anon_sym_RPAREN = 25,
  anon_sym_LT = 26,
  anon_sym_GT = 27,
  anon_sym_DQUOTE = 28,
  aux_sym_string_literal_token1 = 29,
  sym_escape_sequence = 30,
  sym_system_lib_string = 31,
  anon_sym_LBRACK = 32,
  anon_sym_RBRACK = 33,
  sym__byte_string_item = 34,
  sym_integer_literal = 35,
  sym_identifier = 36,
  anon_sym_QMARK = 37,
  anon_sym_BANG = 38,
  anon_sym_TILDE = 39,
  anon_sym_DASH = 40,
  anon_sym_PLUS = 41,
  anon_sym_STAR = 42,
  anon_sym_PERCENT = 43,
  anon_sym_PIPE_PIPE = 44,
  anon_sym_AMP_AMP = 45,
  anon_sym_PIPE = 46,
  anon_sym_CARET = 47,
  anon_sym_EQ_EQ = 48,
  anon_sym_BANG_EQ = 49,
  anon_sym_GT_EQ = 50,
  anon_sym_LT_EQ = 51,
  anon_sym_LT_LT = 52,
  anon_sym_GT_GT = 53,
  anon_sym_SLASHinclude_SLASH = 54,
  aux_sym_preproc_include_token1 = 55,
  aux_sym_preproc_include_token2 = 56,
  aux_sym_preproc_def_token1 = 57,
  anon_sym_LPAREN2 = 58,
  anon_sym_DOT_DOT_DOT = 59,
  aux_sym_preproc_undef_token1 = 60,
  sym_preproc_arg = 61,
  aux_sym_preproc_if_token1 = 62,
  anon_sym_LF = 63,
  aux_sym_preproc_if_token2 = 64,
  aux_sym_preproc_ifdef_token1 = 65,
  aux_sym_preproc_ifdef_token2 = 66,
  aux_sym_preproc_else_token1 = 67,
  aux_sym_preproc_elif_token1 = 68,
  aux_sym_preproc_elifdef_token1 = 69,
  aux_sym_preproc_elifdef_token2 = 70,
  anon_sym_defined = 71,
  sym_document = 72,
  sym__top_level_item = 73,
  sym__label = 74,
  sym_file_version = 75,
  sym_plugin = 76,
  sym_memory_reservation = 77,
  sym__label_name = 78,
  sym__node_name = 79,
  sym__property_name = 80,
  sym_unit_address = 81,
  sym_reference = 82,
  sym__label_reference = 83,
  sym_path_node = 84,
  sym_path = 85,
  sym__node_reference = 86,
  sym_omit_if_no_ref = 87,
  sym_node = 88,
  sym__bits = 89,
  sym_property = 90,
  sym__node_members = 91,
  sym_delete_node = 92,
  sym_delete_property = 93,
  sym_incbin = 94,
  sym__property_value = 95,
  sym_integer_cells = 96,
  sym__integer_cell_items = 97,
  sym_string_literal = 98,
  sym_byte_string_literal = 99,
  sym__expression = 100,
  sym_call_expression = 101,
  sym_argument_list = 102,
  sym_conditional_expression = 103,
  sym_unary_expression = 104,
  sym_binary_expression = 105,
  sym_dtsi_include = 106,
  sym_preproc_include = 107,
  sym_preproc_def = 108,
  sym_preproc_function_def = 109,
  sym_preproc_params = 110,
  sym_preproc_undef = 111,
  sym_preproc_if = 112,
  sym_preproc_ifdef = 113,
  sym_preproc_else = 114,
  sym_preproc_elif = 115,
  sym_preproc_elifdef = 116,
  sym_preproc_if_in_node = 117,
  sym_preproc_ifdef_in_node = 118,
  sym_preproc_else_in_node = 119,
  sym_preproc_elif_in_node = 120,
  sym__preproc_expression = 121,
  sym_preproc_parenthesized_expression = 122,
  sym_preproc_defined = 123,
  sym_preproc_unary_expression = 124,
  sym_preproc_call_expression = 125,
  sym_preproc_argument_list = 126,
  sym_preproc_binary_expression = 127,
  aux_sym_document_repeat1 = 128,
  aux_sym_memory_reservation_repeat1 = 129,
  aux_sym_path_repeat1 = 130,
  aux_sym_node_repeat1 = 131,
  aux_sym_property_repeat1 = 132,
  aux_sym_integer_cells_repeat1 = 133,
  aux_sym_string_literal_repeat1 = 134,
  aux_sym_byte_string_literal_repeat1 = 135,
  aux_sym_argument_list_repeat1 = 136,
  aux_sym_preproc_params_repeat1 = 137,
  aux_sym_preproc_argument_list_repeat1 = 138,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_COLON] = ":",
  [anon_sym_SLASHdts_DASHv1_SLASH] = "/dts-v1/",
  [anon_sym_SEMI] = ";",
  [anon_sym_SLASHplugin_SLASH] = "/plugin/",
  [anon_sym_SLASHmemreserve_SLASH] = "/memreserve/",
  [sym_comment] = "comment",
  [sym__node_path] = "identifier",
  [aux_sym__label_name_token1] = "_label_name_token1",
  [aux_sym__node_name_token1] = "_node_name_token1",
  [aux_sym__property_name_token1] = "_property_name_token1",
  [anon_sym_AMP] = "&",
  [anon_sym_SLASH] = "/",
  [anon_sym_AT] = "@",
  [anon_sym_AMP_LBRACE] = "&{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH] = "/omit-if-no-ref/",
  [anon_sym_LBRACE] = "{",
  [anon_sym_SLASHbits_SLASH] = "/bits/",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [anon_sym_SLASHdelete_DASHnode_SLASH] = "/delete-node/",
  [anon_sym_SLASHdelete_DASHproperty_SLASH] = "/delete-property/",
  [anon_sym_SLASHincbin_SLASH] = "/incbin/",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym__byte_string_item] = "_byte_string_item",
  [sym_integer_literal] = "integer_literal",
  [sym_identifier] = "identifier",
  [anon_sym_QMARK] = "\?",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_SLASHinclude_SLASH] = "/include/",
  [aux_sym_preproc_include_token1] = "#include",
  [aux_sym_preproc_include_token2] = "preproc_include_token2",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [aux_sym_preproc_undef_token1] = "#undef",
  [sym_preproc_arg] = "preproc_arg",
  [aux_sym_preproc_if_token1] = "#if",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [aux_sym_preproc_elifdef_token1] = "#elifdef",
  [aux_sym_preproc_elifdef_token2] = "#elifndef",
  [anon_sym_defined] = "defined",
  [sym_document] = "document",
  [sym__top_level_item] = "_top_level_item",
  [sym__label] = "_label",
  [sym_file_version] = "file_version",
  [sym_plugin] = "plugin",
  [sym_memory_reservation] = "memory_reservation",
  [sym__label_name] = "identifier",
  [sym__node_name] = "identifier",
  [sym__property_name] = "identifier",
  [sym_unit_address] = "unit_address",
  [sym_reference] = "reference",
  [sym__label_reference] = "_label_reference",
  [sym_path_node] = "path_node",
  [sym_path] = "path",
  [sym__node_reference] = "_node_reference",
  [sym_omit_if_no_ref] = "omit_if_no_ref",
  [sym_node] = "node",
  [sym__bits] = "_bits",
  [sym_property] = "property",
  [sym__node_members] = "_node_members",
  [sym_delete_node] = "delete_node",
  [sym_delete_property] = "delete_property",
  [sym_incbin] = "incbin",
  [sym__property_value] = "_property_value",
  [sym_integer_cells] = "integer_cells",
  [sym__integer_cell_items] = "_integer_cell_items",
  [sym_string_literal] = "string_literal",
  [sym_byte_string_literal] = "byte_string_literal",
  [sym__expression] = "_expression",
  [sym_call_expression] = "call_expression",
  [sym_argument_list] = "argument_list",
  [sym_conditional_expression] = "conditional_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_dtsi_include] = "dtsi_include",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_undef] = "preproc_undef",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_elifdef] = "preproc_elifdef",
  [sym_preproc_if_in_node] = "preproc_if",
  [sym_preproc_ifdef_in_node] = "preproc_ifdef",
  [sym_preproc_else_in_node] = "preproc_else",
  [sym_preproc_elif_in_node] = "preproc_elif",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_memory_reservation_repeat1] = "memory_reservation_repeat1",
  [aux_sym_path_repeat1] = "path_repeat1",
  [aux_sym_node_repeat1] = "node_repeat1",
  [aux_sym_property_repeat1] = "property_repeat1",
  [aux_sym_integer_cells_repeat1] = "integer_cells_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_byte_string_literal_repeat1] = "byte_string_literal_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SLASHdts_DASHv1_SLASH] = anon_sym_SLASHdts_DASHv1_SLASH,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_SLASHplugin_SLASH] = anon_sym_SLASHplugin_SLASH,
  [anon_sym_SLASHmemreserve_SLASH] = anon_sym_SLASHmemreserve_SLASH,
  [sym_comment] = sym_comment,
  [sym__node_path] = sym_identifier,
  [aux_sym__label_name_token1] = aux_sym__label_name_token1,
  [aux_sym__node_name_token1] = aux_sym__node_name_token1,
  [aux_sym__property_name_token1] = aux_sym__property_name_token1,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_AMP_LBRACE] = anon_sym_AMP_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH] = anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_SLASHbits_SLASH] = anon_sym_SLASHbits_SLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_SLASHdelete_DASHnode_SLASH] = anon_sym_SLASHdelete_DASHnode_SLASH,
  [anon_sym_SLASHdelete_DASHproperty_SLASH] = anon_sym_SLASHdelete_DASHproperty_SLASH,
  [anon_sym_SLASHincbin_SLASH] = anon_sym_SLASHincbin_SLASH,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym__byte_string_item] = sym__byte_string_item,
  [sym_integer_literal] = sym_integer_literal,
  [sym_identifier] = sym_identifier,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_SLASHinclude_SLASH] = anon_sym_SLASHinclude_SLASH,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [aux_sym_preproc_include_token2] = aux_sym_preproc_include_token2,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [aux_sym_preproc_undef_token1] = aux_sym_preproc_undef_token1,
  [sym_preproc_arg] = sym_preproc_arg,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [aux_sym_preproc_elifdef_token1] = aux_sym_preproc_elifdef_token1,
  [aux_sym_preproc_elifdef_token2] = aux_sym_preproc_elifdef_token2,
  [anon_sym_defined] = anon_sym_defined,
  [sym_document] = sym_document,
  [sym__top_level_item] = sym__top_level_item,
  [sym__label] = sym__label,
  [sym_file_version] = sym_file_version,
  [sym_plugin] = sym_plugin,
  [sym_memory_reservation] = sym_memory_reservation,
  [sym__label_name] = sym_identifier,
  [sym__node_name] = sym_identifier,
  [sym__property_name] = sym_identifier,
  [sym_unit_address] = sym_unit_address,
  [sym_reference] = sym_reference,
  [sym__label_reference] = sym__label_reference,
  [sym_path_node] = sym_path_node,
  [sym_path] = sym_path,
  [sym__node_reference] = sym__node_reference,
  [sym_omit_if_no_ref] = sym_omit_if_no_ref,
  [sym_node] = sym_node,
  [sym__bits] = sym__bits,
  [sym_property] = sym_property,
  [sym__node_members] = sym__node_members,
  [sym_delete_node] = sym_delete_node,
  [sym_delete_property] = sym_delete_property,
  [sym_incbin] = sym_incbin,
  [sym__property_value] = sym__property_value,
  [sym_integer_cells] = sym_integer_cells,
  [sym__integer_cell_items] = sym__integer_cell_items,
  [sym_string_literal] = sym_string_literal,
  [sym_byte_string_literal] = sym_byte_string_literal,
  [sym__expression] = sym__expression,
  [sym_call_expression] = sym_call_expression,
  [sym_argument_list] = sym_argument_list,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_dtsi_include] = sym_dtsi_include,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_undef] = sym_preproc_undef,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_elifdef] = sym_preproc_elifdef,
  [sym_preproc_if_in_node] = sym_preproc_if,
  [sym_preproc_ifdef_in_node] = sym_preproc_ifdef,
  [sym_preproc_else_in_node] = sym_preproc_else,
  [sym_preproc_elif_in_node] = sym_preproc_elif,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_preproc_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_memory_reservation_repeat1] = aux_sym_memory_reservation_repeat1,
  [aux_sym_path_repeat1] = aux_sym_path_repeat1,
  [aux_sym_node_repeat1] = aux_sym_node_repeat1,
  [aux_sym_property_repeat1] = aux_sym_property_repeat1,
  [aux_sym_integer_cells_repeat1] = aux_sym_integer_cells_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_byte_string_literal_repeat1] = aux_sym_byte_string_literal_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHdts_DASHv1_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHplugin_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHmemreserve_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__node_path] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__label_name_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__node_name_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__property_name_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHbits_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHdelete_DASHnode_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHdelete_DASHproperty_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHincbin_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym__byte_string_item] = {
    .visible = false,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHinclude_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_undef_token1] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_item] = {
    .visible = false,
    .named = true,
  },
  [sym__label] = {
    .visible = false,
    .named = true,
  },
  [sym_file_version] = {
    .visible = true,
    .named = true,
  },
  [sym_plugin] = {
    .visible = true,
    .named = true,
  },
  [sym_memory_reservation] = {
    .visible = true,
    .named = true,
  },
  [sym__label_name] = {
    .visible = true,
    .named = true,
  },
  [sym__node_name] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_address] = {
    .visible = true,
    .named = true,
  },
  [sym_reference] = {
    .visible = true,
    .named = true,
  },
  [sym__label_reference] = {
    .visible = false,
    .named = true,
  },
  [sym_path_node] = {
    .visible = true,
    .named = true,
  },
  [sym_path] = {
    .visible = true,
    .named = true,
  },
  [sym__node_reference] = {
    .visible = false,
    .named = true,
  },
  [sym_omit_if_no_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_node] = {
    .visible = true,
    .named = true,
  },
  [sym__bits] = {
    .visible = false,
    .named = true,
  },
  [sym_property] = {
    .visible = true,
    .named = true,
  },
  [sym__node_members] = {
    .visible = false,
    .named = true,
  },
  [sym_delete_node] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_property] = {
    .visible = true,
    .named = true,
  },
  [sym_incbin] = {
    .visible = true,
    .named = true,
  },
  [sym__property_value] = {
    .visible = false,
    .named = true,
  },
  [sym_integer_cells] = {
    .visible = true,
    .named = true,
  },
  [sym__integer_cell_items] = {
    .visible = false,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_byte_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dtsi_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_undef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_node] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_node] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_node] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_node] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_memory_reservation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_node_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_property_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_cells_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_byte_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_address = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_bits = 5,
  field_condition = 6,
  field_consequence = 7,
  field_filename = 8,
  field_function = 9,
  field_label = 10,
  field_left = 11,
  field_length = 12,
  field_name = 13,
  field_offset = 14,
  field_operator = 15,
  field_parameters = 16,
  field_path = 17,
  field_right = 18,
  field_size = 19,
  field_value = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_address] = "address",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_bits] = "bits",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_filename] = "filename",
  [field_function] = "function",
  [field_label] = "label",
  [field_left] = "left",
  [field_length] = "length",
  [field_name] = "name",
  [field_offset] = "offset",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_right] = "right",
  [field_size] = "size",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 2},
  [6] = {.index = 6, .length = 1},
  [7] = {.index = 7, .length = 2},
  [8] = {.index = 9, .length = 2},
  [9] = {.index = 11, .length = 2},
  [10] = {.index = 13, .length = 1},
  [11] = {.index = 14, .length = 2},
  [12] = {.index = 16, .length = 2},
  [13] = {.index = 18, .length = 3},
  [14] = {.index = 21, .length = 1},
  [15] = {.index = 22, .length = 2},
  [16] = {.index = 24, .length = 2},
  [17] = {.index = 26, .length = 2},
  [18] = {.index = 28, .length = 3},
  [19] = {.index = 31, .length = 3},
  [20] = {.index = 34, .length = 2},
  [21] = {.index = 36, .length = 2},
  [22] = {.index = 38, .length = 3},
  [23] = {.index = 41, .length = 3},
  [24] = {.index = 44, .length = 2},
  [25] = {.index = 46, .length = 2},
  [26] = {.index = 48, .length = 2},
  [27] = {.index = 50, .length = 3},
  [28] = {.index = 53, .length = 3},
  [29] = {.index = 56, .length = 3},
  [30] = {.index = 59, .length = 3},
  [31] = {.index = 62, .length = 4},
  [32] = {.index = 66, .length = 1},
  [33] = {.index = 67, .length = 4},
  [34] = {.index = 71, .length = 4},
  [35] = {.index = 75, .length = 4},
  [36] = {.index = 79, .length = 5},
  [37] = {.index = 84, .length = 3},
  [38] = {.index = 87, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_label, 0, .inherited = true},
  [1] =
    {field_label, 1},
  [2] =
    {field_path, 1},
  [3] =
    {field_label, 0},
  [4] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [6] =
    {field_name, 1},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_argument, 1},
    {field_operator, 0},
  [11] =
    {field_address, 1},
    {field_length, 2},
  [13] =
    {field_name, 0},
  [14] =
    {field_name, 1},
    {field_value, 2},
  [16] =
    {field_name, 1},
    {field_parameters, 2},
  [18] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [21] =
    {field_condition, 1},
  [22] =
    {field_alternative, 2},
    {field_name, 1},
  [24] =
    {field_label, 0, .inherited = true},
    {field_name, 1},
  [26] =
    {field_address, 3},
    {field_name, 1},
  [28] =
    {field_address, 2},
    {field_address, 3},
    {field_name, 1},
  [31] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [34] =
    {field_alternative, 3},
    {field_condition, 1},
  [36] =
    {field_alternative, 3},
    {field_name, 1},
  [38] =
    {field_address, 2},
    {field_label, 0, .inherited = true},
    {field_length, 3},
  [41] =
    {field_address, 1},
    {field_address, 2},
    {field_name, 0},
  [44] =
    {field_bits, 2},
    {field_name, 0},
  [46] =
    {field_name, 0},
    {field_value, 2},
  [48] =
    {field_alternative, 4},
    {field_condition, 1},
  [50] =
    {field_bits, 2},
    {field_name, 0},
    {field_value, 3},
  [53] =
    {field_name, 0},
    {field_value, 2},
    {field_value, 3},
  [56] =
    {field_bits, 3},
    {field_label, 0, .inherited = true},
    {field_name, 1},
  [59] =
    {field_label, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3},
  [62] =
    {field_address, 2},
    {field_address, 3},
    {field_label, 0, .inherited = true},
    {field_name, 1},
  [66] =
    {field_filename, 2},
  [67] =
    {field_bits, 2},
    {field_name, 0},
    {field_value, 3},
    {field_value, 4},
  [71] =
    {field_bits, 3},
    {field_label, 0, .inherited = true},
    {field_name, 1},
    {field_value, 4},
  [75] =
    {field_label, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3},
    {field_value, 4},
  [79] =
    {field_bits, 3},
    {field_label, 0, .inherited = true},
    {field_name, 1},
    {field_value, 4},
    {field_value, 5},
  [84] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [87] =
    {field_filename, 2},
    {field_offset, 4},
    {field_size, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 3,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 12,
  [14] = 14,
  [15] = 14,
  [16] = 16,
  [17] = 14,
  [18] = 8,
  [19] = 8,
  [20] = 14,
  [21] = 8,
  [22] = 16,
  [23] = 6,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 27,
  [30] = 26,
  [31] = 26,
  [32] = 27,
  [33] = 27,
  [34] = 26,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 24,
  [39] = 39,
  [40] = 40,
  [41] = 39,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 24,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 24,
  [60] = 60,
  [61] = 49,
  [62] = 60,
  [63] = 53,
  [64] = 54,
  [65] = 56,
  [66] = 57,
  [67] = 58,
  [68] = 68,
  [69] = 40,
  [70] = 39,
  [71] = 42,
  [72] = 43,
  [73] = 45,
  [74] = 46,
  [75] = 47,
  [76] = 50,
  [77] = 51,
  [78] = 52,
  [79] = 49,
  [80] = 60,
  [81] = 53,
  [82] = 54,
  [83] = 56,
  [84] = 57,
  [85] = 58,
  [86] = 68,
  [87] = 40,
  [88] = 39,
  [89] = 42,
  [90] = 43,
  [91] = 45,
  [92] = 46,
  [93] = 47,
  [94] = 68,
  [95] = 51,
  [96] = 52,
  [97] = 49,
  [98] = 60,
  [99] = 53,
  [100] = 54,
  [101] = 56,
  [102] = 57,
  [103] = 58,
  [104] = 68,
  [105] = 40,
  [106] = 39,
  [107] = 42,
  [108] = 43,
  [109] = 45,
  [110] = 46,
  [111] = 47,
  [112] = 50,
  [113] = 51,
  [114] = 52,
  [115] = 49,
  [116] = 60,
  [117] = 53,
  [118] = 54,
  [119] = 56,
  [120] = 57,
  [121] = 58,
  [122] = 68,
  [123] = 40,
  [124] = 42,
  [125] = 43,
  [126] = 45,
  [127] = 46,
  [128] = 47,
  [129] = 50,
  [130] = 51,
  [131] = 52,
  [132] = 49,
  [133] = 60,
  [134] = 53,
  [135] = 54,
  [136] = 56,
  [137] = 57,
  [138] = 58,
  [139] = 68,
  [140] = 40,
  [141] = 39,
  [142] = 42,
  [143] = 43,
  [144] = 45,
  [145] = 46,
  [146] = 47,
  [147] = 50,
  [148] = 51,
  [149] = 52,
  [150] = 50,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 213,
  [215] = 215,
  [216] = 216,
  [217] = 216,
  [218] = 198,
  [219] = 166,
  [220] = 167,
  [221] = 158,
  [222] = 171,
  [223] = 174,
  [224] = 195,
  [225] = 157,
  [226] = 159,
  [227] = 160,
  [228] = 162,
  [229] = 176,
  [230] = 178,
  [231] = 180,
  [232] = 181,
  [233] = 182,
  [234] = 186,
  [235] = 187,
  [236] = 188,
  [237] = 191,
  [238] = 192,
  [239] = 193,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 189,
  [262] = 172,
  [263] = 194,
  [264] = 179,
  [265] = 184,
  [266] = 164,
  [267] = 163,
  [268] = 268,
  [269] = 166,
  [270] = 270,
  [271] = 167,
  [272] = 158,
  [273] = 171,
  [274] = 174,
  [275] = 195,
  [276] = 276,
  [277] = 157,
  [278] = 159,
  [279] = 160,
  [280] = 162,
  [281] = 176,
  [282] = 178,
  [283] = 180,
  [284] = 181,
  [285] = 182,
  [286] = 186,
  [287] = 287,
  [288] = 187,
  [289] = 188,
  [290] = 173,
  [291] = 192,
  [292] = 193,
  [293] = 197,
  [294] = 294,
  [295] = 165,
  [296] = 189,
  [297] = 172,
  [298] = 194,
  [299] = 169,
  [300] = 170,
  [301] = 196,
  [302] = 179,
  [303] = 184,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 183,
  [308] = 161,
  [309] = 309,
  [310] = 164,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 163,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 168,
  [325] = 325,
  [326] = 156,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 175,
  [336] = 177,
  [337] = 185,
  [338] = 190,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 191,
  [348] = 348,
  [349] = 306,
  [350] = 311,
  [351] = 312,
  [352] = 313,
  [353] = 314,
  [354] = 315,
  [355] = 316,
  [356] = 317,
  [357] = 357,
  [358] = 358,
  [359] = 318,
  [360] = 325,
  [361] = 319,
  [362] = 321,
  [363] = 322,
  [364] = 323,
  [365] = 365,
  [366] = 366,
  [367] = 366,
  [368] = 365,
  [369] = 366,
  [370] = 358,
  [371] = 304,
  [372] = 333,
  [373] = 334,
  [374] = 366,
  [375] = 305,
  [376] = 191,
  [377] = 163,
  [378] = 166,
  [379] = 167,
  [380] = 158,
  [381] = 171,
  [382] = 174,
  [383] = 195,
  [384] = 157,
  [385] = 159,
  [386] = 160,
  [387] = 162,
  [388] = 176,
  [389] = 178,
  [390] = 180,
  [391] = 181,
  [392] = 182,
  [393] = 186,
  [394] = 187,
  [395] = 188,
  [396] = 294,
  [397] = 192,
  [398] = 193,
  [399] = 243,
  [400] = 244,
  [401] = 245,
  [402] = 246,
  [403] = 247,
  [404] = 248,
  [405] = 241,
  [406] = 242,
  [407] = 249,
  [408] = 250,
  [409] = 251,
  [410] = 252,
  [411] = 253,
  [412] = 240,
  [413] = 255,
  [414] = 256,
  [415] = 258,
  [416] = 259,
  [417] = 260,
  [418] = 309,
  [419] = 189,
  [420] = 172,
  [421] = 327,
  [422] = 328,
  [423] = 329,
  [424] = 330,
  [425] = 331,
  [426] = 332,
  [427] = 194,
  [428] = 179,
  [429] = 184,
  [430] = 339,
  [431] = 340,
  [432] = 341,
  [433] = 342,
  [434] = 343,
  [435] = 344,
  [436] = 345,
  [437] = 346,
  [438] = 164,
  [439] = 268,
  [440] = 254,
  [441] = 441,
  [442] = 442,
  [443] = 442,
  [444] = 444,
  [445] = 445,
  [446] = 441,
  [447] = 442,
  [448] = 444,
  [449] = 445,
  [450] = 442,
  [451] = 444,
  [452] = 445,
  [453] = 441,
  [454] = 444,
  [455] = 445,
  [456] = 441,
  [457] = 159,
  [458] = 159,
  [459] = 160,
  [460] = 162,
  [461] = 176,
  [462] = 178,
  [463] = 180,
  [464] = 181,
  [465] = 182,
  [466] = 186,
  [467] = 187,
  [468] = 188,
  [469] = 191,
  [470] = 192,
  [471] = 193,
  [472] = 184,
  [473] = 194,
  [474] = 339,
  [475] = 163,
  [476] = 339,
  [477] = 340,
  [478] = 166,
  [479] = 167,
  [480] = 341,
  [481] = 340,
  [482] = 341,
  [483] = 342,
  [484] = 343,
  [485] = 344,
  [486] = 345,
  [487] = 342,
  [488] = 346,
  [489] = 343,
  [490] = 260,
  [491] = 344,
  [492] = 345,
  [493] = 346,
  [494] = 327,
  [495] = 189,
  [496] = 172,
  [497] = 194,
  [498] = 328,
  [499] = 179,
  [500] = 184,
  [501] = 164,
  [502] = 158,
  [503] = 171,
  [504] = 163,
  [505] = 174,
  [506] = 166,
  [507] = 167,
  [508] = 158,
  [509] = 329,
  [510] = 268,
  [511] = 259,
  [512] = 195,
  [513] = 157,
  [514] = 258,
  [515] = 330,
  [516] = 160,
  [517] = 162,
  [518] = 240,
  [519] = 241,
  [520] = 242,
  [521] = 243,
  [522] = 244,
  [523] = 245,
  [524] = 176,
  [525] = 178,
  [526] = 180,
  [527] = 181,
  [528] = 182,
  [529] = 246,
  [530] = 331,
  [531] = 247,
  [532] = 248,
  [533] = 268,
  [534] = 327,
  [535] = 249,
  [536] = 328,
  [537] = 186,
  [538] = 187,
  [539] = 188,
  [540] = 250,
  [541] = 251,
  [542] = 252,
  [543] = 253,
  [544] = 294,
  [545] = 254,
  [546] = 255,
  [547] = 256,
  [548] = 191,
  [549] = 192,
  [550] = 193,
  [551] = 329,
  [552] = 330,
  [553] = 171,
  [554] = 331,
  [555] = 174,
  [556] = 332,
  [557] = 195,
  [558] = 240,
  [559] = 241,
  [560] = 242,
  [561] = 243,
  [562] = 244,
  [563] = 245,
  [564] = 246,
  [565] = 247,
  [566] = 248,
  [567] = 332,
  [568] = 179,
  [569] = 249,
  [570] = 258,
  [571] = 259,
  [572] = 260,
  [573] = 309,
  [574] = 157,
  [575] = 250,
  [576] = 251,
  [577] = 252,
  [578] = 253,
  [579] = 254,
  [580] = 255,
  [581] = 256,
  [582] = 172,
  [583] = 309,
  [584] = 189,
  [585] = 164,
  [586] = 294,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 587,
  [592] = 588,
  [593] = 588,
  [594] = 594,
  [595] = 589,
  [596] = 589,
  [597] = 590,
  [598] = 587,
  [599] = 588,
  [600] = 590,
  [601] = 589,
  [602] = 590,
  [603] = 587,
  [604] = 594,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 606,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 613,
  [625] = 608,
  [626] = 614,
  [627] = 608,
  [628] = 628,
  [629] = 607,
  [630] = 618,
  [631] = 622,
  [632] = 617,
  [633] = 612,
  [634] = 623,
  [635] = 610,
  [636] = 628,
  [637] = 608,
  [638] = 609,
  [639] = 609,
  [640] = 609,
  [641] = 605,
  [642] = 621,
  [643] = 643,
  [644] = 644,
  [645] = 643,
  [646] = 643,
  [647] = 647,
  [648] = 643,
  [649] = 643,
  [650] = 643,
  [651] = 651,
  [652] = 647,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 653,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 653,
  [675] = 653,
  [676] = 653,
  [677] = 653,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 678,
  [682] = 678,
  [683] = 678,
  [684] = 684,
  [685] = 678,
  [686] = 678,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 691,
  [693] = 693,
  [694] = 691,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 696,
  [700] = 696,
  [701] = 696,
  [702] = 698,
  [703] = 703,
  [704] = 703,
  [705] = 705,
  [706] = 706,
  [707] = 705,
  [708] = 706,
  [709] = 698,
  [710] = 703,
  [711] = 705,
  [712] = 706,
  [713] = 705,
  [714] = 706,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 716,
  [719] = 716,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 721,
  [725] = 715,
  [726] = 717,
  [727] = 715,
  [728] = 722,
  [729] = 722,
  [730] = 730,
  [731] = 715,
  [732] = 715,
  [733] = 722,
  [734] = 717,
  [735] = 735,
  [736] = 717,
  [737] = 721,
  [738] = 721,
  [739] = 715,
  [740] = 716,
  [741] = 741,
  [742] = 742,
  [743] = 720,
  [744] = 720,
  [745] = 722,
  [746] = 720,
  [747] = 722,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 748,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 197,
  [764] = 764,
  [765] = 765,
  [766] = 760,
  [767] = 767,
  [768] = 761,
  [769] = 769,
  [770] = 762,
  [771] = 165,
  [772] = 759,
  [773] = 749,
  [774] = 769,
  [775] = 750,
  [776] = 751,
  [777] = 752,
  [778] = 753,
  [779] = 754,
  [780] = 755,
  [781] = 756,
  [782] = 757,
  [783] = 748,
  [784] = 784,
  [785] = 760,
  [786] = 761,
  [787] = 762,
  [788] = 754,
  [789] = 789,
  [790] = 759,
  [791] = 749,
  [792] = 750,
  [793] = 793,
  [794] = 769,
  [795] = 751,
  [796] = 755,
  [797] = 797,
  [798] = 752,
  [799] = 753,
  [800] = 754,
  [801] = 755,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 756,
  [806] = 757,
  [807] = 748,
  [808] = 784,
  [809] = 809,
  [810] = 760,
  [811] = 789,
  [812] = 761,
  [813] = 803,
  [814] = 762,
  [815] = 803,
  [816] = 804,
  [817] = 756,
  [818] = 757,
  [819] = 803,
  [820] = 804,
  [821] = 803,
  [822] = 784,
  [823] = 823,
  [824] = 759,
  [825] = 749,
  [826] = 803,
  [827] = 804,
  [828] = 804,
  [829] = 750,
  [830] = 751,
  [831] = 752,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 803,
  [837] = 804,
  [838] = 804,
  [839] = 769,
  [840] = 803,
  [841] = 804,
  [842] = 753,
  [843] = 784,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 849,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 848,
  [857] = 857,
  [858] = 850,
  [859] = 849,
  [860] = 855,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 854,
  [865] = 848,
  [866] = 850,
  [867] = 867,
  [868] = 862,
  [869] = 869,
  [870] = 848,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 873,
  [877] = 849,
  [878] = 850,
  [879] = 879,
  [880] = 854,
  [881] = 873,
  [882] = 849,
  [883] = 883,
  [884] = 854,
  [885] = 862,
  [886] = 886,
  [887] = 850,
  [888] = 888,
  [889] = 849,
  [890] = 890,
  [891] = 891,
  [892] = 850,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 854,
  [897] = 862,
  [898] = 845,
  [899] = 873,
  [900] = 900,
  [901] = 857,
  [902] = 874,
  [903] = 863,
  [904] = 845,
  [905] = 862,
  [906] = 857,
  [907] = 863,
  [908] = 908,
  [909] = 845,
  [910] = 853,
  [911] = 857,
  [912] = 863,
  [913] = 845,
  [914] = 862,
  [915] = 857,
  [916] = 863,
  [917] = 845,
  [918] = 857,
  [919] = 863,
  [920] = 920,
  [921] = 895,
  [922] = 846,
  [923] = 852,
  [924] = 855,
  [925] = 895,
  [926] = 846,
  [927] = 852,
  [928] = 855,
  [929] = 895,
  [930] = 846,
  [931] = 852,
  [932] = 855,
  [933] = 895,
  [934] = 846,
  [935] = 852,
  [936] = 855,
  [937] = 895,
  [938] = 846,
  [939] = 852,
  [940] = 854,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 953,
  [964] = 954,
  [965] = 955,
  [966] = 958,
  [967] = 962,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 942,
  [972] = 943,
  [973] = 944,
  [974] = 945,
  [975] = 946,
  [976] = 947,
  [977] = 948,
  [978] = 949,
  [979] = 950,
  [980] = 951,
  [981] = 952,
  [982] = 968,
  [983] = 969,
  [984] = 984,
  [985] = 985,
  [986] = 986,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 990,
  [991] = 970,
  [992] = 992,
  [993] = 993,
  [994] = 994,
  [995] = 994,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 959,
  [1001] = 1001,
  [1002] = 962,
  [1003] = 1003,
  [1004] = 942,
  [1005] = 956,
  [1006] = 943,
  [1007] = 944,
  [1008] = 945,
  [1009] = 946,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 957,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 968,
  [1017] = 942,
  [1018] = 943,
  [1019] = 984,
  [1020] = 985,
  [1021] = 1021,
  [1022] = 944,
  [1023] = 992,
  [1024] = 969,
  [1025] = 945,
  [1026] = 947,
  [1027] = 948,
  [1028] = 949,
  [1029] = 1029,
  [1030] = 959,
  [1031] = 946,
  [1032] = 1010,
  [1033] = 1033,
  [1034] = 961,
  [1035] = 1035,
  [1036] = 1013,
  [1037] = 960,
  [1038] = 1038,
  [1039] = 1015,
  [1040] = 197,
  [1041] = 997,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 950,
  [1045] = 951,
  [1046] = 952,
  [1047] = 1001,
  [1048] = 984,
  [1049] = 985,
  [1050] = 984,
  [1051] = 1038,
  [1052] = 992,
  [1053] = 992,
  [1054] = 961,
  [1055] = 1055,
  [1056] = 947,
  [1057] = 942,
  [1058] = 985,
  [1059] = 1059,
  [1060] = 943,
  [1061] = 1061,
  [1062] = 956,
  [1063] = 944,
  [1064] = 986,
  [1065] = 945,
  [1066] = 1066,
  [1067] = 1061,
  [1068] = 946,
  [1069] = 1069,
  [1070] = 1010,
  [1071] = 948,
  [1072] = 165,
  [1073] = 957,
  [1074] = 949,
  [1075] = 959,
  [1076] = 960,
  [1077] = 984,
  [1078] = 985,
  [1079] = 1029,
  [1080] = 1080,
  [1081] = 1029,
  [1082] = 941,
  [1083] = 950,
  [1084] = 1013,
  [1085] = 949,
  [1086] = 1035,
  [1087] = 1069,
  [1088] = 958,
  [1089] = 970,
  [1090] = 1069,
  [1091] = 951,
  [1092] = 950,
  [1093] = 953,
  [1094] = 954,
  [1095] = 955,
  [1096] = 953,
  [1097] = 958,
  [1098] = 962,
  [1099] = 968,
  [1100] = 969,
  [1101] = 970,
  [1102] = 984,
  [1103] = 985,
  [1104] = 951,
  [1105] = 994,
  [1106] = 952,
  [1107] = 987,
  [1108] = 954,
  [1109] = 1014,
  [1110] = 1061,
  [1111] = 1111,
  [1112] = 956,
  [1113] = 1113,
  [1114] = 942,
  [1115] = 943,
  [1116] = 944,
  [1117] = 945,
  [1118] = 946,
  [1119] = 1010,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 955,
  [1123] = 996,
  [1124] = 1013,
  [1125] = 1059,
  [1126] = 953,
  [1127] = 1127,
  [1128] = 954,
  [1129] = 998,
  [1130] = 956,
  [1131] = 1066,
  [1132] = 955,
  [1133] = 994,
  [1134] = 957,
  [1135] = 941,
  [1136] = 1120,
  [1137] = 947,
  [1138] = 1080,
  [1139] = 993,
  [1140] = 1043,
  [1141] = 1141,
  [1142] = 998,
  [1143] = 957,
  [1144] = 947,
  [1145] = 948,
  [1146] = 941,
  [1147] = 1120,
  [1148] = 949,
  [1149] = 1080,
  [1150] = 993,
  [1151] = 1043,
  [1152] = 1029,
  [1153] = 998,
  [1154] = 959,
  [1155] = 960,
  [1156] = 1156,
  [1157] = 941,
  [1158] = 1120,
  [1159] = 960,
  [1160] = 1080,
  [1161] = 993,
  [1162] = 1043,
  [1163] = 1003,
  [1164] = 998,
  [1165] = 952,
  [1166] = 1055,
  [1167] = 961,
  [1168] = 1156,
  [1169] = 1120,
  [1170] = 1080,
  [1171] = 993,
  [1172] = 1043,
  [1173] = 950,
  [1174] = 998,
  [1175] = 948,
  [1176] = 951,
  [1177] = 952,
  [1178] = 941,
  [1179] = 1120,
  [1180] = 1080,
  [1181] = 993,
  [1182] = 1043,
  [1183] = 1111,
  [1184] = 1069,
  [1185] = 958,
  [1186] = 1186,
  [1187] = 962,
  [1188] = 968,
  [1189] = 956,
  [1190] = 957,
  [1191] = 969,
  [1192] = 959,
  [1193] = 960,
  [1194] = 961,
  [1195] = 970,
  [1196] = 953,
  [1197] = 954,
  [1198] = 955,
  [1199] = 958,
  [1200] = 962,
  [1201] = 968,
  [1202] = 969,
  [1203] = 970,
  [1204] = 961,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(134);
      ADVANCE_MAP(
        '!', 322,
        '"', 288,
        '#', 73,
        '%', 327,
        '&', 267,
        '(', 342,
        ')', 283,
        '*', 326,
        '+', 325,
        ',', 278,
        '-', 324,
        '.', 59,
        '/', 269,
        '0', 302,
        ':', 135,
        ';', 137,
        '<', 285,
        '=', 277,
        '>', 287,
        '?', 320,
        '@', 270,
        '[', 300,
      );
      if (lookahead == '\\') SKIP(129);
      if (lookahead == ']') ADVANCE(301);
      if (lookahead == '^') ADVANCE(331);
      if (lookahead == 'd') ADVANCE(304);
      if (lookahead == '{') ADVANCE(274);
      if (lookahead == '|') ADVANCE(330);
      if (lookahead == '}') ADVANCE(272);
      if (lookahead == '~') ADVANCE(323);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(132);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(303);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= '_') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(49);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(49);
      if (lookahead == '\r') SKIP(1);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(46);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(46);
      if (lookahead == '\r') SKIP(3);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(47);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(47);
      if (lookahead == '\r') SKIP(5);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(42);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(42);
      if (lookahead == '\r') SKIP(7);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(11);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(11);
      if (lookahead == '\r') SKIP(9);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '\n', 360,
        '!', 66,
        '%', 327,
        '&', 266,
        '(', 282,
        '*', 326,
        '+', 325,
        '-', 324,
        '/', 269,
        '<', 285,
        '=', 67,
        '>', 287,
      );
      if (lookahead == '\\') SKIP(10);
      if (lookahead == '^') ADVANCE(331);
      if (lookahead == '|') ADVANCE(330);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(44);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(44);
      if (lookahead == '\r') SKIP(12);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(51);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(51);
      if (lookahead == '\r') SKIP(14);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(52);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(52);
      if (lookahead == '\r') SKIP(16);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(43);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(43);
      if (lookahead == '\r') SKIP(18);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(45);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '\\') ADVANCE(21);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(292);
      if (lookahead != 0) ADVANCE(293);
      END_STATE();
    case 21:
      if (lookahead == '\n') ADVANCE(295);
      if (lookahead == '\r') ADVANCE(294);
      if (lookahead == 'U') ADVANCE(127);
      if (lookahead == 'u') ADVANCE(123);
      if (lookahead == 'x') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(297);
      if (lookahead != 0) ADVANCE(294);
      END_STATE();
    case 22:
      ADVANCE_MAP(
        '\n', 340,
        '\r', 347,
        '(', 342,
        '/', 354,
        '\\', 348,
        '\t', 350,
        0x0b, 350,
        '\f', 350,
        ' ', 350,
      );
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(340);
      if (lookahead == '\r') ADVANCE(347);
      if (lookahead == '/') ADVANCE(354);
      if (lookahead == '\\') ADVANCE(348);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(350);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 24:
      if (lookahead == '\n') ADVANCE(340);
      if (lookahead == '\r') ADVANCE(25);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(34);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(65);
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(340);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(34);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(26);
      if (lookahead == '/') ADVANCE(354);
      if (lookahead == '\\') ADVANCE(348);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(350);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(62);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(62);
      if (lookahead == '\r') SKIP(27);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(63);
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(63);
      if (lookahead == '\r') SKIP(29);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(64);
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(64);
      if (lookahead == '\r') SKIP(31);
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(65);
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(65);
      if (lookahead == '\r') SKIP(33);
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(53);
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(53);
      if (lookahead == '\r') SKIP(35);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(48);
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(48);
      if (lookahead == '\r') SKIP(37);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(50);
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(50);
      if (lookahead == '\r') SKIP(39);
      END_STATE();
    case 41:
      if (lookahead == '\r') ADVANCE(144);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 42:
      ADVANCE_MAP(
        '!', 66,
        '%', 327,
        '&', 267,
        '(', 282,
        ')', 283,
        '*', 326,
        '+', 325,
        ',', 278,
        '-', 324,
        '.', 59,
        '/', 269,
        '0', 310,
        ':', 135,
        ';', 137,
        '<', 285,
        '=', 67,
        '>', 287,
        '?', 320,
      );
      if (lookahead == '\\') SKIP(8);
      if (lookahead == '^') ADVANCE(331);
      if (lookahead == '{') ADVANCE(274);
      if (lookahead == '|') ADVANCE(330);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(42);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 43:
      ADVANCE_MAP(
        '!', 321,
        '"', 288,
        '&', 268,
        '(', 282,
        ')', 283,
        '+', 325,
        ',', 278,
        '-', 324,
        '/', 269,
        '0', 310,
        ':', 135,
        ';', 137,
        '<', 68,
        '=', 276,
        '>', 286,
        '@', 270,
      );
      if (lookahead == '\\') SKIP(19);
      if (lookahead == '{') ADVANCE(274);
      if (lookahead == '}') ADVANCE(272);
      if (lookahead == '~') ADVANCE(323);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 44:
      ADVANCE_MAP(
        '!', 321,
        '"', 288,
        '&', 268,
        '(', 282,
        ')', 283,
        '+', 325,
        '-', 324,
        '/', 55,
        '0', 310,
        ';', 137,
        '<', 284,
        '[', 300,
      );
      if (lookahead == '\\') SKIP(13);
      if (lookahead == 'd') ADVANCE(315);
      if (lookahead == '~') ADVANCE(323);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 45:
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') ADVANCE(21);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(45);
      END_STATE();
    case 46:
      if (lookahead == '#') ADVANCE(226);
      if (lookahead == '&') ADVANCE(268);
      if (lookahead == '/') ADVANCE(148);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '\\') SKIP(4);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(46);
      if (('+' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(220);
      END_STATE();
    case 47:
      if (lookahead == '#') ADVANCE(229);
      if (lookahead == '&') ADVANCE(268);
      if (lookahead == '/') ADVANCE(148);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '\\') SKIP(6);
      if (lookahead == '}') ADVANCE(272);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('+' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(220);
      END_STATE();
    case 48:
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '&') ADVANCE(268);
      if (lookahead == '/') ADVANCE(148);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '\\') SKIP(38);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(48);
      if (('+' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(220);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '&') ADVANCE(268);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead == '\\') SKIP(2);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (('+' <= lookahead && lookahead <= '9')) ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(221);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(228);
      if (lookahead == '&') ADVANCE(268);
      if (lookahead == '/') ADVANCE(148);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '\\') SKIP(40);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50);
      if (('+' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(220);
      END_STATE();
    case 51:
      if (lookahead == '&') ADVANCE(268);
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') SKIP(15);
      if (lookahead == '#' ||
          lookahead == '?') ADVANCE(265);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51);
      if (('+' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(220);
      END_STATE();
    case 52:
      if (lookahead == '&') ADVANCE(268);
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') SKIP(17);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52);
      if (('+' <= lookahead && lookahead <= '9')) ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(221);
      END_STATE();
    case 53:
      if (lookahead == '&') ADVANCE(268);
      if (lookahead == '/') ADVANCE(149);
      if (lookahead == '\\') SKIP(36);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (('+' <= lookahead && lookahead <= '9')) ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(221);
      END_STATE();
    case 54:
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(143);
      END_STATE();
    case 55:
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == 'b') ADVANCE(101);
      if (lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 56:
      if (lookahead == '*') ADVANCE(56);
      if (lookahead == '/') ADVANCE(140);
      if (lookahead != 0) ADVANCE(57);
      END_STATE();
    case 57:
      if (lookahead == '*') ADVANCE(56);
      if (lookahead != 0) ADVANCE(57);
      END_STATE();
    case 58:
      if (lookahead == '.') ADVANCE(343);
      END_STATE();
    case 59:
      if (lookahead == '.') ADVANCE(58);
      END_STATE();
    case 60:
      if (lookahead == '/') ADVANCE(275);
      END_STATE();
    case 61:
      if (lookahead == '/') ADVANCE(281);
      END_STATE();
    case 62:
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(28);
      if (lookahead == ']') ADVANCE(301);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(309);
      END_STATE();
    case 63:
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(30);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(224);
      END_STATE();
    case 64:
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(32);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(64);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(222);
      END_STATE();
    case 65:
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(34);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      END_STATE();
    case 66:
      if (lookahead == '=') ADVANCE(333);
      END_STATE();
    case 67:
      if (lookahead == '=') ADVANCE(332);
      END_STATE();
    case 68:
      if (lookahead == '>') ADVANCE(298);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(68);
      END_STATE();
    case 69:
      if (lookahead == '>') ADVANCE(299);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(68);
      END_STATE();
    case 70:
      if (lookahead == 'b') ADVANCE(105);
      END_STATE();
    case 71:
      if (lookahead == 'c') ADVANCE(108);
      END_STATE();
    case 72:
      if (lookahead == 'c') ADVANCE(70);
      END_STATE();
    case 73:
      if (lookahead == 'd') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(107);
      if (lookahead == 'i') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(73);
      END_STATE();
    case 74:
      if (lookahead == 'd') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(110);
      if (lookahead == 'i') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(74);
      END_STATE();
    case 75:
      if (lookahead == 'd') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(109);
      if (lookahead == 'i') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(75);
      END_STATE();
    case 76:
      if (lookahead == 'd') ADVANCE(82);
      if (lookahead == 'i') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(76);
      END_STATE();
    case 77:
      if (lookahead == 'd') ADVANCE(104);
      END_STATE();
    case 78:
      if (lookahead == 'd') ADVANCE(85);
      END_STATE();
    case 79:
      if (lookahead == 'd') ADVANCE(87);
      END_STATE();
    case 80:
      if (lookahead == 'd') ADVANCE(88);
      END_STATE();
    case 81:
      if (lookahead == 'd') ADVANCE(90);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(364);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(339);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 91:
      if (lookahead == 'f') ADVANCE(358);
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 92:
      if (lookahead == 'f') ADVANCE(102);
      END_STATE();
    case 93:
      if (lookahead == 'f') ADVANCE(366);
      END_STATE();
    case 94:
      if (lookahead == 'f') ADVANCE(361);
      END_STATE();
    case 95:
      if (lookahead == 'f') ADVANCE(362);
      END_STATE();
    case 96:
      if (lookahead == 'f') ADVANCE(344);
      END_STATE();
    case 97:
      if (lookahead == 'f') ADVANCE(363);
      END_STATE();
    case 98:
      if (lookahead == 'f') ADVANCE(368);
      END_STATE();
    case 99:
      if (lookahead == 'f') ADVANCE(369);
      END_STATE();
    case 100:
      if (lookahead == 'f') ADVANCE(365);
      END_STATE();
    case 101:
      if (lookahead == 'i') ADVANCE(116);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(114);
      END_STATE();
    case 103:
      if (lookahead == 'i') ADVANCE(93);
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 104:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(113);
      END_STATE();
    case 106:
      if (lookahead == 'i') ADVANCE(100);
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(103);
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 108:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 109:
      if (lookahead == 'l') ADVANCE(106);
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 110:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 112:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 113:
      if (lookahead == 'n') ADVANCE(61);
      END_STATE();
    case 114:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 115:
      if (lookahead == 's') ADVANCE(60);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 117:
      if (lookahead == 'u') ADVANCE(78);
      END_STATE();
    case 118:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      END_STATE();
    case 119:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(312);
      END_STATE();
    case 120:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(294);
      END_STATE();
    case 121:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(120);
      END_STATE();
    case 122:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(121);
      END_STATE();
    case 123:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 124:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(123);
      END_STATE();
    case 125:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(124);
      END_STATE();
    case 126:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      END_STATE();
    case 127:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 128:
      if (eof) ADVANCE(134);
      if (lookahead == '\n') SKIP(132);
      END_STATE();
    case 129:
      if (eof) ADVANCE(134);
      if (lookahead == '\n') SKIP(132);
      if (lookahead == '\r') SKIP(128);
      END_STATE();
    case 130:
      if (eof) ADVANCE(134);
      if (lookahead == '\n') SKIP(133);
      END_STATE();
    case 131:
      if (eof) ADVANCE(134);
      if (lookahead == '\n') SKIP(133);
      if (lookahead == '\r') SKIP(130);
      END_STATE();
    case 132:
      if (eof) ADVANCE(134);
      ADVANCE_MAP(
        '!', 322,
        '"', 288,
        '#', 73,
        '%', 327,
        '&', 267,
        '(', 282,
        ')', 283,
        '*', 326,
        '+', 325,
        ',', 278,
        '-', 324,
        '.', 59,
        '/', 269,
        '0', 302,
        ':', 135,
        ';', 137,
        '<', 285,
        '=', 277,
        '>', 287,
        '?', 320,
        '@', 270,
        '[', 300,
      );
      if (lookahead == '\\') SKIP(129);
      if (lookahead == ']') ADVANCE(301);
      if (lookahead == '^') ADVANCE(331);
      if (lookahead == 'd') ADVANCE(304);
      if (lookahead == '{') ADVANCE(274);
      if (lookahead == '|') ADVANCE(330);
      if (lookahead == '}') ADVANCE(272);
      if (lookahead == '~') ADVANCE(323);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(132);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(303);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= '_') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 133:
      if (eof) ADVANCE(134);
      ADVANCE_MAP(
        '#', 73,
        '&', 268,
        '(', 282,
        '/', 147,
        ':', 135,
        ';', 137,
        '=', 276,
        '@', 270,
      );
      if (lookahead == '\\') SKIP(131);
      if (lookahead == '{') ADVANCE(274);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(133);
      if (('+' <= lookahead && lookahead <= '9')) ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(221);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_SLASHdts_DASHv1_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_SLASHplugin_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_SLASHmemreserve_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(145);
      if (lookahead == '\\') ADVANCE(353);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(145);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(41);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(143);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(353);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(145);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(353);
      if (lookahead != 0) ADVANCE(145);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == 'd') ADVANCE(169);
      if (lookahead == 'i') ADVANCE(194);
      if (lookahead == 'm') ADVANCE(168);
      if (lookahead == 'o') ADVANCE(192);
      if (lookahead == 'p') ADVANCE(188);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == 'd') ADVANCE(181);
      if (lookahead == 'o') ADVANCE(192);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == 'm') ADVANCE(168);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(142);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(216);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(195);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(196);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(186);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(198);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(207);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(136);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(138);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(338);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(139);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(279);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(273);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(280);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '1') ADVANCE(157);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'c') ADVANCE(190);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'd') ADVANCE(175);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'd') ADVANCE(178);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(193);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(189);
      if (lookahead == 't') ADVANCE(208);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(209);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(203);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(212);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(183);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(153);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(159);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(205);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(160);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(161);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(152);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(213);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(191);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'f') ADVANCE(155);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'f') ADVANCE(162);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'g') ADVANCE(187);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'i') ADVANCE(211);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'i') ADVANCE(182);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'i') ADVANCE(197);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'l') ADVANCE(214);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'l') ADVANCE(172);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'l') ADVANCE(215);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'l') ADVANCE(180);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'm') ADVANCE(185);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'm') ADVANCE(204);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'n') ADVANCE(165);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'n') ADVANCE(201);
      if (lookahead == 'p') ADVANCE(206);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'n') ADVANCE(201);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'n') ADVANCE(158);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'n') ADVANCE(200);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'o') ADVANCE(202);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'o') ADVANCE(156);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'o') ADVANCE(167);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'p') ADVANCE(176);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(217);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(170);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(210);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(199);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(173);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 's') ADVANCE(151);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 's') ADVANCE(171);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 't') ADVANCE(218);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 't') ADVANCE(154);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 't') ADVANCE(174);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 't') ADVANCE(179);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'u') ADVANCE(184);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'u') ADVANCE(166);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'v') ADVANCE(164);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'v') ADVANCE(177);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'y') ADVANCE(163);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym__node_path);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym__label_name_token1);
      if (lookahead == '#' ||
          lookahead == '?') ADVANCE(265);
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(220);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(aux_sym__label_name_token1);
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(221);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(aux_sym__label_name_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(222);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(aux_sym__node_name_token1);
      if (lookahead == '#' ||
          lookahead == '?') ADVANCE(265);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(aux_sym__node_name_token1);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(224);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'c') ADVANCE(259);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(258);
      if (lookahead == 'i') ADVANCE(252);
      if (lookahead == 'u') ADVANCE(262);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(73);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(261);
      if (lookahead == 'i') ADVANCE(252);
      if (lookahead == 'u') ADVANCE(262);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(74);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(260);
      if (lookahead == 'i') ADVANCE(252);
      if (lookahead == 'u') ADVANCE(262);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(75);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'i') ADVANCE(252);
      if (lookahead == 'u') ADVANCE(262);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(76);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'd') ADVANCE(256);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'd') ADVANCE(237);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'd') ADVANCE(240);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'd') ADVANCE(241);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'd') ADVANCE(243);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'e') ADVANCE(364);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'e') ADVANCE(341);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'e') ADVANCE(339);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'e') ADVANCE(251);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'e') ADVANCE(245);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'e') ADVANCE(246);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'e') ADVANCE(247);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'e') ADVANCE(248);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'e') ADVANCE(249);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(361);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(362);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(344);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(363);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(368);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(369);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(365);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(254);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(359);
      if (lookahead == 'n') ADVANCE(225);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'f') ADVANCE(367);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'i') ADVANCE(263);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'i') ADVANCE(253);
      if (lookahead == 's') ADVANCE(235);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'i') ADVANCE(244);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'i') ADVANCE(250);
      if (lookahead == 's') ADVANCE(235);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'l') ADVANCE(255);
      if (lookahead == 'n') ADVANCE(230);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'l') ADVANCE(264);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'l') ADVANCE(257);
      if (lookahead == 'n') ADVANCE(230);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'n') ADVANCE(230);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'n') ADVANCE(232);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'n') ADVANCE(236);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == 'u') ADVANCE(231);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(aux_sym__property_name_token1);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(265);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(329);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(329);
      if (lookahead == '{') ADVANCE(271);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '{') ADVANCE(271);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(143);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_AMP_LBRACE);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_SLASHbits_SLASH);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(332);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_SLASHdelete_DASHnode_SLASH);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_SLASHdelete_DASHproperty_SLASH);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_SLASHincbin_SLASH);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(336);
      if (lookahead == '=') ADVANCE(335);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(334);
      if (lookahead == '>') ADVANCE(337);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '/') ADVANCE(293);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(293);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(290);
      if (lookahead == '/') ADVANCE(293);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(290);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(292);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(293);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(293);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(21);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(294);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_system_lib_string);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_system_lib_string);
      if (lookahead == '>') ADVANCE(298);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(68);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (lookahead == '\'') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(307);
      if (lookahead == 'x') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(303);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(309);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (lookahead == '\'') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(303);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(309);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (lookahead == 'e') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (lookahead == 'f') ADVANCE(306);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (lookahead == 'i') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(303);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(309);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(309);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '\'') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(118);
      if (lookahead == 'x') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '\'') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '\'') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(312);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(333);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(328);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_SLASHinclude_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(aux_sym_preproc_include_token1);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(aux_sym_preproc_include_token2);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(aux_sym_preproc_def_token1);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(aux_sym_preproc_undef_token1);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(57);
      if (lookahead == '*') ADVANCE(345);
      if (lookahead == '/') ADVANCE(140);
      if (lookahead == '\\') ADVANCE(352);
      if (lookahead != 0) ADVANCE(346);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(57);
      if (lookahead == '*') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(352);
      if (lookahead != 0) ADVANCE(346);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(340);
      if (lookahead == '/') ADVANCE(354);
      if (lookahead == '\\') ADVANCE(348);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(350);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(350);
      if (lookahead == '\r') ADVANCE(349);
      if (lookahead == '\\') ADVANCE(351);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(350);
      if (lookahead == '\\') ADVANCE(351);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(26);
      if (lookahead == '/') ADVANCE(354);
      if (lookahead == '\\') ADVANCE(348);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(350);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(357);
      if (lookahead == '\\') ADVANCE(351);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(355);
      if (lookahead == '*') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(352);
      if (lookahead != 0) ADVANCE(346);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(146);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead != 0) ADVANCE(145);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == '/') ADVANCE(145);
      if (lookahead == '\\') ADVANCE(351);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(356);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(352);
      if (lookahead != 0) ADVANCE(346);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\\') ADVANCE(351);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(356);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\\') ADVANCE(351);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(86);
      if (lookahead == 'n') ADVANCE(80);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'n') ADVANCE(233);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(242);
      if (lookahead == 'n') ADVANCE(234);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_defined);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 133},
  [2] = {.lex_state = 133},
  [3] = {.lex_state = 133},
  [4] = {.lex_state = 133},
  [5] = {.lex_state = 133},
  [6] = {.lex_state = 133},
  [7] = {.lex_state = 49},
  [8] = {.lex_state = 46},
  [9] = {.lex_state = 49},
  [10] = {.lex_state = 49},
  [11] = {.lex_state = 49},
  [12] = {.lex_state = 49},
  [13] = {.lex_state = 49},
  [14] = {.lex_state = 46},
  [15] = {.lex_state = 46},
  [16] = {.lex_state = 49},
  [17] = {.lex_state = 46},
  [18] = {.lex_state = 46},
  [19] = {.lex_state = 46},
  [20] = {.lex_state = 46},
  [21] = {.lex_state = 46},
  [22] = {.lex_state = 49},
  [23] = {.lex_state = 49},
  [24] = {.lex_state = 46},
  [25] = {.lex_state = 50},
  [26] = {.lex_state = 50},
  [27] = {.lex_state = 50},
  [28] = {.lex_state = 50},
  [29] = {.lex_state = 50},
  [30] = {.lex_state = 50},
  [31] = {.lex_state = 50},
  [32] = {.lex_state = 50},
  [33] = {.lex_state = 50},
  [34] = {.lex_state = 50},
  [35] = {.lex_state = 133},
  [36] = {.lex_state = 133},
  [37] = {.lex_state = 133},
  [38] = {.lex_state = 50},
  [39] = {.lex_state = 47},
  [40] = {.lex_state = 47},
  [41] = {.lex_state = 47},
  [42] = {.lex_state = 47},
  [43] = {.lex_state = 47},
  [44] = {.lex_state = 48},
  [45] = {.lex_state = 47},
  [46] = {.lex_state = 47},
  [47] = {.lex_state = 47},
  [48] = {.lex_state = 48},
  [49] = {.lex_state = 47},
  [50] = {.lex_state = 47},
  [51] = {.lex_state = 47},
  [52] = {.lex_state = 47},
  [53] = {.lex_state = 47},
  [54] = {.lex_state = 47},
  [55] = {.lex_state = 48},
  [56] = {.lex_state = 47},
  [57] = {.lex_state = 47},
  [58] = {.lex_state = 47},
  [59] = {.lex_state = 47},
  [60] = {.lex_state = 47},
  [61] = {.lex_state = 47},
  [62] = {.lex_state = 47},
  [63] = {.lex_state = 47},
  [64] = {.lex_state = 47},
  [65] = {.lex_state = 47},
  [66] = {.lex_state = 47},
  [67] = {.lex_state = 47},
  [68] = {.lex_state = 47},
  [69] = {.lex_state = 47},
  [70] = {.lex_state = 47},
  [71] = {.lex_state = 47},
  [72] = {.lex_state = 47},
  [73] = {.lex_state = 47},
  [74] = {.lex_state = 47},
  [75] = {.lex_state = 47},
  [76] = {.lex_state = 47},
  [77] = {.lex_state = 47},
  [78] = {.lex_state = 47},
  [79] = {.lex_state = 47},
  [80] = {.lex_state = 47},
  [81] = {.lex_state = 47},
  [82] = {.lex_state = 47},
  [83] = {.lex_state = 47},
  [84] = {.lex_state = 47},
  [85] = {.lex_state = 47},
  [86] = {.lex_state = 47},
  [87] = {.lex_state = 47},
  [88] = {.lex_state = 47},
  [89] = {.lex_state = 47},
  [90] = {.lex_state = 47},
  [91] = {.lex_state = 47},
  [92] = {.lex_state = 47},
  [93] = {.lex_state = 47},
  [94] = {.lex_state = 47},
  [95] = {.lex_state = 47},
  [96] = {.lex_state = 47},
  [97] = {.lex_state = 47},
  [98] = {.lex_state = 47},
  [99] = {.lex_state = 47},
  [100] = {.lex_state = 47},
  [101] = {.lex_state = 47},
  [102] = {.lex_state = 47},
  [103] = {.lex_state = 47},
  [104] = {.lex_state = 47},
  [105] = {.lex_state = 47},
  [106] = {.lex_state = 47},
  [107] = {.lex_state = 47},
  [108] = {.lex_state = 47},
  [109] = {.lex_state = 47},
  [110] = {.lex_state = 47},
  [111] = {.lex_state = 47},
  [112] = {.lex_state = 47},
  [113] = {.lex_state = 47},
  [114] = {.lex_state = 47},
  [115] = {.lex_state = 47},
  [116] = {.lex_state = 47},
  [117] = {.lex_state = 47},
  [118] = {.lex_state = 47},
  [119] = {.lex_state = 47},
  [120] = {.lex_state = 47},
  [121] = {.lex_state = 47},
  [122] = {.lex_state = 47},
  [123] = {.lex_state = 47},
  [124] = {.lex_state = 47},
  [125] = {.lex_state = 47},
  [126] = {.lex_state = 47},
  [127] = {.lex_state = 47},
  [128] = {.lex_state = 47},
  [129] = {.lex_state = 47},
  [130] = {.lex_state = 47},
  [131] = {.lex_state = 47},
  [132] = {.lex_state = 47},
  [133] = {.lex_state = 47},
  [134] = {.lex_state = 47},
  [135] = {.lex_state = 47},
  [136] = {.lex_state = 47},
  [137] = {.lex_state = 47},
  [138] = {.lex_state = 47},
  [139] = {.lex_state = 47},
  [140] = {.lex_state = 47},
  [141] = {.lex_state = 47},
  [142] = {.lex_state = 47},
  [143] = {.lex_state = 47},
  [144] = {.lex_state = 47},
  [145] = {.lex_state = 47},
  [146] = {.lex_state = 47},
  [147] = {.lex_state = 47},
  [148] = {.lex_state = 47},
  [149] = {.lex_state = 47},
  [150] = {.lex_state = 47},
  [151] = {.lex_state = 42},
  [152] = {.lex_state = 42},
  [153] = {.lex_state = 42},
  [154] = {.lex_state = 42},
  [155] = {.lex_state = 42},
  [156] = {.lex_state = 133},
  [157] = {.lex_state = 133},
  [158] = {.lex_state = 133},
  [159] = {.lex_state = 133},
  [160] = {.lex_state = 133},
  [161] = {.lex_state = 133},
  [162] = {.lex_state = 133},
  [163] = {.lex_state = 133},
  [164] = {.lex_state = 133},
  [165] = {.lex_state = 133},
  [166] = {.lex_state = 133},
  [167] = {.lex_state = 133},
  [168] = {.lex_state = 133},
  [169] = {.lex_state = 133},
  [170] = {.lex_state = 133},
  [171] = {.lex_state = 133},
  [172] = {.lex_state = 133},
  [173] = {.lex_state = 133},
  [174] = {.lex_state = 133},
  [175] = {.lex_state = 133},
  [176] = {.lex_state = 133},
  [177] = {.lex_state = 133},
  [178] = {.lex_state = 133},
  [179] = {.lex_state = 133},
  [180] = {.lex_state = 133},
  [181] = {.lex_state = 133},
  [182] = {.lex_state = 133},
  [183] = {.lex_state = 133},
  [184] = {.lex_state = 133},
  [185] = {.lex_state = 133},
  [186] = {.lex_state = 133},
  [187] = {.lex_state = 133},
  [188] = {.lex_state = 133},
  [189] = {.lex_state = 133},
  [190] = {.lex_state = 133},
  [191] = {.lex_state = 133},
  [192] = {.lex_state = 133},
  [193] = {.lex_state = 133},
  [194] = {.lex_state = 133},
  [195] = {.lex_state = 133},
  [196] = {.lex_state = 133},
  [197] = {.lex_state = 133},
  [198] = {.lex_state = 133},
  [199] = {.lex_state = 42},
  [200] = {.lex_state = 42},
  [201] = {.lex_state = 42},
  [202] = {.lex_state = 42},
  [203] = {.lex_state = 42},
  [204] = {.lex_state = 42},
  [205] = {.lex_state = 42},
  [206] = {.lex_state = 42},
  [207] = {.lex_state = 42},
  [208] = {.lex_state = 42},
  [209] = {.lex_state = 42},
  [210] = {.lex_state = 42},
  [211] = {.lex_state = 42},
  [212] = {.lex_state = 42},
  [213] = {.lex_state = 42},
  [214] = {.lex_state = 11},
  [215] = {.lex_state = 42},
  [216] = {.lex_state = 42},
  [217] = {.lex_state = 42},
  [218] = {.lex_state = 49},
  [219] = {.lex_state = 49},
  [220] = {.lex_state = 49},
  [221] = {.lex_state = 49},
  [222] = {.lex_state = 49},
  [223] = {.lex_state = 49},
  [224] = {.lex_state = 49},
  [225] = {.lex_state = 49},
  [226] = {.lex_state = 49},
  [227] = {.lex_state = 49},
  [228] = {.lex_state = 49},
  [229] = {.lex_state = 49},
  [230] = {.lex_state = 49},
  [231] = {.lex_state = 49},
  [232] = {.lex_state = 49},
  [233] = {.lex_state = 49},
  [234] = {.lex_state = 49},
  [235] = {.lex_state = 49},
  [236] = {.lex_state = 49},
  [237] = {.lex_state = 49},
  [238] = {.lex_state = 49},
  [239] = {.lex_state = 49},
  [240] = {.lex_state = 46},
  [241] = {.lex_state = 46},
  [242] = {.lex_state = 46},
  [243] = {.lex_state = 46},
  [244] = {.lex_state = 46},
  [245] = {.lex_state = 46},
  [246] = {.lex_state = 46},
  [247] = {.lex_state = 46},
  [248] = {.lex_state = 46},
  [249] = {.lex_state = 46},
  [250] = {.lex_state = 46},
  [251] = {.lex_state = 46},
  [252] = {.lex_state = 46},
  [253] = {.lex_state = 46},
  [254] = {.lex_state = 46},
  [255] = {.lex_state = 46},
  [256] = {.lex_state = 46},
  [257] = {.lex_state = 42},
  [258] = {.lex_state = 46},
  [259] = {.lex_state = 46},
  [260] = {.lex_state = 46},
  [261] = {.lex_state = 46},
  [262] = {.lex_state = 46},
  [263] = {.lex_state = 46},
  [264] = {.lex_state = 46},
  [265] = {.lex_state = 46},
  [266] = {.lex_state = 46},
  [267] = {.lex_state = 46},
  [268] = {.lex_state = 46},
  [269] = {.lex_state = 46},
  [270] = {.lex_state = 42},
  [271] = {.lex_state = 46},
  [272] = {.lex_state = 46},
  [273] = {.lex_state = 46},
  [274] = {.lex_state = 46},
  [275] = {.lex_state = 46},
  [276] = {.lex_state = 42},
  [277] = {.lex_state = 46},
  [278] = {.lex_state = 46},
  [279] = {.lex_state = 46},
  [280] = {.lex_state = 46},
  [281] = {.lex_state = 46},
  [282] = {.lex_state = 46},
  [283] = {.lex_state = 46},
  [284] = {.lex_state = 46},
  [285] = {.lex_state = 46},
  [286] = {.lex_state = 46},
  [287] = {.lex_state = 42},
  [288] = {.lex_state = 46},
  [289] = {.lex_state = 46},
  [290] = {.lex_state = 49},
  [291] = {.lex_state = 46},
  [292] = {.lex_state = 46},
  [293] = {.lex_state = 49},
  [294] = {.lex_state = 46},
  [295] = {.lex_state = 49},
  [296] = {.lex_state = 49},
  [297] = {.lex_state = 49},
  [298] = {.lex_state = 49},
  [299] = {.lex_state = 49},
  [300] = {.lex_state = 49},
  [301] = {.lex_state = 49},
  [302] = {.lex_state = 49},
  [303] = {.lex_state = 49},
  [304] = {.lex_state = 42},
  [305] = {.lex_state = 42},
  [306] = {.lex_state = 42},
  [307] = {.lex_state = 49},
  [308] = {.lex_state = 49},
  [309] = {.lex_state = 46},
  [310] = {.lex_state = 49},
  [311] = {.lex_state = 42},
  [312] = {.lex_state = 42},
  [313] = {.lex_state = 42},
  [314] = {.lex_state = 42},
  [315] = {.lex_state = 42},
  [316] = {.lex_state = 42},
  [317] = {.lex_state = 42},
  [318] = {.lex_state = 42},
  [319] = {.lex_state = 42},
  [320] = {.lex_state = 49},
  [321] = {.lex_state = 42},
  [322] = {.lex_state = 42},
  [323] = {.lex_state = 42},
  [324] = {.lex_state = 49},
  [325] = {.lex_state = 42},
  [326] = {.lex_state = 49},
  [327] = {.lex_state = 46},
  [328] = {.lex_state = 46},
  [329] = {.lex_state = 46},
  [330] = {.lex_state = 46},
  [331] = {.lex_state = 46},
  [332] = {.lex_state = 46},
  [333] = {.lex_state = 42},
  [334] = {.lex_state = 42},
  [335] = {.lex_state = 49},
  [336] = {.lex_state = 49},
  [337] = {.lex_state = 49},
  [338] = {.lex_state = 49},
  [339] = {.lex_state = 46},
  [340] = {.lex_state = 46},
  [341] = {.lex_state = 46},
  [342] = {.lex_state = 46},
  [343] = {.lex_state = 46},
  [344] = {.lex_state = 46},
  [345] = {.lex_state = 46},
  [346] = {.lex_state = 46},
  [347] = {.lex_state = 46},
  [348] = {.lex_state = 11},
  [349] = {.lex_state = 11},
  [350] = {.lex_state = 11},
  [351] = {.lex_state = 11},
  [352] = {.lex_state = 11},
  [353] = {.lex_state = 11},
  [354] = {.lex_state = 11},
  [355] = {.lex_state = 11},
  [356] = {.lex_state = 11},
  [357] = {.lex_state = 11},
  [358] = {.lex_state = 42},
  [359] = {.lex_state = 11},
  [360] = {.lex_state = 11},
  [361] = {.lex_state = 11},
  [362] = {.lex_state = 11},
  [363] = {.lex_state = 11},
  [364] = {.lex_state = 11},
  [365] = {.lex_state = 11},
  [366] = {.lex_state = 11},
  [367] = {.lex_state = 11},
  [368] = {.lex_state = 11},
  [369] = {.lex_state = 11},
  [370] = {.lex_state = 42},
  [371] = {.lex_state = 11},
  [372] = {.lex_state = 11},
  [373] = {.lex_state = 11},
  [374] = {.lex_state = 11},
  [375] = {.lex_state = 11},
  [376] = {.lex_state = 50},
  [377] = {.lex_state = 50},
  [378] = {.lex_state = 50},
  [379] = {.lex_state = 50},
  [380] = {.lex_state = 50},
  [381] = {.lex_state = 50},
  [382] = {.lex_state = 50},
  [383] = {.lex_state = 50},
  [384] = {.lex_state = 50},
  [385] = {.lex_state = 50},
  [386] = {.lex_state = 50},
  [387] = {.lex_state = 50},
  [388] = {.lex_state = 50},
  [389] = {.lex_state = 50},
  [390] = {.lex_state = 50},
  [391] = {.lex_state = 50},
  [392] = {.lex_state = 50},
  [393] = {.lex_state = 50},
  [394] = {.lex_state = 50},
  [395] = {.lex_state = 50},
  [396] = {.lex_state = 50},
  [397] = {.lex_state = 50},
  [398] = {.lex_state = 50},
  [399] = {.lex_state = 50},
  [400] = {.lex_state = 50},
  [401] = {.lex_state = 50},
  [402] = {.lex_state = 50},
  [403] = {.lex_state = 50},
  [404] = {.lex_state = 50},
  [405] = {.lex_state = 50},
  [406] = {.lex_state = 50},
  [407] = {.lex_state = 50},
  [408] = {.lex_state = 50},
  [409] = {.lex_state = 50},
  [410] = {.lex_state = 50},
  [411] = {.lex_state = 50},
  [412] = {.lex_state = 50},
  [413] = {.lex_state = 50},
  [414] = {.lex_state = 50},
  [415] = {.lex_state = 50},
  [416] = {.lex_state = 50},
  [417] = {.lex_state = 50},
  [418] = {.lex_state = 50},
  [419] = {.lex_state = 50},
  [420] = {.lex_state = 50},
  [421] = {.lex_state = 50},
  [422] = {.lex_state = 50},
  [423] = {.lex_state = 50},
  [424] = {.lex_state = 50},
  [425] = {.lex_state = 50},
  [426] = {.lex_state = 50},
  [427] = {.lex_state = 50},
  [428] = {.lex_state = 50},
  [429] = {.lex_state = 50},
  [430] = {.lex_state = 50},
  [431] = {.lex_state = 50},
  [432] = {.lex_state = 50},
  [433] = {.lex_state = 50},
  [434] = {.lex_state = 50},
  [435] = {.lex_state = 50},
  [436] = {.lex_state = 50},
  [437] = {.lex_state = 50},
  [438] = {.lex_state = 50},
  [439] = {.lex_state = 50},
  [440] = {.lex_state = 50},
  [441] = {.lex_state = 44},
  [442] = {.lex_state = 44},
  [443] = {.lex_state = 44},
  [444] = {.lex_state = 44},
  [445] = {.lex_state = 44},
  [446] = {.lex_state = 44},
  [447] = {.lex_state = 44},
  [448] = {.lex_state = 44},
  [449] = {.lex_state = 44},
  [450] = {.lex_state = 44},
  [451] = {.lex_state = 44},
  [452] = {.lex_state = 44},
  [453] = {.lex_state = 44},
  [454] = {.lex_state = 44},
  [455] = {.lex_state = 44},
  [456] = {.lex_state = 44},
  [457] = {.lex_state = 47},
  [458] = {.lex_state = 48},
  [459] = {.lex_state = 48},
  [460] = {.lex_state = 48},
  [461] = {.lex_state = 48},
  [462] = {.lex_state = 48},
  [463] = {.lex_state = 48},
  [464] = {.lex_state = 48},
  [465] = {.lex_state = 48},
  [466] = {.lex_state = 48},
  [467] = {.lex_state = 48},
  [468] = {.lex_state = 48},
  [469] = {.lex_state = 48},
  [470] = {.lex_state = 48},
  [471] = {.lex_state = 48},
  [472] = {.lex_state = 47},
  [473] = {.lex_state = 47},
  [474] = {.lex_state = 47},
  [475] = {.lex_state = 47},
  [476] = {.lex_state = 48},
  [477] = {.lex_state = 48},
  [478] = {.lex_state = 47},
  [479] = {.lex_state = 47},
  [480] = {.lex_state = 48},
  [481] = {.lex_state = 47},
  [482] = {.lex_state = 47},
  [483] = {.lex_state = 47},
  [484] = {.lex_state = 47},
  [485] = {.lex_state = 47},
  [486] = {.lex_state = 47},
  [487] = {.lex_state = 48},
  [488] = {.lex_state = 47},
  [489] = {.lex_state = 48},
  [490] = {.lex_state = 48},
  [491] = {.lex_state = 48},
  [492] = {.lex_state = 48},
  [493] = {.lex_state = 48},
  [494] = {.lex_state = 48},
  [495] = {.lex_state = 48},
  [496] = {.lex_state = 48},
  [497] = {.lex_state = 48},
  [498] = {.lex_state = 48},
  [499] = {.lex_state = 48},
  [500] = {.lex_state = 48},
  [501] = {.lex_state = 48},
  [502] = {.lex_state = 47},
  [503] = {.lex_state = 47},
  [504] = {.lex_state = 48},
  [505] = {.lex_state = 47},
  [506] = {.lex_state = 48},
  [507] = {.lex_state = 48},
  [508] = {.lex_state = 48},
  [509] = {.lex_state = 48},
  [510] = {.lex_state = 47},
  [511] = {.lex_state = 48},
  [512] = {.lex_state = 47},
  [513] = {.lex_state = 47},
  [514] = {.lex_state = 48},
  [515] = {.lex_state = 48},
  [516] = {.lex_state = 47},
  [517] = {.lex_state = 47},
  [518] = {.lex_state = 47},
  [519] = {.lex_state = 47},
  [520] = {.lex_state = 47},
  [521] = {.lex_state = 47},
  [522] = {.lex_state = 47},
  [523] = {.lex_state = 47},
  [524] = {.lex_state = 47},
  [525] = {.lex_state = 47},
  [526] = {.lex_state = 47},
  [527] = {.lex_state = 47},
  [528] = {.lex_state = 47},
  [529] = {.lex_state = 47},
  [530] = {.lex_state = 48},
  [531] = {.lex_state = 47},
  [532] = {.lex_state = 47},
  [533] = {.lex_state = 48},
  [534] = {.lex_state = 47},
  [535] = {.lex_state = 47},
  [536] = {.lex_state = 47},
  [537] = {.lex_state = 47},
  [538] = {.lex_state = 47},
  [539] = {.lex_state = 47},
  [540] = {.lex_state = 47},
  [541] = {.lex_state = 47},
  [542] = {.lex_state = 47},
  [543] = {.lex_state = 47},
  [544] = {.lex_state = 48},
  [545] = {.lex_state = 47},
  [546] = {.lex_state = 47},
  [547] = {.lex_state = 47},
  [548] = {.lex_state = 47},
  [549] = {.lex_state = 47},
  [550] = {.lex_state = 47},
  [551] = {.lex_state = 47},
  [552] = {.lex_state = 47},
  [553] = {.lex_state = 48},
  [554] = {.lex_state = 47},
  [555] = {.lex_state = 48},
  [556] = {.lex_state = 47},
  [557] = {.lex_state = 48},
  [558] = {.lex_state = 48},
  [559] = {.lex_state = 48},
  [560] = {.lex_state = 48},
  [561] = {.lex_state = 48},
  [562] = {.lex_state = 48},
  [563] = {.lex_state = 48},
  [564] = {.lex_state = 48},
  [565] = {.lex_state = 48},
  [566] = {.lex_state = 48},
  [567] = {.lex_state = 48},
  [568] = {.lex_state = 47},
  [569] = {.lex_state = 48},
  [570] = {.lex_state = 47},
  [571] = {.lex_state = 47},
  [572] = {.lex_state = 47},
  [573] = {.lex_state = 47},
  [574] = {.lex_state = 48},
  [575] = {.lex_state = 48},
  [576] = {.lex_state = 48},
  [577] = {.lex_state = 48},
  [578] = {.lex_state = 48},
  [579] = {.lex_state = 48},
  [580] = {.lex_state = 48},
  [581] = {.lex_state = 48},
  [582] = {.lex_state = 47},
  [583] = {.lex_state = 48},
  [584] = {.lex_state = 47},
  [585] = {.lex_state = 47},
  [586] = {.lex_state = 47},
  [587] = {.lex_state = 44},
  [588] = {.lex_state = 44},
  [589] = {.lex_state = 44},
  [590] = {.lex_state = 44},
  [591] = {.lex_state = 44},
  [592] = {.lex_state = 44},
  [593] = {.lex_state = 44},
  [594] = {.lex_state = 44},
  [595] = {.lex_state = 44},
  [596] = {.lex_state = 44},
  [597] = {.lex_state = 44},
  [598] = {.lex_state = 44},
  [599] = {.lex_state = 44},
  [600] = {.lex_state = 44},
  [601] = {.lex_state = 44},
  [602] = {.lex_state = 44},
  [603] = {.lex_state = 44},
  [604] = {.lex_state = 44},
  [605] = {.lex_state = 44},
  [606] = {.lex_state = 44},
  [607] = {.lex_state = 44},
  [608] = {.lex_state = 51},
  [609] = {.lex_state = 44},
  [610] = {.lex_state = 44},
  [611] = {.lex_state = 44},
  [612] = {.lex_state = 44},
  [613] = {.lex_state = 44},
  [614] = {.lex_state = 44},
  [615] = {.lex_state = 44},
  [616] = {.lex_state = 44},
  [617] = {.lex_state = 44},
  [618] = {.lex_state = 44},
  [619] = {.lex_state = 44},
  [620] = {.lex_state = 44},
  [621] = {.lex_state = 44},
  [622] = {.lex_state = 44},
  [623] = {.lex_state = 44},
  [624] = {.lex_state = 44},
  [625] = {.lex_state = 51},
  [626] = {.lex_state = 44},
  [627] = {.lex_state = 51},
  [628] = {.lex_state = 44},
  [629] = {.lex_state = 44},
  [630] = {.lex_state = 44},
  [631] = {.lex_state = 44},
  [632] = {.lex_state = 44},
  [633] = {.lex_state = 44},
  [634] = {.lex_state = 44},
  [635] = {.lex_state = 44},
  [636] = {.lex_state = 44},
  [637] = {.lex_state = 51},
  [638] = {.lex_state = 44},
  [639] = {.lex_state = 44},
  [640] = {.lex_state = 44},
  [641] = {.lex_state = 44},
  [642] = {.lex_state = 44},
  [643] = {.lex_state = 52},
  [644] = {.lex_state = 43},
  [645] = {.lex_state = 52},
  [646] = {.lex_state = 52},
  [647] = {.lex_state = 53},
  [648] = {.lex_state = 52},
  [649] = {.lex_state = 52},
  [650] = {.lex_state = 52},
  [651] = {.lex_state = 43},
  [652] = {.lex_state = 53},
  [653] = {.lex_state = 52},
  [654] = {.lex_state = 43},
  [655] = {.lex_state = 43},
  [656] = {.lex_state = 42},
  [657] = {.lex_state = 43},
  [658] = {.lex_state = 43},
  [659] = {.lex_state = 43},
  [660] = {.lex_state = 43},
  [661] = {.lex_state = 43},
  [662] = {.lex_state = 43},
  [663] = {.lex_state = 43},
  [664] = {.lex_state = 43},
  [665] = {.lex_state = 43},
  [666] = {.lex_state = 43},
  [667] = {.lex_state = 43},
  [668] = {.lex_state = 42},
  [669] = {.lex_state = 52},
  [670] = {.lex_state = 43},
  [671] = {.lex_state = 43},
  [672] = {.lex_state = 43},
  [673] = {.lex_state = 42},
  [674] = {.lex_state = 52},
  [675] = {.lex_state = 52},
  [676] = {.lex_state = 52},
  [677] = {.lex_state = 52},
  [678] = {.lex_state = 52},
  [679] = {.lex_state = 42},
  [680] = {.lex_state = 42},
  [681] = {.lex_state = 52},
  [682] = {.lex_state = 52},
  [683] = {.lex_state = 52},
  [684] = {.lex_state = 42},
  [685] = {.lex_state = 52},
  [686] = {.lex_state = 52},
  [687] = {.lex_state = 42},
  [688] = {.lex_state = 42},
  [689] = {.lex_state = 42},
  [690] = {.lex_state = 42},
  [691] = {.lex_state = 53},
  [692] = {.lex_state = 51},
  [693] = {.lex_state = 42},
  [694] = {.lex_state = 52},
  [695] = {.lex_state = 44},
  [696] = {.lex_state = 51},
  [697] = {.lex_state = 43},
  [698] = {.lex_state = 53},
  [699] = {.lex_state = 51},
  [700] = {.lex_state = 51},
  [701] = {.lex_state = 51},
  [702] = {.lex_state = 51},
  [703] = {.lex_state = 53},
  [704] = {.lex_state = 51},
  [705] = {.lex_state = 133},
  [706] = {.lex_state = 133},
  [707] = {.lex_state = 133},
  [708] = {.lex_state = 133},
  [709] = {.lex_state = 52},
  [710] = {.lex_state = 52},
  [711] = {.lex_state = 133},
  [712] = {.lex_state = 133},
  [713] = {.lex_state = 133},
  [714] = {.lex_state = 133},
  [715] = {.lex_state = 43},
  [716] = {.lex_state = 133},
  [717] = {.lex_state = 20},
  [718] = {.lex_state = 133},
  [719] = {.lex_state = 133},
  [720] = {.lex_state = 20},
  [721] = {.lex_state = 133},
  [722] = {.lex_state = 22},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 133},
  [725] = {.lex_state = 43},
  [726] = {.lex_state = 20},
  [727] = {.lex_state = 43},
  [728] = {.lex_state = 22},
  [729] = {.lex_state = 22},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 43},
  [732] = {.lex_state = 43},
  [733] = {.lex_state = 22},
  [734] = {.lex_state = 20},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 20},
  [737] = {.lex_state = 133},
  [738] = {.lex_state = 133},
  [739] = {.lex_state = 43},
  [740] = {.lex_state = 133},
  [741] = {.lex_state = 20},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 20},
  [744] = {.lex_state = 20},
  [745] = {.lex_state = 22},
  [746] = {.lex_state = 20},
  [747] = {.lex_state = 22},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 42},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 62},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 62},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 62},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 63},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 133},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 63},
  [853] = {.lex_state = 42},
  [854] = {.lex_state = 63},
  [855] = {.lex_state = 63},
  [856] = {.lex_state = 133},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 63},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 23},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 63},
  [865] = {.lex_state = 133},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 23},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 133},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 133},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 133},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 42},
  [880] = {.lex_state = 63},
  [881] = {.lex_state = 133},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 63},
  [884] = {.lex_state = 63},
  [885] = {.lex_state = 23},
  [886] = {.lex_state = 63},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 23},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 23},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 23},
  [895] = {.lex_state = 63},
  [896] = {.lex_state = 63},
  [897] = {.lex_state = 23},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 133},
  [900] = {.lex_state = 64},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 23},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 133},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 42},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 23},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 63},
  [922] = {.lex_state = 63},
  [923] = {.lex_state = 63},
  [924] = {.lex_state = 63},
  [925] = {.lex_state = 63},
  [926] = {.lex_state = 63},
  [927] = {.lex_state = 63},
  [928] = {.lex_state = 63},
  [929] = {.lex_state = 63},
  [930] = {.lex_state = 63},
  [931] = {.lex_state = 63},
  [932] = {.lex_state = 63},
  [933] = {.lex_state = 63},
  [934] = {.lex_state = 63},
  [935] = {.lex_state = 63},
  [936] = {.lex_state = 63},
  [937] = {.lex_state = 63},
  [938] = {.lex_state = 63},
  [939] = {.lex_state = 63},
  [940] = {.lex_state = 63},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 24},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 24},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 24},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 24},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 24},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 42},
  [985] = {.lex_state = 42},
  [986] = {.lex_state = 42},
  [987] = {.lex_state = 42},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 42},
  [990] = {.lex_state = 133},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 42},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 42},
  [997] = {.lex_state = 42},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 24},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 24},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 42},
  [1020] = {.lex_state = 42},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 42},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 24},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 42},
  [1034] = {.lex_state = 24},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 24},
  [1041] = {.lex_state = 42},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 42},
  [1049] = {.lex_state = 42},
  [1050] = {.lex_state = 42},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 42},
  [1053] = {.lex_state = 42},
  [1054] = {.lex_state = 24},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 42},
  [1059] = {.lex_state = 42},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 42},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 42},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 24},
  [1073] = {.lex_state = 24},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 24},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 42},
  [1078] = {.lex_state = 42},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 24},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 42},
  [1103] = {.lex_state = 42},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 42},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 24},
  [1123] = {.lex_state = 42},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 42},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 42},
  [1132] = {.lex_state = 24},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 24},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 24},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 24},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 24},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 24},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 24},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 24},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 24},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 24},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_AMP_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym__byte_string_item] = ACTIONS(1),
    [sym_integer_literal] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [aux_sym_preproc_include_token1] = ACTIONS(1),
    [aux_sym_preproc_def_token1] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [aux_sym_preproc_undef_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token2] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1),
    [aux_sym_preproc_else_token1] = ACTIONS(1),
    [aux_sym_preproc_elif_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1),
    [anon_sym_defined] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(1113),
    [sym__top_level_item] = STATE(36),
    [sym__label] = STATE(698),
    [sym_file_version] = STATE(36),
    [sym_plugin] = STATE(36),
    [sym_memory_reservation] = STATE(36),
    [sym__label_name] = STATE(841),
    [sym__node_name] = STATE(845),
    [sym_reference] = STATE(998),
    [sym__label_reference] = STATE(689),
    [sym__node_reference] = STATE(680),
    [sym_omit_if_no_ref] = STATE(36),
    [sym_node] = STATE(36),
    [sym_delete_node] = STATE(36),
    [sym_dtsi_include] = STATE(36),
    [sym_preproc_include] = STATE(36),
    [sym_preproc_def] = STATE(36),
    [sym_preproc_function_def] = STATE(36),
    [sym_preproc_undef] = STATE(36),
    [sym_preproc_if] = STATE(36),
    [sym_preproc_ifdef] = STATE(36),
    [aux_sym_document_repeat1] = STATE(36),
    [aux_sym_memory_reservation_repeat1] = STATE(647),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_SLASHdts_DASHv1_SLASH] = ACTIONS(7),
    [anon_sym_SLASHplugin_SLASH] = ACTIONS(9),
    [anon_sym_SLASHmemreserve_SLASH] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [sym__node_path] = ACTIONS(13),
    [aux_sym__label_name_token1] = ACTIONS(15),
    [aux_sym__node_name_token1] = ACTIONS(17),
    [anon_sym_AMP] = ACTIONS(19),
    [anon_sym_AMP_LBRACE] = ACTIONS(21),
    [anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH] = ACTIONS(23),
    [anon_sym_SLASHdelete_DASHnode_SLASH] = ACTIONS(25),
    [anon_sym_SLASHinclude_SLASH] = ACTIONS(27),
    [aux_sym_preproc_include_token1] = ACTIONS(29),
    [aux_sym_preproc_def_token1] = ACTIONS(31),
    [aux_sym_preproc_undef_token1] = ACTIONS(33),
    [aux_sym_preproc_if_token1] = ACTIONS(35),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(37),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(37),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__node_path,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(23), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(25), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(27), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(29), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(33), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(35), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(39), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(43), 1,
      aux_sym_preproc_elif_token1,
    STATE(647), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(841), 1,
      sym__label_name,
    STATE(845), 1,
      sym__node_name,
    STATE(998), 1,
      sym_reference,
    ACTIONS(37), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(1035), 3,
      sym_preproc_else,
      sym_preproc_elif,
      sym_preproc_elifdef,
    STATE(3), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [109] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__node_path,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(23), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(25), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(27), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(29), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(33), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(35), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(43), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(47), 1,
      aux_sym_preproc_if_token2,
    STATE(647), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(841), 1,
      sym__label_name,
    STATE(845), 1,
      sym__node_name,
    STATE(998), 1,
      sym_reference,
    ACTIONS(37), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(1055), 3,
      sym_preproc_else,
      sym_preproc_elif,
      sym_preproc_elifdef,
    STATE(6), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [218] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__node_path,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(23), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(25), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(27), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(29), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(33), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(35), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(43), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(49), 1,
      aux_sym_preproc_if_token2,
    STATE(647), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(841), 1,
      sym__label_name,
    STATE(845), 1,
      sym__node_name,
    STATE(998), 1,
      sym_reference,
    ACTIONS(37), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(1086), 3,
      sym_preproc_else,
      sym_preproc_elif,
      sym_preproc_elifdef,
    STATE(5), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [327] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__node_path,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(23), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(25), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(27), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(29), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(33), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(35), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(43), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(51), 1,
      aux_sym_preproc_if_token2,
    STATE(647), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(841), 1,
      sym__label_name,
    STATE(845), 1,
      sym__node_name,
    STATE(998), 1,
      sym_reference,
    ACTIONS(37), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(1166), 3,
      sym_preproc_else,
      sym_preproc_elif,
      sym_preproc_elifdef,
    STATE(6), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [436] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(58), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(61), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(64), 1,
      sym__node_path,
    ACTIONS(67), 1,
      aux_sym__label_name_token1,
    ACTIONS(70), 1,
      aux_sym__node_name_token1,
    ACTIONS(73), 1,
      anon_sym_AMP,
    ACTIONS(76), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(79), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(82), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(85), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(88), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(91), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(94), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(97), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(103), 1,
      aux_sym_preproc_elif_token1,
    STATE(647), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(841), 1,
      sym__label_name,
    STATE(845), 1,
      sym__node_name,
    STATE(998), 1,
      sym_reference,
    ACTIONS(100), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(53), 5,
      ts_builtin_sym_end,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(6), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [537] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(105), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(107), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(109), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(111), 1,
      sym__node_path,
    ACTIONS(113), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(115), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(117), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(119), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(121), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(123), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(125), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(127), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(131), 1,
      aux_sym_preproc_elif_token1,
    STATE(652), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(838), 1,
      sym__label_name,
    STATE(904), 1,
      sym__node_name,
    STATE(1142), 1,
      sym_reference,
    ACTIONS(129), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1011), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(23), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [641] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(133), 1,
      sym__node_path,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(137), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(139), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(143), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(145), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(147), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(149), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(151), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_elif_token1,
    STATE(637), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(714), 1,
      sym__label_name,
    STATE(716), 1,
      sym__node_name,
    STATE(848), 1,
      sym__property_name,
    STATE(1153), 1,
      sym_reference,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(153), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1084), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(24), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [745] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(105), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(107), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(109), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(111), 1,
      sym__node_path,
    ACTIONS(113), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(115), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(117), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(119), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(121), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(123), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(125), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(131), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(159), 1,
      aux_sym_preproc_if_token2,
    STATE(652), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(838), 1,
      sym__label_name,
    STATE(904), 1,
      sym__node_name,
    STATE(1142), 1,
      sym_reference,
    ACTIONS(129), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1127), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(23), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [849] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(105), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(107), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(109), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(111), 1,
      sym__node_path,
    ACTIONS(113), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(115), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(117), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(119), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(121), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(123), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(125), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(131), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(161), 1,
      aux_sym_preproc_if_token2,
    STATE(652), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(838), 1,
      sym__label_name,
    STATE(904), 1,
      sym__node_name,
    STATE(1142), 1,
      sym_reference,
    ACTIONS(129), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1042), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(9), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [953] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(105), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(107), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(109), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(111), 1,
      sym__node_path,
    ACTIONS(113), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(115), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(117), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(119), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(121), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(123), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(125), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(131), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(163), 1,
      aux_sym_preproc_if_token2,
    STATE(652), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(838), 1,
      sym__label_name,
    STATE(904), 1,
      sym__node_name,
    STATE(1142), 1,
      sym_reference,
    ACTIONS(129), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1121), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(7), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1057] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(105), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(107), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(109), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(111), 1,
      sym__node_path,
    ACTIONS(113), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(115), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(117), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(119), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(121), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(123), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(125), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(131), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(165), 1,
      aux_sym_preproc_if_token2,
    STATE(652), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(838), 1,
      sym__label_name,
    STATE(904), 1,
      sym__node_name,
    STATE(1142), 1,
      sym_reference,
    ACTIONS(129), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1003), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(22), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1161] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(105), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(107), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(109), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(111), 1,
      sym__node_path,
    ACTIONS(113), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(115), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(117), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(119), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(121), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(123), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(125), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(131), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(167), 1,
      aux_sym_preproc_if_token2,
    STATE(652), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(838), 1,
      sym__label_name,
    STATE(904), 1,
      sym__node_name,
    STATE(1142), 1,
      sym_reference,
    ACTIONS(129), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1163), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(16), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1265] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(133), 1,
      sym__node_path,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(137), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(139), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(143), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(145), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(147), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(149), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(169), 1,
      aux_sym_preproc_if_token2,
    STATE(637), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(714), 1,
      sym__label_name,
    STATE(716), 1,
      sym__node_name,
    STATE(848), 1,
      sym__property_name,
    STATE(1153), 1,
      sym_reference,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(153), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1133), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(8), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [1369] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(133), 1,
      sym__node_path,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(137), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(139), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(143), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(145), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(147), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(149), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(171), 1,
      aux_sym_preproc_if_token2,
    STATE(637), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(714), 1,
      sym__label_name,
    STATE(716), 1,
      sym__node_name,
    STATE(848), 1,
      sym__property_name,
    STATE(1153), 1,
      sym_reference,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(153), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(995), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(18), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [1473] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(105), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(107), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(109), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(111), 1,
      sym__node_path,
    ACTIONS(113), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(115), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(117), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(119), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(121), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(123), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(125), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(131), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(173), 1,
      aux_sym_preproc_if_token2,
    STATE(652), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(838), 1,
      sym__label_name,
    STATE(904), 1,
      sym__node_name,
    STATE(1142), 1,
      sym_reference,
    ACTIONS(129), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1015), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(23), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1577] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(133), 1,
      sym__node_path,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(137), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(139), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(143), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(145), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(147), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(149), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(175), 1,
      aux_sym_preproc_if_token2,
    STATE(637), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(714), 1,
      sym__label_name,
    STATE(716), 1,
      sym__node_name,
    STATE(848), 1,
      sym__property_name,
    STATE(1153), 1,
      sym_reference,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(153), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1105), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(21), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [1681] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(133), 1,
      sym__node_path,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(137), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(139), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(143), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(145), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(147), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(149), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(177), 1,
      aux_sym_preproc_if_token2,
    STATE(637), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(714), 1,
      sym__label_name,
    STATE(716), 1,
      sym__node_name,
    STATE(848), 1,
      sym__property_name,
    STATE(1153), 1,
      sym_reference,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(153), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1036), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(24), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [1785] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(133), 1,
      sym__node_path,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(137), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(139), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(143), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(145), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(147), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(149), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(179), 1,
      aux_sym_preproc_if_token2,
    STATE(637), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(714), 1,
      sym__label_name,
    STATE(716), 1,
      sym__node_name,
    STATE(848), 1,
      sym__property_name,
    STATE(1153), 1,
      sym_reference,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(153), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1013), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(24), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [1889] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(133), 1,
      sym__node_path,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(137), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(139), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(143), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(145), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(147), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(149), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(181), 1,
      aux_sym_preproc_if_token2,
    STATE(637), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(714), 1,
      sym__label_name,
    STATE(716), 1,
      sym__node_name,
    STATE(848), 1,
      sym__property_name,
    STATE(1153), 1,
      sym_reference,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(153), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(994), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(19), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [1993] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(133), 1,
      sym__node_path,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(137), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(139), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(143), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(145), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(147), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(149), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(183), 1,
      aux_sym_preproc_if_token2,
    STATE(637), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(714), 1,
      sym__label_name,
    STATE(716), 1,
      sym__node_name,
    STATE(848), 1,
      sym__property_name,
    STATE(1153), 1,
      sym_reference,
    ACTIONS(45), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(153), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1124), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(24), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2097] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(41), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(105), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(107), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(109), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(111), 1,
      sym__node_path,
    ACTIONS(113), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(115), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(117), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(119), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(121), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(123), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(125), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(131), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(185), 1,
      aux_sym_preproc_if_token2,
    STATE(652), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(838), 1,
      sym__label_name,
    STATE(904), 1,
      sym__node_name,
    STATE(1142), 1,
      sym_reference,
    ACTIONS(129), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1039), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(23), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [2201] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      aux_sym__label_name_token1,
    ACTIONS(70), 1,
      aux_sym__node_name_token1,
    ACTIONS(73), 1,
      anon_sym_AMP,
    ACTIONS(76), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(187), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(190), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(196), 1,
      sym__node_path,
    ACTIONS(199), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(202), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(205), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(208), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(211), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(214), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(217), 1,
      aux_sym_preproc_if_token1,
    STATE(652), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(838), 1,
      sym__label_name,
    STATE(904), 1,
      sym__node_name,
    STATE(1142), 1,
      sym_reference,
    ACTIONS(220), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(53), 3,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    STATE(23), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [2297] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(223), 1,
      sym__node_path,
    ACTIONS(226), 1,
      aux_sym__label_name_token1,
    ACTIONS(229), 1,
      aux_sym__node_name_token1,
    ACTIONS(232), 1,
      aux_sym__property_name_token1,
    ACTIONS(235), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(241), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(244), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(247), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(250), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(253), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(256), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(259), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(267), 1,
      aux_sym_preproc_elif_token1,
    STATE(637), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(714), 1,
      sym__label_name,
    STATE(716), 1,
      sym__node_name,
    STATE(848), 1,
      sym__property_name,
    STATE(1153), 1,
      sym_reference,
    ACTIONS(264), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(262), 4,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(24), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2392] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(285), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1141), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(38), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2491] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(291), 1,
      aux_sym_preproc_if_token2,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1081), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(38), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2590] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(293), 1,
      aux_sym_preproc_if_token2,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1070), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(26), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2689] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(295), 1,
      aux_sym_preproc_if_token2,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(999), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(25), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2788] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(297), 1,
      aux_sym_preproc_if_token2,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1010), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(31), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2887] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(299), 1,
      aux_sym_preproc_if_token2,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1079), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(38), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2986] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(301), 1,
      aux_sym_preproc_if_token2,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1029), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(38), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3085] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(303), 1,
      aux_sym_preproc_if_token2,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1032), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(30), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3184] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(305), 1,
      aux_sym_preproc_if_token2,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1119), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(34), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3283] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(269), 1,
      sym__node_path,
    ACTIONS(271), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(273), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(275), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(277), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(279), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(281), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(283), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(289), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(307), 1,
      aux_sym_preproc_if_token2,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(287), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1152), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(38), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3382] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__node_path,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(23), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(25), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(27), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(29), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(33), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(35), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(309), 1,
      aux_sym_preproc_if_token2,
    STATE(647), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(841), 1,
      sym__label_name,
    STATE(845), 1,
      sym__node_name,
    STATE(998), 1,
      sym_reference,
    ACTIONS(37), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(37), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [3476] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__node_path,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(23), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(25), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(27), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(29), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(33), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(35), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(311), 1,
      ts_builtin_sym_end,
    STATE(647), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(841), 1,
      sym__label_name,
    STATE(845), 1,
      sym__node_name,
    STATE(998), 1,
      sym_reference,
    ACTIONS(37), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(6), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [3570] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__node_path,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(23), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(25), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(27), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(29), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(33), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(35), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(313), 1,
      aux_sym_preproc_if_token2,
    STATE(647), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(698), 1,
      sym__label,
    STATE(841), 1,
      sym__label_name,
    STATE(845), 1,
      sym__node_name,
    STATE(998), 1,
      sym_reference,
    ACTIONS(37), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(6), 15,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_delete_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [3664] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 1,
      aux_sym__label_name_token1,
    ACTIONS(229), 1,
      aux_sym__node_name_token1,
    ACTIONS(232), 1,
      aux_sym__property_name_token1,
    ACTIONS(235), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(315), 1,
      sym__node_path,
    ACTIONS(318), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(321), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(324), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(327), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(330), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(333), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(336), 1,
      aux_sym_preproc_if_token1,
    STATE(625), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(708), 1,
      sym__label_name,
    STATE(718), 1,
      sym__node_name,
    STATE(865), 1,
      sym__property_name,
    STATE(1164), 1,
      sym_reference,
    ACTIONS(339), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(262), 3,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    STATE(38), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3755] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(344), 1,
      anon_sym_RBRACE,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3844] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(362), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3933] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(364), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4022] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(366), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4111] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(368), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4200] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(370), 1,
      sym__node_path,
    ACTIONS(372), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(374), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(376), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(378), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(380), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(382), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(384), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(386), 1,
      aux_sym_preproc_if_token2,
    STATE(627), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(706), 1,
      sym__label_name,
    STATE(740), 1,
      sym__node_name,
    STATE(856), 1,
      sym__property_name,
    STATE(1174), 1,
      sym_reference,
    ACTIONS(388), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(48), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4289] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(390), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(50), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4378] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(392), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(51), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4467] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(394), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(52), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4556] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(370), 1,
      sym__node_path,
    ACTIONS(372), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(374), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(376), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(378), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(380), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(382), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(384), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(396), 1,
      aux_sym_preproc_if_token2,
    STATE(627), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(706), 1,
      sym__label_name,
    STATE(740), 1,
      sym__node_name,
    STATE(856), 1,
      sym__property_name,
    STATE(1174), 1,
      sym_reference,
    ACTIONS(388), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(55), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4645] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(398), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(60), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4734] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(400), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4823] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(402), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4912] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(404), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5001] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(406), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(94), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5090] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(408), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(40), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5179] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 1,
      aux_sym__label_name_token1,
    ACTIONS(229), 1,
      aux_sym__node_name_token1,
    ACTIONS(232), 1,
      aux_sym__property_name_token1,
    ACTIONS(235), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(262), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(410), 1,
      sym__node_path,
    ACTIONS(413), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(416), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(419), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(422), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(425), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(428), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(431), 1,
      aux_sym_preproc_if_token1,
    STATE(627), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(706), 1,
      sym__label_name,
    STATE(740), 1,
      sym__node_name,
    STATE(856), 1,
      sym__property_name,
    STATE(1174), 1,
      sym_reference,
    ACTIONS(434), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(55), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5268] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(437), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(41), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5357] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(439), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(42), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5446] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(441), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(43), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5535] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 1,
      aux_sym__label_name_token1,
    ACTIONS(229), 1,
      aux_sym__node_name_token1,
    ACTIONS(232), 1,
      aux_sym__property_name_token1,
    ACTIONS(235), 1,
      anon_sym_AMP,
    ACTIONS(238), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(262), 1,
      anon_sym_RBRACE,
    ACTIONS(443), 1,
      sym__node_path,
    ACTIONS(446), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(449), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(452), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(455), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(458), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(461), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(464), 1,
      aux_sym_preproc_if_token1,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(467), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5624] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(470), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5713] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(472), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(62), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5802] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(474), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5891] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(476), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(68), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5980] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(478), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(69), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6069] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(480), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(70), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6158] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(482), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(71), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6247] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(484), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(72), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6336] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(486), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6425] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(488), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6514] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(490), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6603] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(492), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6692] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(494), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6781] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(496), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(76), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6870] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(498), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(77), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6959] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(500), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(78), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7048] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(502), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7137] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(504), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7226] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(506), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7315] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(508), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(80), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7404] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(510), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7493] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(512), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(86), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7582] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(514), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(87), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7671] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(516), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(88), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7760] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(518), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(89), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7849] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(520), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(90), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7938] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(522), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8027] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(524), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8116] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(526), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8205] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(528), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8294] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(530), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8383] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(532), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(150), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8472] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(534), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(95), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8561] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(536), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(96), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8650] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(538), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8739] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(540), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8828] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(542), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8917] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(544), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(98), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9006] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(546), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9095] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(548), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(104), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9184] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(550), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(105), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9273] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(552), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(106), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9362] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(554), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(107), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9451] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(556), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(108), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9540] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(558), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9629] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(560), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9718] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(562), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9807] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(564), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9896] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(566), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9985] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(568), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(112), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10074] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(570), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(113), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10163] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(572), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(114), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10252] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(574), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10341] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(576), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10430] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(578), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10519] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(580), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(116), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10608] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(582), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10697] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(584), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(122), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10786] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(586), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(123), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10875] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(588), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(39), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10964] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(590), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(124), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11053] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(592), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(125), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11142] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(594), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11231] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(596), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11320] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(598), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11409] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(600), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11498] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(602), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(129), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11587] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(604), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(130), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11676] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(606), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(131), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11765] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(608), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11854] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(610), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11943] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(612), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12032] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(614), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(133), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12121] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(616), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12210] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(618), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(139), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12299] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(620), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(140), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12388] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(622), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(141), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12477] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(624), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(142), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12566] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(626), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(143), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12655] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(628), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12744] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(630), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12833] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(632), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12922] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(634), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [13011] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(636), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [13100] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(638), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(147), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [13189] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(640), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(148), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [13278] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(642), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(149), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [13367] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(644), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [13456] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(646), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [13545] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(648), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [13634] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(342), 1,
      sym__node_path,
    ACTIONS(346), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(348), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(350), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(352), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(354), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(356), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(358), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(650), 1,
      anon_sym_RBRACE,
    STATE(608), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(702), 1,
      sym__label,
    STATE(712), 1,
      sym__label_name,
    STATE(719), 1,
      sym__node_name,
    STATE(870), 1,
      sym__property_name,
    STATE(1129), 1,
      sym_reference,
    ACTIONS(360), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [13723] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(652), 21,
      anon_sym_COLON,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer_literal,
      sym_identifier,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(656), 21,
      anon_sym_COLON,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer_literal,
      sym_identifier,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13791] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(660), 21,
      anon_sym_COLON,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer_literal,
      sym_identifier,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13825] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer_literal,
      sym_identifier,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13859] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_LPAREN,
    STATE(154), 1,
      sym_argument_list,
    ACTIONS(670), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(668), 17,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13895] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(674), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [13926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(678), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [13957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(682), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [13988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(678), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14019] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(678), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14050] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(686), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(690), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(694), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14143] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(698), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14174] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(704), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(702), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(706), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14236] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(710), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14267] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(714), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(718), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(722), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(726), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14391] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(730), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14422] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(734), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(738), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14484] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(742), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14515] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(746), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14546] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(750), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14577] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(746), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14608] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(754), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14639] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(746), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14670] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(746), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(758), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(762), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14763] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(766), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14794] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(770), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14825] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(774), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14856] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(774), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(774), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14918] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(778), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(784), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(782), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [14980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(786), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [15011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(786), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [15042] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(786), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [15073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(790), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [15104] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(678), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [15135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(796), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(794), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [15166] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(798), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [15197] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(804), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(802), 12,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [15228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(808), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(806), 17,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15258] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(810), 17,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15288] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(816), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(814), 7,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
  [15332] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(814), 17,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15362] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(816), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(814), 11,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [15400] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(816), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(814), 15,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15434] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE,
    ACTIONS(838), 1,
      anon_sym_CARET,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(814), 5,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
  [15484] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE,
    ACTIONS(838), 1,
      anon_sym_CARET,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(814), 6,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
  [15532] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      anon_sym_PIPE,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(838), 1,
      anon_sym_CARET,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(814), 6,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
  [15580] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      anon_sym_PIPE,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(814), 7,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
  [15626] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(816), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(814), 9,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [15668] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(816), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(814), 13,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15704] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE,
    ACTIONS(838), 1,
      anon_sym_CARET,
    ACTIONS(842), 1,
      anon_sym_QMARK,
    ACTIONS(844), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(840), 3,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15758] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE,
    ACTIONS(838), 1,
      anon_sym_CARET,
    ACTIONS(842), 1,
      anon_sym_QMARK,
    ACTIONS(844), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(846), 1,
      anon_sym_COMMA,
    ACTIONS(848), 1,
      anon_sym_RPAREN,
    STATE(797), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15816] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      anon_sym_LPAREN,
    STATE(304), 1,
      sym_preproc_argument_list,
    ACTIONS(850), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(852), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15850] = 5,
    ACTIONS(852), 1,
      anon_sym_LF,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(858), 1,
      anon_sym_LPAREN,
    STATE(371), 1,
      sym_preproc_argument_list,
    ACTIONS(850), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15883] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE,
    ACTIONS(838), 1,
      anon_sym_CARET,
    ACTIONS(842), 1,
      anon_sym_QMARK,
    ACTIONS(844), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(860), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15936] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_AMP,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(868), 1,
      anon_sym_RPAREN,
    ACTIONS(876), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(878), 1,
      anon_sym_AMP_AMP,
    ACTIONS(880), 1,
      anon_sym_PIPE,
    ACTIONS(882), 1,
      anon_sym_CARET,
    STATE(811), 1,
      aux_sym_preproc_argument_list_repeat1,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15991] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_AMP,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(876), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(878), 1,
      anon_sym_AMP_AMP,
    ACTIONS(880), 1,
      anon_sym_PIPE,
    ACTIONS(882), 1,
      anon_sym_CARET,
    ACTIONS(890), 1,
      anon_sym_RPAREN,
    STATE(789), 1,
      aux_sym_preproc_argument_list_repeat1,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [16046] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(804), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16074] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(706), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(708), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(710), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(712), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16130] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(684), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16158] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(728), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16186] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(740), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16214] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(680), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16242] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(680), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16270] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(680), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(680), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16326] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(692), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16354] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(748), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16382] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(748), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(748), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(748), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16466] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(760), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16494] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(776), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16522] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(776), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16550] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(776), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(788), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16606] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(788), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16634] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(788), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [16662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(894), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(898), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16718] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(902), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16746] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(906), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16774] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(910), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16802] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(906), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(910), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16858] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(906), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16886] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(910), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(914), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16942] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(918), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16970] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(922), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [16998] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(926), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17026] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(922), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17054] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(926), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17082] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(922), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(926), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17138] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_AMP,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(876), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(878), 1,
      anon_sym_AMP_AMP,
    ACTIONS(880), 1,
      anon_sym_PIPE,
    ACTIONS(882), 1,
      anon_sym_CARET,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(928), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [17188] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(932), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17216] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(932), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(932), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17272] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(778), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(730), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17328] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(790), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17356] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(754), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(766), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(698), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(694), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(936), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17496] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(706), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17524] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE,
    ACTIONS(838), 1,
      anon_sym_CARET,
    ACTIONS(842), 1,
      anon_sym_QMARK,
    ACTIONS(844), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(938), 1,
      anon_sym_RPAREN,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17576] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(710), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(682), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(726), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(738), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(678), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17716] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE,
    ACTIONS(838), 1,
      anon_sym_CARET,
    ACTIONS(842), 1,
      anon_sym_QMARK,
    ACTIONS(844), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(940), 1,
      anon_sym_RPAREN,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17768] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(678), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(678), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17824] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(678), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(690), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17880] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(746), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(746), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17936] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(746), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(746), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [17992] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(758), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [18020] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(774), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [18048] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      anon_sym_AMP,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE,
    ACTIONS(838), 1,
      anon_sym_CARET,
    ACTIONS(842), 1,
      anon_sym_QMARK,
    ACTIONS(844), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(942), 1,
      anon_sym_COLON,
    ACTIONS(820), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(822), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(824), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(826), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(828), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(830), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [18100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(774), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [18128] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(774), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [18156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(736), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(786), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [18212] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(786), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [18240] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(800), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18268] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(946), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [18296] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(704), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(780), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18352] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(732), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18380] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(792), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18408] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(718), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(720), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(722), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(724), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(796), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18492] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(756), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(768), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18548] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(950), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [18576] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(954), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [18604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(958), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [18632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(764), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(688), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(962), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [18716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(698), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(700), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18744] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(966), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [18772] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(970), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [18800] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(972), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(974), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
  [18842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(974), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [18870] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(972), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(974), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [18906] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(972), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(974), 13,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [18938] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_AMP,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(878), 1,
      anon_sym_AMP_AMP,
    ACTIONS(880), 1,
      anon_sym_PIPE,
    ACTIONS(882), 1,
      anon_sym_CARET,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(974), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
  [18986] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_AMP,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(880), 1,
      anon_sym_PIPE,
    ACTIONS(882), 1,
      anon_sym_CARET,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(974), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
  [19032] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_AMP,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(882), 1,
      anon_sym_CARET,
    ACTIONS(972), 1,
      anon_sym_PIPE,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(974), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
  [19078] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(696), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19106] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_AMP,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(972), 1,
      anon_sym_PIPE,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(974), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
  [19150] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(972), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(974), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19190] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(972), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(974), 11,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19224] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(714), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(716), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(978), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(676), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19308] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(982), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19336] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(986), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19364] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(990), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19392] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(994), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(994), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19448] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(994), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19476] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(998), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19504] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(1002), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(744), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19560] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(752), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(770), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(772), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19616] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 10,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(784), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(1006), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19672] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(1010), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(1014), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19728] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(1018), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19756] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(1022), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(1026), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(1026), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(1026), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 8,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(786), 12,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [19896] = 12,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1036), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1048), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [19941] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(958), 1,
      anon_sym_LF,
    ACTIONS(956), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19968] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(966), 1,
      anon_sym_LF,
    ACTIONS(964), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19995] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(970), 1,
      anon_sym_LF,
    ACTIONS(968), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20022] = 8,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(972), 5,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [20059] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(972), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20086] = 6,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(972), 11,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20119] = 4,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(972), 15,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20148] = 12,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(972), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20193] = 12,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1036), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1050), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20238] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_AMP,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(876), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(878), 1,
      anon_sym_AMP_AMP,
    ACTIONS(880), 1,
      anon_sym_PIPE,
    ACTIONS(882), 1,
      anon_sym_CARET,
    ACTIONS(1052), 1,
      anon_sym_RPAREN,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20287] = 11,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(972), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20330] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(978), 1,
      anon_sym_LF,
    ACTIONS(976), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20357] = 10,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(972), 3,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20398] = 9,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(972), 4,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20437] = 7,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(972), 7,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20472] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(972), 13,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20503] = 12,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1036), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1054), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20548] = 12,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1036), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1056), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20593] = 12,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1036), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1058), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20638] = 12,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1036), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1060), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20683] = 12,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1036), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1062), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20728] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_AMP,
    ACTIONS(864), 1,
      anon_sym_SLASH,
    ACTIONS(876), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(878), 1,
      anon_sym_AMP_AMP,
    ACTIONS(880), 1,
      anon_sym_PIPE,
    ACTIONS(882), 1,
      anon_sym_CARET,
    ACTIONS(1064), 1,
      anon_sym_RPAREN,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(872), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(884), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(886), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(888), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20777] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(950), 1,
      anon_sym_LF,
    ACTIONS(948), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20804] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(998), 1,
      anon_sym_LF,
    ACTIONS(996), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20831] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1002), 1,
      anon_sym_LF,
    ACTIONS(1000), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20858] = 12,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_AMP,
    ACTIONS(1036), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    ACTIONS(1042), 1,
      anon_sym_CARET,
    ACTIONS(1066), 1,
      anon_sym_LF,
    ACTIONS(1034), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1044), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1030), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1032), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20903] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(954), 1,
      anon_sym_LF,
    ACTIONS(952), 18,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [20930] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(786), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [20956] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(694), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [20982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(706), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21008] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(710), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(682), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(726), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21086] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(738), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21138] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21216] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(690), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21242] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21268] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21294] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21320] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(758), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(774), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21398] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(774), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21424] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(774), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(946), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21476] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(786), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21502] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(786), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21528] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(906), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(910), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(906), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21606] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(910), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(906), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21658] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(910), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21684] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(898), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(902), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21736] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(914), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21762] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(918), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21788] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(922), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21814] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(926), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(922), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(894), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21892] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(922), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21918] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(926), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21944] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(932), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21970] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(932), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [21996] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(932), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22022] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(962), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22048] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(778), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22074] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(730), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(982), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22126] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(986), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22152] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(990), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22178] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(994), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(994), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(994), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22256] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(790), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22282] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(754), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22308] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(766), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22334] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1006), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1010), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22386] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1014), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1018), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1022), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1026), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22490] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1026), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1026), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22542] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(698), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22568] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(936), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22594] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(926), 11,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
  [22620] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1068), 1,
      anon_sym_SEMI,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    STATE(603), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(752), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22665] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1080), 1,
      anon_sym_SEMI,
    STATE(592), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(794), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22710] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1082), 1,
      anon_sym_SEMI,
    STATE(593), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(774), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22755] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1084), 1,
      anon_sym_SEMI,
    STATE(596), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(792), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22800] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1086), 1,
      anon_sym_SEMI,
    STATE(597), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(795), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22845] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1088), 1,
      anon_sym_SEMI,
    STATE(598), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(798), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22890] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1090), 1,
      anon_sym_SEMI,
    STATE(599), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(839), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22935] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1092), 1,
      anon_sym_SEMI,
    STATE(601), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(750), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22980] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1094), 1,
      anon_sym_SEMI,
    STATE(602), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(751), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23025] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_SEMI,
    STATE(588), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(769), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23070] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1098), 1,
      anon_sym_SEMI,
    STATE(589), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(775), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23115] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1100), 1,
      anon_sym_SEMI,
    STATE(590), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(776), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23160] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1102), 1,
      anon_sym_SEMI,
    STATE(591), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(777), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23205] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1104), 1,
      anon_sym_SEMI,
    STATE(595), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(829), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23250] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1106), 1,
      anon_sym_SEMI,
    STATE(600), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(830), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23295] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1070), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1108), 1,
      anon_sym_SEMI,
    STATE(587), 1,
      sym__bits,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(831), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23340] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23364] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23388] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(690), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23460] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23484] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23508] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(758), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23556] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(774), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(774), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(774), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(786), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23652] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(786), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23676] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(786), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(766), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23724] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(790), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23748] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1006), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23772] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(694), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1006), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23820] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1010), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23844] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(706), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(710), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23892] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1014), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23916] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1010), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1014), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1018), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [23988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1022), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1026), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24036] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1026), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1018), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24084] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1026), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24108] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1022), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24132] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(932), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1026), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24180] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1026), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(1026), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(982), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(778), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24276] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(730), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(790), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(986), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24348] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(754), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(766), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24396] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(698), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(682), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24444] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(726), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(694), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24492] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(738), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(706), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24540] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(710), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24564] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(682), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(990), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24612] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(936), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24636] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(932), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24684] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24708] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(932), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(994), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24756] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24780] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(690), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(894), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24828] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(898), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(902), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24876] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(906), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24900] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(910), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24924] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(906), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24948] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24972] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [24996] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25020] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(746), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(758), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(910), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25092] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(994), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25116] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(906), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25140] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(910), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(936), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25188] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(982), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25212] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(914), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25236] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(986), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25260] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(774), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25284] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(774), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25308] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(774), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25332] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(918), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25356] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(922), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25380] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(926), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25404] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(922), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25428] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(946), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25452] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(926), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25476] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(922), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(926), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(786), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25548] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(786), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25572] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(786), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25596] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(990), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(994), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(726), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25668] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(994), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25692] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(738), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(994), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25740] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(894), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25788] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(898), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(902), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25836] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(906), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(910), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25884] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(906), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(910), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25932] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(906), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25956] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(910), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [25980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(994), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(754), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26028] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(914), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26052] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(932), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26076] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(932), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(932), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26124] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(962), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26148] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(678), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26172] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(918), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(922), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26220] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(926), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(922), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26268] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(926), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26292] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(922), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26316] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(926), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26340] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(730), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26364] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(962), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26388] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(778), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(698), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 7,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      aux_sym_preproc_if_token1,
    ACTIONS(946), 9,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
  [26460] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1110), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(748), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26499] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1112), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(772), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26538] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1114), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(779), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26577] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1116), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(781), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26616] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1118), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(783), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26655] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1120), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(824), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26694] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1122), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(790), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26733] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1126), 1,
      anon_sym_RPAREN,
    ACTIONS(1128), 1,
      sym_integer_literal,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(216), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [26766] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1136), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(788), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26805] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1138), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(800), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26844] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1140), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(805), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26883] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1142), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(807), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26922] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1144), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(759), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26961] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1146), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(817), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [27000] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1148), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(754), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [27039] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1150), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(756), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [27078] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    ACTIONS(1152), 1,
      anon_sym_SEMI,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(758), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [27117] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1154), 1,
      anon_sym_RPAREN,
    ACTIONS(1156), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(217), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27150] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1160), 1,
      sym_integer_literal,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(365), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27180] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1168), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(322), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27210] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1170), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(323), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27240] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(1172), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(692), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(702), 1,
      sym__label,
    STATE(711), 1,
      sym__label_name,
    STATE(737), 1,
      sym__node_name,
    STATE(876), 1,
      sym__property_name,
    STATE(1135), 1,
      sym_reference,
  [27286] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1174), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(374), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27316] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1176), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(355), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27346] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1074), 1,
      anon_sym_LT,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    ACTIONS(1078), 1,
      anon_sym_LBRACK,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(920), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [27382] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1178), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(313), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27412] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1180), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(318), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27442] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1182), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(319), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27472] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1184), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(363), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27502] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1186), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(257), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27532] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1188), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(362), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27562] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1190), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(370), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27592] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1192), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(348), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27622] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1194), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(357), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27652] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1196), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(317), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27682] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1198), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(305), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27712] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1200), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(314), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27742] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1202), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(359), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27772] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(1204), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(692), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(702), 1,
      sym__label,
    STATE(713), 1,
      sym__label_name,
    STATE(738), 1,
      sym__node_name,
    STATE(881), 1,
      sym__property_name,
    STATE(941), 1,
      sym_reference,
  [27818] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1206), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(361), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27848] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(1208), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(692), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(702), 1,
      sym__label,
    STATE(705), 1,
      sym__label_name,
    STATE(721), 1,
      sym__node_name,
    STATE(899), 1,
      sym__property_name,
    STATE(1178), 1,
      sym_reference,
  [27894] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1210), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27924] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1212), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(364), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27954] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1214), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(358), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27984] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1216), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(375), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28014] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1218), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(321), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28044] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1220), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(352), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28074] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1222), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(353), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28104] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    ACTIONS(1130), 1,
      sym_identifier,
    ACTIONS(1134), 1,
      anon_sym_defined,
    ACTIONS(1224), 1,
      sym_integer_literal,
    ACTIONS(1132), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(316), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28134] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1226), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(354), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28164] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    ACTIONS(1228), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(692), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(702), 1,
      sym__label,
    STATE(707), 1,
      sym__label_name,
    STATE(724), 1,
      sym__node_name,
    STATE(873), 1,
      sym__property_name,
    STATE(1157), 1,
      sym_reference,
  [28210] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1230), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(366), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28240] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1232), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(367), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28270] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1234), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(369), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28300] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1236), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(368), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28330] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      sym_identifier,
    ACTIONS(1166), 1,
      anon_sym_defined,
    ACTIONS(1238), 1,
      sym_integer_literal,
    ACTIONS(1164), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(356), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [28360] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(133), 1,
      sym__node_path,
    STATE(261), 1,
      sym_node,
    STATE(676), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(709), 1,
      sym__label,
    STATE(820), 1,
      sym__label_name,
    STATE(859), 1,
      sym_reference,
    STATE(909), 1,
      sym__node_name,
  [28403] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1242), 1,
      anon_sym_RPAREN,
    ACTIONS(1244), 1,
      sym_integer_literal,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(212), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28432] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(370), 1,
      sym__node_path,
    STATE(495), 1,
      sym_node,
    STATE(653), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(709), 1,
      sym__label,
    STATE(837), 1,
      sym__label_name,
    STATE(889), 1,
      sym_reference,
    STATE(917), 1,
      sym__node_name,
  [28475] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(111), 1,
      sym__node_path,
    STATE(296), 1,
      sym_node,
    STATE(675), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(709), 1,
      sym__label,
    STATE(816), 1,
      sym__label_name,
    STATE(849), 1,
      sym_reference,
    STATE(904), 1,
      sym__node_name,
  [28518] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1250), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(1252), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(691), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(698), 1,
      sym__label,
    STATE(821), 1,
      sym__label_name,
    STATE(863), 1,
      sym__node_name,
    STATE(1082), 1,
      sym_reference,
  [28561] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(342), 1,
      sym__node_path,
    STATE(584), 1,
      sym_node,
    STATE(674), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(709), 1,
      sym__label,
    STATE(804), 1,
      sym__label_name,
    STATE(882), 1,
      sym_reference,
    STATE(898), 1,
      sym__node_name,
  [28604] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      sym__node_path,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    STATE(189), 1,
      sym_node,
    STATE(669), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(709), 1,
      sym__label,
    STATE(828), 1,
      sym__label_name,
    STATE(845), 1,
      sym__node_name,
    STATE(851), 1,
      sym_reference,
  [28647] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(269), 1,
      sym__node_path,
    STATE(419), 1,
      sym_node,
    STATE(677), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(709), 1,
      sym__label,
    STATE(827), 1,
      sym__label_name,
    STATE(877), 1,
      sym_reference,
    STATE(913), 1,
      sym__node_name,
  [28690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1256), 1,
      anon_sym_AMP,
    ACTIONS(1254), 12,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [28711] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1258), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(1260), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(691), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(698), 1,
      sym__label,
    STATE(840), 1,
      sym__label_name,
    STATE(907), 1,
      sym__node_name,
    STATE(1146), 1,
      sym_reference,
  [28754] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1208), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(694), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(709), 1,
      sym__label,
    STATE(836), 1,
      sym__label_name,
    STATE(919), 1,
      sym__node_name,
    STATE(1178), 1,
      sym_reference,
  [28794] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1262), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(276), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28820] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1264), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(199), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28846] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      anon_sym_AMP,
    ACTIONS(1269), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1272), 1,
      anon_sym_LPAREN,
    ACTIONS(1275), 1,
      anon_sym_GT,
    ACTIONS(1277), 1,
      sym_integer_literal,
    ACTIONS(1280), 1,
      sym_identifier,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(656), 4,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
      aux_sym_integer_cells_repeat1,
  [28880] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1283), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(201), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28906] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1285), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(202), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28932] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1287), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(203), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28958] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1289), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(287), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28984] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1291), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(204), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29010] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1293), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(205), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29036] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1295), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(206), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29062] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1297), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(207), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29088] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(208), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29114] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1301), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(209), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29140] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1303), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(210), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29166] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1305), 1,
      anon_sym_LPAREN,
    ACTIONS(1307), 1,
      anon_sym_GT,
    ACTIONS(1309), 1,
      sym_integer_literal,
    ACTIONS(1311), 1,
      sym_identifier,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(673), 4,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
      aux_sym_integer_cells_repeat1,
  [29200] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1252), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(694), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(709), 1,
      sym__label,
    STATE(813), 1,
      sym__label_name,
    STATE(863), 1,
      sym__node_name,
    STATE(1082), 1,
      sym_reference,
  [29240] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1313), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(215), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29266] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1315), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(211), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29292] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      sym_identifier,
    ACTIONS(1317), 1,
      sym_integer_literal,
    ACTIONS(1248), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(270), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [29318] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1305), 1,
      anon_sym_LPAREN,
    ACTIONS(1311), 1,
      sym_identifier,
    ACTIONS(1319), 1,
      anon_sym_GT,
    ACTIONS(1321), 1,
      sym_integer_literal,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(656), 4,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
      aux_sym_integer_cells_repeat1,
  [29352] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1172), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(694), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(709), 1,
      sym__label,
    STATE(803), 1,
      sym__label_name,
    STATE(903), 1,
      sym__node_name,
    STATE(1135), 1,
      sym_reference,
  [29392] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1260), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(694), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(709), 1,
      sym__label,
    STATE(815), 1,
      sym__label_name,
    STATE(907), 1,
      sym__node_name,
    STATE(1146), 1,
      sym_reference,
  [29432] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1228), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(694), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(709), 1,
      sym__label,
    STATE(819), 1,
      sym__label_name,
    STATE(912), 1,
      sym__node_name,
    STATE(1157), 1,
      sym_reference,
  [29472] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1204), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(694), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(709), 1,
      sym__label,
    STATE(826), 1,
      sym__label_name,
    STATE(916), 1,
      sym__node_name,
    STATE(941), 1,
      sym_reference,
  [29512] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1323), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(1005), 1,
      sym_reference,
    STATE(858), 2,
      sym__label_name,
      sym__node_name,
  [29544] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1305), 1,
      anon_sym_LPAREN,
    ACTIONS(1311), 1,
      sym_identifier,
    ACTIONS(1325), 1,
      sym_integer_literal,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(1021), 3,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
  [29574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 1,
      anon_sym_AMP,
    ACTIONS(1327), 9,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29592] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1331), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(1130), 1,
      sym_reference,
    STATE(850), 2,
      sym__label_name,
      sym__node_name,
  [29624] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1333), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(1062), 1,
      sym_reference,
    STATE(866), 2,
      sym__label_name,
      sym__node_name,
  [29656] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1335), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(1189), 1,
      sym_reference,
    STATE(878), 2,
      sym__label_name,
      sym__node_name,
  [29688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1339), 1,
      anon_sym_AMP,
    ACTIONS(1337), 9,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29706] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1341), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(1112), 1,
      sym_reference,
    STATE(887), 2,
      sym__label_name,
      sym__node_name,
  [29738] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1343), 1,
      sym__node_path,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(956), 1,
      sym_reference,
    STATE(892), 2,
      sym__label_name,
      sym__node_name,
  [29770] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_AMP,
    ACTIONS(21), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1305), 1,
      anon_sym_LPAREN,
    ACTIONS(1311), 1,
      sym_identifier,
    ACTIONS(1345), 1,
      sym_integer_literal,
    STATE(680), 1,
      sym__node_reference,
    STATE(689), 1,
      sym__label_reference,
    STATE(1186), 3,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
  [29800] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 1,
      anon_sym_AMP,
    ACTIONS(1347), 9,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 1,
      anon_sym_AMP,
    ACTIONS(1351), 9,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29836] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_LPAREN,
    ACTIONS(1355), 1,
      anon_sym_AMP,
    STATE(154), 1,
      sym_argument_list,
    ACTIONS(1357), 6,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29857] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 1,
      aux_sym__label_name_token1,
    ACTIONS(1364), 1,
      anon_sym_AMP_LBRACE,
    STATE(691), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(698), 1,
      sym__label,
    STATE(1061), 1,
      sym__label_name,
    ACTIONS(1359), 4,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__node_name_token1,
      anon_sym_AMP,
  [29882] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 1,
      aux_sym__label_name_token1,
    ACTIONS(1364), 1,
      anon_sym_AMP_LBRACE,
    STATE(692), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(702), 1,
      sym__label,
    STATE(1110), 1,
      sym__label_name,
    ACTIONS(1359), 4,
      sym__node_path,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
  [29907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1366), 1,
      anon_sym_AMP,
    ACTIONS(1368), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29923] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 1,
      aux_sym__label_name_token1,
    ACTIONS(1364), 1,
      anon_sym_AMP_LBRACE,
    STATE(694), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(709), 1,
      sym__label,
    STATE(1067), 1,
      sym__label_name,
    ACTIONS(1359), 3,
      sym__node_path,
      aux_sym__node_name_token1,
      anon_sym_AMP,
  [29947] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1372), 1,
      anon_sym_AMP,
    ACTIONS(1370), 6,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHincbin_SLASH,
      anon_sym_LT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
  [29962] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    STATE(1069), 3,
      sym__label_name,
      sym__node_name,
      sym__property_name,
  [29980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1376), 1,
      anon_sym_SLASH,
    ACTIONS(1374), 5,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_LBRACE,
      anon_sym_EQ,
  [29994] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1380), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1378), 5,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
  [30008] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    STATE(1090), 3,
      sym__label_name,
      sym__node_name,
      sym__property_name,
  [30026] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    STATE(1184), 3,
      sym__label_name,
      sym__node_name,
      sym__property_name,
  [30044] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      aux_sym__label_name_token1,
    ACTIONS(17), 1,
      aux_sym__node_name_token1,
    ACTIONS(135), 1,
      aux_sym__property_name_token1,
    STATE(1087), 3,
      sym__label_name,
      sym__node_name,
      sym__property_name,
  [30062] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1380), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1378), 5,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
  [30076] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1382), 5,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
  [30090] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1382), 5,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      aux_sym__property_name_token1,
      anon_sym_AMP,
  [30104] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      anon_sym_COLON,
    ACTIONS(1388), 1,
      anon_sym_SEMI,
    ACTIONS(1390), 1,
      anon_sym_AT,
    ACTIONS(1392), 1,
      anon_sym_LBRACE,
    ACTIONS(1394), 1,
      anon_sym_EQ,
  [30123] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      anon_sym_COLON,
    ACTIONS(1396), 1,
      anon_sym_SEMI,
    ACTIONS(1398), 1,
      anon_sym_AT,
    ACTIONS(1400), 1,
      anon_sym_LBRACE,
    ACTIONS(1402), 1,
      anon_sym_EQ,
  [30142] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      anon_sym_COLON,
    ACTIONS(1404), 1,
      anon_sym_SEMI,
    ACTIONS(1406), 1,
      anon_sym_AT,
    ACTIONS(1408), 1,
      anon_sym_LBRACE,
    ACTIONS(1410), 1,
      anon_sym_EQ,
  [30161] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      anon_sym_COLON,
    ACTIONS(1412), 1,
      anon_sym_SEMI,
    ACTIONS(1414), 1,
      anon_sym_AT,
    ACTIONS(1416), 1,
      anon_sym_LBRACE,
    ACTIONS(1418), 1,
      anon_sym_EQ,
  [30180] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1380), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1378), 4,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
  [30193] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1382), 4,
      sym__node_path,
      aux_sym__label_name_token1,
      aux_sym__node_name_token1,
      anon_sym_AMP,
  [30206] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      anon_sym_COLON,
    ACTIONS(1420), 1,
      anon_sym_SEMI,
    ACTIONS(1422), 1,
      anon_sym_AT,
    ACTIONS(1424), 1,
      anon_sym_LBRACE,
    ACTIONS(1426), 1,
      anon_sym_EQ,
  [30225] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      anon_sym_COLON,
    ACTIONS(1428), 1,
      anon_sym_SEMI,
    ACTIONS(1430), 1,
      anon_sym_AT,
    ACTIONS(1432), 1,
      anon_sym_LBRACE,
    ACTIONS(1434), 1,
      anon_sym_EQ,
  [30244] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      anon_sym_COLON,
    ACTIONS(1436), 1,
      anon_sym_SEMI,
    ACTIONS(1438), 1,
      anon_sym_AT,
    ACTIONS(1440), 1,
      anon_sym_LBRACE,
    ACTIONS(1442), 1,
      anon_sym_EQ,
  [30263] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      anon_sym_COLON,
    ACTIONS(1444), 1,
      anon_sym_SEMI,
    ACTIONS(1446), 1,
      anon_sym_AT,
    ACTIONS(1448), 1,
      anon_sym_LBRACE,
    ACTIONS(1450), 1,
      anon_sym_EQ,
  [30282] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      anon_sym_DQUOTE,
    STATE(1134), 1,
      sym_string_literal,
    ACTIONS(1454), 2,
      sym_system_lib_string,
      sym_identifier,
  [30296] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1444), 1,
      anon_sym_SEMI,
    ACTIONS(1446), 1,
      anon_sym_AT,
    ACTIONS(1448), 1,
      anon_sym_LBRACE,
    ACTIONS(1450), 1,
      anon_sym_EQ,
  [30312] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1456), 1,
      anon_sym_DQUOTE,
    ACTIONS(1458), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1460), 1,
      sym_escape_sequence,
    STATE(741), 1,
      aux_sym_string_literal_repeat1,
  [30328] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1412), 1,
      anon_sym_SEMI,
    ACTIONS(1414), 1,
      anon_sym_AT,
    ACTIONS(1416), 1,
      anon_sym_LBRACE,
    ACTIONS(1418), 1,
      anon_sym_EQ,
  [30344] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 1,
      anon_sym_SEMI,
    ACTIONS(1430), 1,
      anon_sym_AT,
    ACTIONS(1432), 1,
      anon_sym_LBRACE,
    ACTIONS(1434), 1,
      anon_sym_EQ,
  [30360] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1462), 1,
      anon_sym_DQUOTE,
    ACTIONS(1464), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1466), 1,
      sym_escape_sequence,
    STATE(717), 1,
      aux_sym_string_literal_repeat1,
  [30376] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1468), 1,
      anon_sym_SEMI,
    ACTIONS(1470), 1,
      anon_sym_AT,
    ACTIONS(1472), 1,
      anon_sym_LBRACE,
    ACTIONS(1474), 1,
      anon_sym_EQ,
  [30392] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1476), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1478), 1,
      anon_sym_LPAREN2,
    ACTIONS(1480), 1,
      sym_preproc_arg,
    STATE(914), 1,
      sym_preproc_params,
  [30408] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1482), 1,
      anon_sym_SLASH,
    STATE(988), 1,
      sym_path,
    STATE(735), 2,
      sym_path_node,
      aux_sym_path_repeat1,
  [30422] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1484), 1,
      anon_sym_SEMI,
    ACTIONS(1486), 1,
      anon_sym_AT,
    ACTIONS(1488), 1,
      anon_sym_LBRACE,
    ACTIONS(1490), 1,
      anon_sym_EQ,
  [30438] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      anon_sym_DQUOTE,
    STATE(1012), 1,
      sym_string_literal,
    ACTIONS(1492), 2,
      sym_system_lib_string,
      sym_identifier,
  [30452] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1458), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1460), 1,
      sym_escape_sequence,
    ACTIONS(1494), 1,
      anon_sym_DQUOTE,
    STATE(741), 1,
      aux_sym_string_literal_repeat1,
  [30468] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      anon_sym_DQUOTE,
    STATE(1073), 1,
      sym_string_literal,
    ACTIONS(1496), 2,
      sym_system_lib_string,
      sym_identifier,
  [30482] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1478), 1,
      anon_sym_LPAREN2,
    ACTIONS(1498), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1500), 1,
      sym_preproc_arg,
    STATE(885), 1,
      sym_preproc_params,
  [30498] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1478), 1,
      anon_sym_LPAREN2,
    ACTIONS(1502), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1504), 1,
      sym_preproc_arg,
    STATE(897), 1,
      sym_preproc_params,
  [30514] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1506), 1,
      anon_sym_SLASH,
    ACTIONS(1509), 1,
      anon_sym_RBRACE,
    STATE(730), 2,
      sym_path_node,
      aux_sym_path_repeat1,
  [30528] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      anon_sym_DQUOTE,
    STATE(1190), 1,
      sym_string_literal,
    ACTIONS(1511), 2,
      sym_system_lib_string,
      sym_identifier,
  [30542] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      anon_sym_DQUOTE,
    STATE(1143), 1,
      sym_string_literal,
    ACTIONS(1513), 2,
      sym_system_lib_string,
      sym_identifier,
  [30556] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1478), 1,
      anon_sym_LPAREN2,
    ACTIONS(1515), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1517), 1,
      sym_preproc_arg,
    STATE(862), 1,
      sym_preproc_params,
  [30572] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1458), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1460), 1,
      sym_escape_sequence,
    ACTIONS(1519), 1,
      anon_sym_DQUOTE,
    STATE(741), 1,
      aux_sym_string_literal_repeat1,
  [30588] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1482), 1,
      anon_sym_SLASH,
    ACTIONS(1521), 1,
      anon_sym_RBRACE,
    STATE(730), 2,
      sym_path_node,
      aux_sym_path_repeat1,
  [30602] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1458), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1460), 1,
      sym_escape_sequence,
    ACTIONS(1523), 1,
      anon_sym_DQUOTE,
    STATE(741), 1,
      aux_sym_string_literal_repeat1,
  [30618] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1525), 1,
      anon_sym_SEMI,
    ACTIONS(1527), 1,
      anon_sym_AT,
    ACTIONS(1529), 1,
      anon_sym_LBRACE,
    ACTIONS(1531), 1,
      anon_sym_EQ,
  [30634] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1533), 1,
      anon_sym_SEMI,
    ACTIONS(1535), 1,
      anon_sym_AT,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
    ACTIONS(1539), 1,
      anon_sym_EQ,
  [30650] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      anon_sym_DQUOTE,
    STATE(957), 1,
      sym_string_literal,
    ACTIONS(1541), 2,
      sym_system_lib_string,
      sym_identifier,
  [30664] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1396), 1,
      anon_sym_SEMI,
    ACTIONS(1398), 1,
      anon_sym_AT,
    ACTIONS(1400), 1,
      anon_sym_LBRACE,
    ACTIONS(1402), 1,
      anon_sym_EQ,
  [30680] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1543), 1,
      anon_sym_DQUOTE,
    ACTIONS(1545), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1548), 1,
      sym_escape_sequence,
    STATE(741), 1,
      aux_sym_string_literal_repeat1,
  [30696] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1553), 1,
      anon_sym_SLASH,
    ACTIONS(1551), 3,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LBRACE,
  [30708] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1555), 1,
      anon_sym_DQUOTE,
    ACTIONS(1557), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1559), 1,
      sym_escape_sequence,
    STATE(736), 1,
      aux_sym_string_literal_repeat1,
  [30724] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1561), 1,
      anon_sym_DQUOTE,
    ACTIONS(1563), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1565), 1,
      sym_escape_sequence,
    STATE(734), 1,
      aux_sym_string_literal_repeat1,
  [30740] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1478), 1,
      anon_sym_LPAREN2,
    ACTIONS(1567), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1569), 1,
      sym_preproc_arg,
    STATE(905), 1,
      sym_preproc_params,
  [30756] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1571), 1,
      anon_sym_DQUOTE,
    ACTIONS(1573), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1575), 1,
      sym_escape_sequence,
    STATE(726), 1,
      aux_sym_string_literal_repeat1,
  [30772] = 5,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1478), 1,
      anon_sym_LPAREN2,
    ACTIONS(1577), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1579), 1,
      sym_preproc_arg,
    STATE(868), 1,
      sym_preproc_params,
  [30788] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1581), 1,
      anon_sym_SEMI,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    STATE(770), 1,
      aux_sym_property_repeat1,
  [30801] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1585), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [30814] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1587), 1,
      anon_sym_SEMI,
    STATE(755), 1,
      aux_sym_property_repeat1,
  [30827] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1589), 1,
      anon_sym_SEMI,
    STATE(757), 1,
      aux_sym_property_repeat1,
  [30840] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1591), 1,
      anon_sym_SEMI,
    STATE(843), 1,
      aux_sym_property_repeat1,
  [30853] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1593), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [30866] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1595), 1,
      anon_sym_SEMI,
    STATE(760), 1,
      aux_sym_property_repeat1,
  [30879] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1597), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [30892] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1599), 1,
      anon_sym_SEMI,
    STATE(761), 1,
      aux_sym_property_repeat1,
  [30905] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1601), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [30918] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1603), 1,
      anon_sym_SEMI,
    STATE(762), 1,
      aux_sym_property_repeat1,
  [30931] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1605), 1,
      anon_sym_SEMI,
    STATE(753), 1,
      aux_sym_property_repeat1,
  [30944] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1607), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [30957] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1609), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [30970] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1611), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [30983] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [30992] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1613), 1,
      anon_sym_SEMI,
    ACTIONS(1615), 1,
      anon_sym_COMMA,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31005] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1618), 1,
      anon_sym_SLASH,
    ACTIONS(1620), 1,
      anon_sym_AT,
    ACTIONS(1622), 1,
      anon_sym_RBRACE,
  [31018] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1624), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1626), 1,
      anon_sym_RPAREN,
    ACTIONS(1628), 2,
      sym_identifier,
      anon_sym_DOT_DOT_DOT,
  [31042] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1630), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31055] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1632), 1,
      anon_sym_SEMI,
    STATE(773), 1,
      aux_sym_property_repeat1,
  [31068] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1634), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31081] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [31090] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1636), 1,
      anon_sym_SEMI,
    STATE(778), 1,
      aux_sym_property_repeat1,
  [31103] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1638), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31116] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1640), 1,
      anon_sym_SEMI,
    STATE(791), 1,
      aux_sym_property_repeat1,
  [31129] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1642), 1,
      anon_sym_SEMI,
    STATE(780), 1,
      aux_sym_property_repeat1,
  [31142] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1644), 1,
      anon_sym_SEMI,
    STATE(782), 1,
      aux_sym_property_repeat1,
  [31155] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1646), 1,
      anon_sym_SEMI,
    STATE(784), 1,
      aux_sym_property_repeat1,
  [31168] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1648), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31181] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1650), 1,
      anon_sym_SEMI,
    STATE(785), 1,
      aux_sym_property_repeat1,
  [31194] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1652), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31207] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1654), 1,
      anon_sym_SEMI,
    STATE(786), 1,
      aux_sym_property_repeat1,
  [31220] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1656), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31233] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1658), 1,
      anon_sym_SEMI,
    STATE(787), 1,
      aux_sym_property_repeat1,
  [31246] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1660), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31259] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1662), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31272] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1664), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31285] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1666), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31298] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1668), 1,
      anon_sym_SEMI,
    STATE(766), 1,
      aux_sym_property_repeat1,
  [31311] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(1670), 1,
      anon_sym_RPAREN,
    STATE(835), 1,
      aux_sym_preproc_argument_list_repeat1,
  [31324] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1672), 1,
      anon_sym_SEMI,
    STATE(799), 1,
      aux_sym_property_repeat1,
  [31337] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1674), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31350] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1676), 1,
      anon_sym_SEMI,
    STATE(801), 1,
      aux_sym_property_repeat1,
  [31363] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1678), 1,
      anon_sym_RBRACK,
    ACTIONS(1680), 1,
      sym__byte_string_item,
    STATE(823), 1,
      aux_sym_byte_string_literal_repeat1,
  [31376] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1682), 1,
      anon_sym_SEMI,
    STATE(825), 1,
      aux_sym_property_repeat1,
  [31389] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1684), 1,
      anon_sym_SEMI,
    STATE(806), 1,
      aux_sym_property_repeat1,
  [31402] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1686), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31415] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      anon_sym_COMMA,
    ACTIONS(1688), 1,
      anon_sym_RPAREN,
    STATE(802), 1,
      aux_sym_argument_list_repeat1,
  [31428] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1690), 1,
      anon_sym_SEMI,
    STATE(808), 1,
      aux_sym_property_repeat1,
  [31441] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1692), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31454] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1694), 1,
      anon_sym_SEMI,
    STATE(810), 1,
      aux_sym_property_repeat1,
  [31467] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1696), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31480] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 1,
      anon_sym_RPAREN,
    ACTIONS(1698), 1,
      anon_sym_COMMA,
    STATE(802), 1,
      aux_sym_argument_list_repeat1,
  [31493] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1422), 1,
      anon_sym_AT,
    ACTIONS(1424), 1,
      anon_sym_LBRACE,
    ACTIONS(1701), 1,
      anon_sym_COLON,
  [31506] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1430), 1,
      anon_sym_AT,
    ACTIONS(1432), 1,
      anon_sym_LBRACE,
    ACTIONS(1701), 1,
      anon_sym_COLON,
  [31519] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_SEMI,
    STATE(812), 1,
      aux_sym_property_repeat1,
  [31532] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1705), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31545] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1707), 1,
      anon_sym_SEMI,
    STATE(814), 1,
      aux_sym_property_repeat1,
  [31558] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1709), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31571] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1711), 1,
      anon_sym_COMMA,
    ACTIONS(1713), 1,
      anon_sym_RPAREN,
    STATE(832), 1,
      aux_sym_preproc_params_repeat1,
  [31584] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1715), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31597] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(1717), 1,
      anon_sym_RPAREN,
    STATE(835), 1,
      aux_sym_preproc_argument_list_repeat1,
  [31610] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1719), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31623] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1701), 1,
      anon_sym_COLON,
    ACTIONS(1721), 1,
      anon_sym_AT,
    ACTIONS(1723), 1,
      anon_sym_LBRACE,
  [31636] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1725), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31649] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1701), 1,
      anon_sym_COLON,
    ACTIONS(1727), 1,
      anon_sym_AT,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
  [31662] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1701), 1,
      anon_sym_COLON,
    ACTIONS(1731), 1,
      anon_sym_AT,
    ACTIONS(1733), 1,
      anon_sym_LBRACE,
  [31675] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1735), 1,
      anon_sym_SEMI,
    STATE(768), 1,
      aux_sym_property_repeat1,
  [31688] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1737), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31701] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1406), 1,
      anon_sym_AT,
    ACTIONS(1408), 1,
      anon_sym_LBRACE,
    ACTIONS(1701), 1,
      anon_sym_COLON,
  [31714] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1446), 1,
      anon_sym_AT,
    ACTIONS(1448), 1,
      anon_sym_LBRACE,
    ACTIONS(1701), 1,
      anon_sym_COLON,
  [31727] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1721), 1,
      anon_sym_AT,
    ACTIONS(1723), 1,
      anon_sym_LBRACE,
    ACTIONS(1739), 1,
      anon_sym_COLON,
  [31740] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1741), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31753] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1743), 1,
      anon_sym_RBRACK,
    ACTIONS(1745), 1,
      sym__byte_string_item,
    STATE(834), 1,
      aux_sym_byte_string_literal_repeat1,
  [31766] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1747), 1,
      anon_sym_SEMI,
    STATE(842), 1,
      aux_sym_property_repeat1,
  [31779] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1749), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [31792] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1438), 1,
      anon_sym_AT,
    ACTIONS(1440), 1,
      anon_sym_LBRACE,
    ACTIONS(1701), 1,
      anon_sym_COLON,
  [31805] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      anon_sym_AT,
    ACTIONS(1416), 1,
      anon_sym_LBRACE,
    ACTIONS(1701), 1,
      anon_sym_COLON,
  [31818] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1701), 1,
      anon_sym_COLON,
    ACTIONS(1751), 1,
      anon_sym_AT,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
  [31831] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1755), 1,
      anon_sym_SEMI,
    STATE(796), 1,
      aux_sym_property_repeat1,
  [31844] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1757), 1,
      anon_sym_SEMI,
    STATE(818), 1,
      aux_sym_property_repeat1,
  [31857] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1759), 1,
      anon_sym_SEMI,
    STATE(822), 1,
      aux_sym_property_repeat1,
  [31870] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1761), 1,
      anon_sym_COMMA,
    ACTIONS(1764), 1,
      anon_sym_RPAREN,
    STATE(832), 1,
      aux_sym_preproc_params_repeat1,
  [31883] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1711), 1,
      anon_sym_COMMA,
    ACTIONS(1766), 1,
      anon_sym_RPAREN,
    STATE(809), 1,
      aux_sym_preproc_params_repeat1,
  [31896] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1768), 1,
      anon_sym_RBRACK,
    ACTIONS(1770), 1,
      sym__byte_string_item,
    STATE(834), 1,
      aux_sym_byte_string_literal_repeat1,
  [31909] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_RPAREN,
    ACTIONS(1773), 1,
      anon_sym_COMMA,
    STATE(835), 1,
      aux_sym_preproc_argument_list_repeat1,
  [31922] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1390), 1,
      anon_sym_AT,
    ACTIONS(1392), 1,
      anon_sym_LBRACE,
    ACTIONS(1701), 1,
      anon_sym_COLON,
  [31935] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      anon_sym_AT,
    ACTIONS(1400), 1,
      anon_sym_LBRACE,
    ACTIONS(1701), 1,
      anon_sym_COLON,
  [31948] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1731), 1,
      anon_sym_AT,
    ACTIONS(1733), 1,
      anon_sym_LBRACE,
    ACTIONS(1739), 1,
      anon_sym_COLON,
  [31961] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1776), 1,
      anon_sym_SEMI,
    STATE(749), 1,
      aux_sym_property_repeat1,
  [31974] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1727), 1,
      anon_sym_AT,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1739), 1,
      anon_sym_COLON,
  [31987] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1739), 1,
      anon_sym_COLON,
    ACTIONS(1751), 1,
      anon_sym_AT,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
  [32000] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1778), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [32013] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1780), 1,
      anon_sym_SEMI,
    STATE(764), 1,
      aux_sym_property_repeat1,
  [32026] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1782), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [32034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1751), 1,
      anon_sym_AT,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
  [32044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1080), 1,
      sym_unit_address,
  [32054] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1786), 1,
      anon_sym_COMMA,
    ACTIONS(1788), 1,
      anon_sym_RPAREN,
  [32064] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1444), 1,
      anon_sym_SEMI,
    ACTIONS(1450), 1,
      anon_sym_EQ,
  [32074] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1733), 1,
      anon_sym_LBRACE,
    ACTIONS(1790), 1,
      anon_sym_SEMI,
  [32084] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1792), 1,
      anon_sym_SEMI,
    ACTIONS(1794), 1,
      anon_sym_AT,
  [32094] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
    ACTIONS(1796), 1,
      anon_sym_SEMI,
  [32104] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(993), 1,
      sym_unit_address,
  [32114] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1798), 1,
      anon_sym_LPAREN,
    ACTIONS(1800), 1,
      sym_identifier,
  [32124] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1094), 1,
      sym_unit_address,
  [32134] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1043), 1,
      sym_unit_address,
  [32144] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1396), 1,
      anon_sym_SEMI,
    ACTIONS(1402), 1,
      anon_sym_EQ,
  [32154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1802), 1,
      anon_sym_AT,
    ACTIONS(1804), 1,
      anon_sym_LBRACE,
  [32164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1806), 1,
      anon_sym_SEMI,
    ACTIONS(1808), 1,
      anon_sym_AT,
  [32174] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1448), 1,
      anon_sym_LBRACE,
    ACTIONS(1810), 1,
      anon_sym_SEMI,
  [32184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1182), 1,
      sym_unit_address,
  [32194] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1812), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [32202] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1814), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1816), 1,
      sym_preproc_arg,
  [32212] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1818), 1,
      anon_sym_AT,
    ACTIONS(1820), 1,
      anon_sym_LBRACE,
  [32222] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1197), 1,
      sym_unit_address,
  [32232] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1412), 1,
      anon_sym_SEMI,
    ACTIONS(1418), 1,
      anon_sym_EQ,
  [32242] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      anon_sym_SEMI,
    ACTIONS(1824), 1,
      anon_sym_AT,
  [32252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DQUOTE,
    STATE(847), 1,
      sym_string_literal,
  [32262] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1826), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1828), 1,
      sym_preproc_arg,
  [32272] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1830), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [32280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 1,
      anon_sym_SEMI,
    ACTIONS(1434), 1,
      anon_sym_EQ,
  [32290] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1832), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [32298] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1834), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [32306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1836), 1,
      anon_sym_SEMI,
    ACTIONS(1838), 1,
      anon_sym_EQ,
  [32316] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1840), 1,
      anon_sym_DQUOTE,
    STATE(301), 1,
      sym_string_literal,
  [32326] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1842), 1,
      anon_sym_SLASH,
    ACTIONS(1844), 1,
      anon_sym_RBRACE,
  [32336] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1846), 1,
      anon_sym_SEMI,
    ACTIONS(1848), 1,
      anon_sym_EQ,
  [32346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_LBRACE,
    ACTIONS(1850), 1,
      anon_sym_SEMI,
  [32356] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1852), 1,
      anon_sym_SEMI,
    ACTIONS(1854), 1,
      anon_sym_AT,
  [32366] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1856), 2,
      sym_identifier,
      anon_sym_DOT_DOT_DOT,
  [32374] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1108), 1,
      sym_unit_address,
  [32384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1858), 1,
      anon_sym_SEMI,
    ACTIONS(1860), 1,
      anon_sym_EQ,
  [32394] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_LBRACE,
    ACTIONS(1862), 1,
      anon_sym_SEMI,
  [32404] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(875), 1,
      sym_unit_address,
  [32414] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(964), 1,
      sym_unit_address,
  [32424] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1864), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1866), 1,
      sym_preproc_arg,
  [32434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1868), 1,
      aux_sym__node_name_token1,
    STATE(765), 1,
      sym__node_name,
  [32444] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1870), 1,
      anon_sym_SEMI,
    ACTIONS(1872), 1,
      anon_sym_AT,
  [32454] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1874), 2,
      aux_sym_preproc_include_token2,
      sym_preproc_arg,
  [32462] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      anon_sym_LBRACE,
    ACTIONS(1876), 1,
      anon_sym_SEMI,
  [32472] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1764), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [32480] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1878), 2,
      aux_sym_preproc_include_token2,
      sym_preproc_arg,
  [32488] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1880), 1,
      anon_sym_SEMI,
    ACTIONS(1882), 1,
      anon_sym_AT,
  [32498] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1884), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [32506] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1886), 2,
      aux_sym_preproc_include_token2,
      sym_preproc_arg,
  [32514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1120), 1,
      sym_unit_address,
  [32524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1128), 1,
      sym_unit_address,
  [32534] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1888), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1890), 1,
      sym_preproc_arg,
  [32544] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1430), 1,
      anon_sym_AT,
    ACTIONS(1432), 1,
      anon_sym_LBRACE,
  [32554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1892), 1,
      anon_sym_SEMI,
    ACTIONS(1894), 1,
      anon_sym_EQ,
  [32564] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1896), 1,
      aux_sym__label_name_token1,
    STATE(684), 1,
      sym__label_name,
  [32574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1898), 1,
      anon_sym_AT,
    ACTIONS(1900), 1,
      anon_sym_LBRACE,
  [32584] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1902), 1,
      anon_sym_DQUOTE,
    STATE(196), 1,
      sym_string_literal,
  [32594] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1527), 1,
      anon_sym_AT,
    ACTIONS(1529), 1,
      anon_sym_LBRACE,
  [32604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1731), 1,
      anon_sym_AT,
    ACTIONS(1733), 1,
      anon_sym_LBRACE,
  [32614] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1904), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1906), 1,
      sym_preproc_arg,
  [32624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1908), 1,
      anon_sym_AT,
    ACTIONS(1910), 1,
      anon_sym_LBRACE,
  [32634] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1912), 1,
      anon_sym_AT,
    ACTIONS(1914), 1,
      anon_sym_LBRACE,
  [32644] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1916), 2,
      anon_sym_SEMI,
      anon_sym_EQ,
  [32652] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1446), 1,
      anon_sym_AT,
    ACTIONS(1448), 1,
      anon_sym_LBRACE,
  [32662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1918), 1,
      anon_sym_LPAREN,
    ACTIONS(1920), 1,
      sym_identifier,
  [32672] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1922), 1,
      anon_sym_AT,
    ACTIONS(1924), 1,
      anon_sym_LBRACE,
  [32682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1486), 1,
      anon_sym_AT,
    ACTIONS(1488), 1,
      anon_sym_LBRACE,
  [32692] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      anon_sym_AT,
    ACTIONS(1416), 1,
      anon_sym_LBRACE,
  [32702] = 3,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1926), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1928), 1,
      sym_preproc_arg,
  [32712] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1930), 1,
      anon_sym_AT,
    ACTIONS(1932), 1,
      anon_sym_LBRACE,
  [32722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1535), 1,
      anon_sym_AT,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
  [32732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      anon_sym_AT,
    ACTIONS(1400), 1,
      anon_sym_LBRACE,
  [32742] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1934), 1,
      anon_sym_AT,
    ACTIONS(1936), 1,
      anon_sym_LBRACE,
  [32752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1470), 1,
      anon_sym_AT,
    ACTIONS(1472), 1,
      anon_sym_LBRACE,
  [32762] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1613), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [32770] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1136), 1,
      sym_unit_address,
  [32780] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1138), 1,
      sym_unit_address,
  [32790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1139), 1,
      sym_unit_address,
  [32800] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1140), 1,
      sym_unit_address,
  [32810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1147), 1,
      sym_unit_address,
  [32820] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1149), 1,
      sym_unit_address,
  [32830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1150), 1,
      sym_unit_address,
  [32840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1151), 1,
      sym_unit_address,
  [32850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1158), 1,
      sym_unit_address,
  [32860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1160), 1,
      sym_unit_address,
  [32870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1161), 1,
      sym_unit_address,
  [32880] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1162), 1,
      sym_unit_address,
  [32890] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1169), 1,
      sym_unit_address,
  [32900] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1170), 1,
      sym_unit_address,
  [32910] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1171), 1,
      sym_unit_address,
  [32920] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1172), 1,
      sym_unit_address,
  [32930] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1179), 1,
      sym_unit_address,
  [32940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1180), 1,
      sym_unit_address,
  [32950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(1181), 1,
      sym_unit_address,
  [32960] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      aux_sym__node_name_token1,
    STATE(954), 1,
      sym_unit_address,
  [32970] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1938), 1,
      anon_sym_LBRACE,
  [32977] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1940), 1,
      anon_sym_SEMI,
  [32984] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1942), 1,
      anon_sym_SEMI,
  [32991] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1944), 1,
      anon_sym_SEMI,
  [32998] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1946), 1,
      anon_sym_SEMI,
  [33005] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1948), 1,
      anon_sym_SEMI,
  [33012] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1950), 1,
      anon_sym_SEMI,
  [33019] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1952), 1,
      anon_sym_SEMI,
  [33026] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1954), 1,
      anon_sym_SEMI,
  [33033] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1956), 1,
      anon_sym_SEMI,
  [33040] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1958), 1,
      anon_sym_SEMI,
  [33047] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1960), 1,
      anon_sym_SEMI,
  [33054] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1962), 1,
      anon_sym_SEMI,
  [33061] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1964), 1,
      anon_sym_SEMI,
  [33068] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1966), 1,
      aux_sym_preproc_include_token2,
  [33075] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1880), 1,
      anon_sym_SEMI,
  [33082] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1968), 1,
      aux_sym_preproc_include_token2,
  [33089] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1970), 1,
      anon_sym_SEMI,
  [33096] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1972), 1,
      aux_sym_preproc_include_token2,
  [33103] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1974), 1,
      anon_sym_SEMI,
  [33110] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1976), 1,
      aux_sym_preproc_include_token2,
  [33117] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1978), 1,
      anon_sym_SEMI,
  [33124] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1980), 1,
      anon_sym_SEMI,
  [33131] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1982), 1,
      anon_sym_SEMI,
  [33138] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(1984), 1,
      aux_sym_preproc_include_token2,
  [33145] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1986), 1,
      anon_sym_SEMI,
  [33152] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1988), 1,
      anon_sym_SEMI,
  [33159] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1990), 1,
      anon_sym_SEMI,
  [33166] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1992), 1,
      anon_sym_SEMI,
  [33173] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1994), 1,
      anon_sym_SEMI,
  [33180] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1996), 1,
      anon_sym_SEMI,
  [33187] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1998), 1,
      anon_sym_SEMI,
  [33194] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2000), 1,
      anon_sym_SEMI,
  [33201] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2002), 1,
      anon_sym_SEMI,
  [33208] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2004), 1,
      anon_sym_SEMI,
  [33215] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2006), 1,
      anon_sym_SEMI,
  [33222] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2008), 1,
      anon_sym_SEMI,
  [33229] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2010), 1,
      anon_sym_SEMI,
  [33236] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2012), 1,
      anon_sym_SEMI,
  [33243] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2014), 1,
      anon_sym_SEMI,
  [33250] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2016), 1,
      anon_sym_SEMI,
  [33257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2018), 1,
      anon_sym_SEMI,
  [33264] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2020), 1,
      anon_sym_SEMI,
  [33271] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2022), 1,
      sym_identifier,
  [33278] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2024), 1,
      sym_identifier,
  [33285] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2026), 1,
      sym_identifier,
  [33292] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2028), 1,
      sym_integer_literal,
  [33299] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2030), 1,
      anon_sym_RBRACE,
  [33306] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2032), 1,
      sym_integer_literal,
  [33313] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2034), 1,
      anon_sym_LPAREN,
  [33320] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2036), 1,
      anon_sym_SEMI,
  [33327] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2038), 1,
      sym_identifier,
  [33334] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2040), 1,
      anon_sym_LBRACE,
  [33341] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2042), 1,
      aux_sym_preproc_if_token2,
  [33348] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2044), 1,
      aux_sym_preproc_if_token2,
  [33355] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2046), 1,
      sym_identifier,
  [33362] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2048), 1,
      sym_integer_literal,
  [33369] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
  [33376] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2050), 1,
      aux_sym_preproc_if_token2,
  [33383] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2052), 1,
      aux_sym_preproc_include_token2,
  [33390] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2054), 1,
      anon_sym_SEMI,
  [33397] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2056), 1,
      anon_sym_SEMI,
  [33404] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2058), 1,
      aux_sym_preproc_if_token2,
  [33411] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2060), 1,
      anon_sym_SEMI,
  [33418] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1806), 1,
      anon_sym_SEMI,
  [33425] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2062), 1,
      anon_sym_SEMI,
  [33432] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2064), 1,
      anon_sym_SEMI,
  [33439] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2066), 1,
      anon_sym_SEMI,
  [33446] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2068), 1,
      anon_sym_SEMI,
  [33453] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2070), 1,
      aux_sym_preproc_if_token2,
  [33460] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2072), 1,
      aux_sym_preproc_if_token2,
  [33467] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2074), 1,
      aux_sym_preproc_include_token2,
  [33474] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2076), 1,
      aux_sym_preproc_if_token2,
  [33481] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2078), 1,
      anon_sym_SEMI,
  [33488] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2080), 1,
      aux_sym_preproc_if_token2,
  [33495] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2082), 1,
      anon_sym_SEMI,
  [33502] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2084), 1,
      anon_sym_SEMI,
  [33509] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2086), 1,
      anon_sym_SEMI,
  [33516] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2088), 1,
      sym_identifier,
  [33523] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2090), 1,
      sym_identifier,
  [33530] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2092), 1,
      anon_sym_RPAREN,
  [33537] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2094), 1,
      anon_sym_SEMI,
  [33544] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2096), 1,
      sym_identifier,
  [33551] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2098), 1,
      anon_sym_SEMI,
  [33558] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2100), 1,
      anon_sym_SEMI,
  [33565] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2102), 1,
      anon_sym_SEMI,
  [33572] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2104), 1,
      anon_sym_SEMI,
  [33579] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2106), 1,
      anon_sym_SEMI,
  [33586] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2108), 1,
      aux_sym_preproc_if_token2,
  [33593] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2110), 1,
      aux_sym_preproc_include_token2,
  [33600] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2112), 1,
      anon_sym_SEMI,
  [33607] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2114), 1,
      aux_sym_preproc_if_token2,
  [33614] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2116), 1,
      sym_identifier,
  [33621] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2118), 1,
      aux_sym_preproc_include_token2,
  [33628] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2120), 1,
      aux_sym_preproc_if_token2,
  [33635] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2122), 1,
      aux_sym_preproc_if_token2,
  [33642] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2124), 1,
      anon_sym_SEMI,
  [33649] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2126), 1,
      anon_sym_SEMI,
  [33656] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2128), 1,
      aux_sym_preproc_if_token2,
  [33663] = 2,
    ACTIONS(798), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(856), 1,
      sym_comment,
  [33670] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2130), 1,
      sym_integer_literal,
  [33677] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2132), 1,
      aux_sym_preproc_if_token2,
  [33684] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2134), 1,
      anon_sym_LBRACE,
  [33691] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2136), 1,
      anon_sym_SEMI,
  [33698] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2138), 1,
      anon_sym_SEMI,
  [33705] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2140), 1,
      anon_sym_SEMI,
  [33712] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2142), 1,
      anon_sym_SEMI,
  [33719] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2144), 1,
      sym_identifier,
  [33726] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2146), 1,
      sym_identifier,
  [33733] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2148), 1,
      sym_identifier,
  [33740] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2150), 1,
      anon_sym_SEMI,
  [33747] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2152), 1,
      sym_identifier,
  [33754] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2154), 1,
      sym_identifier,
  [33761] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2156), 1,
      aux_sym_preproc_include_token2,
  [33768] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2158), 1,
      aux_sym_preproc_if_token2,
  [33775] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2160), 1,
      anon_sym_SEMI,
  [33782] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2162), 1,
      anon_sym_SEMI,
  [33789] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2164), 1,
      sym_identifier,
  [33796] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2166), 1,
      sym_integer_literal,
  [33803] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2168), 1,
      anon_sym_SEMI,
  [33810] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1739), 1,
      anon_sym_COLON,
  [33817] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1822), 1,
      anon_sym_SEMI,
  [33824] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2170), 1,
      anon_sym_SEMI,
  [33831] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2172), 1,
      sym_identifier,
  [33838] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2174), 1,
      anon_sym_SEMI,
  [33845] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2176), 1,
      sym_integer_literal,
  [33852] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1701), 1,
      anon_sym_COLON,
  [33859] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2178), 1,
      anon_sym_SEMI,
  [33866] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2180), 1,
      anon_sym_SEMI,
  [33873] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2182), 1,
      aux_sym_preproc_if_token2,
  [33880] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2184), 1,
      anon_sym_SEMI,
  [33887] = 2,
    ACTIONS(702), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(856), 1,
      sym_comment,
  [33894] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2186), 1,
      aux_sym_preproc_include_token2,
  [33901] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2188), 1,
      anon_sym_SEMI,
  [33908] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2190), 1,
      aux_sym_preproc_include_token2,
  [33915] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2192), 1,
      anon_sym_SEMI,
  [33922] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2194), 1,
      sym_identifier,
  [33929] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2196), 1,
      sym_identifier,
  [33936] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2198), 1,
      aux_sym_preproc_if_token2,
  [33943] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2200), 1,
      anon_sym_LBRACE,
  [33950] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2202), 1,
      aux_sym_preproc_if_token2,
  [33957] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2204), 1,
      anon_sym_LBRACE,
  [33964] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2206), 1,
      anon_sym_SEMI,
  [33971] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2208), 1,
      aux_sym_preproc_if_token2,
  [33978] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2210), 1,
      anon_sym_SEMI,
  [33985] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2212), 1,
      aux_sym_preproc_if_token2,
  [33992] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2214), 1,
      anon_sym_SEMI,
  [33999] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2216), 1,
      anon_sym_SEMI,
  [34006] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2218), 1,
      anon_sym_SEMI,
  [34013] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2220), 1,
      anon_sym_SEMI,
  [34020] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2222), 1,
      anon_sym_SEMI,
  [34027] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2224), 1,
      anon_sym_SEMI,
  [34034] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2226), 1,
      anon_sym_SEMI,
  [34041] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2228), 1,
      anon_sym_SEMI,
  [34048] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2230), 1,
      aux_sym_preproc_include_token2,
  [34055] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2232), 1,
      anon_sym_SEMI,
  [34062] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2234), 1,
      anon_sym_SEMI,
  [34069] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2236), 1,
      anon_sym_SEMI,
  [34076] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2238), 1,
      anon_sym_SEMI,
  [34083] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2240), 1,
      anon_sym_SEMI,
  [34090] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2242), 1,
      anon_sym_SEMI,
  [34097] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2244), 1,
      sym_identifier,
  [34104] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2246), 1,
      sym_identifier,
  [34111] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2248), 1,
      anon_sym_SEMI,
  [34118] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2250), 1,
      aux_sym_preproc_if_token2,
  [34125] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2252), 1,
      anon_sym_SEMI,
  [34132] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2254), 1,
      sym_integer_literal,
  [34139] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2256), 1,
      anon_sym_SEMI,
  [34146] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2258), 1,
      anon_sym_SEMI,
  [34153] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      anon_sym_COLON,
  [34160] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2260), 1,
      anon_sym_SEMI,
  [34167] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1870), 1,
      anon_sym_SEMI,
  [34174] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2262), 1,
      ts_builtin_sym_end,
  [34181] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2264), 1,
      anon_sym_SEMI,
  [34188] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2266), 1,
      anon_sym_SEMI,
  [34195] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2268), 1,
      anon_sym_SEMI,
  [34202] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2270), 1,
      anon_sym_SEMI,
  [34209] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2272), 1,
      anon_sym_SEMI,
  [34216] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2274), 1,
      aux_sym_preproc_if_token2,
  [34223] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2276), 1,
      anon_sym_LBRACE,
  [34230] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2278), 1,
      aux_sym_preproc_if_token2,
  [34237] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2280), 1,
      aux_sym_preproc_include_token2,
  [34244] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2282), 1,
      sym_identifier,
  [34251] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2284), 1,
      aux_sym_preproc_if_token2,
  [34258] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2286), 1,
      sym_integer_literal,
  [34265] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2288), 1,
      anon_sym_SEMI,
  [34272] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2290), 1,
      aux_sym_preproc_if_token2,
  [34279] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2292), 1,
      anon_sym_SEMI,
  [34286] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      anon_sym_LBRACE,
  [34293] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1792), 1,
      anon_sym_SEMI,
  [34300] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2294), 1,
      sym_integer_literal,
  [34307] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2296), 1,
      aux_sym_preproc_include_token2,
  [34314] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2298), 1,
      aux_sym_preproc_if_token2,
  [34321] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2300), 1,
      aux_sym_preproc_include_token2,
  [34328] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2302), 1,
      anon_sym_LBRACE,
  [34335] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2304), 1,
      anon_sym_LBRACE,
  [34342] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2306), 1,
      anon_sym_SEMI,
  [34349] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2308), 1,
      anon_sym_LBRACE,
  [34356] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2310), 1,
      anon_sym_LBRACE,
  [34363] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2312), 1,
      anon_sym_LBRACE,
  [34370] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2314), 1,
      aux_sym_preproc_if_token2,
  [34377] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1733), 1,
      anon_sym_LBRACE,
  [34384] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2316), 1,
      aux_sym_preproc_include_token2,
  [34391] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2318), 1,
      anon_sym_SEMI,
  [34398] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2320), 1,
      anon_sym_SEMI,
  [34405] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2322), 1,
      anon_sym_LBRACE,
  [34412] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2324), 1,
      anon_sym_LBRACE,
  [34419] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2326), 1,
      anon_sym_SEMI,
  [34426] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2328), 1,
      anon_sym_LBRACE,
  [34433] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2330), 1,
      anon_sym_LBRACE,
  [34440] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2332), 1,
      anon_sym_LBRACE,
  [34447] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2334), 1,
      aux_sym_preproc_if_token2,
  [34454] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1448), 1,
      anon_sym_LBRACE,
  [34461] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2336), 1,
      aux_sym_preproc_include_token2,
  [34468] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2338), 1,
      anon_sym_SEMI,
  [34475] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2340), 1,
      anon_sym_RPAREN,
  [34482] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2342), 1,
      anon_sym_LBRACE,
  [34489] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2344), 1,
      anon_sym_LBRACE,
  [34496] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2346), 1,
      anon_sym_SEMI,
  [34503] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2348), 1,
      anon_sym_LBRACE,
  [34510] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2350), 1,
      anon_sym_LBRACE,
  [34517] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2352), 1,
      anon_sym_LBRACE,
  [34524] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2354), 1,
      aux_sym_preproc_if_token2,
  [34531] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_LBRACE,
  [34538] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2356), 1,
      anon_sym_SEMI,
  [34545] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2358), 1,
      aux_sym_preproc_if_token2,
  [34552] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2360), 1,
      aux_sym_preproc_include_token2,
  [34559] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2362), 1,
      anon_sym_RPAREN,
  [34566] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2364), 1,
      anon_sym_LBRACE,
  [34573] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2366), 1,
      anon_sym_LBRACE,
  [34580] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2368), 1,
      anon_sym_LBRACE,
  [34587] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2370), 1,
      anon_sym_LBRACE,
  [34594] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2372), 1,
      anon_sym_SEMI,
  [34601] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      anon_sym_LBRACE,
  [34608] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2374), 1,
      anon_sym_SEMI,
  [34615] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2376), 1,
      anon_sym_SEMI,
  [34622] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2378), 1,
      anon_sym_SEMI,
  [34629] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2380), 1,
      anon_sym_LBRACE,
  [34636] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2382), 1,
      anon_sym_LBRACE,
  [34643] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2384), 1,
      anon_sym_LBRACE,
  [34650] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2386), 1,
      anon_sym_LBRACE,
  [34657] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2388), 1,
      anon_sym_LBRACE,
  [34664] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2390), 1,
      anon_sym_SEMI,
  [34671] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2392), 1,
      anon_sym_SEMI,
  [34678] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2394), 1,
      anon_sym_SEMI,
  [34685] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2396), 1,
      anon_sym_COMMA,
  [34692] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2398), 1,
      anon_sym_SEMI,
  [34699] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2400), 1,
      anon_sym_SEMI,
  [34706] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1852), 1,
      anon_sym_SEMI,
  [34713] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2402), 1,
      aux_sym_preproc_include_token2,
  [34720] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2404), 1,
      anon_sym_SEMI,
  [34727] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2406), 1,
      aux_sym_preproc_include_token2,
  [34734] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2408), 1,
      anon_sym_SEMI,
  [34741] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2410), 1,
      aux_sym_preproc_include_token2,
  [34748] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2412), 1,
      anon_sym_SEMI,
  [34755] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2414), 1,
      anon_sym_SEMI,
  [34762] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2416), 1,
      anon_sym_SEMI,
  [34769] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2418), 1,
      aux_sym_preproc_include_token2,
  [34776] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2420), 1,
      anon_sym_SEMI,
  [34783] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2422), 1,
      anon_sym_SEMI,
  [34790] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2424), 1,
      anon_sym_SEMI,
  [34797] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2426), 1,
      anon_sym_SEMI,
  [34804] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2428), 1,
      anon_sym_SEMI,
  [34811] = 2,
    ACTIONS(856), 1,
      sym_comment,
    ACTIONS(2430), 1,
      aux_sym_preproc_include_token2,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 109,
  [SMALL_STATE(4)] = 218,
  [SMALL_STATE(5)] = 327,
  [SMALL_STATE(6)] = 436,
  [SMALL_STATE(7)] = 537,
  [SMALL_STATE(8)] = 641,
  [SMALL_STATE(9)] = 745,
  [SMALL_STATE(10)] = 849,
  [SMALL_STATE(11)] = 953,
  [SMALL_STATE(12)] = 1057,
  [SMALL_STATE(13)] = 1161,
  [SMALL_STATE(14)] = 1265,
  [SMALL_STATE(15)] = 1369,
  [SMALL_STATE(16)] = 1473,
  [SMALL_STATE(17)] = 1577,
  [SMALL_STATE(18)] = 1681,
  [SMALL_STATE(19)] = 1785,
  [SMALL_STATE(20)] = 1889,
  [SMALL_STATE(21)] = 1993,
  [SMALL_STATE(22)] = 2097,
  [SMALL_STATE(23)] = 2201,
  [SMALL_STATE(24)] = 2297,
  [SMALL_STATE(25)] = 2392,
  [SMALL_STATE(26)] = 2491,
  [SMALL_STATE(27)] = 2590,
  [SMALL_STATE(28)] = 2689,
  [SMALL_STATE(29)] = 2788,
  [SMALL_STATE(30)] = 2887,
  [SMALL_STATE(31)] = 2986,
  [SMALL_STATE(32)] = 3085,
  [SMALL_STATE(33)] = 3184,
  [SMALL_STATE(34)] = 3283,
  [SMALL_STATE(35)] = 3382,
  [SMALL_STATE(36)] = 3476,
  [SMALL_STATE(37)] = 3570,
  [SMALL_STATE(38)] = 3664,
  [SMALL_STATE(39)] = 3755,
  [SMALL_STATE(40)] = 3844,
  [SMALL_STATE(41)] = 3933,
  [SMALL_STATE(42)] = 4022,
  [SMALL_STATE(43)] = 4111,
  [SMALL_STATE(44)] = 4200,
  [SMALL_STATE(45)] = 4289,
  [SMALL_STATE(46)] = 4378,
  [SMALL_STATE(47)] = 4467,
  [SMALL_STATE(48)] = 4556,
  [SMALL_STATE(49)] = 4645,
  [SMALL_STATE(50)] = 4734,
  [SMALL_STATE(51)] = 4823,
  [SMALL_STATE(52)] = 4912,
  [SMALL_STATE(53)] = 5001,
  [SMALL_STATE(54)] = 5090,
  [SMALL_STATE(55)] = 5179,
  [SMALL_STATE(56)] = 5268,
  [SMALL_STATE(57)] = 5357,
  [SMALL_STATE(58)] = 5446,
  [SMALL_STATE(59)] = 5535,
  [SMALL_STATE(60)] = 5624,
  [SMALL_STATE(61)] = 5713,
  [SMALL_STATE(62)] = 5802,
  [SMALL_STATE(63)] = 5891,
  [SMALL_STATE(64)] = 5980,
  [SMALL_STATE(65)] = 6069,
  [SMALL_STATE(66)] = 6158,
  [SMALL_STATE(67)] = 6247,
  [SMALL_STATE(68)] = 6336,
  [SMALL_STATE(69)] = 6425,
  [SMALL_STATE(70)] = 6514,
  [SMALL_STATE(71)] = 6603,
  [SMALL_STATE(72)] = 6692,
  [SMALL_STATE(73)] = 6781,
  [SMALL_STATE(74)] = 6870,
  [SMALL_STATE(75)] = 6959,
  [SMALL_STATE(76)] = 7048,
  [SMALL_STATE(77)] = 7137,
  [SMALL_STATE(78)] = 7226,
  [SMALL_STATE(79)] = 7315,
  [SMALL_STATE(80)] = 7404,
  [SMALL_STATE(81)] = 7493,
  [SMALL_STATE(82)] = 7582,
  [SMALL_STATE(83)] = 7671,
  [SMALL_STATE(84)] = 7760,
  [SMALL_STATE(85)] = 7849,
  [SMALL_STATE(86)] = 7938,
  [SMALL_STATE(87)] = 8027,
  [SMALL_STATE(88)] = 8116,
  [SMALL_STATE(89)] = 8205,
  [SMALL_STATE(90)] = 8294,
  [SMALL_STATE(91)] = 8383,
  [SMALL_STATE(92)] = 8472,
  [SMALL_STATE(93)] = 8561,
  [SMALL_STATE(94)] = 8650,
  [SMALL_STATE(95)] = 8739,
  [SMALL_STATE(96)] = 8828,
  [SMALL_STATE(97)] = 8917,
  [SMALL_STATE(98)] = 9006,
  [SMALL_STATE(99)] = 9095,
  [SMALL_STATE(100)] = 9184,
  [SMALL_STATE(101)] = 9273,
  [SMALL_STATE(102)] = 9362,
  [SMALL_STATE(103)] = 9451,
  [SMALL_STATE(104)] = 9540,
  [SMALL_STATE(105)] = 9629,
  [SMALL_STATE(106)] = 9718,
  [SMALL_STATE(107)] = 9807,
  [SMALL_STATE(108)] = 9896,
  [SMALL_STATE(109)] = 9985,
  [SMALL_STATE(110)] = 10074,
  [SMALL_STATE(111)] = 10163,
  [SMALL_STATE(112)] = 10252,
  [SMALL_STATE(113)] = 10341,
  [SMALL_STATE(114)] = 10430,
  [SMALL_STATE(115)] = 10519,
  [SMALL_STATE(116)] = 10608,
  [SMALL_STATE(117)] = 10697,
  [SMALL_STATE(118)] = 10786,
  [SMALL_STATE(119)] = 10875,
  [SMALL_STATE(120)] = 10964,
  [SMALL_STATE(121)] = 11053,
  [SMALL_STATE(122)] = 11142,
  [SMALL_STATE(123)] = 11231,
  [SMALL_STATE(124)] = 11320,
  [SMALL_STATE(125)] = 11409,
  [SMALL_STATE(126)] = 11498,
  [SMALL_STATE(127)] = 11587,
  [SMALL_STATE(128)] = 11676,
  [SMALL_STATE(129)] = 11765,
  [SMALL_STATE(130)] = 11854,
  [SMALL_STATE(131)] = 11943,
  [SMALL_STATE(132)] = 12032,
  [SMALL_STATE(133)] = 12121,
  [SMALL_STATE(134)] = 12210,
  [SMALL_STATE(135)] = 12299,
  [SMALL_STATE(136)] = 12388,
  [SMALL_STATE(137)] = 12477,
  [SMALL_STATE(138)] = 12566,
  [SMALL_STATE(139)] = 12655,
  [SMALL_STATE(140)] = 12744,
  [SMALL_STATE(141)] = 12833,
  [SMALL_STATE(142)] = 12922,
  [SMALL_STATE(143)] = 13011,
  [SMALL_STATE(144)] = 13100,
  [SMALL_STATE(145)] = 13189,
  [SMALL_STATE(146)] = 13278,
  [SMALL_STATE(147)] = 13367,
  [SMALL_STATE(148)] = 13456,
  [SMALL_STATE(149)] = 13545,
  [SMALL_STATE(150)] = 13634,
  [SMALL_STATE(151)] = 13723,
  [SMALL_STATE(152)] = 13757,
  [SMALL_STATE(153)] = 13791,
  [SMALL_STATE(154)] = 13825,
  [SMALL_STATE(155)] = 13859,
  [SMALL_STATE(156)] = 13895,
  [SMALL_STATE(157)] = 13926,
  [SMALL_STATE(158)] = 13957,
  [SMALL_STATE(159)] = 13988,
  [SMALL_STATE(160)] = 14019,
  [SMALL_STATE(161)] = 14050,
  [SMALL_STATE(162)] = 14081,
  [SMALL_STATE(163)] = 14112,
  [SMALL_STATE(164)] = 14143,
  [SMALL_STATE(165)] = 14174,
  [SMALL_STATE(166)] = 14205,
  [SMALL_STATE(167)] = 14236,
  [SMALL_STATE(168)] = 14267,
  [SMALL_STATE(169)] = 14298,
  [SMALL_STATE(170)] = 14329,
  [SMALL_STATE(171)] = 14360,
  [SMALL_STATE(172)] = 14391,
  [SMALL_STATE(173)] = 14422,
  [SMALL_STATE(174)] = 14453,
  [SMALL_STATE(175)] = 14484,
  [SMALL_STATE(176)] = 14515,
  [SMALL_STATE(177)] = 14546,
  [SMALL_STATE(178)] = 14577,
  [SMALL_STATE(179)] = 14608,
  [SMALL_STATE(180)] = 14639,
  [SMALL_STATE(181)] = 14670,
  [SMALL_STATE(182)] = 14701,
  [SMALL_STATE(183)] = 14732,
  [SMALL_STATE(184)] = 14763,
  [SMALL_STATE(185)] = 14794,
  [SMALL_STATE(186)] = 14825,
  [SMALL_STATE(187)] = 14856,
  [SMALL_STATE(188)] = 14887,
  [SMALL_STATE(189)] = 14918,
  [SMALL_STATE(190)] = 14949,
  [SMALL_STATE(191)] = 14980,
  [SMALL_STATE(192)] = 15011,
  [SMALL_STATE(193)] = 15042,
  [SMALL_STATE(194)] = 15073,
  [SMALL_STATE(195)] = 15104,
  [SMALL_STATE(196)] = 15135,
  [SMALL_STATE(197)] = 15166,
  [SMALL_STATE(198)] = 15197,
  [SMALL_STATE(199)] = 15228,
  [SMALL_STATE(200)] = 15258,
  [SMALL_STATE(201)] = 15288,
  [SMALL_STATE(202)] = 15332,
  [SMALL_STATE(203)] = 15362,
  [SMALL_STATE(204)] = 15400,
  [SMALL_STATE(205)] = 15434,
  [SMALL_STATE(206)] = 15484,
  [SMALL_STATE(207)] = 15532,
  [SMALL_STATE(208)] = 15580,
  [SMALL_STATE(209)] = 15626,
  [SMALL_STATE(210)] = 15668,
  [SMALL_STATE(211)] = 15704,
  [SMALL_STATE(212)] = 15758,
  [SMALL_STATE(213)] = 15816,
  [SMALL_STATE(214)] = 15850,
  [SMALL_STATE(215)] = 15883,
  [SMALL_STATE(216)] = 15936,
  [SMALL_STATE(217)] = 15991,
  [SMALL_STATE(218)] = 16046,
  [SMALL_STATE(219)] = 16074,
  [SMALL_STATE(220)] = 16102,
  [SMALL_STATE(221)] = 16130,
  [SMALL_STATE(222)] = 16158,
  [SMALL_STATE(223)] = 16186,
  [SMALL_STATE(224)] = 16214,
  [SMALL_STATE(225)] = 16242,
  [SMALL_STATE(226)] = 16270,
  [SMALL_STATE(227)] = 16298,
  [SMALL_STATE(228)] = 16326,
  [SMALL_STATE(229)] = 16354,
  [SMALL_STATE(230)] = 16382,
  [SMALL_STATE(231)] = 16410,
  [SMALL_STATE(232)] = 16438,
  [SMALL_STATE(233)] = 16466,
  [SMALL_STATE(234)] = 16494,
  [SMALL_STATE(235)] = 16522,
  [SMALL_STATE(236)] = 16550,
  [SMALL_STATE(237)] = 16578,
  [SMALL_STATE(238)] = 16606,
  [SMALL_STATE(239)] = 16634,
  [SMALL_STATE(240)] = 16662,
  [SMALL_STATE(241)] = 16690,
  [SMALL_STATE(242)] = 16718,
  [SMALL_STATE(243)] = 16746,
  [SMALL_STATE(244)] = 16774,
  [SMALL_STATE(245)] = 16802,
  [SMALL_STATE(246)] = 16830,
  [SMALL_STATE(247)] = 16858,
  [SMALL_STATE(248)] = 16886,
  [SMALL_STATE(249)] = 16914,
  [SMALL_STATE(250)] = 16942,
  [SMALL_STATE(251)] = 16970,
  [SMALL_STATE(252)] = 16998,
  [SMALL_STATE(253)] = 17026,
  [SMALL_STATE(254)] = 17054,
  [SMALL_STATE(255)] = 17082,
  [SMALL_STATE(256)] = 17110,
  [SMALL_STATE(257)] = 17138,
  [SMALL_STATE(258)] = 17188,
  [SMALL_STATE(259)] = 17216,
  [SMALL_STATE(260)] = 17244,
  [SMALL_STATE(261)] = 17272,
  [SMALL_STATE(262)] = 17300,
  [SMALL_STATE(263)] = 17328,
  [SMALL_STATE(264)] = 17356,
  [SMALL_STATE(265)] = 17384,
  [SMALL_STATE(266)] = 17412,
  [SMALL_STATE(267)] = 17440,
  [SMALL_STATE(268)] = 17468,
  [SMALL_STATE(269)] = 17496,
  [SMALL_STATE(270)] = 17524,
  [SMALL_STATE(271)] = 17576,
  [SMALL_STATE(272)] = 17604,
  [SMALL_STATE(273)] = 17632,
  [SMALL_STATE(274)] = 17660,
  [SMALL_STATE(275)] = 17688,
  [SMALL_STATE(276)] = 17716,
  [SMALL_STATE(277)] = 17768,
  [SMALL_STATE(278)] = 17796,
  [SMALL_STATE(279)] = 17824,
  [SMALL_STATE(280)] = 17852,
  [SMALL_STATE(281)] = 17880,
  [SMALL_STATE(282)] = 17908,
  [SMALL_STATE(283)] = 17936,
  [SMALL_STATE(284)] = 17964,
  [SMALL_STATE(285)] = 17992,
  [SMALL_STATE(286)] = 18020,
  [SMALL_STATE(287)] = 18048,
  [SMALL_STATE(288)] = 18100,
  [SMALL_STATE(289)] = 18128,
  [SMALL_STATE(290)] = 18156,
  [SMALL_STATE(291)] = 18184,
  [SMALL_STATE(292)] = 18212,
  [SMALL_STATE(293)] = 18240,
  [SMALL_STATE(294)] = 18268,
  [SMALL_STATE(295)] = 18296,
  [SMALL_STATE(296)] = 18324,
  [SMALL_STATE(297)] = 18352,
  [SMALL_STATE(298)] = 18380,
  [SMALL_STATE(299)] = 18408,
  [SMALL_STATE(300)] = 18436,
  [SMALL_STATE(301)] = 18464,
  [SMALL_STATE(302)] = 18492,
  [SMALL_STATE(303)] = 18520,
  [SMALL_STATE(304)] = 18548,
  [SMALL_STATE(305)] = 18576,
  [SMALL_STATE(306)] = 18604,
  [SMALL_STATE(307)] = 18632,
  [SMALL_STATE(308)] = 18660,
  [SMALL_STATE(309)] = 18688,
  [SMALL_STATE(310)] = 18716,
  [SMALL_STATE(311)] = 18744,
  [SMALL_STATE(312)] = 18772,
  [SMALL_STATE(313)] = 18800,
  [SMALL_STATE(314)] = 18842,
  [SMALL_STATE(315)] = 18870,
  [SMALL_STATE(316)] = 18906,
  [SMALL_STATE(317)] = 18938,
  [SMALL_STATE(318)] = 18986,
  [SMALL_STATE(319)] = 19032,
  [SMALL_STATE(320)] = 19078,
  [SMALL_STATE(321)] = 19106,
  [SMALL_STATE(322)] = 19150,
  [SMALL_STATE(323)] = 19190,
  [SMALL_STATE(324)] = 19224,
  [SMALL_STATE(325)] = 19252,
  [SMALL_STATE(326)] = 19280,
  [SMALL_STATE(327)] = 19308,
  [SMALL_STATE(328)] = 19336,
  [SMALL_STATE(329)] = 19364,
  [SMALL_STATE(330)] = 19392,
  [SMALL_STATE(331)] = 19420,
  [SMALL_STATE(332)] = 19448,
  [SMALL_STATE(333)] = 19476,
  [SMALL_STATE(334)] = 19504,
  [SMALL_STATE(335)] = 19532,
  [SMALL_STATE(336)] = 19560,
  [SMALL_STATE(337)] = 19588,
  [SMALL_STATE(338)] = 19616,
  [SMALL_STATE(339)] = 19644,
  [SMALL_STATE(340)] = 19672,
  [SMALL_STATE(341)] = 19700,
  [SMALL_STATE(342)] = 19728,
  [SMALL_STATE(343)] = 19756,
  [SMALL_STATE(344)] = 19784,
  [SMALL_STATE(345)] = 19812,
  [SMALL_STATE(346)] = 19840,
  [SMALL_STATE(347)] = 19868,
  [SMALL_STATE(348)] = 19896,
  [SMALL_STATE(349)] = 19941,
  [SMALL_STATE(350)] = 19968,
  [SMALL_STATE(351)] = 19995,
  [SMALL_STATE(352)] = 20022,
  [SMALL_STATE(353)] = 20059,
  [SMALL_STATE(354)] = 20086,
  [SMALL_STATE(355)] = 20119,
  [SMALL_STATE(356)] = 20148,
  [SMALL_STATE(357)] = 20193,
  [SMALL_STATE(358)] = 20238,
  [SMALL_STATE(359)] = 20287,
  [SMALL_STATE(360)] = 20330,
  [SMALL_STATE(361)] = 20357,
  [SMALL_STATE(362)] = 20398,
  [SMALL_STATE(363)] = 20437,
  [SMALL_STATE(364)] = 20472,
  [SMALL_STATE(365)] = 20503,
  [SMALL_STATE(366)] = 20548,
  [SMALL_STATE(367)] = 20593,
  [SMALL_STATE(368)] = 20638,
  [SMALL_STATE(369)] = 20683,
  [SMALL_STATE(370)] = 20728,
  [SMALL_STATE(371)] = 20777,
  [SMALL_STATE(372)] = 20804,
  [SMALL_STATE(373)] = 20831,
  [SMALL_STATE(374)] = 20858,
  [SMALL_STATE(375)] = 20903,
  [SMALL_STATE(376)] = 20930,
  [SMALL_STATE(377)] = 20956,
  [SMALL_STATE(378)] = 20982,
  [SMALL_STATE(379)] = 21008,
  [SMALL_STATE(380)] = 21034,
  [SMALL_STATE(381)] = 21060,
  [SMALL_STATE(382)] = 21086,
  [SMALL_STATE(383)] = 21112,
  [SMALL_STATE(384)] = 21138,
  [SMALL_STATE(385)] = 21164,
  [SMALL_STATE(386)] = 21190,
  [SMALL_STATE(387)] = 21216,
  [SMALL_STATE(388)] = 21242,
  [SMALL_STATE(389)] = 21268,
  [SMALL_STATE(390)] = 21294,
  [SMALL_STATE(391)] = 21320,
  [SMALL_STATE(392)] = 21346,
  [SMALL_STATE(393)] = 21372,
  [SMALL_STATE(394)] = 21398,
  [SMALL_STATE(395)] = 21424,
  [SMALL_STATE(396)] = 21450,
  [SMALL_STATE(397)] = 21476,
  [SMALL_STATE(398)] = 21502,
  [SMALL_STATE(399)] = 21528,
  [SMALL_STATE(400)] = 21554,
  [SMALL_STATE(401)] = 21580,
  [SMALL_STATE(402)] = 21606,
  [SMALL_STATE(403)] = 21632,
  [SMALL_STATE(404)] = 21658,
  [SMALL_STATE(405)] = 21684,
  [SMALL_STATE(406)] = 21710,
  [SMALL_STATE(407)] = 21736,
  [SMALL_STATE(408)] = 21762,
  [SMALL_STATE(409)] = 21788,
  [SMALL_STATE(410)] = 21814,
  [SMALL_STATE(411)] = 21840,
  [SMALL_STATE(412)] = 21866,
  [SMALL_STATE(413)] = 21892,
  [SMALL_STATE(414)] = 21918,
  [SMALL_STATE(415)] = 21944,
  [SMALL_STATE(416)] = 21970,
  [SMALL_STATE(417)] = 21996,
  [SMALL_STATE(418)] = 22022,
  [SMALL_STATE(419)] = 22048,
  [SMALL_STATE(420)] = 22074,
  [SMALL_STATE(421)] = 22100,
  [SMALL_STATE(422)] = 22126,
  [SMALL_STATE(423)] = 22152,
  [SMALL_STATE(424)] = 22178,
  [SMALL_STATE(425)] = 22204,
  [SMALL_STATE(426)] = 22230,
  [SMALL_STATE(427)] = 22256,
  [SMALL_STATE(428)] = 22282,
  [SMALL_STATE(429)] = 22308,
  [SMALL_STATE(430)] = 22334,
  [SMALL_STATE(431)] = 22360,
  [SMALL_STATE(432)] = 22386,
  [SMALL_STATE(433)] = 22412,
  [SMALL_STATE(434)] = 22438,
  [SMALL_STATE(435)] = 22464,
  [SMALL_STATE(436)] = 22490,
  [SMALL_STATE(437)] = 22516,
  [SMALL_STATE(438)] = 22542,
  [SMALL_STATE(439)] = 22568,
  [SMALL_STATE(440)] = 22594,
  [SMALL_STATE(441)] = 22620,
  [SMALL_STATE(442)] = 22665,
  [SMALL_STATE(443)] = 22710,
  [SMALL_STATE(444)] = 22755,
  [SMALL_STATE(445)] = 22800,
  [SMALL_STATE(446)] = 22845,
  [SMALL_STATE(447)] = 22890,
  [SMALL_STATE(448)] = 22935,
  [SMALL_STATE(449)] = 22980,
  [SMALL_STATE(450)] = 23025,
  [SMALL_STATE(451)] = 23070,
  [SMALL_STATE(452)] = 23115,
  [SMALL_STATE(453)] = 23160,
  [SMALL_STATE(454)] = 23205,
  [SMALL_STATE(455)] = 23250,
  [SMALL_STATE(456)] = 23295,
  [SMALL_STATE(457)] = 23340,
  [SMALL_STATE(458)] = 23364,
  [SMALL_STATE(459)] = 23388,
  [SMALL_STATE(460)] = 23412,
  [SMALL_STATE(461)] = 23436,
  [SMALL_STATE(462)] = 23460,
  [SMALL_STATE(463)] = 23484,
  [SMALL_STATE(464)] = 23508,
  [SMALL_STATE(465)] = 23532,
  [SMALL_STATE(466)] = 23556,
  [SMALL_STATE(467)] = 23580,
  [SMALL_STATE(468)] = 23604,
  [SMALL_STATE(469)] = 23628,
  [SMALL_STATE(470)] = 23652,
  [SMALL_STATE(471)] = 23676,
  [SMALL_STATE(472)] = 23700,
  [SMALL_STATE(473)] = 23724,
  [SMALL_STATE(474)] = 23748,
  [SMALL_STATE(475)] = 23772,
  [SMALL_STATE(476)] = 23796,
  [SMALL_STATE(477)] = 23820,
  [SMALL_STATE(478)] = 23844,
  [SMALL_STATE(479)] = 23868,
  [SMALL_STATE(480)] = 23892,
  [SMALL_STATE(481)] = 23916,
  [SMALL_STATE(482)] = 23940,
  [SMALL_STATE(483)] = 23964,
  [SMALL_STATE(484)] = 23988,
  [SMALL_STATE(485)] = 24012,
  [SMALL_STATE(486)] = 24036,
  [SMALL_STATE(487)] = 24060,
  [SMALL_STATE(488)] = 24084,
  [SMALL_STATE(489)] = 24108,
  [SMALL_STATE(490)] = 24132,
  [SMALL_STATE(491)] = 24156,
  [SMALL_STATE(492)] = 24180,
  [SMALL_STATE(493)] = 24204,
  [SMALL_STATE(494)] = 24228,
  [SMALL_STATE(495)] = 24252,
  [SMALL_STATE(496)] = 24276,
  [SMALL_STATE(497)] = 24300,
  [SMALL_STATE(498)] = 24324,
  [SMALL_STATE(499)] = 24348,
  [SMALL_STATE(500)] = 24372,
  [SMALL_STATE(501)] = 24396,
  [SMALL_STATE(502)] = 24420,
  [SMALL_STATE(503)] = 24444,
  [SMALL_STATE(504)] = 24468,
  [SMALL_STATE(505)] = 24492,
  [SMALL_STATE(506)] = 24516,
  [SMALL_STATE(507)] = 24540,
  [SMALL_STATE(508)] = 24564,
  [SMALL_STATE(509)] = 24588,
  [SMALL_STATE(510)] = 24612,
  [SMALL_STATE(511)] = 24636,
  [SMALL_STATE(512)] = 24660,
  [SMALL_STATE(513)] = 24684,
  [SMALL_STATE(514)] = 24708,
  [SMALL_STATE(515)] = 24732,
  [SMALL_STATE(516)] = 24756,
  [SMALL_STATE(517)] = 24780,
  [SMALL_STATE(518)] = 24804,
  [SMALL_STATE(519)] = 24828,
  [SMALL_STATE(520)] = 24852,
  [SMALL_STATE(521)] = 24876,
  [SMALL_STATE(522)] = 24900,
  [SMALL_STATE(523)] = 24924,
  [SMALL_STATE(524)] = 24948,
  [SMALL_STATE(525)] = 24972,
  [SMALL_STATE(526)] = 24996,
  [SMALL_STATE(527)] = 25020,
  [SMALL_STATE(528)] = 25044,
  [SMALL_STATE(529)] = 25068,
  [SMALL_STATE(530)] = 25092,
  [SMALL_STATE(531)] = 25116,
  [SMALL_STATE(532)] = 25140,
  [SMALL_STATE(533)] = 25164,
  [SMALL_STATE(534)] = 25188,
  [SMALL_STATE(535)] = 25212,
  [SMALL_STATE(536)] = 25236,
  [SMALL_STATE(537)] = 25260,
  [SMALL_STATE(538)] = 25284,
  [SMALL_STATE(539)] = 25308,
  [SMALL_STATE(540)] = 25332,
  [SMALL_STATE(541)] = 25356,
  [SMALL_STATE(542)] = 25380,
  [SMALL_STATE(543)] = 25404,
  [SMALL_STATE(544)] = 25428,
  [SMALL_STATE(545)] = 25452,
  [SMALL_STATE(546)] = 25476,
  [SMALL_STATE(547)] = 25500,
  [SMALL_STATE(548)] = 25524,
  [SMALL_STATE(549)] = 25548,
  [SMALL_STATE(550)] = 25572,
  [SMALL_STATE(551)] = 25596,
  [SMALL_STATE(552)] = 25620,
  [SMALL_STATE(553)] = 25644,
  [SMALL_STATE(554)] = 25668,
  [SMALL_STATE(555)] = 25692,
  [SMALL_STATE(556)] = 25716,
  [SMALL_STATE(557)] = 25740,
  [SMALL_STATE(558)] = 25764,
  [SMALL_STATE(559)] = 25788,
  [SMALL_STATE(560)] = 25812,
  [SMALL_STATE(561)] = 25836,
  [SMALL_STATE(562)] = 25860,
  [SMALL_STATE(563)] = 25884,
  [SMALL_STATE(564)] = 25908,
  [SMALL_STATE(565)] = 25932,
  [SMALL_STATE(566)] = 25956,
  [SMALL_STATE(567)] = 25980,
  [SMALL_STATE(568)] = 26004,
  [SMALL_STATE(569)] = 26028,
  [SMALL_STATE(570)] = 26052,
  [SMALL_STATE(571)] = 26076,
  [SMALL_STATE(572)] = 26100,
  [SMALL_STATE(573)] = 26124,
  [SMALL_STATE(574)] = 26148,
  [SMALL_STATE(575)] = 26172,
  [SMALL_STATE(576)] = 26196,
  [SMALL_STATE(577)] = 26220,
  [SMALL_STATE(578)] = 26244,
  [SMALL_STATE(579)] = 26268,
  [SMALL_STATE(580)] = 26292,
  [SMALL_STATE(581)] = 26316,
  [SMALL_STATE(582)] = 26340,
  [SMALL_STATE(583)] = 26364,
  [SMALL_STATE(584)] = 26388,
  [SMALL_STATE(585)] = 26412,
  [SMALL_STATE(586)] = 26436,
  [SMALL_STATE(587)] = 26460,
  [SMALL_STATE(588)] = 26499,
  [SMALL_STATE(589)] = 26538,
  [SMALL_STATE(590)] = 26577,
  [SMALL_STATE(591)] = 26616,
  [SMALL_STATE(592)] = 26655,
  [SMALL_STATE(593)] = 26694,
  [SMALL_STATE(594)] = 26733,
  [SMALL_STATE(595)] = 26766,
  [SMALL_STATE(596)] = 26805,
  [SMALL_STATE(597)] = 26844,
  [SMALL_STATE(598)] = 26883,
  [SMALL_STATE(599)] = 26922,
  [SMALL_STATE(600)] = 26961,
  [SMALL_STATE(601)] = 27000,
  [SMALL_STATE(602)] = 27039,
  [SMALL_STATE(603)] = 27078,
  [SMALL_STATE(604)] = 27117,
  [SMALL_STATE(605)] = 27150,
  [SMALL_STATE(606)] = 27180,
  [SMALL_STATE(607)] = 27210,
  [SMALL_STATE(608)] = 27240,
  [SMALL_STATE(609)] = 27286,
  [SMALL_STATE(610)] = 27316,
  [SMALL_STATE(611)] = 27346,
  [SMALL_STATE(612)] = 27382,
  [SMALL_STATE(613)] = 27412,
  [SMALL_STATE(614)] = 27442,
  [SMALL_STATE(615)] = 27472,
  [SMALL_STATE(616)] = 27502,
  [SMALL_STATE(617)] = 27532,
  [SMALL_STATE(618)] = 27562,
  [SMALL_STATE(619)] = 27592,
  [SMALL_STATE(620)] = 27622,
  [SMALL_STATE(621)] = 27652,
  [SMALL_STATE(622)] = 27682,
  [SMALL_STATE(623)] = 27712,
  [SMALL_STATE(624)] = 27742,
  [SMALL_STATE(625)] = 27772,
  [SMALL_STATE(626)] = 27818,
  [SMALL_STATE(627)] = 27848,
  [SMALL_STATE(628)] = 27894,
  [SMALL_STATE(629)] = 27924,
  [SMALL_STATE(630)] = 27954,
  [SMALL_STATE(631)] = 27984,
  [SMALL_STATE(632)] = 28014,
  [SMALL_STATE(633)] = 28044,
  [SMALL_STATE(634)] = 28074,
  [SMALL_STATE(635)] = 28104,
  [SMALL_STATE(636)] = 28134,
  [SMALL_STATE(637)] = 28164,
  [SMALL_STATE(638)] = 28210,
  [SMALL_STATE(639)] = 28240,
  [SMALL_STATE(640)] = 28270,
  [SMALL_STATE(641)] = 28300,
  [SMALL_STATE(642)] = 28330,
  [SMALL_STATE(643)] = 28360,
  [SMALL_STATE(644)] = 28403,
  [SMALL_STATE(645)] = 28432,
  [SMALL_STATE(646)] = 28475,
  [SMALL_STATE(647)] = 28518,
  [SMALL_STATE(648)] = 28561,
  [SMALL_STATE(649)] = 28604,
  [SMALL_STATE(650)] = 28647,
  [SMALL_STATE(651)] = 28690,
  [SMALL_STATE(652)] = 28711,
  [SMALL_STATE(653)] = 28754,
  [SMALL_STATE(654)] = 28794,
  [SMALL_STATE(655)] = 28820,
  [SMALL_STATE(656)] = 28846,
  [SMALL_STATE(657)] = 28880,
  [SMALL_STATE(658)] = 28906,
  [SMALL_STATE(659)] = 28932,
  [SMALL_STATE(660)] = 28958,
  [SMALL_STATE(661)] = 28984,
  [SMALL_STATE(662)] = 29010,
  [SMALL_STATE(663)] = 29036,
  [SMALL_STATE(664)] = 29062,
  [SMALL_STATE(665)] = 29088,
  [SMALL_STATE(666)] = 29114,
  [SMALL_STATE(667)] = 29140,
  [SMALL_STATE(668)] = 29166,
  [SMALL_STATE(669)] = 29200,
  [SMALL_STATE(670)] = 29240,
  [SMALL_STATE(671)] = 29266,
  [SMALL_STATE(672)] = 29292,
  [SMALL_STATE(673)] = 29318,
  [SMALL_STATE(674)] = 29352,
  [SMALL_STATE(675)] = 29392,
  [SMALL_STATE(676)] = 29432,
  [SMALL_STATE(677)] = 29472,
  [SMALL_STATE(678)] = 29512,
  [SMALL_STATE(679)] = 29544,
  [SMALL_STATE(680)] = 29574,
  [SMALL_STATE(681)] = 29592,
  [SMALL_STATE(682)] = 29624,
  [SMALL_STATE(683)] = 29656,
  [SMALL_STATE(684)] = 29688,
  [SMALL_STATE(685)] = 29706,
  [SMALL_STATE(686)] = 29738,
  [SMALL_STATE(687)] = 29770,
  [SMALL_STATE(688)] = 29800,
  [SMALL_STATE(689)] = 29818,
  [SMALL_STATE(690)] = 29836,
  [SMALL_STATE(691)] = 29857,
  [SMALL_STATE(692)] = 29882,
  [SMALL_STATE(693)] = 29907,
  [SMALL_STATE(694)] = 29923,
  [SMALL_STATE(695)] = 29947,
  [SMALL_STATE(696)] = 29962,
  [SMALL_STATE(697)] = 29980,
  [SMALL_STATE(698)] = 29994,
  [SMALL_STATE(699)] = 30008,
  [SMALL_STATE(700)] = 30026,
  [SMALL_STATE(701)] = 30044,
  [SMALL_STATE(702)] = 30062,
  [SMALL_STATE(703)] = 30076,
  [SMALL_STATE(704)] = 30090,
  [SMALL_STATE(705)] = 30104,
  [SMALL_STATE(706)] = 30123,
  [SMALL_STATE(707)] = 30142,
  [SMALL_STATE(708)] = 30161,
  [SMALL_STATE(709)] = 30180,
  [SMALL_STATE(710)] = 30193,
  [SMALL_STATE(711)] = 30206,
  [SMALL_STATE(712)] = 30225,
  [SMALL_STATE(713)] = 30244,
  [SMALL_STATE(714)] = 30263,
  [SMALL_STATE(715)] = 30282,
  [SMALL_STATE(716)] = 30296,
  [SMALL_STATE(717)] = 30312,
  [SMALL_STATE(718)] = 30328,
  [SMALL_STATE(719)] = 30344,
  [SMALL_STATE(720)] = 30360,
  [SMALL_STATE(721)] = 30376,
  [SMALL_STATE(722)] = 30392,
  [SMALL_STATE(723)] = 30408,
  [SMALL_STATE(724)] = 30422,
  [SMALL_STATE(725)] = 30438,
  [SMALL_STATE(726)] = 30452,
  [SMALL_STATE(727)] = 30468,
  [SMALL_STATE(728)] = 30482,
  [SMALL_STATE(729)] = 30498,
  [SMALL_STATE(730)] = 30514,
  [SMALL_STATE(731)] = 30528,
  [SMALL_STATE(732)] = 30542,
  [SMALL_STATE(733)] = 30556,
  [SMALL_STATE(734)] = 30572,
  [SMALL_STATE(735)] = 30588,
  [SMALL_STATE(736)] = 30602,
  [SMALL_STATE(737)] = 30618,
  [SMALL_STATE(738)] = 30634,
  [SMALL_STATE(739)] = 30650,
  [SMALL_STATE(740)] = 30664,
  [SMALL_STATE(741)] = 30680,
  [SMALL_STATE(742)] = 30696,
  [SMALL_STATE(743)] = 30708,
  [SMALL_STATE(744)] = 30724,
  [SMALL_STATE(745)] = 30740,
  [SMALL_STATE(746)] = 30756,
  [SMALL_STATE(747)] = 30772,
  [SMALL_STATE(748)] = 30788,
  [SMALL_STATE(749)] = 30801,
  [SMALL_STATE(750)] = 30814,
  [SMALL_STATE(751)] = 30827,
  [SMALL_STATE(752)] = 30840,
  [SMALL_STATE(753)] = 30853,
  [SMALL_STATE(754)] = 30866,
  [SMALL_STATE(755)] = 30879,
  [SMALL_STATE(756)] = 30892,
  [SMALL_STATE(757)] = 30905,
  [SMALL_STATE(758)] = 30918,
  [SMALL_STATE(759)] = 30931,
  [SMALL_STATE(760)] = 30944,
  [SMALL_STATE(761)] = 30957,
  [SMALL_STATE(762)] = 30970,
  [SMALL_STATE(763)] = 30983,
  [SMALL_STATE(764)] = 30992,
  [SMALL_STATE(765)] = 31005,
  [SMALL_STATE(766)] = 31018,
  [SMALL_STATE(767)] = 31031,
  [SMALL_STATE(768)] = 31042,
  [SMALL_STATE(769)] = 31055,
  [SMALL_STATE(770)] = 31068,
  [SMALL_STATE(771)] = 31081,
  [SMALL_STATE(772)] = 31090,
  [SMALL_STATE(773)] = 31103,
  [SMALL_STATE(774)] = 31116,
  [SMALL_STATE(775)] = 31129,
  [SMALL_STATE(776)] = 31142,
  [SMALL_STATE(777)] = 31155,
  [SMALL_STATE(778)] = 31168,
  [SMALL_STATE(779)] = 31181,
  [SMALL_STATE(780)] = 31194,
  [SMALL_STATE(781)] = 31207,
  [SMALL_STATE(782)] = 31220,
  [SMALL_STATE(783)] = 31233,
  [SMALL_STATE(784)] = 31246,
  [SMALL_STATE(785)] = 31259,
  [SMALL_STATE(786)] = 31272,
  [SMALL_STATE(787)] = 31285,
  [SMALL_STATE(788)] = 31298,
  [SMALL_STATE(789)] = 31311,
  [SMALL_STATE(790)] = 31324,
  [SMALL_STATE(791)] = 31337,
  [SMALL_STATE(792)] = 31350,
  [SMALL_STATE(793)] = 31363,
  [SMALL_STATE(794)] = 31376,
  [SMALL_STATE(795)] = 31389,
  [SMALL_STATE(796)] = 31402,
  [SMALL_STATE(797)] = 31415,
  [SMALL_STATE(798)] = 31428,
  [SMALL_STATE(799)] = 31441,
  [SMALL_STATE(800)] = 31454,
  [SMALL_STATE(801)] = 31467,
  [SMALL_STATE(802)] = 31480,
  [SMALL_STATE(803)] = 31493,
  [SMALL_STATE(804)] = 31506,
  [SMALL_STATE(805)] = 31519,
  [SMALL_STATE(806)] = 31532,
  [SMALL_STATE(807)] = 31545,
  [SMALL_STATE(808)] = 31558,
  [SMALL_STATE(809)] = 31571,
  [SMALL_STATE(810)] = 31584,
  [SMALL_STATE(811)] = 31597,
  [SMALL_STATE(812)] = 31610,
  [SMALL_STATE(813)] = 31623,
  [SMALL_STATE(814)] = 31636,
  [SMALL_STATE(815)] = 31649,
  [SMALL_STATE(816)] = 31662,
  [SMALL_STATE(817)] = 31675,
  [SMALL_STATE(818)] = 31688,
  [SMALL_STATE(819)] = 31701,
  [SMALL_STATE(820)] = 31714,
  [SMALL_STATE(821)] = 31727,
  [SMALL_STATE(822)] = 31740,
  [SMALL_STATE(823)] = 31753,
  [SMALL_STATE(824)] = 31766,
  [SMALL_STATE(825)] = 31779,
  [SMALL_STATE(826)] = 31792,
  [SMALL_STATE(827)] = 31805,
  [SMALL_STATE(828)] = 31818,
  [SMALL_STATE(829)] = 31831,
  [SMALL_STATE(830)] = 31844,
  [SMALL_STATE(831)] = 31857,
  [SMALL_STATE(832)] = 31870,
  [SMALL_STATE(833)] = 31883,
  [SMALL_STATE(834)] = 31896,
  [SMALL_STATE(835)] = 31909,
  [SMALL_STATE(836)] = 31922,
  [SMALL_STATE(837)] = 31935,
  [SMALL_STATE(838)] = 31948,
  [SMALL_STATE(839)] = 31961,
  [SMALL_STATE(840)] = 31974,
  [SMALL_STATE(841)] = 31987,
  [SMALL_STATE(842)] = 32000,
  [SMALL_STATE(843)] = 32013,
  [SMALL_STATE(844)] = 32026,
  [SMALL_STATE(845)] = 32034,
  [SMALL_STATE(846)] = 32044,
  [SMALL_STATE(847)] = 32054,
  [SMALL_STATE(848)] = 32064,
  [SMALL_STATE(849)] = 32074,
  [SMALL_STATE(850)] = 32084,
  [SMALL_STATE(851)] = 32094,
  [SMALL_STATE(852)] = 32104,
  [SMALL_STATE(853)] = 32114,
  [SMALL_STATE(854)] = 32124,
  [SMALL_STATE(855)] = 32134,
  [SMALL_STATE(856)] = 32144,
  [SMALL_STATE(857)] = 32154,
  [SMALL_STATE(858)] = 32164,
  [SMALL_STATE(859)] = 32174,
  [SMALL_STATE(860)] = 32184,
  [SMALL_STATE(861)] = 32194,
  [SMALL_STATE(862)] = 32202,
  [SMALL_STATE(863)] = 32212,
  [SMALL_STATE(864)] = 32222,
  [SMALL_STATE(865)] = 32232,
  [SMALL_STATE(866)] = 32242,
  [SMALL_STATE(867)] = 32252,
  [SMALL_STATE(868)] = 32262,
  [SMALL_STATE(869)] = 32272,
  [SMALL_STATE(870)] = 32280,
  [SMALL_STATE(871)] = 32290,
  [SMALL_STATE(872)] = 32298,
  [SMALL_STATE(873)] = 32306,
  [SMALL_STATE(874)] = 32316,
  [SMALL_STATE(875)] = 32326,
  [SMALL_STATE(876)] = 32336,
  [SMALL_STATE(877)] = 32346,
  [SMALL_STATE(878)] = 32356,
  [SMALL_STATE(879)] = 32366,
  [SMALL_STATE(880)] = 32374,
  [SMALL_STATE(881)] = 32384,
  [SMALL_STATE(882)] = 32394,
  [SMALL_STATE(883)] = 32404,
  [SMALL_STATE(884)] = 32414,
  [SMALL_STATE(885)] = 32424,
  [SMALL_STATE(886)] = 32434,
  [SMALL_STATE(887)] = 32444,
  [SMALL_STATE(888)] = 32454,
  [SMALL_STATE(889)] = 32462,
  [SMALL_STATE(890)] = 32472,
  [SMALL_STATE(891)] = 32480,
  [SMALL_STATE(892)] = 32488,
  [SMALL_STATE(893)] = 32498,
  [SMALL_STATE(894)] = 32506,
  [SMALL_STATE(895)] = 32514,
  [SMALL_STATE(896)] = 32524,
  [SMALL_STATE(897)] = 32534,
  [SMALL_STATE(898)] = 32544,
  [SMALL_STATE(899)] = 32554,
  [SMALL_STATE(900)] = 32564,
  [SMALL_STATE(901)] = 32574,
  [SMALL_STATE(902)] = 32584,
  [SMALL_STATE(903)] = 32594,
  [SMALL_STATE(904)] = 32604,
  [SMALL_STATE(905)] = 32614,
  [SMALL_STATE(906)] = 32624,
  [SMALL_STATE(907)] = 32634,
  [SMALL_STATE(908)] = 32644,
  [SMALL_STATE(909)] = 32652,
  [SMALL_STATE(910)] = 32662,
  [SMALL_STATE(911)] = 32672,
  [SMALL_STATE(912)] = 32682,
  [SMALL_STATE(913)] = 32692,
  [SMALL_STATE(914)] = 32702,
  [SMALL_STATE(915)] = 32712,
  [SMALL_STATE(916)] = 32722,
  [SMALL_STATE(917)] = 32732,
  [SMALL_STATE(918)] = 32742,
  [SMALL_STATE(919)] = 32752,
  [SMALL_STATE(920)] = 32762,
  [SMALL_STATE(921)] = 32770,
  [SMALL_STATE(922)] = 32780,
  [SMALL_STATE(923)] = 32790,
  [SMALL_STATE(924)] = 32800,
  [SMALL_STATE(925)] = 32810,
  [SMALL_STATE(926)] = 32820,
  [SMALL_STATE(927)] = 32830,
  [SMALL_STATE(928)] = 32840,
  [SMALL_STATE(929)] = 32850,
  [SMALL_STATE(930)] = 32860,
  [SMALL_STATE(931)] = 32870,
  [SMALL_STATE(932)] = 32880,
  [SMALL_STATE(933)] = 32890,
  [SMALL_STATE(934)] = 32900,
  [SMALL_STATE(935)] = 32910,
  [SMALL_STATE(936)] = 32920,
  [SMALL_STATE(937)] = 32930,
  [SMALL_STATE(938)] = 32940,
  [SMALL_STATE(939)] = 32950,
  [SMALL_STATE(940)] = 32960,
  [SMALL_STATE(941)] = 32970,
  [SMALL_STATE(942)] = 32977,
  [SMALL_STATE(943)] = 32984,
  [SMALL_STATE(944)] = 32991,
  [SMALL_STATE(945)] = 32998,
  [SMALL_STATE(946)] = 33005,
  [SMALL_STATE(947)] = 33012,
  [SMALL_STATE(948)] = 33019,
  [SMALL_STATE(949)] = 33026,
  [SMALL_STATE(950)] = 33033,
  [SMALL_STATE(951)] = 33040,
  [SMALL_STATE(952)] = 33047,
  [SMALL_STATE(953)] = 33054,
  [SMALL_STATE(954)] = 33061,
  [SMALL_STATE(955)] = 33068,
  [SMALL_STATE(956)] = 33075,
  [SMALL_STATE(957)] = 33082,
  [SMALL_STATE(958)] = 33089,
  [SMALL_STATE(959)] = 33096,
  [SMALL_STATE(960)] = 33103,
  [SMALL_STATE(961)] = 33110,
  [SMALL_STATE(962)] = 33117,
  [SMALL_STATE(963)] = 33124,
  [SMALL_STATE(964)] = 33131,
  [SMALL_STATE(965)] = 33138,
  [SMALL_STATE(966)] = 33145,
  [SMALL_STATE(967)] = 33152,
  [SMALL_STATE(968)] = 33159,
  [SMALL_STATE(969)] = 33166,
  [SMALL_STATE(970)] = 33173,
  [SMALL_STATE(971)] = 33180,
  [SMALL_STATE(972)] = 33187,
  [SMALL_STATE(973)] = 33194,
  [SMALL_STATE(974)] = 33201,
  [SMALL_STATE(975)] = 33208,
  [SMALL_STATE(976)] = 33215,
  [SMALL_STATE(977)] = 33222,
  [SMALL_STATE(978)] = 33229,
  [SMALL_STATE(979)] = 33236,
  [SMALL_STATE(980)] = 33243,
  [SMALL_STATE(981)] = 33250,
  [SMALL_STATE(982)] = 33257,
  [SMALL_STATE(983)] = 33264,
  [SMALL_STATE(984)] = 33271,
  [SMALL_STATE(985)] = 33278,
  [SMALL_STATE(986)] = 33285,
  [SMALL_STATE(987)] = 33292,
  [SMALL_STATE(988)] = 33299,
  [SMALL_STATE(989)] = 33306,
  [SMALL_STATE(990)] = 33313,
  [SMALL_STATE(991)] = 33320,
  [SMALL_STATE(992)] = 33327,
  [SMALL_STATE(993)] = 33334,
  [SMALL_STATE(994)] = 33341,
  [SMALL_STATE(995)] = 33348,
  [SMALL_STATE(996)] = 33355,
  [SMALL_STATE(997)] = 33362,
  [SMALL_STATE(998)] = 33369,
  [SMALL_STATE(999)] = 33376,
  [SMALL_STATE(1000)] = 33383,
  [SMALL_STATE(1001)] = 33390,
  [SMALL_STATE(1002)] = 33397,
  [SMALL_STATE(1003)] = 33404,
  [SMALL_STATE(1004)] = 33411,
  [SMALL_STATE(1005)] = 33418,
  [SMALL_STATE(1006)] = 33425,
  [SMALL_STATE(1007)] = 33432,
  [SMALL_STATE(1008)] = 33439,
  [SMALL_STATE(1009)] = 33446,
  [SMALL_STATE(1010)] = 33453,
  [SMALL_STATE(1011)] = 33460,
  [SMALL_STATE(1012)] = 33467,
  [SMALL_STATE(1013)] = 33474,
  [SMALL_STATE(1014)] = 33481,
  [SMALL_STATE(1015)] = 33488,
  [SMALL_STATE(1016)] = 33495,
  [SMALL_STATE(1017)] = 33502,
  [SMALL_STATE(1018)] = 33509,
  [SMALL_STATE(1019)] = 33516,
  [SMALL_STATE(1020)] = 33523,
  [SMALL_STATE(1021)] = 33530,
  [SMALL_STATE(1022)] = 33537,
  [SMALL_STATE(1023)] = 33544,
  [SMALL_STATE(1024)] = 33551,
  [SMALL_STATE(1025)] = 33558,
  [SMALL_STATE(1026)] = 33565,
  [SMALL_STATE(1027)] = 33572,
  [SMALL_STATE(1028)] = 33579,
  [SMALL_STATE(1029)] = 33586,
  [SMALL_STATE(1030)] = 33593,
  [SMALL_STATE(1031)] = 33600,
  [SMALL_STATE(1032)] = 33607,
  [SMALL_STATE(1033)] = 33614,
  [SMALL_STATE(1034)] = 33621,
  [SMALL_STATE(1035)] = 33628,
  [SMALL_STATE(1036)] = 33635,
  [SMALL_STATE(1037)] = 33642,
  [SMALL_STATE(1038)] = 33649,
  [SMALL_STATE(1039)] = 33656,
  [SMALL_STATE(1040)] = 33663,
  [SMALL_STATE(1041)] = 33670,
  [SMALL_STATE(1042)] = 33677,
  [SMALL_STATE(1043)] = 33684,
  [SMALL_STATE(1044)] = 33691,
  [SMALL_STATE(1045)] = 33698,
  [SMALL_STATE(1046)] = 33705,
  [SMALL_STATE(1047)] = 33712,
  [SMALL_STATE(1048)] = 33719,
  [SMALL_STATE(1049)] = 33726,
  [SMALL_STATE(1050)] = 33733,
  [SMALL_STATE(1051)] = 33740,
  [SMALL_STATE(1052)] = 33747,
  [SMALL_STATE(1053)] = 33754,
  [SMALL_STATE(1054)] = 33761,
  [SMALL_STATE(1055)] = 33768,
  [SMALL_STATE(1056)] = 33775,
  [SMALL_STATE(1057)] = 33782,
  [SMALL_STATE(1058)] = 33789,
  [SMALL_STATE(1059)] = 33796,
  [SMALL_STATE(1060)] = 33803,
  [SMALL_STATE(1061)] = 33810,
  [SMALL_STATE(1062)] = 33817,
  [SMALL_STATE(1063)] = 33824,
  [SMALL_STATE(1064)] = 33831,
  [SMALL_STATE(1065)] = 33838,
  [SMALL_STATE(1066)] = 33845,
  [SMALL_STATE(1067)] = 33852,
  [SMALL_STATE(1068)] = 33859,
  [SMALL_STATE(1069)] = 33866,
  [SMALL_STATE(1070)] = 33873,
  [SMALL_STATE(1071)] = 33880,
  [SMALL_STATE(1072)] = 33887,
  [SMALL_STATE(1073)] = 33894,
  [SMALL_STATE(1074)] = 33901,
  [SMALL_STATE(1075)] = 33908,
  [SMALL_STATE(1076)] = 33915,
  [SMALL_STATE(1077)] = 33922,
  [SMALL_STATE(1078)] = 33929,
  [SMALL_STATE(1079)] = 33936,
  [SMALL_STATE(1080)] = 33943,
  [SMALL_STATE(1081)] = 33950,
  [SMALL_STATE(1082)] = 33957,
  [SMALL_STATE(1083)] = 33964,
  [SMALL_STATE(1084)] = 33971,
  [SMALL_STATE(1085)] = 33978,
  [SMALL_STATE(1086)] = 33985,
  [SMALL_STATE(1087)] = 33992,
  [SMALL_STATE(1088)] = 33999,
  [SMALL_STATE(1089)] = 34006,
  [SMALL_STATE(1090)] = 34013,
  [SMALL_STATE(1091)] = 34020,
  [SMALL_STATE(1092)] = 34027,
  [SMALL_STATE(1093)] = 34034,
  [SMALL_STATE(1094)] = 34041,
  [SMALL_STATE(1095)] = 34048,
  [SMALL_STATE(1096)] = 34055,
  [SMALL_STATE(1097)] = 34062,
  [SMALL_STATE(1098)] = 34069,
  [SMALL_STATE(1099)] = 34076,
  [SMALL_STATE(1100)] = 34083,
  [SMALL_STATE(1101)] = 34090,
  [SMALL_STATE(1102)] = 34097,
  [SMALL_STATE(1103)] = 34104,
  [SMALL_STATE(1104)] = 34111,
  [SMALL_STATE(1105)] = 34118,
  [SMALL_STATE(1106)] = 34125,
  [SMALL_STATE(1107)] = 34132,
  [SMALL_STATE(1108)] = 34139,
  [SMALL_STATE(1109)] = 34146,
  [SMALL_STATE(1110)] = 34153,
  [SMALL_STATE(1111)] = 34160,
  [SMALL_STATE(1112)] = 34167,
  [SMALL_STATE(1113)] = 34174,
  [SMALL_STATE(1114)] = 34181,
  [SMALL_STATE(1115)] = 34188,
  [SMALL_STATE(1116)] = 34195,
  [SMALL_STATE(1117)] = 34202,
  [SMALL_STATE(1118)] = 34209,
  [SMALL_STATE(1119)] = 34216,
  [SMALL_STATE(1120)] = 34223,
  [SMALL_STATE(1121)] = 34230,
  [SMALL_STATE(1122)] = 34237,
  [SMALL_STATE(1123)] = 34244,
  [SMALL_STATE(1124)] = 34251,
  [SMALL_STATE(1125)] = 34258,
  [SMALL_STATE(1126)] = 34265,
  [SMALL_STATE(1127)] = 34272,
  [SMALL_STATE(1128)] = 34279,
  [SMALL_STATE(1129)] = 34286,
  [SMALL_STATE(1130)] = 34293,
  [SMALL_STATE(1131)] = 34300,
  [SMALL_STATE(1132)] = 34307,
  [SMALL_STATE(1133)] = 34314,
  [SMALL_STATE(1134)] = 34321,
  [SMALL_STATE(1135)] = 34328,
  [SMALL_STATE(1136)] = 34335,
  [SMALL_STATE(1137)] = 34342,
  [SMALL_STATE(1138)] = 34349,
  [SMALL_STATE(1139)] = 34356,
  [SMALL_STATE(1140)] = 34363,
  [SMALL_STATE(1141)] = 34370,
  [SMALL_STATE(1142)] = 34377,
  [SMALL_STATE(1143)] = 34384,
  [SMALL_STATE(1144)] = 34391,
  [SMALL_STATE(1145)] = 34398,
  [SMALL_STATE(1146)] = 34405,
  [SMALL_STATE(1147)] = 34412,
  [SMALL_STATE(1148)] = 34419,
  [SMALL_STATE(1149)] = 34426,
  [SMALL_STATE(1150)] = 34433,
  [SMALL_STATE(1151)] = 34440,
  [SMALL_STATE(1152)] = 34447,
  [SMALL_STATE(1153)] = 34454,
  [SMALL_STATE(1154)] = 34461,
  [SMALL_STATE(1155)] = 34468,
  [SMALL_STATE(1156)] = 34475,
  [SMALL_STATE(1157)] = 34482,
  [SMALL_STATE(1158)] = 34489,
  [SMALL_STATE(1159)] = 34496,
  [SMALL_STATE(1160)] = 34503,
  [SMALL_STATE(1161)] = 34510,
  [SMALL_STATE(1162)] = 34517,
  [SMALL_STATE(1163)] = 34524,
  [SMALL_STATE(1164)] = 34531,
  [SMALL_STATE(1165)] = 34538,
  [SMALL_STATE(1166)] = 34545,
  [SMALL_STATE(1167)] = 34552,
  [SMALL_STATE(1168)] = 34559,
  [SMALL_STATE(1169)] = 34566,
  [SMALL_STATE(1170)] = 34573,
  [SMALL_STATE(1171)] = 34580,
  [SMALL_STATE(1172)] = 34587,
  [SMALL_STATE(1173)] = 34594,
  [SMALL_STATE(1174)] = 34601,
  [SMALL_STATE(1175)] = 34608,
  [SMALL_STATE(1176)] = 34615,
  [SMALL_STATE(1177)] = 34622,
  [SMALL_STATE(1178)] = 34629,
  [SMALL_STATE(1179)] = 34636,
  [SMALL_STATE(1180)] = 34643,
  [SMALL_STATE(1181)] = 34650,
  [SMALL_STATE(1182)] = 34657,
  [SMALL_STATE(1183)] = 34664,
  [SMALL_STATE(1184)] = 34671,
  [SMALL_STATE(1185)] = 34678,
  [SMALL_STATE(1186)] = 34685,
  [SMALL_STATE(1187)] = 34692,
  [SMALL_STATE(1188)] = 34699,
  [SMALL_STATE(1189)] = 34706,
  [SMALL_STATE(1190)] = 34713,
  [SMALL_STATE(1191)] = 34720,
  [SMALL_STATE(1192)] = 34727,
  [SMALL_STATE(1193)] = 34734,
  [SMALL_STATE(1194)] = 34741,
  [SMALL_STATE(1195)] = 34748,
  [SMALL_STATE(1196)] = 34755,
  [SMALL_STATE(1197)] = 34762,
  [SMALL_STATE(1198)] = 34769,
  [SMALL_STATE(1199)] = 34776,
  [SMALL_STATE(1200)] = 34783,
  [SMALL_STATE(1201)] = 34790,
  [SMALL_STATE(1202)] = 34797,
  [SMALL_STATE(1203)] = 34804,
  [SMALL_STATE(1204)] = 34811,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1051),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1001),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1059),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(845),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(651),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(697),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(900),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(723),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(649),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(678),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(902),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(725),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1050),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1058),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(641),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1064),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(619),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1033),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [53] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0),
  [55] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1051),
  [58] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1001),
  [61] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1059),
  [64] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(845),
  [67] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(651),
  [70] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(697),
  [73] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(900),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(723),
  [79] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(649),
  [82] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(678),
  [85] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(902),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(725),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1050),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1058),
  [97] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(641),
  [100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1064),
  [103] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1038),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1047),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1125),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(904),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(646),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(681),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(874),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(715),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1019),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1020),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(605),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif, 4, 0, 14),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(986),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(909),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(908),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(643),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(682),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(699),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(727),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1048),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1049),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(638),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(992),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(620),
  [159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elifdef, 3, 0, 6),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elifdef, 2, 0, 6),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif, 3, 0, 14),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [187] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1038),
  [190] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1047),
  [193] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1125),
  [196] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(904),
  [199] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(646),
  [202] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(681),
  [205] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(874),
  [208] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(715),
  [211] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1019),
  [214] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(1020),
  [217] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(605),
  [220] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(986),
  [223] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(909),
  [226] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(651),
  [229] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(697),
  [232] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(908),
  [235] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(900),
  [238] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(723),
  [241] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(643),
  [244] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(682),
  [247] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(699),
  [250] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(727),
  [253] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(1048),
  [256] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(1049),
  [259] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(638),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0),
  [264] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(992),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0),
  [269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(913),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(650),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(683),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(731),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1077),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1078),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(639),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif_in_node, 4, 0, 14),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1023),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif_in_node, 3, 0, 14),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_else, 1, 0, 0),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1, 0, 0),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_else, 2, 0, 0),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(913),
  [318] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(650),
  [321] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(683),
  [324] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(700),
  [327] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(731),
  [330] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(1077),
  [333] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(1078),
  [336] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(639),
  [339] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(1023),
  [342] = {.entry = {.count = 1, .reusable = false}}, SHIFT(898),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(944),
  [346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(648),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(696),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(732),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(984),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(985),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(609),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1053),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1060),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1063),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1065),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1068),
  [370] = {.entry = {.count = 1, .reusable = false}}, SHIFT(917),
  [372] = {.entry = {.count = 1, .reusable = false}}, SHIFT(645),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(686),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(701),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(739),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1102),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1103),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(640),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_else_in_node, 1, 0, 0),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1052),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1137),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1175),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1085),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_else_in_node, 2, 0, 0),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1159),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1083),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1091),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1165),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1088),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1002),
  [410] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(917),
  [413] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(645),
  [416] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(686),
  [419] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(701),
  [422] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(739),
  [425] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(1102),
  [428] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(1103),
  [431] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(640),
  [434] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(1052),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1016),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1024),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1089),
  [443] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(898),
  [446] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(648),
  [449] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(685),
  [452] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(696),
  [455] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(732),
  [458] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(984),
  [461] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(985),
  [464] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(609),
  [467] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2, 0, 0), SHIFT_REPEAT(1053),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1096),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1037),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1126),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1185),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1187),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1188),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1191),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1195),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1017),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1018),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1022),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1025),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1031),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1056),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1071),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1074),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1092),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1104),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1106),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1155),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(953),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(958),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(962),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(982),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(983),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(991),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1004),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1006),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1007),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1008),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1009),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1026),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1027),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1028),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1057),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1045),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1046),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1076),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1093),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1097),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1098),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1099),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1100),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1101),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1114),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1115),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1116),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1117),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1118),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1144),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1145),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1148),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1173),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1176),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1177),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1193),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1196),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1199),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1200),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1201),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1202),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1203),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(942),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(943),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(945),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(946),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(947),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(948),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(949),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(950),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(951),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(952),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(960),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(963),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(966),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(967),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(968),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(969),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(970),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(971),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(972),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(973),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(974),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(975),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(976),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(977),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(978),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(979),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(980),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(981),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1044),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2, 0, 0),
  [654] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 2, 0, 0),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 3, 0, 0),
  [658] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 3, 0, 0),
  [660] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 4, 0, 0),
  [662] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 4, 0, 0),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 2, 0, 7),
  [666] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 2, 0, 7),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0),
  [670] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, 0, 0),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(644),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef, 4, 0, 6),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef, 4, 0, 6),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 5, 0, 16),
  [680] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 5, 0, 16),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 5, 0, 10),
  [684] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 5, 0, 10),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_memory_reservation, 4, 0, 9),
  [688] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_memory_reservation, 4, 0, 9),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 6, 0, 23),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 6, 0, 23),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 4, 0, 10),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 4, 0, 10),
  [698] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_undef, 3, 0, 6),
  [700] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_undef, 3, 0, 6),
  [702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 3, 0, 0),
  [704] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 3, 0, 0),
  [706] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_def, 4, 0, 11),
  [708] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_def, 4, 0, 11),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_function_def, 4, 0, 12),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_function_def, 4, 0, 12),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if, 4, 0, 14),
  [716] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if, 4, 0, 14),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file_version, 2, 0, 0),
  [720] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_file_version, 2, 0, 0),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_plugin, 2, 0, 0),
  [724] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_plugin, 2, 0, 0),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_delete_node, 5, 0, 18),
  [728] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_delete_node, 5, 0, 18),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_omit_if_no_ref, 3, 0, 0),
  [732] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_omit_if_no_ref, 3, 0, 0),
  [734] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if, 6, 0, 26),
  [736] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if, 6, 0, 26),
  [738] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_function_def, 5, 0, 19),
  [740] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_function_def, 5, 0, 19),
  [742] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if, 5, 0, 20),
  [744] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if, 5, 0, 20),
  [746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 6, 0, 16),
  [748] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 6, 0, 16),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if, 5, 0, 14),
  [752] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if, 5, 0, 14),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_include, 3, 0, 3),
  [756] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_include, 3, 0, 3),
  [758] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 7, 0, 23),
  [760] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 7, 0, 23),
  [762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef, 3, 0, 6),
  [764] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef, 3, 0, 6),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_def, 3, 0, 6),
  [768] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_def, 3, 0, 6),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef, 5, 0, 21),
  [772] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef, 5, 0, 21),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 7, 0, 31),
  [776] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 7, 0, 31),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_omit_if_no_ref, 2, 0, 0),
  [780] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_omit_if_no_ref, 2, 0, 0),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_memory_reservation, 5, 0, 22),
  [784] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_memory_reservation, 5, 0, 22),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 8, 0, 31),
  [788] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 8, 0, 31),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_delete_node, 3, 0, 6),
  [792] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_delete_node, 3, 0, 6),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dtsi_include, 2, 0, 3),
  [796] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dtsi_include, 2, 0, 3),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 2, 0, 0),
  [800] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 2, 0, 0),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef, 4, 0, 15),
  [804] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef, 4, 0, 15),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, 0, 8),
  [808] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, 0, 8),
  [810] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 3, 0, 0),
  [812] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 3, 0, 0),
  [814] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, 0, 13),
  [816] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, 0, 13),
  [818] = {.entry = {.count = 1, .reusable = false}}, SHIFT(658),
  [820] = {.entry = {.count = 1, .reusable = false}}, SHIFT(659),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(658),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(666),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(659),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [832] = {.entry = {.count = 1, .reusable = false}}, SHIFT(657),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [836] = {.entry = {.count = 1, .reusable = false}}, SHIFT(664),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(665),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional_expression, 5, 0, 37),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(670),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [850] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__preproc_expression, 1, 0, 0),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__preproc_expression, 1, 0, 0),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [856] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [858] = {.entry = {.count = 1, .reusable = false}}, SHIFT(594),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0),
  [862] = {.entry = {.count = 1, .reusable = false}}, SHIFT(612),
  [864] = {.entry = {.count = 1, .reusable = false}}, SHIFT(623),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(616),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [870] = {.entry = {.count = 1, .reusable = false}}, SHIFT(628),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(623),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [880] = {.entry = {.count = 1, .reusable = false}}, SHIFT(614),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [892] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef_in_node, 5, 0, 21),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef_in_node, 5, 0, 21),
  [896] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 5, 0, 27),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 5, 0, 27),
  [900] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 5, 0, 28),
  [902] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 5, 0, 28),
  [904] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 5, 0, 29),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 5, 0, 29),
  [908] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 5, 0, 30),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 5, 0, 30),
  [912] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if_in_node, 6, 0, 26),
  [914] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if_in_node, 6, 0, 26),
  [916] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 6, 0, 33),
  [918] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 6, 0, 33),
  [920] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 6, 0, 34),
  [922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 6, 0, 34),
  [924] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 6, 0, 35),
  [926] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 6, 0, 35),
  [928] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_preproc_argument_list_repeat1, 2, 0, 0),
  [930] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 7, 0, 36),
  [932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 7, 0, 36),
  [934] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if_in_node, 5, 0, 20),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if_in_node, 5, 0, 20),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(671),
  [944] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if_in_node, 5, 0, 14),
  [946] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if_in_node, 5, 0, 14),
  [948] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_call_expression, 2, 0, 7),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_call_expression, 2, 0, 7),
  [952] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_unary_expression, 2, 0, 8),
  [954] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_unary_expression, 2, 0, 8),
  [956] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_defined, 2, 0, 0),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_defined, 2, 0, 0),
  [960] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 2, 0, 10),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 2, 0, 10),
  [964] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_parenthesized_expression, 3, 0, 0),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_parenthesized_expression, 3, 0, 0),
  [968] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_argument_list, 2, 0, 0),
  [970] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_argument_list, 2, 0, 0),
  [972] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_binary_expression, 3, 0, 13),
  [974] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_binary_expression, 3, 0, 13),
  [976] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_argument_list, 4, 0, 0),
  [978] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_argument_list, 4, 0, 0),
  [980] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_delete_property, 3, 0, 6),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_delete_property, 3, 0, 6),
  [984] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef_in_node, 3, 0, 6),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef_in_node, 3, 0, 6),
  [988] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 3, 0, 10),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 3, 0, 10),
  [992] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 3, 0, 16),
  [994] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 3, 0, 16),
  [996] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_argument_list, 3, 0, 0),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_argument_list, 3, 0, 0),
  [1000] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_defined, 4, 0, 0),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_defined, 4, 0, 0),
  [1004] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if_in_node, 4, 0, 14),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if_in_node, 4, 0, 14),
  [1008] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef_in_node, 4, 0, 15),
  [1010] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef_in_node, 4, 0, 15),
  [1012] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef_in_node, 4, 0, 6),
  [1014] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef_in_node, 4, 0, 6),
  [1016] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 4, 0, 24),
  [1018] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 4, 0, 24),
  [1020] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 4, 0, 25),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 4, 0, 25),
  [1024] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 4, 0, 16),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 4, 0, 16),
  [1028] = {.entry = {.count = 1, .reusable = false}}, SHIFT(633),
  [1030] = {.entry = {.count = 1, .reusable = false}}, SHIFT(634),
  [1032] = {.entry = {.count = 1, .reusable = false}}, SHIFT(636),
  [1034] = {.entry = {.count = 1, .reusable = false}}, SHIFT(610),
  [1036] = {.entry = {.count = 1, .reusable = false}}, SHIFT(642),
  [1038] = {.entry = {.count = 1, .reusable = false}}, SHIFT(624),
  [1040] = {.entry = {.count = 1, .reusable = false}}, SHIFT(626),
  [1042] = {.entry = {.count = 1, .reusable = false}}, SHIFT(617),
  [1044] = {.entry = {.count = 1, .reusable = false}}, SHIFT(615),
  [1046] = {.entry = {.count = 1, .reusable = false}}, SHIFT(629),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(989),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(990),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(746),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(793),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1130] = {.entry = {.count = 1, .reusable = false}}, SHIFT(213),
  [1132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [1134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(910),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [1144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [1148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1162] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [1166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(853),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1172] = {.entry = {.count = 1, .reusable = false}}, SHIFT(901),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(915),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(918),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(911),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [1250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1066),
  [1252] = {.entry = {.count = 1, .reusable = false}}, SHIFT(857),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__label_name, 1, 0, 0),
  [1256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__label_name, 1, 0, 0),
  [1258] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1131),
  [1260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(906),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1266] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_integer_cells_repeat1, 2, 0, 0), SHIFT_REPEAT(900),
  [1269] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2, 0, 0), SHIFT_REPEAT(723),
  [1272] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2, 0, 0), SHIFT_REPEAT(672),
  [1275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2, 0, 0),
  [1277] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2, 0, 0), SHIFT_REPEAT(656),
  [1280] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2, 0, 0), SHIFT_REPEAT(690),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(672),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(869),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(690),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(861),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [1323] = {.entry = {.count = 1, .reusable = false}}, SHIFT(858),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1021),
  [1327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference, 1, 0, 0),
  [1329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reference, 1, 0, 0),
  [1331] = {.entry = {.count = 1, .reusable = false}}, SHIFT(850),
  [1333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(866),
  [1335] = {.entry = {.count = 1, .reusable = false}}, SHIFT(878),
  [1337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__label_reference, 2, 0, 2),
  [1339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__label_reference, 2, 0, 2),
  [1341] = {.entry = {.count = 1, .reusable = false}}, SHIFT(887),
  [1343] = {.entry = {.count = 1, .reusable = false}}, SHIFT(892),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1186),
  [1347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__node_reference, 3, 0, 0),
  [1349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__node_reference, 3, 0, 0),
  [1351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference, 1, 0, 1),
  [1353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reference, 1, 0, 1),
  [1355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__integer_cell_items, 1, 0, 0),
  [1357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__integer_cell_items, 1, 0, 0),
  [1359] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_memory_reservation_repeat1, 2, 0, 5),
  [1361] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_memory_reservation_repeat1, 2, 0, 5), SHIFT_REPEAT(651),
  [1364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_memory_reservation_repeat1, 2, 0, 5),
  [1366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__integer_cell_items, 3, 0, 0),
  [1368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__integer_cell_items, 3, 0, 0),
  [1370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bits, 2, 0, 0),
  [1372] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bits, 2, 0, 0),
  [1374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__node_name, 1, 0, 0),
  [1376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__node_name, 1, 0, 0),
  [1378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_memory_reservation_repeat1, 1, 0, 1),
  [1380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_memory_reservation_repeat1, 1, 0, 1),
  [1382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__label, 2, 0, 4),
  [1384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__label, 2, 0, 4),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(704),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(939),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(937),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(931),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(933),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(923),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(921),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(935),
  [1440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(929),
  [1448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(744),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1134),
  [1456] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [1458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(741),
  [1460] = {.entry = {.count = 1, .reusable = false}}, SHIFT(741),
  [1462] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [1464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(717),
  [1466] = {.entry = {.count = 1, .reusable = false}}, SHIFT(717),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(860),
  [1472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [1478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(767),
  [1480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1034),
  [1482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(886),
  [1484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(932),
  [1488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1012),
  [1494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(771),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1073),
  [1498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(429),
  [1500] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1194),
  [1502] = {.entry = {.count = 1, .reusable = false}}, SHIFT(500),
  [1504] = {.entry = {.count = 1, .reusable = false}}, SHIFT(961),
  [1506] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_path_repeat1, 2, 0, 0), SHIFT_REPEAT(886),
  [1509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_path_repeat1, 2, 0, 0),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1190),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1143),
  [1515] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [1517] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1204),
  [1519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1072),
  [1521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path, 1, 0, 0),
  [1523] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(924),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(936),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(957),
  [1543] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2, 0, 0),
  [1545] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(741),
  [1548] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(741),
  [1551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unit_address, 1, 0, 0),
  [1553] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unit_address, 1, 0, 0),
  [1555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(736),
  [1559] = {.entry = {.count = 1, .reusable = false}}, SHIFT(736),
  [1561] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1040),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(734),
  [1565] = {.entry = {.count = 1, .reusable = false}}, SHIFT(734),
  [1567] = {.entry = {.count = 1, .reusable = false}}, SHIFT(472),
  [1569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1054),
  [1571] = {.entry = {.count = 1, .reusable = false}}, SHIFT(763),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(726),
  [1575] = {.entry = {.count = 1, .reusable = false}}, SHIFT(726),
  [1577] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [1579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1167),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1613] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_property_repeat1, 2, 0, 0),
  [1615] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_property_repeat1, 2, 0, 0), SHIFT_REPEAT(611),
  [1618] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_path_node, 2, 0, 6),
  [1620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(883),
  [1622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path_node, 2, 0, 6),
  [1624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [1626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(888),
  [1628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(833),
  [1630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [1640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [1644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [1656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [1672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [1674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(872),
  [1680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(823),
  [1682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1698] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(670),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(710),
  [1703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [1709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(879),
  [1713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(891),
  [1715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(852),
  [1723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(927),
  [1729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(925),
  [1733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(703),
  [1741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(871),
  [1745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(834),
  [1747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(895),
  [1753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [1759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1761] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_preproc_params_repeat1, 2, 0, 0), SHIFT_REPEAT(879),
  [1764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_preproc_params_repeat1, 2, 0, 0),
  [1766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(894),
  [1768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_byte_string_literal_repeat1, 2, 0, 0),
  [1770] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_byte_string_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(834),
  [1773] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_preproc_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(616),
  [1776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [1778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_incbin, 8, 0, 38),
  [1784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(742),
  [1786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(687),
  [1788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(893),
  [1790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(940),
  [1796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1123),
  [1800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(846),
  [1804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(880),
  [1810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer_cells, 3, 0, 0),
  [1814] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [1816] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1095),
  [1818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(855),
  [1820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(854),
  [1826] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [1828] = {.entry = {.count = 1, .reusable = false}}, SHIFT(955),
  [1830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer_cells, 2, 0, 0),
  [1832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_byte_string_literal, 3, 0, 0),
  [1834] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_byte_string_literal, 2, 0, 0),
  [1836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(720),
  [1842] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_path_node, 4, 0, 17),
  [1844] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path_node, 4, 0, 17),
  [1846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(864),
  [1856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(890),
  [1858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1864] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [1866] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1198),
  [1868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(697),
  [1870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [1872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(896),
  [1874] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_params, 2, 0, 0),
  [1876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1878] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_params, 4, 0, 0),
  [1880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(884),
  [1884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_incbin, 4, 0, 32),
  [1886] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_params, 3, 0, 0),
  [1888] = {.entry = {.count = 1, .reusable = false}}, SHIFT(507),
  [1890] = {.entry = {.count = 1, .reusable = false}}, SHIFT(965),
  [1892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(651),
  [1898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(922),
  [1900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1902] = {.entry = {.count = 1, .reusable = true}}, SHIFT(743),
  [1904] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [1906] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1132),
  [1908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(926),
  [1910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(928),
  [1914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__property_name, 1, 0, 0),
  [1918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(996),
  [1920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [1922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(930),
  [1924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1926] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [1928] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1122),
  [1930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(934),
  [1932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(938),
  [1936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [1938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [1954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [1962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [1974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [1984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [1986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [2000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [2002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [2004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [2006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [2008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [2010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [2012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [2014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [2016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [2018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [2020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [2022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(745),
  [2024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1000),
  [2026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [2028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1014),
  [2030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(688),
  [2032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(695),
  [2034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(867),
  [2036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [2038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [2040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [2042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [2044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [2046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1156),
  [2048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1183),
  [2050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif_in_node, 4, 0, 20),
  [2052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [2054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [2056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [2058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [2060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [2062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [2064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [2066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [2068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [2070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [2072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif, 5, 0, 26),
  [2074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [2076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [2078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [2080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [2082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [2084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [2086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [2088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(747),
  [2090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1154),
  [2092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(844),
  [2094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [2096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [2098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [2100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [2102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [2104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [2106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [2108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [2110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [2112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [2114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [2116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [2118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [2120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [2122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [2124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [2126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [2128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [2130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1111),
  [2132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elifdef, 3, 0, 15),
  [2134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [2136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [2138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [2140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [2142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [2144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(733),
  [2146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1075),
  [2148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(722),
  [2150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [2152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [2154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [2156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [2158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [2160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [2162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [2164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1030),
  [2166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1107),
  [2168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [2170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [2172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [2174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [2176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1041),
  [2178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [2180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [2182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [2184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [2186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [2188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [2190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [2192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [2194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(728),
  [2196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1192),
  [2198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [2200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [2202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [2204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [2206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [2208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [2210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [2212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [2214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [2216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [2218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [2220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [2222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [2224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [2226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [2228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [2230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [2232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [2234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [2236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [2238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [2240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [2242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [2244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(729),
  [2246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(959),
  [2248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [2250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [2252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [2254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1109),
  [2256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [2258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [2260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [2262] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [2264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [2266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [2268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [2270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [2272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [2274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [2276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [2278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif, 4, 0, 20),
  [2280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [2282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1168),
  [2284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [2286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(987),
  [2288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [2290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elifdef, 4, 0, 21),
  [2292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [2294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(997),
  [2296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [2298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [2300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [2302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [2304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [2306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [2308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [2310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [2312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [2314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif_in_node, 5, 0, 26),
  [2316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [2318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [2320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [2322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [2324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [2326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [2328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [2330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [2332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [2334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [2336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [2338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [2340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [2342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [2344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [2346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [2348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [2350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [2352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [2354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [2356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [2358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [2360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [2362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [2364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [2366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [2368] = {.entry = {.count = 1, .reusable = tru