/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.contrib.demo;

import com.sun.jna.platform.WindowUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class AlphaMaskDemo2
implements Runnable {
    private static final DataFlavor URL_FLAVOR = new DataFlavor("application/x-java-url; class=java.net.URL", "URL");
    private static final DataFlavor URI_LIST_FLAVOR = new DataFlavor("text/uri-list; class=java.lang.String", "URI list");
    private JFrame frame;
    private JWindow alphaWindow;
    private JLabel icon;
    private ImageObserver observer = new ImageObserver(){

        @Override
        public boolean imageUpdate(final Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x30) != 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlphaMaskDemo2.this.setImage(img);
                    }
                });
                return false;
            }
            if ((infoflags & 0xC0) != 0) {
                System.err.println("Image load error: " + img);
                return false;
            }
            return true;
        }
    };

    private void setImage(Image image) {
        int w = image.getWidth(this.observer);
        int h = image.getHeight(this.observer);
        if (w > 0 && h > 0) {
            this.frame.setIconImage(image);
            this.icon.setIcon(new ImageIcon(image));
            if (!this.alphaWindow.isVisible()) {
                this.alphaWindow.pack();
                this.alphaWindow.setVisible(true);
            } else {
                this.alphaWindow.setSize(this.alphaWindow.getPreferredSize());
            }
            this.icon.getParent().invalidate();
            this.icon.getParent().repaint();
        }
    }

    @Override
    public void run() {
        GraphicsConfiguration gconfig = WindowUtils.getAlphaCompatibleGraphicsConfiguration();
        this.frame = new JFrame("Alpha Mask Demo");
        this.alphaWindow = new JWindow(this.frame, gconfig);
        this.icon = new JLabel();
        this.icon.setCursor(Cursor.getPredefinedCursor(12));
        this.alphaWindow.getContentPane().add(this.icon);
        JButton quit = new JButton("Quit");
        JLabel label = new JLabel("Drag this window by its image");
        label.setHorizontalAlignment(0);
        this.alphaWindow.getContentPane().add((Component)label, "North");
        this.alphaWindow.getContentPane().add((Component)quit, "South");
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        MouseInputAdapter handler = new MouseInputAdapter(){
            private Point offset;

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    this.offset = e.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.offset = null;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.offset != null) {
                    Window w = (Window)e.getSource();
                    Point where = e.getPoint();
                    where.translate(-this.offset.x, -this.offset.y);
                    Point loc = w.getLocationOnScreen();
                    loc.translate(where.x, where.y);
                    w.setLocation(loc.x, loc.y);
                }
            }
        };
        this.alphaWindow.addMouseListener(handler);
        this.alphaWindow.addMouseMotionListener(handler);
        JPanel p = new JPanel(new BorderLayout(8, 8));
        p.setBorder(new EmptyBorder(8, 8, 8, 8));
        p.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                List<DataFlavor> list = Arrays.asList(transferFlavors);
                if (list.contains(URL_FLAVOR) || list.contains(URI_LIST_FLAVOR) || list.contains(DataFlavor.imageFlavor) || list.contains(DataFlavor.javaFileListFlavor)) {
                    return true;
                }
                if (DataFlavor.selectBestTextFlavor(transferFlavors) != null) {
                    return true;
                }
                System.err.println("No acceptable flavor found in " + Arrays.asList(transferFlavors));
                return false;
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                try {
                    if (t.isDataFlavorSupported(URL_FLAVOR)) {
                        URL url = (URL)t.getTransferData(URL_FLAVOR);
                        AlphaMaskDemo2.this.setImage(Toolkit.getDefaultToolkit().getImage(url));
                        return true;
                    }
                    if (t.isDataFlavorSupported(URI_LIST_FLAVOR)) {
                        String s = (String)t.getTransferData(URI_LIST_FLAVOR);
                        String[] uris = s.split("[\r\n]");
                        if (uris.length > 0) {
                            URL url = new URL(uris[0]);
                            AlphaMaskDemo2.this.setImage(Toolkit.getDefaultToolkit().getImage(url));
                            return true;
                        }
                        return false;
                    }
                    if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                        Image image = (Image)t.getTransferData(DataFlavor.imageFlavor);
                        AlphaMaskDemo2.this.setImage(image);
                        return true;
                    }
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        File f = (File)files.get(0);
                        URL url = new URL("file://" + f.toURI().toURL().getPath());
                        Image image = Toolkit.getDefaultToolkit().getImage(url);
                        AlphaMaskDemo2.this.setImage(image);
                        return true;
                    }
                    DataFlavor flavor = DataFlavor.selectBestTextFlavor(t.getTransferDataFlavors());
                    if (flavor != null) {
                        int count;
                        Reader reader = flavor.getReaderForText(t);
                        char[] buf = new char[512];
                        StringBuilder b = new StringBuilder();
                        while ((count = reader.read(buf)) > 0) {
                            for (int i = 0; i < count; ++i) {
                                if (buf[i] == '\u0000') continue;
                                b.append(buf, i, 1);
                            }
                        }
                        String html = b.toString();
                        Pattern p = Pattern.compile("<img.*src=\"([^\\\"\">]+)\"", 192);
                        Matcher m = p.matcher(html);
                        if (m.find()) {
                            URL url = new URL(m.group(1));
                            System.out.println("Load image from " + url);
                            Image image = Toolkit.getDefaultToolkit().getImage(url);
                            AlphaMaskDemo2.this.setImage(image);
                            return true;
                        }
                        System.err.println("Can't parse text: " + html);
                        return false;
                    }
                    System.err.println("No flavor available: " + Arrays.asList(t.getTransferDataFlavors()));
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        p.add((Component)new JLabel("<html><center>Drop an image with an alpha channel onto this window<br>You may also adjust the overall transparency with the slider</center></html>"), "North");
        p.setCursor(Cursor.getPredefinedCursor(12));
        final JSlider slider = new JSlider(0, 255, 255);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = slider.getValue();
                WindowUtils.setWindowAlpha(AlphaMaskDemo2.this.alphaWindow, (float)value / 255.0f);
            }
        });
        p.add((Component)slider, "South");
        this.frame.getContentPane().add(p);
        this.frame.pack();
        this.frame.setDefaultCloseOperation(3);
        AlphaMaskDemo2.centerOnScreen(this.frame);
        this.frame.setVisible(true);
        WindowUtils.setWindowTransparent(this.alphaWindow, true);
        this.alphaWindow.setLocation(this.frame.getX() + this.frame.getWidth() + 4, this.frame.getY());
        try {
            URL url = this.getClass().getResource("tardis.png");
            if (url != null) {
                this.setImage(Toolkit.getDefaultToolkit().getImage(url));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void centerOnScreen(Window window) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Rectangle max = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int x = Math.max(center.x - Math.round((float)window.getWidth() / 2.0f), max.x);
        int y = Math.max(center.y - Math.round((float)window.getHeight() / 2.0f), max.y);
        window.setLocation(new Point(x, y));
    }

    public static void main(String[] args) {
        try {
            System.setProperty("sun.java2d.noddraw", "true");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new AlphaMaskDemo2());
    }
}

