/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipFileAttributes;
import com.sun.nio.zipfs.ZipPath;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class ZipFileAttributeView
implements BasicFileAttributeView {
    private final ZipPath path;
    private final boolean isZipView;

    private ZipFileAttributeView(ZipPath zipPath, boolean bl) {
        this.path = zipPath;
        this.isZipView = bl;
    }

    static <V extends FileAttributeView> V get(ZipPath zipPath, Class<V> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (clazz == BasicFileAttributeView.class) {
            return (V)new ZipFileAttributeView(zipPath, false);
        }
        if (clazz == ZipFileAttributeView.class) {
            return (V)new ZipFileAttributeView(zipPath, true);
        }
        return null;
    }

    static ZipFileAttributeView get(ZipPath zipPath, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("basic")) {
            return new ZipFileAttributeView(zipPath, false);
        }
        if (string.equals("zip")) {
            return new ZipFileAttributeView(zipPath, true);
        }
        return null;
    }

    @Override
    public String name() {
        return this.isZipView ? "zip" : "basic";
    }

    @Override
    public ZipFileAttributes readAttributes() throws IOException {
        return this.path.getAttributes();
    }

    @Override
    public void setTimes(FileTime fileTime, FileTime fileTime2, FileTime fileTime3) throws IOException {
        this.path.setTimes(fileTime, fileTime2, fileTime3);
    }

    void setAttribute(String string, Object object) throws IOException {
        try {
            if (AttrID.valueOf(string) == AttrID.lastModifiedTime) {
                this.setTimes((FileTime)object, null, null);
            }
            if (AttrID.valueOf(string) == AttrID.lastAccessTime) {
                this.setTimes(null, (FileTime)object, null);
            }
            if (AttrID.valueOf(string) == AttrID.creationTime) {
                this.setTimes(null, null, (FileTime)object);
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("'" + string + "' is unknown or read-only attribute");
        }
    }

    Map<String, Object> readAttributes(String string) throws IOException {
        ZipFileAttributes zipFileAttributes = this.readAttributes();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if ("*".equals(string)) {
            for (AttrID attrID : AttrID.values()) {
                try {
                    linkedHashMap.put(attrID.name(), this.attribute(attrID, zipFileAttributes));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                try {
                    linkedHashMap.put(string2, this.attribute(AttrID.valueOf(string2), zipFileAttributes));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return linkedHashMap;
    }

    Object attribute(AttrID attrID, ZipFileAttributes zipFileAttributes) {
        switch (attrID) {
            case size: {
                return zipFileAttributes.size();
            }
            case creationTime: {
                return zipFileAttributes.creationTime();
            }
            case lastAccessTime: {
                return zipFileAttributes.lastAccessTime();
            }
            case lastModifiedTime: {
                return zipFileAttributes.lastModifiedTime();
            }
            case isDirectory: {
                return zipFileAttributes.isDirectory();
            }
            case isRegularFile: {
                return zipFileAttributes.isRegularFile();
            }
            case isSymbolicLink: {
                return zipFileAttributes.isSymbolicLink();
            }
            case isOther: {
                return zipFileAttributes.isOther();
            }
            case fileKey: {
                return zipFileAttributes.fileKey();
            }
            case compressedSize: {
                if (!this.isZipView) break;
                return zipFileAttributes.compressedSize();
            }
            case crc: {
                if (!this.isZipView) break;
                return zipFileAttributes.crc();
            }
            case method: {
                if (!this.isZipView) break;
                return zipFileAttributes.method();
            }
        }
        return null;
    }

    private static enum AttrID {
        size,
        creationTime,
        lastAccessTime,
        lastModifiedTime,
        isDirectory,
        isRegularFile,
        isSymbolicLink,
        isOther,
        fileKey,
        compressedSize,
        crc,
        method;

    }
}

