# Building M2Crypto

## Dependencies

*   Python 3 (>= 3.6)
*   SWIG
*   OpenSSL (development libraries)
*   A C compiler (like GCC)

## Build Commands

The project uses a `Makefile` to simplify development.

*   `make all`: **Default.** Builds wheel, installs locally, runs tests.
*   `make wheel`: Builds the Python wheel package (in `dist/`).
*   `make install`: Installs the wheel into a local `build` directory for testing.
*   `make clean`: Removes generated files and artifacts.
*   `make sdist`: Creates source distribution and runs twine/pyroma checks.

## Environment Variables

*   `OPENSSL_PATH`: Path to OpenSSL installation directory.
*   `BUNDLEDLLS`: Set to bundle OpenSSL DLLs on Windows.
*   `CC`: C compiler to use.
*   `CFLAGS`: C compiler flags.

## SWIG Integration

M2Crypto uses SWIG to generate Python bindings from OpenSSL C headers. SWIG options are configured in the `finalize_options()` method of `_M2CryptoBuildExt` in `setup.py`.
