//
// Copyright (c) 2016 KAMADA Ken'ichi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//

// Macros for testing.

macro_rules! assert_ok {
    ($expr:expr, $value:expr) => (
        match $expr {
            Ok(v) => assert_eq!(v, $value),
            r => panic!("assertion failed: unexpected {:?}", r),
        }
    )
}

macro_rules! assert_pat {
    ($expr:expr, $pat:pat) => (
        match $expr {
            $pat => {},
            ref r => panic!("assertion failed: unexpected {:?}", r),
        }
    )
}

macro_rules! assert_err_pat {
    ($expr:expr, $variant:pat) => (
        match $expr {
            Err($variant) => {},
            r => panic!("assertion failed: unexpected {:?}", r),
        }
    )
}

// This macro is intended to be used with std::io::Error, but other
// types with kind() will also work.
macro_rules! assert_err_kind {
    ($expr:expr, $kind:expr) => (
        match $expr {
            Err(e) => assert_eq!(e.kind(), $kind),
            r => panic!("assertion failed: unexpected {:?}", r),
        }
    )
}
