/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_bn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "গ্রীনিচ মিন টাইম",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "একর মানক সময়",
               "",
               "একর গ্রীষ্মকাল সময়",
               "",
               "একর সময়",
               "",
            };
        final String[] Apia = new String[] {
               "অপিয়া মানক সময়",
               "",
               "অপিয়া দিনের সময়",
               "",
               "অপিয়া সময়",
               "",
            };
        final String[] Cook = new String[] {
               "কুক দ্বীপপুঞ্জ মানক সময়",
               "",
               "কুক দ্বীপপুঞ্জ অর্ধেক গ্রীষ্মকালীন সময়",
               "",
               "কুক দ্বীপপুঞ্জ সময়",
               "",
            };
        final String[] Cuba = new String[] {
               "কিউবা মানক সময়",
               "CST",
               "কিউবা দিবালোক সময়",
               "CDT",
               "কিউবার সময়",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ফিজি মানক সময়",
               "",
               "ফিজি গ্রীষ্মকালীন সময়",
               "",
               "ফিজি সময়",
               "",
            };
        final String[] Gulf = new String[] {
               "উপসাগরীয় মানক সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "হোভড মানক সময়",
               "",
               "হোভড গ্রীষ্মকালীন সময়",
               "",
               "হোভড সময়",
               "",
            };
        final String[] Iran = new String[] {
               "ইরান মানক সময়",
               "",
               "ইরান দিবালোক সময়",
               "",
               "ইরান সময়",
               "",
            };
        final String[] Niue = new String[] {
               "নিউই সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ওমস্ক মানক সময়",
               "",
               "ওমস্ক গ্রীষ্মকালীন সময়",
               "",
               "ওমস্ক সময়",
               "",
            };
        final String[] Peru = new String[] {
               "পেরু মানক সময়",
               "",
               "পেরু গ্রীষ্মকালীন সময়",
               "",
               "পেরু সময়",
               "",
            };
        final String[] Truk = new String[] {
               "চুক সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ওয়েক দ্বীপ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "চিলি মানক সময়",
               "",
               "চিলি গ্রীষ্মকালীন সময়",
               "",
               "চিলি সময়",
               "",
            };
        final String[] China = new String[] {
               "চীন মানক সময়",
               "CST",
               "চীন দিবালোক সময়",
               "CDT",
               "চীন সময়",
               "CT",
            };
        final String[] Cocos = new String[] {
               "কোকোস দ্বীপপুঞ্জ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ডেভিস সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ভারতীয় মানক সময়",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "জাপান মানক সময়",
               "JST",
               "জাপান দিবালোক সময়",
               "JDT",
               "জাপান সময়",
               "JT",
            };
        final String[] Korea = new String[] {
               "কোরিয়ান মানক সময়",
               "KST",
               "কোরিয়ান দিবালোক সময়",
               "KST",
               "কোরিয়ান সময়",
               "KST",
            };
        final String[] Nauru = new String[] {
               "নাউরু সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "নেপাল সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "পালাউ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "সামোয়া মানক সময়",
               "SST",
               "সামোয়া দিবালোক সময়",
               "SST",
               "সামোয়া সময়",
               "SST",
            };
        final String[] Syowa = new String[] {
               "সায়োওয়া সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "টোঙ্গা মানক সময়",
               "",
               "টোঙ্গা গ্রীষ্মকালীন সময়",
               "",
               "টোঙ্গা সময়",
               "",
            };
        final String[] Yukon = new String[] {
               "ইউকোন সময়",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "আলাস্কা মানক সময়",
               "AKST",
               "আলাস্কা দিবালোক সময়",
               "AKDT",
               "আলাস্কা সময়",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "আমাজন মানক সময়",
               "",
               "আমাজন গ্রীষ্মকালীন সময়",
               "",
               "আমাজন সময়",
               "",
            };
        final String[] Azores = new String[] {
               "এজোরেস মানক সময়",
               "",
               "এজোরেস গ্রীষ্মকালীন সময়",
               "",
               "এজোরেস সময়",
               "",
            };
        final String[] Bhutan = new String[] {
               "ভুটান সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ব্রুনেই দারুসসালাম সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ইস্টার দ্বীপ মানক সময়",
               "",
               "ইস্টার দ্বীপ গ্রীষ্মকালীন সময়",
               "",
               "ইস্টার দ্বীপ সময়",
               "",
            };
        final String[] Guyana = new String[] {
               "গুয়ানা সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "হাওয়াই-আলেউত মানক সময়",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ইজরায়েল মানক সময়",
               "IST",
               "ইজরায়েল দিবালোক সময়",
               "IDT",
               "ইজরায়েল সময়",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "কোসরেই সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "মসন সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "মস্কো মানক সময়",
               "MSK",
               "মস্কো গ্রীষ্মকালীন সময়",
               "MSK",
               "মস্কো সময়",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "পোনাপে সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "সামারা মান সময়",
               "",
               "সামারা গৃষ্মকালীন সময়",
               "",
               "সামারা সময়",
               "",
            };
        final String[] Tahiti = new String[] {
               "তাহিতি সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "তাইপেই মানক সময়",
               "CST",
               "তাইপেই দিবালোক সময়",
               "CDT",
               "তাইপেই সময়",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "টুভালু সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ভসটক সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ওয়ালিস এবং ফুটুনা সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "আরবি মানক সময়",
               "",
               "আরবি দিবালোক সময়",
               "",
               "আরবি সময়",
               "",
            };
        final String[] Armenia = new String[] {
               "আর্মেনিয়া মানক সময়",
               "",
               "আর্মেনিয়া গ্রীষ্মকালীন সময়",
               "",
               "আর্মেনিয়া সময়",
               "",
            };
        final String[] Bolivia = new String[] {
               "বোলিভিয়া সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "চ্যাথাম মানক সময়",
               "",
               "চ্যাথাম দিবালোক সময়",
               "",
               "চ্যাথাম সময়",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "স্থানাংকিত আন্তর্জাতিক সময়",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ইকুয়েডর সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "গ্যাম্বিয়ার সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "জর্জিয়া মানক সময়",
               "",
               "জর্জিয়া গ্রীষ্মকালীন সময়",
               "",
               "জর্জিয়া সময়",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ইরকুটস্ক মানক সময়",
               "",
               "ইরকুটস্ক গ্রীষ্মকালীন সময়",
               "",
               "ইরকুটস্ক সময়",
               "",
            };
        final String[] Magadan = new String[] {
               "ম্যাগাডান মানক সময়",
               "",
               "ম্যাগাডান গ্রীষ্মকালীন সময়",
               "",
               "ম্যাগাডান সময়",
               "",
            };
        final String[] Myanmar = new String[] {
               "মায়ানমার সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "নরফোক দ্বীপ মানক সময়",
               "",
               "নরফোক দ্বীপ দিবালোক সময়",
               "",
               "নরফোক দ্বীপ সময়",
               "",
            };
        final String[] Noronha = new String[] {
               "ফার্নান্দো ডি নোরোনহা মানক সময়",
               "",
               "ফার্নান্দো ডি নোরোনহা গ্রীষ্মকালীন সময়",
               "",
               "ফার্নান্দো ডি নোরোনহা সময়",
               "",
            };
        final String[] Reunion = new String[] {
               "রিইউনিয়ন সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "রথেরা সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "সলোমন দ্বীপপুঞ্জ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "টোকেলাউ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "উরুগুয়ে মানক সময়",
               "",
               "উরুগুয়ে গ্রীষ্মকালীন সময়",
               "",
               "উরুগুয়ে সময়",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ভানুয়াতু মানক সময়",
               "",
               "ভানুয়াতু গ্রীষ্মকালীন সময়",
               "",
               "ভানুয়াতু সময়",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ইয়াকুটাস্ক মানক সময়",
               "",
               "ইয়াকুটাস্ক গ্রীষ্মকালীন সময়",
               "",
               "ইয়াকুটাস্ক সময়",
               "",
            };
        final String[] Atlantic = new String[] {
               "অতলান্তিক মানক সময়",
               "AST",
               "অতলান্তিক দিবালোক সময়",
               "AST",
               "অতলান্তিকের সময়",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ব্রাসিলিয়া মানক সময়",
               "",
               "ব্রাসিলিয়া গ্রীষ্মকালীন সময়",
               "",
               "ব্রাসিলিয়া সময়",
               "",
            };
        final String[] Chamorro = new String[] {
               "চামেরো মানক সময়",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "কোলোম্বিয়া মানক সময়",
               "",
               "কলম্বিয়া গ্রীষ্মকালীন সময়",
               "",
               "কলম্বিয়া সময়",
               "",
            };
        final String[] Falkland = new String[] {
               "ফকল্যান্ড দ্বীপপুঞ্জ মানক সময়",
               "",
               "ফকল্যান্ড দ্বীপপুঞ্জ গ্রীষ্মকালীন সময়",
               "",
               "ফকল্যান্ড দ্বীপপুঞ্জ সময়",
               "",
            };
        final String[] Malaysia = new String[] {
               "মালয়েশিয়া সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "মালদ্বীপ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "উলান বাতোর মানক সময়",
               "",
               "উলান বাতোর গ্রীষ্মকালীন সময়",
               "",
               "উলান বাতোর সময়",
               "",
            };
        final String[] Pakistan = new String[] {
               "পাকিস্তান মানক সময়",
               "PKT",
               "পাকিস্তান গ্রীষ্মকালীন সময়",
               "PKST",
               "পাকিস্তান সময়",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "প্যারাগুয়ে মানক সময়",
               "",
               "প্যারাগুয়ে গ্রীষ্মকালীন সময়",
               "",
               "প্যারাগুয়ে সময়",
               "",
            };
        final String[] Pitcairn = new String[] {
               "পিটকেয়ার্ন সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "সুরিনাম সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "আর্জেন্টিনা মানক সময়",
               "",
               "আর্জেন্টিনা গ্রীষ্মকালীন সময়",
               "",
               "আর্জেন্টিনা সময়",
               "",
            };
        final String[] Christmas = new String[] {
               "ক্রিসমাস দ্বীপ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "গালাপাগোস সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "হং কং মানক সময়",
               "HKT",
               "হং কং গ্রীষ্মকালীন সময়",
               "HKST",
               "হং কং সময়",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ইন্দোচীন সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "পিত্রেপ্যাভলস্ক- ক্যামচ্যাটস্কি মান সময়",
               "",
               "পিত্রেপ্যাভলস্ক- ক্যামচ্যাটস্কি গৃষ্মকালীন সময়",
               "",
               "পিত্রেপ্যাভলস্ক- ক্যামচ্যাটস্কি সময়",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "কিরগিস্তান সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "লর্ড হাওয়ে মানক মসয়",
               "",
               "লর্ড হাওয়ে দিবালোক মসয়",
               "",
               "লর্ড হাওয়ে সময়",
               "",
            };
        final String[] Marquesas = new String[] {
               "মার্কেসাস সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "মরিশাস মানক সময়",
               "",
               "মরিশাস গ্রীষ্মকালীন সময়",
               "",
               "মরিশাস সময়",
               "",
            };
        final String[] Singapore = new String[] {
               "সিঙ্গাপুর মানক সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ভেনেজুয়েলা সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "আজারবাইজান মানক সময়",
               "",
               "আজারবাইজান গ্রীষ্মকালীন সময়",
               "",
               "আজারবাইজান সময়",
               "",
            };
        final String[] Bangladesh = new String[] {
               "বাংলাদেশ মানক সময়",
               "",
               "বাংলাদেশ গ্রীষ্মকালীন সময়",
               "",
               "বাংলাদেশ সময়",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "কেপ ভার্দ মানক সময়",
               "",
               "কেপ ভার্দ গ্রীষ্মকালীন সময়",
               "",
               "কেপ ভার্দ সময়",
               "",
            };
        final String[] East_Timor = new String[] {
               "পূর্ব টিমর সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "কাজাখাস্তান সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "সেশেলস সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "তাজাখাস্তান সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "উজবেকিস্তান মানক সময়",
               "",
               "উজবেকিস্তান গ্রীষ্মকালীন সময়",
               "",
               "উজবেকিস্তান সময়",
               "",
            };
        final String[] Afghanistan = new String[] {
               "আফগানিস্তান সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ক্রাসনোয়ার্স্কি মানক সময়",
               "",
               "ক্রাসনোয়ার্স্কি গ্রীষ্মকালীন সময়",
               "",
               "ক্রাসনোয়ার্স্কি সময়",
               "",
            };
        final String[] New_Zealand = new String[] {
               "নিউজিল্যান্ড মানক সময়",
               "NZST",
               "নিউজিল্যান্ড দিবালোক সময়",
               "NZDT",
               "নিউজিল্যান্ড সময়",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ফিলিপাইন মানক সময়",
               "PST",
               "ফিলিপাইন গ্রীষ্মকালীন সময়",
               "PDT",
               "ফিলিপাইন সময়",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ভ্লাদিভস্তক মানক সময়",
               "",
               "ভ্লাদিভস্তক গ্রীষ্মকালীন সময়",
               "",
               "ভ্লাদিভস্তক সময়",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ভারত মহাসাগরীয় সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "লাইন দ্বীপপুঞ্জ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "নিউফাউন্ডল্যান্ড মানক সময়",
               "NST",
               "নিউফাউন্ডল্যান্ড দিবালোক সময়",
               "NDT",
               "নিউফাউন্ডল্যান্ড সময়",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "তুর্কমেনিস্তান মানক সময়",
               "",
               "তুর্কমেনিস্তান গ্রীষ্মকালীন সময়",
               "",
               "তুর্কমেনিস্তান সময়",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ফরাসি গায়ানা সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "নিউ ক্যালেডোনিয়া মানক সময়",
               "",
               "নিউ ক্যালেডোনিয়া গ্রীষ্মকালীন সময়",
               "",
               "নিউ ক্যালেডোনিয়া সময়",
               "",
            };
        final String[] South_Georgia = new String[] {
               "দক্ষিণ জর্জিয়া সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ইয়েকাতেরিনবুর্গ মানক সময়",
               "",
               "ইয়েকাতেরিনবুর্গ গ্রীষ্মকালীন সময়",
               "",
               "ইয়েকাতেরিনবুর্গ সময়",
               "",
            };
        final String[] Africa_Central = new String[] {
               "মধ্য আফ্রিকা সময়",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "পূর্ব আফ্রিকা সময়",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "পশ্চিম আফ্রিকা সময়",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ডুমন্ট-দ্য’উরভিলে সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "মধ্য ইউরোপীয় মানক সময়",
               "CET",
               "মধ্য ইউরোপীয় গ্রীষ্মকালীন সময়",
               "CEST",
               "মধ্য ইউরোপীয় সময়",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "পূর্ব ইউরোপীয় মানক সময়",
               "EET",
               "পূর্ব ইউরোপীয় গ্রীষ্মকালীন সময়",
               "EEST",
               "পূর্ব ইউরোপীয় সময়",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "পশ্চিম ইউরোপীয় মানক সময়",
               "WET",
               "পশ্চিম ইউরোপীয় গ্রীষ্মকালীন সময়",
               "WEST",
               "পশ্চিম ইউরোপীয় সময়",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "মেক্সিকান প্রশান্ত মহসাগরীয় মানক সময়",
               "MST",
               "মেক্সিকান প্রশান্ত মহাসাগরীয় দিবালোক সময়",
               "MDT",
               "মেক্সিকান প্রশান্ত মহাসাগরীয় সময়",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "দক্ষিণ আফ্রিকা মানক সময়",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "কেন্দ্রীয় মানক সময়",
               "CST",
               "কেন্দ্রীয় দিবালোক সময়",
               "CDT",
               "কেন্দ্রীয় সময়",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "পূর্বাঞ্চলের মানক সময়",
               "EST",
               "পূর্বাঞ্চলের দিবালোক সময়",
               "EST",
               "পূর্বাঞ্চলীয় সময়",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "প্রশান্ত মহাসাগরীয় অঞ্চলের মানক সময়",
               "PST",
               "প্রশান্ত মহাসাগরীয় অঞ্চলের দিনের সময়",
               "PDT",
               "প্রশান্ত মহাসাগরীয় অঞ্চলের সময়",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ফরাসি দক্ষিণ এবং আন্টার্কটিক সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "গিলবার্ট দ্বীপপুঞ্জ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "হাওয়াই-আলেউত মানক সময়",
               "HST",
               "হাওয়াই-আলেউত দিবালোক সময়",
               "HDT",
               "হাওয়াই-আলেউত সময়",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ফোনিক্স দ্বীপপুঞ্জ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "সেন্ট পিয়ের ও মিকেলন মানক সময়",
               "",
               "সেন্ট পিয়ের ও মিকেলন দিবালোক সময়",
               "",
               "সেন্ট পিয়ের ও মিকেলন সময়",
               "",
            };
        final String[] America_Mountain = new String[] {
               "পার্বত্য অঞ্চলের মানক সময়",
               "MST",
               "পার্বত্য অঞ্চলের দিনের সময়",
               "MST",
               "পার্বত্য অঞ্চলের সময়",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "মার্শাল দ্বীপপুঞ্জ সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "পাপুয়া নিউ গিনি সময়",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "অস্ট্রেলীয় কেন্দ্রীয় মানক সময়",
               "ACST",
               "অস্ট্রেলীয় কেন্দ্রীয় দিবালোক সময়",
               "ACDT",
               "কেন্দ্রীয় অস্ট্রেলীয় সময়",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "অস্ট্রেলীয় পূর্ব মানক সময়",
               "AEST",
               "অস্ট্রেলীয় পূর্ব দিবালোক সময়",
               "AEDT",
               "পূর্ব অস্ট্রেলীয় সময়",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "অস্ট্রেলীয় পশ্চিমি মানক সময়",
               "AWST",
               "অস্ট্রেলীয় পশ্চিমি দিবালোক সময়",
               "AWDT",
               "পশ্চিমি অস্ট্রেলীয় সময়",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "কেন্দ্রীয় ইন্দোনেশিয়া সময়",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "পূর্ব ইন্দোনেশিয়া সময়",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "পশ্চিমী ইন্দোনেশিয়া সময়",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি মানক সময়",
               "",
               "অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি দিবালোক সময়",
               "",
               "অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি সময়",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "গ্রীনিচ মিন টাইম",
                    "GMT",
                    "ব্রিটিশ গ্রীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "স্থানাংকিত আন্তর্জাতিক সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "গ্রীনিচ মিন টাইম",
                    "GMT",
                    "আইরিশ মানক সময়",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "স্থানাংকিত আন্তর্জাতিক সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "স্থানাংকিত আন্তর্জাতিক সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "গ্রীনিচ মিন টাইম",
                    "GMT",
                    "ব্রিটিশ গ্রীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "স্থানাংকিত আন্তর্জাতিক সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "স্থানাংকিত আন্তর্জাতিক সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "স্থানাংকিত আন্তর্জাতিক সময়",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "গ্রীনিচ মিন টাইম",
                    "GMT",
                    "আইরিশ মানক সময়",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "গ্রীনিচ মিন টাইম",
                    "GMT",
                    "ব্রিটিশ গ্রীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "গ্রীনিচ মিন টাইম",
                    "GMT",
                    "ব্রিটিশ গ্রীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "গ্রীনিচ মিন টাইম",
                    "GMT",
                    "ব্রিটিশ গ্রীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "গ্রীনিচ মিন টাইম",
                    "GMT",
                    "ব্রিটিশ গ্রীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "গ্রীনিচ মিন টাইম",
                    "GMT",
                    "ব্রিটিশ গ্রীষ্মকালীন সময়",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "আহদেন" },
            { "timezone.excity.Asia/Baku", "বাকু" },
            { "timezone.excity.Asia/Dili", "দিলি" },
            { "timezone.excity.Asia/Gaza", "গাজা" },
            { "timezone.excity.Asia/Hovd", "হোভ্ড" },
            { "timezone.excity.Asia/Omsk", "ওম্স্ক" },
            { "timezone.excity.Asia/Oral", "ওরাল" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "আম্মান" },
            { "timezone.excity.Asia/Aqtau", "আকটাউ" },
            { "timezone.excity.Asia/Chita", "চিতা" },
            { "timezone.excity.Asia/Dhaka", "ঢাকা" },
            { "timezone.excity.Asia/Dubai", "দুবাই" },
            { "timezone.excity.Asia/Kabul", "কাবুল" },
            { "timezone.excity.Asia/Macau", "ম্যাকাও" },
            { "timezone.excity.Asia/Qatar", "কাতার" },
            { "timezone.excity.Asia/Seoul", "সিওল" },
            { "timezone.excity.Asia/Tokyo", "টোকিও" },
            { "timezone.excity.Asia/Tomsk", "তোমস্ক" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "জুবা" },
            { "timezone.excity.Africa/Lome", "লোমে" },
            { "timezone.excity.Asia/Almaty", "আলমাটি" },
            { "timezone.excity.Asia/Anadyr", "অ্যানাডির" },
            { "timezone.excity.Asia/Aqtobe", "আকটোবে" },
            { "timezone.excity.Asia/Atyrau", "অতিরাউ" },
            { "timezone.excity.Asia/Beirut", "বেইরুট" },
            { "timezone.excity.Asia/Brunei", "ব্রুনেই" },
            { "timezone.excity.Asia/Hebron", "হেব্রোন" },
            { "timezone.excity.Asia/Kuwait", "কুয়েত" },
            { "timezone.excity.Asia/Manila", "ম্যানিলা" },
            { "timezone.excity.Asia/Muscat", "মাসকট" },
            { "timezone.excity.Asia/Riyadh", "রিয়াধ" },
            { "timezone.excity.Asia/Saigon", "হো চি মিন শহর" },
            { "timezone.excity.Asia/Taipei", "তাইপেই" },
            { "timezone.excity.Asia/Tehran", "তেহেরান" },
            { "timezone.excity.Asia/Urumqi", "উরুমকি" },
            { "timezone.excity.Etc/Unknown", "অজানা শহর" },
            { "timezone.excity.Europe/Kiev", "কিয়েভ" },
            { "timezone.excity.Europe/Oslo", "অসলো" },
            { "timezone.excity.Europe/Riga", "রিগা" },
            { "timezone.excity.Europe/Rome", "রোম" },
            { "timezone.excity.Indian/Mahe", "মাহে" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "আক্রা" },
            { "timezone.excity.Africa/Cairo", "কায়রো" },
            { "timezone.excity.Africa/Ceuta", "সেউটা" },
            { "timezone.excity.Africa/Dakar", "ডাকার" },
            { "timezone.excity.Africa/Lagos", "লাগোস" },
            { "timezone.excity.Africa/Tunis", "টিউনিস" },
            { "timezone.excity.America/Adak", "আডক" },
            { "timezone.excity.America/Lima", "লিমা" },
            { "timezone.excity.America/Nome", "নোম" },
            { "timezone.excity.Asia/Baghdad", "বাগদাদ" },
            { "timezone.excity.Asia/Bahrain", "বাহারিন" },
            { "timezone.excity.Asia/Bangkok", "ব্যাংকক" },
            { "timezone.excity.Asia/Barnaul", "বার্নৌল" },
            { "timezone.excity.Asia/Bishkek", "বিশকেক" },
            { "timezone.excity.Asia/Colombo", "কলম্বো" },
            { "timezone.excity.Asia/Irkutsk", "ইরকুটস্ক" },
            { "timezone.excity.Asia/Jakarta", "জাকার্তা" },
            { "timezone.excity.Asia/Karachi", "করাচি" },
            { "timezone.excity.Asia/Kuching", "কুচিং" },
            { "timezone.excity.Asia/Magadan", "ম্যাগাডান" },
            { "timezone.excity.Asia/Nicosia", "নিকোসিয়া" },
            { "timezone.excity.Asia/Rangoon", "রেঙ্গুন" },
            { "timezone.excity.Asia/Tbilisi", "সিবিলিশি" },
            { "timezone.excity.Asia/Thimphu", "থিম্ফু" },
            { "timezone.excity.Asia/Yakutsk", "ইয়াকুটস্ক" },
            { "timezone.excity.Asia/Yerevan", "ইয়েরাভান" },
            { "timezone.excity.Europe/Kirov", "কিরোভ" },
            { "timezone.excity.Europe/Malta", "মাল্টা" },
            { "timezone.excity.Europe/Minsk", "মিন্সক" },
            { "timezone.excity.Europe/Paris", "প্যারিস" },
            { "timezone.excity.Europe/Sofia", "সোফিয়া" },
            { "timezone.excity.Europe/Vaduz", "ভাদুজ" },
            { "timezone.excity.Indian/Cocos", "কোকোস" },
            { "timezone.excity.Pacific/Apia", "আপিয়া" },
            { "timezone.excity.Pacific/Fiji", "ফিজি" },
            { "timezone.excity.Pacific/Guam", "গুয়াম" },
            { "timezone.excity.Pacific/Niue", "নিউয়ি" },
            { "timezone.excity.Pacific/Truk", "চুক" },
            { "timezone.excity.Pacific/Wake", "ওয়েক" },
            { "timezone.excity.Africa/Asmera", "অ্যাসমারাহু" },
            { "timezone.excity.Africa/Bamako", "বাম্যাকো" },
            { "timezone.excity.Africa/Bangui", "বাঙ্গুই" },
            { "timezone.excity.Africa/Banjul", "বাঞ্জুল" },
            { "timezone.excity.Africa/Bissau", "বিসোউ" },
            { "timezone.excity.Africa/Douala", "ডোয়ালা" },
            { "timezone.excity.Africa/Harare", "হারারে" },
            { "timezone.excity.Africa/Kigali", "কিগালি" },
            { "timezone.excity.Africa/Luanda", "লোয়ান্ডা" },
            { "timezone.excity.Africa/Lusaka", "লুসাকা" },
            { "timezone.excity.Africa/Malabo", "মালাবো" },
            { "timezone.excity.Africa/Maputo", "মাপুতো" },
            { "timezone.excity.Africa/Maseru", "মাহসুরু" },
            { "timezone.excity.Africa/Niamey", "নিয়ামে" },
            { "timezone.excity.America/Aruba", "এরুবা" },
            { "timezone.excity.America/Bahia", "বাহিয়া" },
            { "timezone.excity.America/Belem", "বেলেম" },
            { "timezone.excity.America/Boise", "বয়জি" },
            { "timezone.excity.America/Jujuy", "জুজুই" },
            { "timezone.excity.America/Sitka", "শিটকা" },
            { "timezone.excity.America/Thule", "থুলি" },
            { "timezone.excity.Asia/Ashgabat", "আশগাবাত" },
            { "timezone.excity.Asia/Calcutta", "কোলকাতা" },
            { "timezone.excity.Asia/Damascus", "দামাস্কাস" },
            { "timezone.excity.Asia/Dushanbe", "দুশানবে" },
            { "timezone.excity.Asia/Jayapura", "জয়াপুরা" },
            { "timezone.excity.Asia/Katmandu", "কাঠমান্ডু" },
            { "timezone.excity.Asia/Khandyga", "খানডিয়াগা" },
            { "timezone.excity.Asia/Makassar", "মাকাসসার" },
            { "timezone.excity.Asia/Qostanay", "কোস্টানয়" },
            { "timezone.excity.Asia/Sakhalin", "সাখালিন" },
            { "timezone.excity.Asia/Shanghai", "সাংহাই" },
            { "timezone.excity.Asia/Tashkent", "তাসখন্দ" },
            { "timezone.excity.Asia/Ust-Nera", "উস্ত- নেরা" },
            { "timezone.excity.Europe/Athens", "এথেন্স" },
            { "timezone.excity.Europe/Berlin", "বার্লিন" },
            { "timezone.excity.Europe/Dublin", "ডাবলিন" },
            { "timezone.excity.Europe/Jersey", "জার্সি" },
            { "timezone.excity.Europe/Lisbon", "লিসবন" },
            { "timezone.excity.Europe/London", "লন্ডন" },
            { "timezone.excity.Europe/Madrid", "মাদ্রিদ" },
            { "timezone.excity.Europe/Monaco", "মোনাকো" },
            { "timezone.excity.Europe/Moscow", "মস্কো" },
            { "timezone.excity.Europe/Prague", "প্রাগ" },
            { "timezone.excity.Europe/Samara", "সামারা" },
            { "timezone.excity.Europe/Skopje", "স্কপয়ে" },
            { "timezone.excity.Europe/Tirane", "তিরানা" },
            { "timezone.excity.Europe/Vienna", "ভিয়েনা" },
            { "timezone.excity.Europe/Warsaw", "ওয়ারশ" },
            { "timezone.excity.Europe/Zagreb", "জাগ্রেব" },
            { "timezone.excity.Europe/Zurich", "জুরিখ" },
            { "timezone.excity.Indian/Chagos", "ছাগোস" },
            { "timezone.excity.Indian/Comoro", "কোমোরো" },
            { "timezone.excity.Pacific/Efate", "ইফাতে" },
            { "timezone.excity.Pacific/Nauru", "নাউরু" },
            { "timezone.excity.Pacific/Palau", "পালাউ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "আবিদজান" },
            { "timezone.excity.Africa/Algiers", "আলজিয়ার্স" },
            { "timezone.excity.Africa/Conakry", "কনাক্রি" },
            { "timezone.excity.Africa/Kampala", "কামপালা" },
            { "timezone.excity.Africa/Mbabane", "অমবাবান" },
            { "timezone.excity.Africa/Nairobi", "নাইরোবি" },
            { "timezone.excity.Africa/Tripoli", "ত্রিপোলি" },
            { "timezone.excity.America/Belize", "বেলিজ" },
            { "timezone.excity.America/Bogota", "বোগোটা" },
            { "timezone.excity.America/Cancun", "ক্যানকুন" },
            { "timezone.excity.America/Cayman", "কামেন" },
            { "timezone.excity.America/Cuiaba", "কুইয়াবা" },
            { "timezone.excity.America/Dawson", "ডসোন" },
            { "timezone.excity.America/Denver", "ডেনভার" },
            { "timezone.excity.America/Guyana", "গায়ানা" },
            { "timezone.excity.America/Havana", "হাভানা" },
            { "timezone.excity.America/Inuvik", "ইনুভ্যাক" },
            { "timezone.excity.America/Juneau", "জুনো" },
            { "timezone.excity.America/La_Paz", "লা পাজ" },
            { "timezone.excity.America/Maceio", "মাসেয়ো" },
            { "timezone.excity.America/Manaus", "মানাউস" },
            { "timezone.excity.America/Merida", "মেরিডা" },
            { "timezone.excity.America/Nassau", "নাসাউ" },
            { "timezone.excity.America/Panama", "পানামা" },
            { "timezone.excity.America/Recife", "রেসিফে" },
            { "timezone.excity.America/Regina", "রেজিনা" },
            { "timezone.excity.Asia/Famagusta", "ফামাগাস্তা" },
            { "timezone.excity.Asia/Hong_Kong", "হং কং" },
            { "timezone.excity.Asia/Jerusalem", "জেরুজালেম" },
            { "timezone.excity.Asia/Kamchatka", "কামচাটকা" },
            { "timezone.excity.Asia/Pontianak", "পন্টিয়ান্যাক" },
            { "timezone.excity.Asia/Pyongyang", "পিয়ংইয়ং" },
            { "timezone.excity.Asia/Qyzylorda", "কিজিলর্ডা" },
            { "timezone.excity.Asia/Samarkand", "সমরখন্দ" },
            { "timezone.excity.Asia/Singapore", "সিঙ্গাপুর" },
            { "timezone.excity.Asia/Vientiane", "ভিয়েনতায়েন" },
            { "timezone.excity.Europe/Andorra", "অ্যান্ডোরা" },
            { "timezone.excity.Europe/Saratov", "সারাটোভ" },
            { "timezone.excity.Europe/Tallinn", "তাহলিন" },
            { "timezone.excity.Europe/Vatican", "ভাটিকান" },
            { "timezone.excity.Europe/Vilnius", "ভিলনিওস" },
            { "timezone.excity.Indian/Mayotte", "মায়োতো" },
            { "timezone.excity.Indian/Reunion", "রিইউনিয়ন" },
            { "timezone.excity.Pacific/Easter", "ইস্টার" },
            { "timezone.excity.Pacific/Kosrae", "কোসরায়" },
            { "timezone.excity.Pacific/Majuro", "মাজুরো" },
            { "timezone.excity.Pacific/Midway", "মিডওয়ে" },
            { "timezone.excity.Pacific/Noumea", "নুমিয়া" },
            { "timezone.excity.Pacific/Ponape", "পোনাপে" },
            { "timezone.excity.Pacific/Saipan", "সাইপান" },
            { "timezone.excity.Pacific/Tahiti", "তাহিতি" },
            { "timezone.excity.Pacific/Tarawa", "টারাওয়া" },
            { "timezone.excity.Pacific/Wallis", "ওলিস" },
            { "timezone.excity.Africa/Blantyre", "ব্ল্যানটায়ের" },
            { "timezone.excity.Africa/Djibouti", "জিবুটি" },
            { "timezone.excity.Africa/El_Aaiun", "এল আহইউন" },
            { "timezone.excity.Africa/Freetown", "ফ্রীটাউন" },
            { "timezone.excity.Africa/Gaborone", "গ্যাবুরনি" },
            { "timezone.excity.Africa/Khartoum", "খার্তুম" },
            { "timezone.excity.Africa/Kinshasa", "কিনশাসা" },
            { "timezone.excity.Africa/Monrovia", "মনরোভিয়া" },
            { "timezone.excity.Africa/Ndjamena", "এনজমেনা" },
            { "timezone.excity.Africa/Sao_Tome", "সাও টোম" },
            { "timezone.excity.Africa/Windhoek", "উইনধোক" },
            { "timezone.excity.America/Antigua", "অ্যান্টিগুয়া" },
            { "timezone.excity.America/Caracas", "ক্যারাকাস" },
            { "timezone.excity.America/Cayenne", "কাহেন" },
            { "timezone.excity.America/Chicago", "শিকাগো" },
            { "timezone.excity.America/Cordoba", "কর্ডোবা" },
            { "timezone.excity.America/Creston", "ক্রিস্টান" },
            { "timezone.excity.America/Curacao", "কুরাসাও" },
            { "timezone.excity.America/Detroit", "ডেট্রোইট" },
            { "timezone.excity.America/Godthab", "নুক" },
            { "timezone.excity.America/Grenada", "গ্রেনাডা" },
            { "timezone.excity.America/Halifax", "হ্যালিফ্যাক্স" },
            { "timezone.excity.America/Iqaluit", "ইকুয়ালুইট" },
            { "timezone.excity.America/Jamaica", "জামাইকা" },
            { "timezone.excity.America/Managua", "মানাগুয়া" },
            { "timezone.excity.America/Marigot", "মারিগো" },
            { "timezone.excity.America/Mendoza", "মেন্ডোজা" },
            { "timezone.excity.America/Moncton", "মঙ্কটোন" },
            { "timezone.excity.America/Noronha", "নরোন্‌হা" },
            { "timezone.excity.America/Ojinaga", "ওজিনাগা" },
            { "timezone.excity.America/Phoenix", "ফিনিক্স" },
            { "timezone.excity.America/Tijuana", "তিজুয়ানা" },
            { "timezone.excity.America/Toronto", "টোরন্টো" },
            { "timezone.excity.America/Tortola", "টরটোলা" },
            { "timezone.excity.America/Yakutat", "ইয়াকুটাট" },
            { "timezone.excity.Asia/Phnom_Penh", "নম পেন" },
            { "timezone.excity.Atlantic/Azores", "আজোরেস" },
            { "timezone.excity.Atlantic/Canary", "কানেরি" },
            { "timezone.excity.Atlantic/Faeroe", "ফ্যারো" },
            { "timezone.excity.Australia/Eucla", "ইউক্লা" },
            { "timezone.excity.Australia/Perth", "পার্থ" },
            { "timezone.excity.Europe/Belgrade", "বেলগ্রেড" },
            { "timezone.excity.Europe/Brussels", "ব্রাসেলস" },
            { "timezone.excity.Europe/Budapest", "বুডাপেস্ট" },
            { "timezone.excity.Europe/Busingen", "বুসিনগেন" },
            { "timezone.excity.Europe/Chisinau", "কিসিনাহু" },
            { "timezone.excity.Europe/Guernsey", "গুয়ার্নসি" },
            { "timezone.excity.Europe/Helsinki", "হেলসিঙ্কি" },
            { "timezone.excity.Europe/Istanbul", "ইস্তানবুল" },
            { "timezone.excity.Europe/Sarajevo", "সারাজিভো" },
            { "timezone.excity.Indian/Maldives", "মালদ্বীপ" },
            { "timezone.excity.Pacific/Chatham", "চ্যাঠাম" },
            { "timezone.excity.Pacific/Fakaofo", "ফ্যাকাওফো" },
            { "timezone.excity.Pacific/Gambier", "গাম্বিয়ের" },
            { "timezone.excity.Pacific/Norfolk", "নরফক" },
            { "timezone.excity.Africa/Bujumbura", "বুজুমবুরহু" },
            { "timezone.excity.Africa/Mogadishu", "মাওগাদিসু" },
            { "timezone.excity.America/Anguilla", "অ্যাঙ্গুইলা" },
            { "timezone.excity.America/Asuncion", "আসুনসিয়ন" },
            { "timezone.excity.America/Barbados", "বার্বাডোজ" },
            { "timezone.excity.America/Dominica", "ডোমিনিকা" },
            { "timezone.excity.America/Edmonton", "এডমন্টোন" },
            { "timezone.excity.America/Eirunepe", "আইরুনেপে" },
            { "timezone.excity.America/Mazatlan", "মাজাটলান" },
            { "timezone.excity.America/Miquelon", "মিকুলন" },
            { "timezone.excity.America/New_York", "নিউইয়র্ক" },
            { "timezone.excity.America/Resolute", "রেসোলুট" },
            { "timezone.excity.America/Santarem", "সেনটুরেম" },
            { "timezone.excity.America/Santiago", "সান্টিয়াগো" },
            { "timezone.excity.America/St_Johns", "সেন্ট জন্স" },
            { "timezone.excity.America/St_Kitts", "সেন্ট. কিটস" },
            { "timezone.excity.America/St_Lucia", "সেন্ট. লুসিয়া" },
            { "timezone.excity.America/Winnipeg", "উইনিপেগ" },
            { "timezone.excity.Antarctica/Casey", "কেইসি" },
            { "timezone.excity.Antarctica/Davis", "ডেভিস" },
            { "timezone.excity.Antarctica/Syowa", "সিওয়া" },
            { "timezone.excity.Antarctica/Troll", "ট্রল" },
            { "timezone.excity.Asia/Krasnoyarsk", "ক্রাসনোইয়ার্স্ক" },
            { "timezone.excity.Asia/Novosibirsk", "নভোসিবির্স্ক" },
            { "timezone.excity.Asia/Ulaanbaatar", "উলানবাতার" },
            { "timezone.excity.Asia/Vladivostok", "ভ্লাদিভস্তোক" },
            { "timezone.excity.Atlantic/Bermuda", "বারমুডা" },
            { "timezone.excity.Atlantic/Madeira", "মাডেইরা" },
            { "timezone.excity.Atlantic/Stanley", "স্টানলী" },
            { "timezone.excity.Australia/Darwin", "ডারউইন" },
            { "timezone.excity.Australia/Hobart", "হোবার্ট" },
            { "timezone.excity.Australia/Sydney", "সিডনি" },
            { "timezone.excity.Europe/Amsterdam", "আমস্টারডাম" },
            { "timezone.excity.Europe/Astrakhan", "আসট্রাখান" },
            { "timezone.excity.Europe/Bucharest", "বুখারেস্ট" },
            { "timezone.excity.Europe/Gibraltar", "জিব্রাল্টার" },
            { "timezone.excity.Europe/Ljubljana", "লুবলিয়ানা" },
            { "timezone.excity.Europe/Mariehamn", "মরিয়েহামেন" },
            { "timezone.excity.Europe/Podgorica", "পডগরিত্সা" },
            { "timezone.excity.Europe/Stockholm", "স্টকহোম" },
            { "timezone.excity.Europe/Ulyanovsk", "উলিয়ানোভস্ক" },
            { "timezone.excity.Europe/Volgograd", "ভোল্গোগ্রাদ" },
            { "timezone.excity.Indian/Christmas", "ক্রিসমাস" },
            { "timezone.excity.Indian/Kerguelen", "কার্গুলেন" },
            { "timezone.excity.Indian/Mauritius", "মরিশাস" },
            { "timezone.excity.Pacific/Auckland", "অকল্যান্ড" },
            { "timezone.excity.Pacific/Funafuti", "ফুনাফুটি" },
            { "timezone.excity.Pacific/Honolulu", "হনোলুলু" },
            { "timezone.excity.Pacific/Pitcairn", "পিটকেয়ার্ন" },
            { "timezone.excity.Africa/Casablanca", "কাসাব্লাঙ্কা" },
            { "timezone.excity.Africa/Libreville", "লিব্রুভিল" },
            { "timezone.excity.Africa/Lubumbashi", "লুবুম্বাশি" },
            { "timezone.excity.Africa/Nouakchott", "নোয়াকশট" },
            { "timezone.excity.Africa/Porto-Novo", "পোর্টো-নোভো" },
            { "timezone.excity.America/Anchorage", "এনকোরেজ" },
            { "timezone.excity.America/Araguaina", "আরাগুয়াইনা" },
            { "timezone.excity.America/Boa_Vista", "বোয়া ভিস্তা" },
            { "timezone.excity.America/Catamarca", "ক্যাটামার্কা" },
            { "timezone.excity.America/Chihuahua", "চিহুয়াহুয়া" },
            { "timezone.excity.America/Coyhaique", "কোয়আইকে" },
            { "timezone.excity.America/Fortaleza", "ফোর্টালেজা" },
            { "timezone.excity.America/Glace_Bay", "গ্লাস বে" },
            { "timezone.excity.America/Goose_Bay", "গুস বে" },
            { "timezone.excity.America/Guatemala", "গুয়াতেমালা" },
            { "timezone.excity.America/Guayaquil", "গোয়াইয়াকিল" },
            { "timezone.excity.America/Matamoros", "মাতামোরস" },
            { "timezone.excity.America/Menominee", "মেনোমিনি" },
            { "timezone.excity.America/Monterrey", "মন্টেরি" },
            { "timezone.excity.America/Sao_Paulo", "সাও পাউলো" },
            { "timezone.excity.America/St_Thomas", "সেন্ট. থমাস" },
            { "timezone.excity.America/Vancouver", "ভ্যাঙ্কুভার" },
            { "timezone.excity.Antarctica/Mawson", "মসোন" },
            { "timezone.excity.Antarctica/Palmer", "পালমার" },
            { "timezone.excity.Antarctica/Vostok", "ভস্টোক" },
            { "timezone.excity.Asia/Kuala_Lumpur", "কুয়ালালামপুর" },
            { "timezone.excity.Asia/Novokuznetsk", "নভকুয়েতস্নক" },
            { "timezone.excity.Europe/Bratislava", "ব্রাতিস্লাভা" },
            { "timezone.excity.Europe/Copenhagen", "কোপেনহেগেন" },
            { "timezone.excity.Europe/Luxembourg", "লুক্সেমবার্গ" },
            { "timezone.excity.Europe/San_Marino", "সান মেরিনো" },
            { "timezone.excity.Europe/Simferopol", "সিমফেরোপোল" },
            { "timezone.excity.Pacific/Enderbury", "ক্যান্টন" },
            { "timezone.excity.Pacific/Galapagos", "গ্যালাপ্যাগোস" },
            { "timezone.excity.Pacific/Kwajalein", "কোয়াজালেইন" },
            { "timezone.excity.Pacific/Marquesas", "মার্কেসাস" },
            { "timezone.excity.Pacific/Pago_Pago", "প্যাগো প্যাগো" },
            { "timezone.excity.Pacific/Rarotonga", "রারউহতুঙ্গা" },
            { "timezone.excity.Pacific/Tongatapu", "টোঙ্গাটাপু" },
            { "timezone.excity.Africa/Addis_Ababa", "আদ্দিস আবাবা" },
            { "timezone.excity.Africa/Brazzaville", "ব্রাজাভিলি" },
            { "timezone.excity.Africa/Ouagadougou", "ওয়াহগুডোগু" },
            { "timezone.excity.America/Costa_Rica", "কোস্টারিকা" },
            { "timezone.excity.America/Grand_Turk", "গ্র্যান্ড তুর্ক" },
            { "timezone.excity.America/Guadeloupe", "গুয়াদেলোপ" },
            { "timezone.excity.America/Hermosillo", "হারমোসিল্লো" },
            { "timezone.excity.America/Kralendijk", "ক্রেলেন্ডাজিক" },
            { "timezone.excity.America/Louisville", "লুইসভিল" },
            { "timezone.excity.America/Martinique", "মারটিনিক" },
            { "timezone.excity.America/Metlakatla", "মেটলাকাটলা" },
            { "timezone.excity.America/Montevideo", "মন্টেভিডিও" },
            { "timezone.excity.America/Montserrat", "মন্তসেরাত" },
            { "timezone.excity.America/Paramaribo", "প্যারামেরিবো" },
            { "timezone.excity.America/Rio_Branco", "রিও ব্রাঙ্কো" },
            { "timezone.excity.America/St_Vincent", "সেন্ট. ভিনসেন্ট" },
            { "timezone.excity.America/Whitehorse", "হোয়াইটহর্স" },
            { "timezone.excity.Antarctica/McMurdo", "ম্যাকমুর্ডো" },
            { "timezone.excity.Antarctica/Rothera", "রথেরা" },
            { "timezone.excity.Asia/Srednekolymsk", "স্রেদনেকোলয়মস্ক" },
            { "timezone.excity.Asia/Yekaterinburg", "ইয়েকাটেরিনবার্গ" },
            { "timezone.excity.Atlantic/Reykjavik", "রিকজাভিক" },
            { "timezone.excity.Atlantic/St_Helena", "সেন্ট. হেলেনা" },
            { "timezone.excity.Australia/Adelaide", "এ্যাডেলেইড" },
            { "timezone.excity.Australia/Brisbane", "ব্রিসবেন" },
            { "timezone.excity.Australia/Lindeman", "লিনডেম্যান" },
            { "timezone.excity.Europe/Isle_of_Man", "আইল অফ ম্যান" },
            { "timezone.excity.Europe/Kaliningrad", "কালিনিঙগ্রাড" },
            { "timezone.excity.Pacific/Kiritimati", "কিরিতিমাতি" },
            { "timezone.excity.Africa/Johannesburg", "জোহানেসবার্গ" },
            { "timezone.excity.America/El_Salvador", "এল সালভাদোর" },
            { "timezone.excity.America/Fort_Nelson", "ফোর্ট নেলসন" },
            { "timezone.excity.America/Los_Angeles", "লস অ্যাঞ্জেলেস" },
            { "timezone.excity.America/Mexico_City", "মেক্সিকো সিটি" },
            { "timezone.excity.America/Porto_Velho", "পোর্তো ভেল্‌হো" },
            { "timezone.excity.America/Puerto_Rico", "পুয়ের্তো রিকো" },
            { "timezone.excity.America/Tegucigalpa", "তেগুসিগালপা" },
            { "timezone.excity.Arctic/Longyearbyen", "লঞ্জিয়বিয়েঁন" },
            { "timezone.excity.Atlantic/Cape_Verde", "কেপ ভার্দ" },
            { "timezone.excity.Australia/Lord_Howe", "লর্ড হাও" },
            { "timezone.excity.Australia/Melbourne", "মেলবোর্ন" },
            { "timezone.excity.Indian/Antananarivo", "আন্তুনানারিভো" },
            { "timezone.excity.Pacific/Guadalcanal", "গোয়াদালকুনাল" },
            { "timezone.excity.Africa/Dar_es_Salaam", "দার এস সালাম" },
            { "timezone.excity.America/Blanc-Sablon", "ব্লাঙ্ক-সাব্লোন" },
            { "timezone.excity.America/Buenos_Aires", "বুয়েনোস আয়েরেস" },
            { "timezone.excity.America/Campo_Grande", "কাম্পো গ্রান্ডে" },
            { "timezone.excity.America/Danmarkshavn", "ডানমার্কশ্যাভন" },
            { "timezone.excity.America/Dawson_Creek", "ডসোন ক্রিক" },
            { "timezone.excity.America/Indiana/Knox", "নক্স, ইন্ডিয়ানা" },
            { "timezone.excity.America/Indianapolis", "ইন্ডিয়ানাপোলিস" },
            { "timezone.excity.America/Punta_Arenas", "পুন্টা আরেনাস" },
            { "timezone.excity.America/Rankin_Inlet", "র‍্যাঙ্কিন ইনলেট" },
            { "timezone.excity.America/Scoresbysund", "ইট্টকুয়োরটুরমিট" },
            { "timezone.excity.Antarctica/Macquarie", "ম্যাককুয়্যারি" },
            { "timezone.excity.Pacific/Bougainville", "বুগেনভিলে" },
            { "timezone.excity.Pacific/Port_Moresby", "পোর্ট মৌরজবি" },
            { "timezone.excity.America/Cambridge_Bay", "কেমব্রিজ বে" },
            { "timezone.excity.America/Ciudad_Juarez", "সিউদাদ জুয়ারেজ" },
            { "timezone.excity.America/Coral_Harbour", "আটিকোকান" },
            { "timezone.excity.America/Indiana/Vevay", "ভেভেয়, ইন্ডিয়ানা" },
            { "timezone.excity.America/Lower_Princes", "লোয়ার প্রিন্সেস কোয়ার্টার" },
            { "timezone.excity.America/Port_of_Spain", "পোর্ট অফ স্পেন" },
            { "timezone.excity.America/Santo_Domingo", "স্যান্টো ডোমিংগো" },
            { "timezone.excity.America/St_Barthelemy", "সেন্ট.বার্থেলেমি" },
            { "timezone.excity.America/Swift_Current", "সুইফ্ট কারেন্ট" },
            { "timezone.excity.Australia/Broken_Hill", "ব্রোকেন হিল" },
            { "timezone.excity.America/Bahia_Banderas", "বাহিয়া বান্দেরাস" },
            { "timezone.excity.America/Port-au-Prince", "পোর্ট-অহ-প্রিন্স" },
            { "timezone.excity.Atlantic/South_Georgia", "দক্ষিণ জর্জিয়া" },
            { "timezone.excity.America/Argentina/Salta", "স্যালটা" },
            { "timezone.excity.America/Indiana/Marengo", "মারেঙ্গো, ইন্ডিয়ানা" },
            { "timezone.excity.America/Indiana/Winamac", "উইনাম্যাক, ইন্ডিয়ানা" },
            { "timezone.excity.America/Argentina/Tucuman", "টুকুমান" },
            { "timezone.excity.America/Argentina/Ushuaia", "উশুয়াইয়া" },
            { "timezone.excity.America/Indiana/Tell_City", "টেলসিটি, ইন্ডিয়ানা" },
            { "timezone.excity.America/Indiana/Vincennes", "ভিনসেন্নেস, ইন্ডিয়ানা" },
            { "timezone.excity.Antarctica/DumontDUrville", "ডুমন্ট ডি’উরভিল" },
            { "timezone.excity.America/Argentina/La_Rioja", "লা রিওহা" },
            { "timezone.excity.America/Argentina/San_Juan", "সান জুয়ান" },
            { "timezone.excity.America/Argentina/San_Luis", "সান লুইস" },
            { "timezone.excity.America/Indiana/Petersburg", "পিটারর্সবার্গ, ইন্ডিয়ানা" },
            { "timezone.excity.America/Kentucky/Monticello", "মন্টিচেলো, কেন্টাকি" },
            { "timezone.excity.America/North_Dakota/Beulah", "বেউলা, উত্তর ডাকোটা" },
            { "timezone.excity.America/North_Dakota/Center", "মধ্য, উত্তর ডাকোটা" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "রিও গায়েগোস" },
            { "timezone.excity.America/North_Dakota/New_Salem", "নিউ সালেম, উত্তর ডাকোটা" },
        };
        return data;
    }
}
