/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.Exported;
import sun.security.util.SecurityConstants;

@Exported
public class AWTEventMonitor {
    private static boolean runningOnJDK1_4 = false;
    @Deprecated
    protected static Component componentWithFocus = null;
    private static Component componentWithFocus_private = null;
    @Deprecated
    protected static ComponentListener componentListener = null;
    private static ComponentListener componentListener_private = null;
    @Deprecated
    protected static ContainerListener containerListener = null;
    private static ContainerListener containerListener_private = null;
    @Deprecated
    protected static FocusListener focusListener = null;
    private static FocusListener focusListener_private = null;
    @Deprecated
    protected static KeyListener keyListener = null;
    private static KeyListener keyListener_private = null;
    @Deprecated
    protected static MouseListener mouseListener = null;
    private static MouseListener mouseListener_private = null;
    @Deprecated
    protected static MouseMotionListener mouseMotionListener = null;
    private static MouseMotionListener mouseMotionListener_private = null;
    @Deprecated
    protected static WindowListener windowListener = null;
    private static WindowListener windowListener_private = null;
    @Deprecated
    protected static ActionListener actionListener = null;
    private static ActionListener actionListener_private = null;
    @Deprecated
    protected static AdjustmentListener adjustmentListener = null;
    private static AdjustmentListener adjustmentListener_private = null;
    @Deprecated
    protected static ItemListener itemListener = null;
    private static ItemListener itemListener_private = null;
    @Deprecated
    protected static TextListener textListener = null;
    private static TextListener textListener_private = null;
    @Deprecated
    protected static AWTEventsListener awtListener = new AWTEventsListener();
    private static final AWTEventsListener awtListener_private = new AWTEventsListener();

    public static Component getComponentWithFocus() {
        return componentWithFocus_private;
    }

    private static void checkInstallPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.ALL_AWT_EVENTS_PERMISSION);
        }
    }

    public static void addComponentListener(ComponentListener componentListener) {
        if (componentListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(2);
        }
        componentListener_private = AWTEventMulticaster.add(componentListener_private, componentListener);
    }

    public static void removeComponentListener(ComponentListener componentListener) {
        if ((componentListener_private = AWTEventMulticaster.remove(componentListener_private, componentListener)) == null) {
            awtListener_private.removeListeners(2);
        }
    }

    public static void addContainerListener(ContainerListener containerListener) {
        containerListener_private = AWTEventMulticaster.add(containerListener_private, containerListener);
    }

    public static void removeContainerListener(ContainerListener containerListener) {
        containerListener_private = AWTEventMulticaster.remove(containerListener_private, containerListener);
    }

    public static void addFocusListener(FocusListener focusListener) {
        focusListener_private = AWTEventMulticaster.add(focusListener_private, focusListener);
    }

    public static void removeFocusListener(FocusListener focusListener) {
        focusListener_private = AWTEventMulticaster.remove(focusListener_private, focusListener);
    }

    public static void addKeyListener(KeyListener keyListener) {
        if (keyListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(6);
        }
        keyListener_private = AWTEventMulticaster.add(keyListener_private, keyListener);
    }

    public static void removeKeyListener(KeyListener keyListener) {
        if ((keyListener_private = AWTEventMulticaster.remove(keyListener_private, keyListener)) == null) {
            awtListener_private.removeListeners(6);
        }
    }

    public static void addMouseListener(MouseListener mouseListener) {
        if (mouseListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(7);
        }
        mouseListener_private = AWTEventMulticaster.add(mouseListener_private, mouseListener);
    }

    public static void removeMouseListener(MouseListener mouseListener) {
        if ((mouseListener_private = AWTEventMulticaster.remove(mouseListener_private, mouseListener)) == null) {
            awtListener_private.removeListeners(7);
        }
    }

    public static void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(8);
        }
        mouseMotionListener_private = AWTEventMulticaster.add(mouseMotionListener_private, mouseMotionListener);
    }

    public static void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if ((mouseMotionListener_private = AWTEventMulticaster.remove(mouseMotionListener_private, mouseMotionListener)) == null) {
            awtListener_private.removeListeners(8);
        }
    }

    public static void addWindowListener(WindowListener windowListener) {
        if (windowListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(11);
        }
        windowListener_private = AWTEventMulticaster.add(windowListener_private, windowListener);
    }

    public static void removeWindowListener(WindowListener windowListener) {
        if ((windowListener_private = AWTEventMulticaster.remove(windowListener_private, windowListener)) == null) {
            awtListener_private.removeListeners(11);
        }
    }

    public static void addActionListener(ActionListener actionListener) {
        if (actionListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(0);
        }
        actionListener_private = AWTEventMulticaster.add(actionListener_private, actionListener);
    }

    public static void removeActionListener(ActionListener actionListener) {
        if ((actionListener_private = AWTEventMulticaster.remove(actionListener_private, actionListener)) == null) {
            awtListener_private.removeListeners(0);
        }
    }

    public static void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(1);
        }
        adjustmentListener_private = AWTEventMulticaster.add(adjustmentListener_private, adjustmentListener);
    }

    public static void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if ((adjustmentListener_private = AWTEventMulticaster.remove(adjustmentListener_private, adjustmentListener)) == null) {
            awtListener_private.removeListeners(1);
        }
    }

    public static void addItemListener(ItemListener itemListener) {
        if (itemListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(5);
        }
        itemListener_private = AWTEventMulticaster.add(itemListener_private, itemListener);
    }

    public static void removeItemListener(ItemListener itemListener) {
        if ((itemListener_private = AWTEventMulticaster.remove(itemListener_private, itemListener)) == null) {
            awtListener_private.removeListeners(5);
        }
    }

    public static void addTextListener(TextListener textListener) {
        if (textListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(10);
        }
        textListener_private = AWTEventMulticaster.add(textListener_private, textListener);
    }

    public static void removeTextListener(TextListener textListener) {
        if ((textListener_private = AWTEventMulticaster.remove(textListener_private, textListener)) == null) {
            awtListener_private.removeListeners(10);
        }
    }

    static class AWTEventsListener
    implements TopLevelWindowListener,
    ActionListener,
    AdjustmentListener,
    ComponentListener,
    ContainerListener,
    FocusListener,
    ItemListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    TextListener,
    WindowListener,
    ChangeListener {
        private Class[] actionListeners;
        private Method removeActionMethod;
        private Method addActionMethod;
        private Object[] actionArgs;
        private Class[] itemListeners;
        private Method removeItemMethod;
        private Method addItemMethod;
        private Object[] itemArgs;
        private Class[] textListeners;
        private Method removeTextMethod;
        private Method addTextMethod;
        private Object[] textArgs;
        private Class[] windowListeners;
        private Method removeWindowMethod;
        private Method addWindowMethod;
        private Object[] windowArgs;

        public AWTEventsListener() {
            String string = System.getProperty("java.version");
            if (string != null) {
                runningOnJDK1_4 = string.compareTo("1.4") >= 0;
            }
            this.initializeIntrospection();
            this.installListeners();
            if (runningOnJDK1_4) {
                MenuSelectionManager.defaultManager().addChangeListener(this);
            }
            EventQueueMonitor.addTopLevelWindowListener(this);
        }

        private boolean initializeIntrospection() {
            try {
                this.actionListeners = new Class[1];
                this.actionArgs = new Object[1];
                this.actionListeners[0] = Class.forName("java.awt.event.ActionListener");
                this.actionArgs[0] = this;
                this.itemListeners = new Class[1];
                this.itemArgs = new Object[1];
                this.itemListeners[0] = Class.forName("java.awt.event.ItemListener");
                this.itemArgs[0] = this;
                this.textListeners = new Class[1];
                this.textArgs = new Object[1];
                this.textListeners[0] = Class.forName("java.awt.event.TextListener");
                this.textArgs[0] = this;
                this.windowListeners = new Class[1];
                this.windowArgs = new Object[1];
                this.windowListeners[0] = Class.forName("java.awt.event.WindowListener");
                this.windowArgs[0] = this;
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("EXCEPTION - Class 'java.awt.event.*' not in CLASSPATH");
                return false;
            }
        }

        protected void installListeners() {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    this.installListeners(windowArray[i]);
                }
            }
        }

        protected void installListeners(int n) {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    this.installListeners(windowArray[i], n);
                }
            }
        }

        protected void installListeners(Component component) {
            this.installListeners(component, 3);
            this.installListeners(component, 4);
            if (componentListener_private != null) {
                this.installListeners(component, 2);
            }
            if (keyListener_private != null) {
                this.installListeners(component, 6);
            }
            if (mouseListener_private != null) {
                this.installListeners(component, 7);
            }
            if (mouseMotionListener_private != null) {
                this.installListeners(component, 8);
            }
            if (windowListener_private != null) {
                this.installListeners(component, 11);
            }
            if (actionListener_private != null) {
                this.installListeners(component, 0);
            }
            if (adjustmentListener_private != null) {
                this.installListeners(component, 1);
            }
            if (itemListener_private != null) {
                this.installListeners(component, 5);
            }
            if (textListener_private != null) {
                this.installListeners(component, 10);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.processFocusGained();
        }

        private void processFocusGained() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null) {
                return;
            }
            MenuSelectionManager.defaultManager().removeChangeListener(this);
            MenuSelectionManager.defaultManager().addChangeListener(this);
            if (component instanceof JRootPane) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 1) {
                    Component component2 = menuElementArray[menuElementArray.length - 2].getComponent();
                    Component component3 = menuElementArray[menuElementArray.length - 1].getComponent();
                    if (component3 instanceof JPopupMenu || component3 instanceof JMenu) {
                        componentWithFocus_private = component3;
                    } else if (component2 instanceof JPopupMenu) {
                        componentWithFocus_private = component2;
                    }
                }
            } else {
                componentWithFocus_private = component;
            }
        }

        protected void installListeners(Component component, int n) {
            switch (n) {
                case 0: {
                    try {
                        this.removeActionMethod = component.getClass().getMethod("removeActionListener", this.actionListeners);
                        this.addActionMethod = component.getClass().getMethod("addActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)component, this.actionArgs);
                            this.addActionMethod.invoke((Object)component, this.actionArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(component instanceof Adjustable)) break;
                    ((Adjustable)((Object)component)).removeAdjustmentListener(this);
                    ((Adjustable)((Object)component)).addAdjustmentListener(this);
                    break;
                }
                case 2: {
                    component.removeComponentListener(this);
                    component.addComponentListener(this);
                    break;
                }
                case 3: {
                    if (!(component instanceof Container)) break;
                    ((Container)component).removeContainerListener(this);
                    ((Container)component).addContainerListener(this);
                    break;
                }
                case 4: {
                    component.removeFocusListener(this);
                    component.addFocusListener(this);
                    if (runningOnJDK1_4) {
                        this.processFocusGained();
                        break;
                    }
                    if (component == componentWithFocus_private || !component.hasFocus()) break;
                    componentWithFocus_private = component;
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = component.getClass().getMethod("removeItemListener", this.itemListeners);
                        this.addItemMethod = component.getClass().getMethod("addItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)component, this.itemArgs);
                            this.addItemMethod.invoke((Object)component, this.itemArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 6: {
                    component.removeKeyListener(this);
                    component.addKeyListener(this);
                    break;
                }
                case 7: {
                    component.removeMouseListener(this);
                    component.addMouseListener(this);
                    break;
                }
                case 8: {
                    component.removeMouseMotionListener(this);
                    component.addMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = component.getClass().getMethod("removeTextListener", this.textListeners);
                        this.addTextMethod = component.getClass().getMethod("addTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)component, this.textArgs);
                            this.addTextMethod.invoke((Object)component, this.textArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = component.getClass().getMethod("removeWindowListener", this.windowListeners);
                        this.addWindowMethod = component.getClass().getMethod("addWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)component, this.windowArgs);
                            this.addWindowMethod.invoke((Object)component, this.windowArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (component instanceof Container) {
                int n2 = ((Container)component).getComponentCount();
                for (int i = 0; i < n2; ++i) {
                    this.installListeners(((Container)component).getComponent(i), n);
                }
            }
        }

        protected void removeListeners(int n) {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    this.removeListeners(windowArray[i], n);
                }
            }
        }

        protected void removeListeners(Component component) {
            if (componentListener_private != null) {
                this.removeListeners(component, 2);
            }
            if (keyListener_private != null) {
                this.removeListeners(component, 6);
            }
            if (mouseListener_private != null) {
                this.removeListeners(component, 7);
            }
            if (mouseMotionListener_private != null) {
                this.removeListeners(component, 8);
            }
            if (windowListener_private != null) {
                this.removeListeners(component, 11);
            }
            if (actionListener_private != null) {
                this.removeListeners(component, 0);
            }
            if (adjustmentListener_private != null) {
                this.removeListeners(component, 1);
            }
            if (itemListener_private != null) {
                this.removeListeners(component, 5);
            }
            if (textListener_private != null) {
                this.removeListeners(component, 10);
            }
        }

        protected void removeListeners(Component component, int n) {
            switch (n) {
                case 0: {
                    try {
                        this.removeActionMethod = component.getClass().getMethod("removeActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)component, this.actionArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(component instanceof Adjustable)) break;
                    ((Adjustable)((Object)component)).removeAdjustmentListener(this);
                    break;
                }
                case 2: {
                    component.removeComponentListener(this);
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = component.getClass().getMethod("removeItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)component, this.itemArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 6: {
                    component.removeKeyListener(this);
                    break;
                }
                case 7: {
                    component.removeMouseListener(this);
                    break;
                }
                case 8: {
                    component.removeMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = component.getClass().getMethod("removeTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)component, this.textArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = component.getClass().getMethod("removeWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)component, this.windowArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (component instanceof Container) {
                int n2 = ((Container)component).getComponentCount();
                for (int i = 0; i < n2; ++i) {
                    this.removeListeners(((Container)component).getComponent(i), n);
                }
            }
        }

        @Override
        public void topLevelWindowCreated(Window window) {
            this.installListeners(window);
        }

        @Override
        public void topLevelWindowDestroyed(Window window) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionListener_private != null) {
                actionListener_private.actionPerformed(actionEvent);
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (adjustmentListener_private != null) {
                adjustmentListener_private.adjustmentValueChanged(adjustmentEvent);
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            if (componentListener_private != null) {
                componentListener_private.componentHidden(componentEvent);
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (componentListener_private != null) {
                componentListener_private.componentMoved(componentEvent);
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (componentListener_private != null) {
                componentListener_private.componentResized(componentEvent);
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (componentListener_private != null) {
                componentListener_private.componentShown(componentEvent);
            }
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            this.installListeners(containerEvent.getChild());
            if (containerListener_private != null) {
                containerListener_private.componentAdded(containerEvent);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            this.removeListeners(containerEvent.getChild());
            if (containerListener_private != null) {
                containerListener_private.componentRemoved(containerEvent);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            componentWithFocus_private = (Component)focusEvent.getSource();
            if (focusListener_private != null) {
                focusListener_private.focusGained(focusEvent);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            componentWithFocus_private = null;
            if (focusListener_private != null) {
                focusListener_private.focusLost(focusEvent);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemListener_private != null) {
                itemListener_private.itemStateChanged(itemEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyListener_private != null) {
                keyListener_private.keyPressed(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyListener_private != null) {
                keyListener_private.keyReleased(keyEvent);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyListener_private != null) {
                keyListener_private.keyTyped(keyEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseListener_private != null) {
                mouseListener_private.mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseListener_private != null) {
                mouseListener_private.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseListener_private != null) {
                mouseListener_private.mouseExited(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseListener_private != null) {
                mouseListener_private.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseListener_private != null) {
                mouseListener_private.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseMotionListener_private != null) {
                mouseMotionListener_private.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseMotionListener_private != null) {
                mouseMotionListener_private.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            if (textListener_private != null) {
                textListener_private.textValueChanged(textEvent);
            }
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (windowListener_private != null) {
                windowListener_private.windowOpened(windowEvent);
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (windowListener_private != null) {
                windowListener_private.windowClosing(windowEvent);
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            if (windowListener_private != null) {
                windowListener_private.windowClosed(windowEvent);
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            if (windowListener_private != null) {
                windowListener_private.windowIconified(windowEvent);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            if (windowListener_private != null) {
                windowListener_private.windowDeiconified(windowEvent);
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (windowListener_private != null) {
                windowListener_private.windowActivated(windowEvent);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (windowListener_private != null) {
                windowListener_private.windowDeactivated(windowEvent);
            }
        }
    }
}

