{ This file contains a VW grammar written by Steven Pemberton that
  describes the syntax and semantics of a very simple subset of the
  ABC programming language.

  This grammar doesn't have free metanotions, and therefore is
  suitable to check particular terminal productions automatically.

  The original article describing the grammar is at
  https://homepages.cwi.nl/~steven/vw.html

  The sectioning has been slightly changed to adapt better to the
  RR style, and some rules reordered accordingly.
  Pragmatics are obtained verbatim from the article above.
  Cross-references have been added to the rules.  }

1 General definitions

1.1 Syntax

A) COMMANDS :: EMPTY ; COMMAND COMMANDS.
B) EMPTY ::.
C) COMMAND :: put EXPR in TARGET;
              write EXPR;
              if TEST indent COMMANDS outdent;
              while TEST indent COMMANDS outdent.
D) EXPR :: TERM; TERM plus EXPR.
E) TERM :: FACT; FACT times TERM.
F) FACT :: NUMBER ; TAG.
G) TEST :: EXPR COMP EXPR.
H) COMP :: lt ; le ; eq ; ne ; ge ; gt.
I) TARGET :: TAG.
J) NUMBER :: DIGIT number; DIGIT NUMBER.
K) TAG :: LETTER tag; LETTER TAG.
L) DIGIT :: digit D.
M) LETTER :: letter L.
N) D :: ZERO ; i ; ii ; iii ; iiii ; iiiii ; iiiii i ; iiiii ii ;
        iiiiii iii ; iiiiii iiii.
O) L :: a ; b ; c ; d ; e ; f ; g ; h ; i ; j ; k ; l ; m ; n ;
        o ; p ; q ; r ; s ; t ; u ; v ; w ; x ; y ; z.

a) COMMANDS : execute COMMANDS in memory.
b) execute EMPTY in memory VARS : EMPTY.

{ The hyperrule b) defines what happens when the end of the program
  is reached.  }

2 Predicates

2.1 Syntax

A) ANY :: EMPTY ; NOTION.

{ Checking whether a given tag is in some vars:  }
a) where TAG1 no in var TAG2 has VALUE VARS2:
     where TAG1 differs from TAG2, where TAG1 not in VARS2.
b) where TAG not in EMPTY : where true.
c) where true: .
{ Checking that two tags are different uses the same method, testing each
  letter in turn, until two letters that do not match are found:  }
d) where LETTER1 TAG1 differs from LETTER2 TAG2 :
     where LETTER1 differs from LETTER2 ;
     where LETTER1 is LETTER2, where TAG1 differs from TAG2.
e) where EMTPTY tag differs from TAG : where true.
f) where TAG differs from EMPTY tag : where true.
g) where ANY is ANY : where true.
{ Testing if two letters are different is achieved by testing if the
  alphabet contains both letters:  }
h) where letter L1 differs from letter L2 :
     where L1 precedes L2 in abcdefghijklmnopqrstuvwxyz ;
     where L2 precedes L1 in abcdefghijklmnopqrstuvwxyz.
i) where L1 precedes L2 in ANY1 L1 ANY2 L2 ANY3 :
     where true.

3 The put command

3.1 Syntax

A) VARS :: EMPTY; VAR VARS.
B) VAR :: var TAG has VALUE.
C) VALUE :: ZERO ; iVALUE.

a) execute put VALUE1 in TAG COMMANDS in memory VARS1 var TAG has VALUE2 VARS2 :
     execute COMMANDS in memory VARS1 var TAG has VALUE1 VARS2.
b) execute put VALUE in TAG COMMANDS in memory VARS :
     where TAG not in VARS,
       execute COMMANDS in memory VARS var TAG has VALUE.

4 Expressions

4.1 Syntax

a) execute put EXPR in TARGET COMMANDS in memory VARS :
     execute put evaluate EXPR close in TARGET COMMANDS in memory VARS.

{ To evaluate an expression containing an operator, we first
  evaluate the operands:  }

b) ANY evaluate EXPR plus TERM close ANY2 :
     ANY1 evaluate evaluate EXPR close plus evaluate TERM close close ANY2.
c) ANY1 evaluate TERM times FACT close ANY2 :
     ANY1 evaluate evaluate TERM close times evaluate FACT close close ANY2.

{ Now we are left with the lowest level of expressions to evaluate:
  tags and numbers. To evaluate a tag we just map it to its value in
  the memory: }

e) ANY1 evaluate TAG close ANY2 in memory VARS1 var TAG has VALUE VARS2 :
     ANY VALUE ANY2 in memory VARS1 var TAG has VALUE VARS2.

5 Operators

5.1 Syntax

A) DIGITS :: DIGIT; DIGIT DIGITS.

{ The preceding section has now transformed expressions into bracketed
  pairs of values, with the values separated by ‘plus’ or ‘times’. Since
  integers to the base one are being used, addition is trivial, since it
  can be achieved by concatenation: }

a) ANY evaluate VALUE1 plus VALUE2 close ANY2 :
     ANY1 VALUE1 VALUE2 ANY2.

{ Multiplication is achieved with repeated addition: }

b) ANY1 evaluate VALUE1i times VALUE2 close ANY2 :
     ANY1 evaluate evaluate VALUE1 times VALUE2 close plus VALUE2 close ANY2.
c) ANY1 evaluate ZERO times VALUE close ANY2 :
     ANY1 evaluate evaluate VALUE1 times VALUE2 close plus VALUE2 close ANY2.
d) ANY1 evaluate ZERO times VALUE close ANY2:
     ANY1 ZERO ANY2.

{ That is to say (a*b) = (((a-1)*b)+b), and (0*b)=0. Now we can define
  the evaluation of NUMBERs: }

e) ANY1 evaluate DIGITS digit D number close ANY2 :
     ANY1 evaluate evaluate evaluate DIGITS number close
          times iiiii iiiii close plus D close ANY2.
f) ANY1 evaluate digit D number close ANY2 :
     ANY1 D ANY2.

{ In brief, the first rule says
  (ND)=(((N)*10)+D)
  It uses the new, if obvious, metarule DIGITS.  }

6 The write command

6.1 Syntax

A) TEN :: iiiiiiiiii.

a) execute write EXPR COMMANDS in memory VARS :
     execute write evaluate EXPR close COMMANDS in memory VARS.
b) execute write VALUE COMMANDS in memory VARS :
     repr VALUE, execute COMMANDS in memory VARS.
c) VALUE1 repr TEN VALUE2 : VALUE1i repr VALUE2.
d) VALUEi repr D : repr VALUEi, repr D.
e) repr D : digit D symbol.

{ The metarule A) an hyperrules c), d) and e) implement the
  representation of a number which is traditional in VWG
  circles.  It can be seen as equivalent to the following
  function:

  repr(v1, v2)=
    if v2>=10: return repr(v1+1, v2-10)
    if v1>=1 and v2 in [0..9]: return repr(0, v1) ++ repr(0, v2)
    if v1=0  and v2 in [0..9]: return convert-to-text(v2) }

7 The if command

7.1 Syntax

a) execute if TEST indent COMMANDS1 outdent COMMANDS2 in memory VARS :
     execute if test TEST close indent COMMANDS1 outdent COMMANDS2 in memory VARS.

{ Testing TESTs will either yield success or failure. }

{ Assuming the definition of testing TESTs exists, if the test is
  successful we execute the controlled commands, and then the
  following ones. If the test is unsuccessful, only the following
  commands are executed: }

b) execute if success indent COMMANDS1 outdent COMMANDS2 in memory VARS :
     execute COMMANDS1 COMMANDS2 in memory VARS.
c) execute if failure indent COMMANDS1 outdent COMMANDS2 in memory VARS :
     execute COMMANDS2 in memory VARS.

{ We can now define the testing of TESTs: }

d) ANY1 test EXPR1 COMP EXPR2 close ANY2 :
     ANY1 test evaluate EXPR1 close COMP evaluate EXPR2 close close ANY2.

{ And the comparison operators:  }

e) ANY1 test VALUE eq VALUE close ANY2 :
     ANY1 success ANY2.
f) ANY1 test VALUE1 eq VALUE2 close ANY2 :
     where VALUE1 differs from VALUE2, ANY1 failure ANY2.

{ This needs 'differs from' to be generalised: }

g) where L1 NOTION differs from L2 NOTION2 :
     where L1 differs from L2 ;
     where L1 is L2, where NOTION1 differs from NOTION2.
h) where L1 differs from L2 :
     where L1 precedes L2 in abcdefghijklmnopqrstuvwxyz ;
     where L2 precedes L1 in abcdefghijklmnopqrstuvwxyz.

{ The definition of ‘ne’ is left to the reader. Here are the order
  signs: }

i) ANY1 test VALUE1 VALUE2 ge VALUE2 close ANY2: ANY1 success ANY2.
j) ANY1 test VALUE1 ge VALUE1i VALUE2 close ANY2: ANY1 failure ANY2.
k) ANY1 test VALUE1 le VALUE2 close ANY2: ANY1 test VALUE2 ge VALUE1 close ANY2.
l) ANY1 test VALUE1 lt VALUE2 close ANY2: ANY1 test VALUE1i le VALUE2 close ANY2.
m) ANY1 test VALUE1 gt VALUE2 close ANY2: ANY1 test VALUE2 lt VALUE1 close ANY2.

{ Adding an ELSE part to the IF command is trivial and left to the
  reader. }

8 While commands

8.1 Syntax

a) execute while TEST indetn COMMANDS1 outdent COMMANDS2 in memory VARS :
     execute if TEST indent COMMANDS1
             while TEST indent COMMANDS1 outdent
             outdent COMMANDS2 in memory VARS.
  
