// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ArrayValue is a list of AnyValue messages. We need ArrayValue as a message since oneof in AnyValue does not allow repeated fields.
type ArrayValue struct {
	Values []AnyValue
}

var (
	protoPoolArrayValue = sync.Pool{
		New: func() any {
			return &ArrayValue{}
		},
	}
)

func NewArrayValue() *ArrayValue {
	if !UseProtoPooling.IsEnabled() {
		return &ArrayValue{}
	}
	return protoPoolArrayValue.Get().(*ArrayValue)
}

func DeleteArrayValue(orig *ArrayValue, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.Values {
		DeleteAnyValue(&orig.Values[i], false)
	}
	orig.Reset()
	if nullable {
		protoPoolArrayValue.Put(orig)
	}
}

func CopyArrayValue(dest, src *ArrayValue) *ArrayValue {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewArrayValue()
	}
	dest.Values = CopyAnyValueSlice(dest.Values, src.Values)

	return dest
}

func CopyArrayValueSlice(dest, src []ArrayValue) []ArrayValue {
	var newDest []ArrayValue
	if cap(dest) < len(src) {
		newDest = make([]ArrayValue, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteArrayValue(&dest[i], false)
		}
	}
	for i := range src {
		CopyArrayValue(&newDest[i], &src[i])
	}
	return newDest
}

func CopyArrayValuePtrSlice(dest, src []*ArrayValue) []*ArrayValue {
	var newDest []*ArrayValue
	if cap(dest) < len(src) {
		newDest = make([]*ArrayValue, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewArrayValue()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteArrayValue(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewArrayValue()
		}
	}
	for i := range src {
		CopyArrayValue(newDest[i], src[i])
	}
	return newDest
}

func (orig *ArrayValue) Reset() {
	*orig = ArrayValue{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ArrayValue) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Values) > 0 {
		dest.WriteObjectField("values")
		dest.WriteArrayStart()
		orig.Values[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Values); i++ {
			dest.WriteMore()
			orig.Values[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ArrayValue) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "values":
			for iter.ReadArray() {
				orig.Values = append(orig.Values, AnyValue{})
				orig.Values[len(orig.Values)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *ArrayValue) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.Values {
		l = orig.Values[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ArrayValue) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Values) - 1; i >= 0; i-- {
		l = orig.Values[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func (orig *ArrayValue) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Values = append(orig.Values, AnyValue{})
			err = orig.Values[len(orig.Values)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestArrayValue() *ArrayValue {
	orig := NewArrayValue()
	orig.Values = []AnyValue{{}, *GenTestAnyValue()}
	return orig
}

func GenTestArrayValuePtrSlice() []*ArrayValue {
	orig := make([]*ArrayValue, 5)
	orig[0] = NewArrayValue()
	orig[1] = GenTestArrayValue()
	orig[2] = NewArrayValue()
	orig[3] = GenTestArrayValue()
	orig[4] = NewArrayValue()
	return orig
}

func GenTestArrayValueSlice() []ArrayValue {
	orig := make([]ArrayValue, 5)
	orig[1] = *GenTestArrayValue()
	orig[3] = *GenTestArrayValue()
	return orig
}
