<?php
/**
 * Generates the normalizer data file for Malayalam.
 *
 * @license GPL-2.0-or-later
 * @file
 * @ingroup MaintenanceLanguage
 */

// @codeCoverageIgnoreStart
require_once __DIR__ . '/../Maintenance.php';
// @codeCoverageIgnoreEnd

use MediaWiki\Maintenance\Maintenance;
use Wikimedia\StaticArrayWriter;

/**
 * Generates the normalizer data file for Malayalam.
 *
 * This data file is used after normalizing to NFC.
 *
 * @ingroup MaintenanceLanguage
 */
class GenerateNormalizerDataMl extends Maintenance {
	public function __construct() {
		parent::__construct();
		$this->addDescription( 'Generate the normalizer data file for Malayalam' );
	}

	/** @inheritDoc */
	public function getDbType() {
		return Maintenance::DB_NONE;
	}

	public function execute() {
		$hexPairs = [
			# From https://www.unicode.org/versions/Unicode5.1.0/#Malayalam_Chillu_Characters
			'0D23 0D4D 200D' => '0D7A',
			'0D28 0D4D 200D' => '0D7B',
			'0D30 0D4D 200D' => '0D7C',
			'0D32 0D4D 200D' => '0D7D',
			'0D33 0D4D 200D' => '0D7E',

			# From http://permalink.gmane.org/gmane.science.linguistics.wikipedia.technical/46413
			'0D15 0D4D 200D' => '0D7F',
		];

		$pairs = [];
		foreach ( $hexPairs as $hexSource => $hexDest ) {
			$source = UtfNormal\Utils::hexSequenceToUtf8( $hexSource );
			$dest = UtfNormal\Utils::hexSequenceToUtf8( $hexDest );
			$pairs[$source] = $dest;
		}

		global $IP;
		$writer = new StaticArrayWriter();
		file_put_contents( "$IP/includes/languages/data/NormalizeMl.php", $writer->writeClass(
			$pairs,
			[
				'header' => 'Generated by generateNormalizerDataMl.php. Do not modify!',
				'namespace' => 'MediaWiki\\Languages\\Data',
				'class' => 'NormalizeMl',
				'const' => 'PAIRS',
			]
		) );

		echo "ml: " . count( $pairs ) . " pairs written.\n";
	}
}

// @codeCoverageIgnoreStart
$maintClass = GenerateNormalizerDataMl::class;
require_once RUN_MAINTENANCE_IF_MAIN;
// @codeCoverageIgnoreEnd
