/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ComponentPropsWithoutRef, type ReactNode, type Ref } from 'react';
import { type UIAnalyticsEvent } from '@atlaskit/analytics-next';
import type { BasePrimitiveProps, StyleProp } from './types';
type BasePressableProps = {
    /**
     * Elements to be rendered inside the Pressable.
     */
    children?: ReactNode;
    /**
     * Handler called on click. The second argument provides an Atlaskit UI analytics event that can be fired to a listening channel. See the ['analytics-next' package](https://atlaskit.atlassian.com/packages/analytics/analytics-next) documentation for more information.
     */
    onClick?: (e: React.MouseEvent<HTMLButtonElement>, analyticsEvent: UIAnalyticsEvent) => void;
    /**
     * Whether the button is disabled.
     */
    isDisabled?: boolean;
    /**
     * An optional name used to identify events for [React UFO (Unified Frontend Observability) press interactions](https://developer.atlassian.com/platform/ufo/react-ufo/react-ufo/getting-started/#quick-start--press-interactions). For more information, see [React UFO integration into Design System components](https://go.atlassian.com/react-ufo-dst-integration).
     */
    interactionName?: string;
    /**
     * An optional component name used to identify this component in Atlaskit analytics events. This can be used if a parent component's name is preferred over the default 'Pressable'.
     */
    componentName?: string;
    /**
     * Additional information to be included in the `context` of Atlaskit analytics events that come from pressable.
     */
    analyticsContext?: Record<string, any>;
    /**
     * Forwarded ref.
     */
    ref?: Ref<HTMLButtonElement>;
};
export type PressableProps = Omit<ComponentPropsWithoutRef<'button'>, 'disabled' | 'onClick' | 'style' | 'className'> & BasePrimitiveProps & StyleProp & BasePressableProps;
/**
 * __Pressable__
 *
 * A primitive for building custom buttons.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
declare const Pressable: import("react").ForwardRefExoticComponent<Omit<PressableProps, "ref"> & import("react").RefAttributes<HTMLButtonElement>>;
export default Pressable;
