import { attributes, customAttributes, getAttribute } from './attributes';
import { findElementAll } from './find-element';
function getDroppablesOfType(_ref) {
  var contextId = _ref.contextId,
    type = _ref.type;
  return findElementAll({
    attribute: attributes.droppable.contextId,
    value: contextId
  }, {
    attribute: customAttributes.droppable.type,
    value: type
  });
}

/**
 * This is similar to the function of the same name in `react-beautiful-dnd`.
 *
 * Many of the checks from rbd are removed though, such as visibility checks.
 */
export function getBestCrossAxisDroppable(_ref2) {
  var droppableId = _ref2.droppableId,
    type = _ref2.type,
    isMovingForward = _ref2.isMovingForward,
    contextId = _ref2.contextId,
    droppableRegistry = _ref2.droppableRegistry;
  var droppables = getDroppablesOfType({
    contextId: contextId,
    type: type
  });
  var currentIndex = droppables.findIndex(function (element) {
    return getAttribute(element, attributes.droppable.id) === droppableId;
  });
  var candidates = droppables.filter(function (_, index) {
    /**
     * We are following the DOM order of the droppables,
     * so keep only those that are before/after the current.
     */
    if (isMovingForward) {
      return index > currentIndex;
    }
    return index < currentIndex;
  }).filter(function (element) {
    /**
     * Filter out the disabled droppables.
     */
    var droppableId = getAttribute(element, attributes.droppable.id);
    var entry = droppableRegistry.getEntry({
      droppableId: droppableId
    });
    var isValidCandidate = entry && !entry.isDropDisabled;
    return isValidCandidate;
  });

  /**
   * If we're moving forward then take the first candidate,
   * if moving backwards take the last candidate
   * (because it is closest to where the current is).
   *
   * Using `.at()` provides a safer type, making us handle the `undefined` case.
   */
  var bestCandidate = isMovingForward ? candidates.at(0) : candidates.at(-1);
  return bestCandidate !== null && bestCandidate !== void 0 ? bestCandidate : null;
}