import type { Layer as NewLayer } from '@statsig/js-client';
import type { EvaluationDetails } from './types';
export type LogParameterFunction = (layer: Layer, parameterName: string) => void;
export declare class Layer {
    static fromLayer(layer: NewLayer): Layer;
    readonly _name: string;
    readonly _value: Record<string, any>;
    readonly _ruleID: string;
    /** @deprecated - do not use, this is still exported for backwards compatibility but will be removed in the next major version  */
    readonly _secondaryExposures: Record<string, string>[];
    /** @deprecated - do not use, this is still exported for backwards compatibility but will be removed in the next major version  */
    readonly _undelegatedSecondaryExposures: Record<string, string>[];
    readonly _allocatedExperimentName: string;
    readonly _explicitParameters: string[];
    readonly _evaluationDetails: EvaluationDetails;
    readonly _logParameterFunction: LogParameterFunction | null;
    private constructor();
    get<T>(key: string, defaultValue: T, typeGuard?: (value: unknown) => value is T): T;
    getValue(key: string, defaultValue?: any | null): boolean | number | string | object | Array<any> | null;
    private _logLayerParameterExposure;
}
