/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.dagger.internal;

import io.bazel.kotlin.builder.dagger.internal.MapFactory;
import io.bazel.kotlin.builder.dagger.internal.Provider;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class LazyClassKeyMap<V>
implements Map<Class<?>, V> {
    private final Map<String, V> delegate;

    public static <V> Map<Class<?>, V> of(Map<String, V> delegate) {
        return new LazyClassKeyMap<V>(delegate);
    }

    private LazyClassKeyMap(Map<String, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof Class)) {
            throw new IllegalArgumentException("Key must be a class");
        }
        return this.delegate.get(((Class)key).getName());
    }

    @Override
    public Set<Class<?>> keySet() {
        throw new UnsupportedOperationException("Maps created with @LazyClassKey do not support usage of keySet(). Consider @ClassKey instead.");
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof Class)) {
            throw new IllegalArgumentException("Key must be a class");
        }
        return this.delegate.containsKey(((Class)key).getName());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        throw new UnsupportedOperationException("Maps created with @LazyClassKey do not support usage of entrySet(). Consider @ClassKey instead.");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Dagger map bindings are immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Dagger map bindings are immutable");
    }

    @Override
    public V put(Class<?> key, V value) {
        throw new UnsupportedOperationException("Dagger map bindings are immutable");
    }

    @Override
    public void putAll(Map<? extends Class<?>, ? extends V> map) {
        throw new UnsupportedOperationException("Dagger map bindings are immutable");
    }

    public static class Factory<V>
    implements Provider<Map<Class<?>, V>> {
        MapFactory<String, V> delegate;

        public static <V> Factory<V> of(MapFactory<String, V> delegate) {
            return new Factory<V>(delegate);
        }

        private Factory(MapFactory<String, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Map<Class<?>, V> get() {
            return LazyClassKeyMap.of(this.delegate.get());
        }
    }
}

