const __vite__mapDeps=(i,m=__vite__mapDeps,d=(m.f||(m.f=["assets/marker-icon-BLvfY1mT.js","assets/marker-icon-CjH5v03A.js","assets/marker-shadow-CI9jEvAf.js","assets/marker-shadow-Cm2WQXxK.js"])))=>i.map(i=>d[i]);
import { $n as e, Ct as t, Dt as n, Et as r, Fn as i, Nn as a, Ot as o, Qn as s, Rn as c, St as l, Tt as u, Wt as d, Zn as f, Zt as p, _n as m, _t as h, cn as g, dn as _, fn as v, ft as y, gn as b, gt as x, j as S, jn as C, kn as w, kt as T, or as E, pn as D, un as O, wn as k, wt as A, xt as j, __tla as __tla_0 } from "./index-D8m6Kk7Q.js";
import { t as M } from "./marker-icon-CjH5v03A.js";
import { t as N } from "./marker-shadow-Cm2WQXxK.js";
import { t as P } from "./leaflet-src-DVApI5R2.js";
import { a as F, c as I, i as L, o as R, r as z, s as B, t as V, u as H, __tla as __tla_1 } from "./leaflet-Cvl34qLx.js";
let q, Z;
let __tla = Promise.all([
  (() => {
    try {
      return __tla_0;
    } catch {
    }
  })(),
  (() => {
    try {
      return __tla_1;
    } catch {
    }
  })()
]).then(async () => {
  const U = () => new j("oh-plan-page", "Floor plan", "Displays markers on an image overlay").params([
    o("imageUrl", "Image URL", "The URL of the image to display as background").c("url"),
    r("imageWidth", "Image Width", "The width of the image (by default 1000 pixels). Please specify if the image is not square to compute the aspect ratio"),
    r("imageHeight", "Image Height", "The height of the image (by default 1000 pixels). Please specify if the image is not square to compute the aspect ratio"),
    l("noZoomOrDrag", "Disable Zooming & Dragging", "Disable the ability to zoom and drag"),
    l("noZoomAnimation", "No Zoom Animation", "Change zoom levels without animation, can also avoid graphic glitches with persistent tooltips"),
    l("noMarkerZoomAnimation", "Hide Markers during Zoom Animation").a(),
    n("backgroundColor", "Background Color", 'Color outside the bounds of the image. "Black or White" means it will be black in dark mode and white in light mode', [
      {
        value: "",
        label: "Default"
      },
      {
        value: "white",
        label: "Always White"
      },
      {
        value: "black",
        label: "Always Black"
      },
      {
        value: "blackwhite",
        label: "Black or White"
      }
    ]),
    l("darkModeInvert", "Invert Image in Dark Mode", "Apply an invert filter to the image in dark mode - use with images in black & white or grayscale for best results"),
    n("tooltipColor", "Tooltip Color", 'Color of the tooltip. "Black or White" means it will be black in dark mode and white in light mode', [
      {
        value: "white",
        label: "White"
      },
      {
        value: "black",
        label: "Black"
      },
      {
        value: "blackwhite",
        label: "Black or White"
      }
    ])
  ]);
  var W = {
    mixins: [
      T,
      S
    ],
    components: {
      LMarker: I,
      LTooltip: L,
      LIcon: B,
      LPopup: H
    },
    widget: () => new j("oh-plan-marker", "Floor Plan Marker", "A marker on a floor plan", "map_pin").paramGroup(A("marker", "Marker Settings"), [
      o("name", "Name", "The name of the marker (for identification)"),
      o("coords", "Coordinates", "The coordinates of this marker in the floor plan Coordinate Reference System; usually set by dragging the marker at design time").a(),
      u("item", "Item", "The item whose state to display on this marker"),
      o("visible", "Visibility", 'Enter an expression to dynamically show the marker, see <a class="external text-color-blue" target="_blank" href="https://www.openhab.org/docs/ui/building-pages.html#widgets-definition-usage">Building Pages: <code>visible</code></a>')
    ]).paramGroup(A("icon", "Icon", "You can customize the styles further with CSS attributes in the <code>iconStyle</code> parameter (in YAML only)"), [
      o("icon", "Icon", 'Use <code>oh:iconName</code> (<a class="external text-color-blue" target="_blank" href="https://www.openhab.org/link/icons">openHAB icon</a>), <code>f7:iconName</code> (<a class="external text-color-blue" target="_blank" href="https://framework7.io/icons/">Framework7 icon</a>), <code>material:iconName</code> (<a class="external text-color-blue" target="_blank" href="https://jossef.github.io/material-design-icons-iconfont/">Material icon</a>) or <code>iconify:iconSet:iconName</code> (<a class="external text-color-blue" target="_blank" href="https://icon-sets.iconify.design">Iconify icon</a>, requires being online if not in cache)'),
      l("iconUseState", "Icon depends on state", "Use the state of the Item to get a dynamic icon (enabled by default for <code>Contact</code>, <code>Dimmer</code>, <code>Rollershutter</code> & <code>Switch</code> Item types) (for openHAB icons only)"),
      r("iconSize", "Icon Size", "Size of the icon in pixels (40 by default)"),
      r("iconWidth", "Icon Width", "Width of the icon in pixels (for openHAB icons only, 40 by default)").a(),
      r("iconHeight", "Icon Height", "Height of the icon in pixels (for openHAB icons only, 40 by default)").a(),
      o("iconColor", "Icon Color", "Color of the icon (for Framework7/Material/certain Iconify icons); use expression for dynamic colors"),
      r("iconRotation", "Icon Rotation", "Rotation of the icon in degrees")
    ]).paramGroup(A("tooltip", "Tooltip", "You can customize the styles further with CSS attributes in the <code>tooltipStyle</code> parameter (in YAML only)"), [
      o("tooltip", "Tooltip Text", "The tooltip text - leave blank to display the state of the item"),
      l("tooltipPermanent", "Always display the tooltip"),
      l("useTooltipAsLabel", "Use Tooltip as Label", "Put the tooltip text directly over the plan instead of displaying an icon"),
      o("tooltipFontSize", "Tooltip Font Size", "Font size of the tooltip text"),
      o("tooltipColor", "Tooltip color", "Color of the tooltip"),
      n("tooltipDirection", "Tooltip Direction", "The direction of the tooltip", [
        {
          value: "top",
          label: "Top"
        },
        {
          value: "bottom",
          label: "Bottom"
        },
        {
          value: "left",
          label: "Left"
        },
        {
          value: "right",
          label: "Right"
        },
        {
          value: "center",
          label: "Center"
        },
        {
          value: "auto",
          label: "Auto"
        }
      ]),
      r("tooltipOffsetX", "Tooltip Offset X", "The X offset of the tooltip from the marker in pixels").a(),
      r("tooltipOffsetY", "Tooltip Offset Y", "The Y offset of the tooltip from the marker in pixels").a(),
      t("tooltipOpacity", "Tooltip Opacity", "The opacity of the tooltip (0-1)").a()
    ]).paramGroup(A("zoomVisibility", "Zoom Visibility", "Hide this marker outside certain zoom labels"), [
      r("zoomVisibilityMin", "Zoom Visibility Minimum", "Visible only when zoomed to above this level (no limit if empty)").a(),
      r("zoomVisibilityMax", "Zoom Visibility Maximum", "Visible only when zoomed to below this level (no limit if empty)").a()
    ]).paramGroup(x(null, "Action to perform when the marker is clicked"), h()),
    emits: [
      "update"
    ],
    data() {
      return {
        markerKey: "marker-" + p.utils.id(),
        dragging: false
      };
    },
    created() {
      this.DefaultIcon = {
        iconUrl: M,
        shadowUrl: N
      };
    },
    computed: {
      coords() {
        return this.config.coords ? this.config.coords.split(",") : [
          250,
          250
        ];
      },
      hasCustomIcon() {
        return this.config.useTooltipAsLabel || this.config.icon;
      },
      iconSize() {
        if (this.hasCustomIcon) return null;
        let e2 = this.config.iconSize || 40;
        return [
          e2,
          e2
        ];
      },
      tooltipOptions() {
        return {
          permanent: this.config.tooltipPermanent,
          direction: this.config.tooltipDirection || "auto",
          offset: [
            this.config.tooltipOffsetX || 0,
            this.config.tooltipOffsetY || 0
          ],
          opacity: this.config.tooltipOpacity || 0.9
        };
      },
      state() {
        return this.config.item ? this.context.store[this.config.item].state : null;
      },
      tooltipStyle() {
        return Object.assign({
          fontSize: this.config.tooltipFontSize,
          color: this.config.tooltipColor
        }, this.config.tooltipStyle);
      },
      iconStyle() {
        return Object.assign({
          transform: "rotate(" + this.config.iconRotation + "deg)"
        }, this.config.iconStyle);
      }
    },
    asyncComputed: {
      tooltip() {
        if (this.config.tooltip) return this.config.tooltip;
        if (this.config.item) {
          let e2 = this.context.store[this.config.item];
          return e2 && e2.displayState ? e2.displayState : e2.state;
        }
        return null;
      }
    },
    methods: {
      onMove(e2) {
        this.context.component.config.coords = [
          e2.lat,
          e2.lng
        ].join(",");
      },
      onClick(e2) {
        this.context.editmode || this.performAction(e2);
      }
    },
    mounted() {
      this.$emit("update", this.coords);
    }
  }, G = {
    class: "display-flex"
  };
  function K(t2, n2, r2, i2, o2, l2) {
    let u2 = a("l-tooltip"), d2 = a("oh-icon"), f2 = a("l-icon"), p2 = a("f7-link"), h2 = a("l-popup"), g2 = a("l-marker");
    return t2.visible && l2.coords ? (w(), _(g2, {
      ref: "marker",
      key: o2.markerKey,
      draggable: t2.context.editmode !== void 0 && t2.context.editmode !== null,
      "lat-lng": l2.coords,
      "onUpdate:latLng": l2.onMove,
      onClick: l2.onClick
    }, {
      default: c(() => [
        t2.tooltip && !t2.config.useTooltipAsLabel ? (w(), _(u2, {
          key: 0,
          options: l2.tooltipOptions
        }, {
          default: c(() => [
            O("div", {
              style: s([
                {
                  "white-space": "nowrap"
                },
                l2.tooltipStyle
              ])
            }, e(t2.tooltip), 5)
          ]),
          _: 1
        }, 8, [
          "options"
        ])) : v("", true),
        l2.hasCustomIcon ? (w(), _(f2, {
          key: 1,
          "icon-size": l2.iconSize
        }, {
          default: c(() => [
            t2.config.useTooltipAsLabel ? (w(), D("div", {
              key: 0,
              style: s([
                {
                  "white-space": "nowrap"
                },
                l2.tooltipStyle
              ])
            }, e(t2.tooltip), 5)) : t2.config.icon ? (w(), _(d2, {
              key: 1,
              style: s(l2.iconStyle),
              icon: t2.config.icon,
              color: t2.config.iconColor,
              width: t2.config.iconWidth || t2.config.iconSize || 40,
              height: t2.config.iconHeight || t2.config.iconSize || 40,
              state: t2.config.iconUseState ? l2.state : void 0
            }, null, 8, [
              "style",
              "icon",
              "color",
              "width",
              "height",
              "state"
            ])) : v("", true)
          ]),
          _: 1
        }, 8, [
          "icon-size"
        ])) : (w(), _(f2, {
          key: 2,
          "icon-url": t2.DefaultIcon.iconUrl,
          "shadow-url": t2.DefaultIcon.shadowUrl
        }, null, 8, [
          "icon-url",
          "shadow-url"
        ])),
        t2.context.editmode && !o2.dragging ? (w(), _(h2, {
          key: 3
        }, {
          default: c(() => [
            O("div", G, [
              m(p2, {
                href: "#",
                class: "text-color-blue display-flex flex-direction-column margin-right",
                onClick: n2[0] || (n2[0] = (e2) => t2.context.editmode.configureWidget(t2.context.component, t2.context.parent)),
                "icon-f7": "square_pencil"
              }, {
                default: c(() => [
                  ...n2[4] || (n2[4] = [
                    b(" Configure ", -1)
                  ])
                ]),
                _: 1
              }),
              m(p2, {
                href: "#",
                class: "text-color-blue display-flex flex-direction-column margin-right",
                onClick: n2[1] || (n2[1] = (e2) => t2.context.editmode.editWidgetCode(t2.context.component, t2.context.parent)),
                "icon-f7": "doc_text"
              }, {
                default: c(() => [
                  ...n2[5] || (n2[5] = [
                    b(" YAML ", -1)
                  ])
                ]),
                _: 1
              }),
              m(p2, {
                href: "#",
                class: "text-color-blue display-flex flex-direction-column margin-right",
                onClick: n2[2] || (n2[2] = (e2) => t2.context.editmode.copyWidget(t2.context.component, t2.context.parent)),
                "icon-f7": "scissors_alt"
              }, {
                default: c(() => [
                  ...n2[6] || (n2[6] = [
                    b(" Copy ", -1)
                  ])
                ]),
                _: 1
              }),
              m(p2, {
                href: "#",
                class: "text-color-red display-flex flex-direction-column",
                onClick: n2[3] || (n2[3] = (e2) => t2.context.editmode.removeWidget(t2.context.component, t2.context.parent)),
                "icon-f7": "trash"
              }, {
                default: c(() => [
                  ...n2[7] || (n2[7] = [
                    b(" Remove ", -1)
                  ])
                ]),
                _: 1
              })
            ])
          ]),
          _: 1
        })) : v("", true)
      ]),
      _: 1
    }, 8, [
      "draggable",
      "lat-lng",
      "onUpdate:latLng",
      "onClick"
    ])) : v("", true);
  }
  let J;
  q = y(W, [
    [
      "render",
      K
    ]
  ]);
  J = E(P());
  delete J.Icon.Default.prototype._getIconUrl, J.Icon.Default.mergeOptions({
    iconRetinaUrl: d(() => import("./marker-icon-2x-Iy0OynPB.js").then(async (m2) => {
      await m2.__tla;
      return m2;
    }), []),
    iconUrl: d(() => import("./marker-icon-BLvfY1mT.js").then(async (m2) => {
      await m2.__tla;
      return m2;
    }), __vite__mapDeps([0,1])),
    shadowUrl: d(() => import("./marker-shadow-CI9jEvAf.js").then(async (m2) => {
      await m2.__tla;
      return m2;
    }), __vite__mapDeps([2,3]))
  });
  var Y = {
    mixins: [
      T
    ],
    components: {
      LMap: F,
      LImageOverlay: z,
      LControl: V,
      LFeatureGroup: R,
      OhPlanMarker: q
    },
    widget: U,
    data() {
      return {
        currentZoom: 13,
        currentCenter: null,
        minZoom: -2,
        zoom: -0.5,
        crs: J.CRS.Simple,
        showMap: false,
        mapKey: p.utils.id(),
        markers: []
      };
    },
    computed: {
      bounds() {
        return [
          [
            0,
            0
          ],
          [
            this.config.imageHeight || 1e3,
            this.config.imageWidth || 1e3
          ]
        ];
      },
      mapOptions() {
        return Object.assign({
          zoomSnap: 0.1,
          tap: false
        }, this.config.noZoomOrDrag ? {
          dragging: false,
          touchZoom: false,
          doubleClickZoom: false,
          scrollWheelZoom: false,
          zoomControl: false
        } : {});
      }
    },
    asyncComputed: {
      backgroundImageUrl() {
        return this.$oh.media.getImage(this.config.imageUrl);
      }
    },
    watch: {
      "config.noZoomOrDrag": function(e2) {
        this.refreshMap();
      },
      backgroundImageUrl(e2) {
        this.showMap = true, this.refreshMap();
      }
    },
    methods: {
      zoomUpdate(e2) {
        this.currentZoom = e2;
        let t2 = this.context.component.slots.default.filter((e3) => {
          let t3 = parseFloat(e3.config.zoomVisibilityMin), n2 = parseFloat(e3.config.zoomVisibilityMax), r2 = isNaN(t3) || t3 < this.currentZoom, i2 = isNaN(n2) || n2 > this.currentZoom;
          return this.context.editmode != null || r2 && i2;
        });
        (t2.length !== this.markers.length || t2.every((e3) => this.markers.indexOf(e3) < 0)) && (this.markers = t2);
      },
      centerUpdate(e2) {
        this.currentCenter = e2;
      },
      markerComponent(e2) {
        return "oh-plan-marker";
      },
      onMarkerUpdate() {
      },
      fitMapBounds() {
        var _a;
        this.$refs.map && ((_a = this.$refs.map.leafletObject) == null ? void 0 : _a.fitBounds(this.bounds));
      },
      refreshMap() {
        this.mapKey = p.utils.id(), k(() => {
          this.fitMapBounds();
        });
      }
    }
  };
  function X(t2, n2, r2, o2, s2, l2) {
    let u2 = a("l-image-overlay"), d2 = a("l-feature-group"), p2 = a("f7-menu-item"), h2 = a("f7-menu"), y2 = a("l-control"), b2 = a("l-map");
    return s2.showMap ? (w(), _(b2, {
      ref: "map",
      zoom: s2.zoom,
      "min-zoom": s2.minZoom,
      crs: s2.crs,
      options: l2.mapOptions,
      "zoom-animation": !t2.config.noZoomAnimation,
      "marker-zoom-animation": !t2.config.noMarkerZoomAnimation,
      "max-bounds": l2.bounds,
      key: s2.mapKey,
      class: f([
        "oh-plan-page-lmap",
        {
          "with-tabbar": t2.context.tab,
          "oh-plan-white-background": t2.config.backgroundColor === "white",
          "oh-plan-black-background": t2.config.backgroundColor === "black",
          "oh-plan-blackwhite-background": t2.config.backgroundColor === "blackwhite",
          "oh-plan-dark-mode-invert": t2.config.darkModeInvert,
          "oh-plan-tooltip-black": t2.config.tooltipColor === "black",
          "oh-plan-tooltip-blackwhite": t2.config.tooltipColor === "blackwhite"
        }
      ]),
      onReady: l2.fitMapBounds,
      "onUpdate:center": l2.centerUpdate,
      "onUpdate:zoom": l2.zoomUpdate
    }, {
      default: c(() => [
        t2.backgroundImageUrl ? (w(), _(u2, {
          key: 0,
          url: t2.backgroundImageUrl,
          bounds: l2.bounds
        }, null, 8, [
          "url",
          "bounds"
        ])) : v("", true),
        t2.context.component.slots ? (w(), _(d2, {
          key: 1,
          ref: "featureGroup"
        }, {
          default: c(() => [
            (w(true), D(g, null, C(s2.markers, (e2, n3) => (w(), _(i(l2.markerComponent(e2)), {
              key: n3,
              context: t2.childContext(e2),
              onUpdate: l2.onMarkerUpdate
            }, null, 40, [
              "context",
              "onUpdate"
            ]))), 128))
          ]),
          _: 1
        }, 512)) : v("", true),
        t2.context.editmode ? (w(), _(y2, {
          key: 2,
          position: "topright"
        }, {
          default: c(() => [
            m(h2, {
              class: "padding"
            }, {
              default: c(() => [
                m(p2, {
                  onClick: n2[0] || (n2[0] = (e2) => t2.context.editmode.addWidget(t2.context.component, "oh-plan-marker")),
                  "icon-f7": "plus",
                  text: "Add Marker"
                }),
                t2.context.clipboardtype ? (w(), _(p2, {
                  key: 0,
                  onClick: n2[1] || (n2[1] = (e2) => t2.context.editmode.pasteWidget(t2.context.component)),
                  "icon-f7": "square_on_square"
                })) : v("", true)
              ]),
              _: 1
            })
          ]),
          _: 1
        })) : v("", true),
        t2.context.editmode ? (w(), _(y2, {
          key: 3,
          position: "bottomleft"
        }, {
          default: c(() => [
            O("span", null, "Zoom Level: " + e(s2.currentZoom.toFixed(2)), 1)
          ]),
          _: 1
        })) : v("", true)
      ]),
      _: 1
    }, 8, [
      "zoom",
      "min-zoom",
      "crs",
      "options",
      "zoom-animation",
      "marker-zoom-animation",
      "max-bounds",
      "onReady",
      "class",
      "onUpdate:center",
      "onUpdate:zoom"
    ])) : v("", true);
  }
  Z = y(Y, [
    [
      "render",
      X
    ]
  ]);
});
export {
  __tla,
  q as n,
  Z as t
};
