/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.http;

import aQute.bnd.connection.settings.ConnectionSettings;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.http.HttpRequest;
import aQute.bnd.http.HttpRequestException;
import aQute.bnd.http.ProgressWrappingStream;
import aQute.bnd.http.RetryException;
import aQute.bnd.http.URLCache;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.Registry;
import aQute.bnd.service.progress.ProgressPlugin;
import aQute.bnd.service.url.ProxyHandler;
import aQute.bnd.service.url.State;
import aQute.bnd.service.url.TaggedData;
import aQute.bnd.service.url.URLConnectionHandler;
import aQute.bnd.service.url.URLConnector;
import aQute.bnd.stream.MapStream;
import aQute.bnd.util.home.Home;
import aQute.lib.date.Dates;
import aQute.lib.io.IO;
import aQute.lib.json.JSONCodec;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLHandshakeException;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Closeable,
URLConnector {
    static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    @Deprecated
    public static final SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    static final long INITIAL_TIMEOUT = TimeUnit.MINUTES.toMillis(3L);
    static final long FINAL_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    static final long MAX_RETRY_DELAY = TimeUnit.MINUTES.toMillis(10L);
    private final List<ProxyHandler> proxyHandlers = new ArrayList<ProxyHandler>();
    private final List<URLConnectionHandler> connectionHandlers = new ArrayList<URLConnectionHandler>();
    private ThreadLocal<PasswordAuthentication> passwordAuthentication = new ThreadLocal();
    private boolean inited;
    static final JSONCodec codec;
    private URLCache cache = new URLCache(IO.getFile(Home.getUserHomeBnd() + "/urlcache"));
    private Registry registry = null;
    private Reporter reporter;
    private volatile AtomicBoolean offline;
    private final PromiseFactory promiseFactory = Processor.getPromiseFactory();
    private ConnectionSettings connectionSettings;
    int retries = 3;
    long retryDelay = 0L;

    synchronized void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return (PasswordAuthentication)HttpClient.this.passwordAuthentication.get();
            }
        });
    }

    @Override
    public void close() {
        Authenticator.setDefault(null);
    }

    @Override
    public InputStream connect(URL url) throws Exception {
        return this.build().get(InputStream.class).go(url);
    }

    @Override
    public TaggedData connectTagged(URL url) throws Exception {
        return this.build().get(TaggedData.class).go(url);
    }

    @Override
    public TaggedData connectTagged(URL url, String tag) throws Exception {
        return this.build().get(TaggedData.class).ifNoneMatch(tag).go(url);
    }

    public HttpRequest<Object> build() {
        return new HttpRequest<Object>(this);
    }

    <T> Promise<T> sendAsync(HttpRequest<T> request) {
        int retries = request.isIdemPotent ? request.retries : 0;
        long delay = request.retryDelay == 0L ? 1000L : request.retryDelay;
        return this.sendAsync(request, retries, delay);
    }

    private <T> Promise<T> sendAsync(HttpRequest<T> request, int retries, long delay) {
        HttpConnection connection = new HttpConnection(request);
        return this.promiseFactory().submit(connection).timeout(Math.max(retries < 1 ? FINAL_TIMEOUT : INITIAL_TIMEOUT, request.timeout * 10L)).recoverWith(failed -> {
            Throwable failure = failed.getFailure();
            Throwable logFailure = null;
            if (failure instanceof TimeoutException) {
                Thread requestThread = connection.requestThread();
                if (requestThread != null) {
                    failure.setStackTrace(requestThread.getStackTrace());
                }
                connection.cancel();
                logFailure = failure;
            }
            if (retries < 1) {
                if (failure instanceof RetryException) {
                    TaggedData tag = ((RetryException)failure).getTag();
                    if (request.download == TaggedData.class) {
                        Promise recovery = this.promiseFactory().resolved((Object)tag);
                        return recovery;
                    }
                    return this.promiseFactory().failed((Throwable)new HttpRequestException(tag, failure.getCause()));
                }
                return null;
            }
            String message = failure.getMessage();
            if (message == null) {
                message = failure.toString();
            }
            logger.info("Retrying failed connection. url={}, message={}, delay={}, retries={}", new Object[]{request.url, message, delay, retries, logFailure});
            Promise delayed = failed.delay(delay);
            long nextDelay = request.retryDelay == 0L ? Math.min(delay * 2L, MAX_RETRY_DELAY) : delay;
            return delayed.recoverWith(f -> this.sendAsync(request, retries - 1, nextDelay));
        });
    }

    public <T> T send(HttpRequest<T> request) throws Exception {
        Promise<T> promise = this.sendAsync(request);
        Throwable failure = promise.getFailure();
        if (failure != null) {
            throw Exceptions.duck(failure);
        }
        return (T)promise.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaggedData send0(HttpRequest<?> request) throws Exception {
        Type download = request.download;
        try {
            TaggedData taggedData = this.send(request.asTag());
            return taggedData;
        }
        finally {
            request.download = download;
        }
    }

    public ProxyHandler.ProxySetup getProxySetup(URL url) throws Exception {
        this.init();
        for (ProxyHandler proxyHandler : this.getProxyHandlers()) {
            ProxyHandler.ProxySetup setup = proxyHandler.forURL(url);
            if (setup == null) continue;
            logger.debug("Proxy {}", (Object)setup);
            return setup;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T connectWithProxy(ProxyHandler.ProxySetup proxySetup, Callable<T> r) throws Exception {
        if (proxySetup == null) {
            return r.call();
        }
        this.passwordAuthentication.set(proxySetup.authentication);
        try {
            T t = r.call();
            return t;
        }
        finally {
            this.passwordAuthentication.set(null);
        }
    }

    public URLConnectionHandler findMatchingHandler(URL url) {
        Collection<? extends URLConnectionHandler> urlConnectionHandlers = this.getURLConnectionHandlers();
        for (URLConnectionHandler uRLConnectionHandler : urlConnectionHandlers) {
            if (!uRLConnectionHandler.matches(url)) continue;
            logger.debug("Decorate {} with handler {}", (Object)url, (Object)uRLConnectionHandler);
            return uRLConnectionHandler;
        }
        logger.debug("No match for {}, handlers {}", (Object)url, urlConnectionHandlers);
        return null;
    }

    private synchronized Collection<? extends URLConnectionHandler> getURLConnectionHandlers() {
        if (this.connectionHandlers.isEmpty() && this.registry != null) {
            List<URLConnectionHandler> connectionHandlers = this.registry.getPlugins(URLConnectionHandler.class);
            this.connectionHandlers.addAll(connectionHandlers);
            logger.debug("URL Connection handlers {}", connectionHandlers);
        }
        return this.connectionHandlers;
    }

    private synchronized Collection<? extends ProxyHandler> getProxyHandlers() throws Exception {
        if (this.proxyHandlers.isEmpty() && this.registry != null) {
            List<ProxyHandler> proxyHandlers = this.registry.getPlugins(ProxyHandler.class);
            this.proxyHandlers.addAll(proxyHandlers);
            logger.debug("Proxy handlers {}", proxyHandlers);
        }
        return this.proxyHandlers;
    }

    InputStream createProgressWrappedStream(InputStream inputStream, String name, int size, ProgressPlugin.Task task, long timeout) {
        if (this.registry == null) {
            return inputStream;
        }
        return new ProgressWrappingStream(inputStream, name, size, task, timeout);
    }

    public void setCache(File cache) {
        this.cache = new URLCache(cache);
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void addURLConnectionHandler(URLConnectionHandler handler) {
        this.connectionHandlers.add(handler);
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public void addProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandlers.add(proxyHandler);
    }

    public void setLog(File log) throws IOException {
        IO.mkdirs(log.getParentFile());
        this.reporter = new ReporterAdapter(IO.writer(log));
    }

    public String getUserFor(String base) throws MalformedURLException, Exception {
        URLConnectionHandler handler = this.findMatchingHandler(new URL(base));
        if (handler == null) {
            return null;
        }
        return handler.toString();
    }

    public String toName(URI url) throws Exception {
        return URLCache.toName(url);
    }

    public File getCacheFileFor(URI url) throws Exception {
        return this.cache().getCacheFileFor(url);
    }

    public void readSettings(Processor processor) throws IOException, Exception {
        this.connectionSettings = new ConnectionSettings(processor, this);
        this.connectionSettings.readSettings();
    }

    public URI makeDir(URI uri) throws URISyntaxException {
        if (uri.getPath() != null && uri.getPath().endsWith("/")) {
            String string = uri.toString();
            return new URI(string.substring(0, string.length() - 1));
        }
        return uri;
    }

    public boolean isOffline() {
        AtomicBoolean localOffline = this.offline;
        if (localOffline == null) {
            return false;
        }
        return localOffline.get();
    }

    public void setOffline(AtomicBoolean offline) {
        this.offline = offline;
    }

    public PromiseFactory promiseFactory() {
        return this.promiseFactory;
    }

    public URLCache cache() {
        return this.cache;
    }

    public void reportSettings(Formatter out) {
        if (this.connectionSettings != null) {
            this.connectionSettings.report(out);
        }
    }

    public HttpClient retries(int retries) {
        this.retries = retries;
        return this;
    }

    public HttpClient retryDelay(int retryDelay) {
        this.retryDelay = TimeUnit.SECONDS.toMillis(retryDelay);
        return this;
    }

    public String validateURI(URI u) {
        String scheme = u.getScheme();
        if (scheme == null) {
            return "Invalid uri, no scheme: " + u;
        }
        switch (scheme.toLowerCase()) {
            case "http": 
            case "https": 
            case "file": {
                return null;
            }
        }
        return "Invalid scheme " + scheme + "for uri " + u;
    }

    static {
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        codec = new JSONCodec();
    }

    class HttpConnection<T>
    implements Callable<T> {
        private static final int HTTP_TEMPORARY_REDIRECT = 307;
        private static final int HTTP_PERMANENT_REDIRECT = 308;
        private static final int HTTP_UNKNOWN_ERROR = 520;
        private static final int HTTP_INVALID_SSL_CERTIFICATE = 526;
        private final HttpRequest<T> request;
        private volatile Thread requestThread;
        private volatile TaggedData connected;

        HttpConnection(HttpRequest<T> request) {
            this.request = Objects.requireNonNull(request);
            Objects.requireNonNull(request.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Thread thread = this.requestThread = Thread.currentThread();
            String threadName = thread.getName();
            thread.setName(this.toString());
            try {
                if (HttpClient.this.isOffline() || this.request.isCache()) {
                    T t = this.doCached();
                    return t;
                }
                TaggedData tag = this.connect();
                if (this.request.download == TaggedData.class) {
                    TaggedData taggedData = tag;
                    return (T)taggedData;
                }
                if (this.request.download == State.class) {
                    State state = tag.getState();
                    return (T)((Object)state);
                }
                switch (tag.getState()) {
                    case NOT_FOUND: {
                        T t = null;
                        return t;
                    }
                    case OTHER: {
                        throw new HttpRequestException(tag);
                    }
                }
                Object object = this.convert(this.request.download, tag.getInputStream());
                return (T)object;
            }
            finally {
                thread.setName(threadName);
            }
        }

        public String toString() {
            return "HttpClient," + this.request.url;
        }

        Thread requestThread() {
            return this.requestThread;
        }

        void cancel() {
            TaggedData tag = this.connected;
            if (tag != null) {
                IO.close(tag);
                File file = tag.getFile();
                if (file != null) {
                    IO.delete(file);
                }
            }
        }

        private T doCached() throws Exception {
            TaggedData tag = this.doCached0();
            if (this.request.download == TaggedData.class) {
                return (T)tag;
            }
            if (this.request.download == State.class) {
                return (T)((Object)tag.getState());
            }
            switch (tag.getState()) {
                case NOT_FOUND: {
                    return null;
                }
                case OTHER: {
                    throw new HttpRequestException(tag);
                }
            }
            return (T)this.convert(this.request.download, this.request.useCacheFile == null ? tag.getFile() : this.request.useCacheFile, tag);
        }

        private TaggedData doCached0() throws Exception {
            URL url = this.request.url;
            URI uri = url.toURI();
            logger.debug("cached {}", (Object)url);
            try (URLCache.Info info = HttpClient.this.cache().get(this.request.useCacheFile, uri);){
                if ("file".equalsIgnoreCase(url.getProtocol())) {
                    File sourceFile = new File(uri);
                    if (!sourceFile.isFile()) {
                        TaggedData taggedData = new TaggedData(uri, 404, null);
                        return taggedData;
                    }
                    if (info.file.isFile() && info.file.lastModified() == sourceFile.lastModified() && info.file.length() == sourceFile.length()) {
                        TaggedData taggedData = new TaggedData(uri, 304, info.file);
                        return taggedData;
                    }
                    info.update(IO.stream(sourceFile), null, sourceFile.lastModified());
                    TaggedData taggedData = new TaggedData(uri, 200, info.file);
                    return taggedData;
                }
                this.request.useCacheFile = info.file;
                if (info.isPresent()) {
                    if (!(HttpClient.this.isOffline() || this.request.maxStale >= 0L && info.jsonFile.lastModified() + this.request.maxStale >= System.currentTimeMillis())) {
                        if (info.dto.etag != null) {
                            this.request.ifNoneMatch(info.getETag());
                        } else {
                            long time = info.file.lastModified();
                            if (time > 0L) {
                                this.request.ifModifiedSince(time + 1L);
                            }
                        }
                        TaggedData tag = this.connect();
                        if (tag.getState() == State.NOT_FOUND) {
                            HttpClient.this.cache().clear(uri);
                        } else if (tag.getState() == State.UPDATED) {
                            info.update(tag.getInputStream(), tag.getTag(), tag.getModified());
                        } else if (tag.getState() == State.UNMODIFIED) {
                            info.jsonFile.setLastModified(System.currentTimeMillis());
                        }
                        TaggedData taggedData = tag;
                        return taggedData;
                    }
                    TaggedData tag = new TaggedData(uri, 304, info.file);
                    return tag;
                }
                this.request.ifMatch = null;
                this.request.ifNoneMatch = null;
                this.request.ifModifiedSince = -1L;
                if (HttpClient.this.isOffline()) {
                    TaggedData tag = new TaggedData(uri, 404, this.request.useCacheFile);
                    return tag;
                }
                TaggedData tag = this.connect();
                if (tag.isOk()) {
                    info.update(tag.getInputStream(), tag.getTag(), tag.getModified());
                }
                TaggedData taggedData = tag;
                return taggedData;
            }
        }

        private TaggedData connect() throws Exception {
            ProxyHandler.ProxySetup proxy = HttpClient.this.getProxySetup(this.request.url);
            URLConnection con = this.getProxiedAndConfiguredConnection(this.request.url, proxy);
            HttpURLConnection hcon = (HttpURLConnection)(con instanceof HttpURLConnection ? con : null);
            if (this.request.ifNoneMatch != null) {
                this.request.headers.put("If-None-Match", this.entitytag(this.request.ifNoneMatch));
            }
            if (this.request.ifMatch != null) {
                this.request.headers.put("If-Match", "\"" + this.entitytag(this.request.ifMatch));
            }
            if (this.request.ifModifiedSince > 0L) {
                this.request.headers.put("If-Modified-Since", Dates.formatMillis(Dates.RFC_7231_DATE_TIME, this.request.ifModifiedSince));
            }
            if (this.request.ifUnmodifiedSince != 0L) {
                this.request.headers.put("If-Unmodified-Since", Dates.formatMillis(Dates.RFC_7231_DATE_TIME, this.request.ifUnmodifiedSince));
            }
            this.setHeaders(this.request.headers, con);
            this.configureHttpConnection(this.request.verb, hcon);
            TaggedData tag = HttpClient.this.connectWithProxy(proxy, () -> this.doConnect(this.request.upload, this.request.download, con, hcon));
            logger.debug("result {}", (Object)tag);
            this.connected = tag;
            return this.connected;
        }

        private TaggedData doConnect(Object put, Type ref, URLConnection con, HttpURLConnection hcon) throws Exception {
            ProgressPlugin.Task task = this.getTask();
            if (put != null) {
                task.worked(1);
                this.doOutput(put, con);
            } else {
                logger.debug("{} {}", (Object)this.request.verb, hcon == null ? this.request.url : hcon);
            }
            if (this.request.timeout > 0L) {
                con.setConnectTimeout((int)this.request.timeout * 10);
                con.setReadTimeout((int)(5000L > this.request.timeout ? this.request.timeout : 5000L));
            } else {
                con.setConnectTimeout(120000);
                con.setReadTimeout(60000);
            }
            try {
                if (hcon == null) {
                    try {
                        con.connect();
                        InputStream in = con.getInputStream();
                        return new TaggedData(con, in, this.request.useCacheFile);
                    }
                    catch (FileNotFoundException e) {
                        URI uri = con.getURL().toURI();
                        task.done("File not found " + uri, e);
                        return new TaggedData(uri, 404, this.request.useCacheFile);
                    }
                }
                int code = hcon.getResponseCode();
                if (code == -1) {
                    throw new IOException("Invalid response code (-1) from connection");
                }
                if ((code == 302 || code == 301 || code == 303 || code == 307 || code == 308) && this.request.redirects-- > 0) {
                    String location = hcon.getHeaderField("Location");
                    this.request.url = new URL(this.request.url, location);
                    this.requestThread().setName(this.toString());
                    task.done("Redirected " + code + " " + location, null);
                    return this.connect();
                }
                if (this.isUpdateInfo(code, con)) {
                    File file = (File)this.request.upload;
                    String etag = con.getHeaderField("ETag");
                    try (URLCache.Info info = HttpClient.this.cache().get(file, con.getURL().toURI());){
                        info.update(etag);
                    }
                }
                if (code / 100 != 2) {
                    String message = "Finished " + code + " " + con.getURL().toURI();
                    task.done(message, null);
                    TaggedData tag = new TaggedData(con, null, this.request.useCacheFile);
                    if (code / 100 == 5) {
                        throw new RetryException(tag, message);
                    }
                    return tag;
                }
                InputStream xin = con.getInputStream();
                InputStream in = this.handleContentEncoding(xin, hcon);
                in = HttpClient.this.createProgressWrappedStream(in, con.toString(), con.getContentLength(), task, this.request.timeout);
                return new TaggedData(con, in, this.request.useCacheFile);
            }
            catch (SSLHandshakeException e) {
                task.done(Exceptions.causes(e), null);
                TaggedData tag = new TaggedData(this.request.url.toURI(), 526, this.request.useCacheFile);
                throw new RetryException(tag, (Throwable)e);
            }
            catch (SocketTimeoutException e) {
                task.done(e.toString(), null);
                TaggedData tag = new TaggedData(this.request.url.toURI(), 504, this.request.useCacheFile);
                throw new RetryException(tag, (Throwable)e);
            }
            catch (IOException e) {
                task.done(e.toString(), null);
                TaggedData tag = new TaggedData(this.request.url.toURI(), 520, this.request.useCacheFile);
                throw new RetryException(tag, (Throwable)e);
            }
            catch (RetryException e) {
                throw e;
            }
            catch (Throwable t) {
                task.done("Failed " + t, t);
                throw t;
            }
        }

        private void configureHttpConnection(String verb, HttpURLConnection hcon) throws ProtocolException {
            if (hcon != null) {
                hcon.setRequestProperty("Accept-Encoding", "deflate, gzip");
                hcon.setInstanceFollowRedirects(false);
                hcon.setRequestMethod(verb);
            }
        }

        private void setHeaders(Map<String, String> headers, URLConnection con) {
            MapStream<String, String> stream = MapStream.ofNullable(headers);
            if (logger.isDebugEnabled()) {
                stream = stream.peek((k, v) -> logger.debug("set header {}={}", k, v));
            }
            stream.forEachOrdered(con::setRequestProperty);
        }

        private Object convert(Type type, File in, TaggedData tag) throws Exception {
            if (type == TaggedData.class) {
                return tag;
            }
            if (type == File.class) {
                return in;
            }
            try (InputStream fin = IO.stream(in);){
                Object object = this.convert(type, fin);
                return object;
            }
        }

        private Object convert(Type ref, InputStream in) throws Exception {
            if (ref instanceof Class) {
                Class refc = (Class)ref;
                if (refc == byte[].class) {
                    return IO.read(in);
                }
                if (InputStream.class.isAssignableFrom(refc)) {
                    return in;
                }
                if (String.class == refc) {
                    return IO.collect(in);
                }
            }
            String s = IO.collect(in);
            return codec.dec().from(s).get(ref);
        }

        private void doOutput(Object put, URLConnection con) throws Exception {
            con.setDoOutput(true);
            try (OutputStream out = con.getOutputStream();){
                if (put instanceof InputStream) {
                    logger.debug("out {} input stream {}", (Object)this.request.verb, (Object)this.request.url);
                    IO.copy((InputStream)put, out);
                } else if (put instanceof String) {
                    logger.debug("out {} string {}", (Object)this.request.verb, (Object)this.request.url);
                    IO.store(put, out);
                } else if (put instanceof byte[]) {
                    logger.debug("out {} byte[] {}", (Object)this.request.verb, (Object)this.request.url);
                    IO.copy((byte[])put, out);
                } else if (put instanceof File) {
                    logger.debug("out {} file {} {}", new Object[]{this.request.verb, put, this.request.url});
                    IO.copy((File)put, out);
                } else {
                    logger.debug("out {} JSON {} {}", new Object[]{this.request.verb, put, this.request.url});
                    codec.enc().to(out).put(put).flush();
                }
            }
        }

        private String entitytag(String entity) {
            if (entity == null || entity.isEmpty() || "*".equals(entity)) {
                return entity;
            }
            return entity;
        }

        private URLConnection getProxiedAndConfiguredConnection(URL url, ProxyHandler.ProxySetup proxy) throws Exception {
            URLConnection urlc = proxy != null ? url.openConnection(proxy.proxy) : url.openConnection();
            URLConnectionHandler matching = HttpClient.this.findMatchingHandler(url);
            if (matching == null) {
                return urlc;
            }
            matching.handle(urlc);
            return urlc;
        }

        private ProgressPlugin.Task getTask() {
            ProgressPlugin.Task task;
            List<ProgressPlugin> progressPlugins;
            String name = (this.request.upload == null ? "Download " : "Upload ") + this.request.url;
            int size = 100;
            List<ProgressPlugin> list = progressPlugins = HttpClient.this.registry != null ? HttpClient.this.registry.getPlugins(ProgressPlugin.class) : null;
            if (progressPlugins != null && progressPlugins.size() > 1) {
                final ArrayList<ProgressPlugin.Task> multiplexedTasks = new ArrayList<ProgressPlugin.Task>();
                for (ProgressPlugin progressPlugin : progressPlugins) {
                    multiplexedTasks.add(progressPlugin.startTask(name, 100));
                }
                task = new ProgressPlugin.Task(){

                    @Override
                    public void worked(int units) {
                        for (ProgressPlugin.Task task : multiplexedTasks) {
                            task.worked(units);
                        }
                    }

                    @Override
                    public void done(String message, Throwable e) {
                        for (ProgressPlugin.Task task : multiplexedTasks) {
                            task.done(message, e);
                        }
                    }

                    @Override
                    public boolean isCanceled() {
                        for (ProgressPlugin.Task task : multiplexedTasks) {
                            if (!task.isCanceled()) continue;
                            return true;
                        }
                        return false;
                    }
                };
            } else {
                task = progressPlugins != null && progressPlugins.size() == 1 ? progressPlugins.get(0).startTask(name, 100) : new ProgressPlugin.Task(){

                    @Override
                    public void worked(int units) {
                    }

                    @Override
                    public void done(String message, Throwable e) {
                    }

                    @Override
                    public boolean isCanceled() {
                        return Thread.currentThread().isInterrupted();
                    }
                };
            }
            return task;
        }

        private InputStream handleContentEncoding(InputStream in, HttpURLConnection hcon) throws IOException {
            if (hcon == null) {
                return in;
            }
            String encoding = hcon.getHeaderField("Content-Encoding");
            if (encoding != null) {
                if (encoding.equalsIgnoreCase("deflate")) {
                    in = new InflaterInputStream(in);
                    logger.debug("inflate");
                } else if (encoding.equalsIgnoreCase("gzip")) {
                    in = new GZIPInputStream(in);
                    logger.debug("gzip");
                }
            }
            return in;
        }

        private boolean isUpdateInfo(int code, URLConnection con) {
            return this.request.upload instanceof File && this.request.updateTag && code == 201 && con.getHeaderField("ETag") != null;
        }
    }
}

